/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.DescriptorDerivedFromTypeAlias;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.DeprecationResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.VersionRequirement;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\tJ\u001a\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\rH\u0007J\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\tH\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/DeprecationResolver;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "deprecations", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "Lorg/jetbrains/kotlin/resolve/Deprecation;", "isHiddenBecauseOfKotlinVersionAccessibility", "", "deprecationByOverridden", "root", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getDeprecationByVersionRequirement", "Lorg/jetbrains/kotlin/resolve/DeprecatedByVersionRequirement;", "target", "getDeprecations", "descriptor", "isDeprecatedHidden", "isHiddenInResolution", "isSuperCall", "deprecationsByConstituentTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "getOwnDeprecations", "frontend"})
public final class DeprecationResolver {
    private final MemoizedFunctionToNotNull<DeclarationDescriptor, List<Deprecation>> deprecations;
    private final MemoizedFunctionToNotNull<DeclarationDescriptor, Boolean> isHiddenBecauseOfKotlinVersionAccessibility;
    private final LanguageVersionSettings languageVersionSettings;

    @NotNull
    public final List<Deprecation> getDeprecations(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.original");
        return (List)this.deprecations.invoke(declarationDescriptor);
    }

    public final boolean isDeprecatedHidden(@NotNull DeclarationDescriptor descriptor2) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Iterable $receiver$iv = this.getDeprecations(descriptor2);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Deprecation it = (Deprecation)element$iv;
                    if (!(it.getDeprecationLevel() == DeprecationLevelValue.HIDDEN)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2, boolean isSuperCall) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2 instanceof FunctionDescriptor) {
            if (((FunctionDescriptor)descriptor2).isHiddenToOvercomeSignatureClash()) {
                return true;
            }
            if (((FunctionDescriptor)descriptor2).isHiddenForResolutionEverywhereBesideSupercalls() && !isSuperCall) {
                return true;
            }
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.original");
        if (!((Boolean)this.isHiddenBecauseOfKotlinVersionAccessibility.invoke(declarationDescriptor)).booleanValue()) {
            return true;
        }
        return this.isDeprecatedHidden(descriptor2);
    }

    @JvmOverloads
    public static /* synthetic */ boolean isHiddenInResolution$default(DeprecationResolver deprecationResolver, DeclarationDescriptor declarationDescriptor, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return deprecationResolver.isHiddenInResolution(declarationDescriptor, bl);
    }

    @JvmOverloads
    public final boolean isHiddenInResolution(@NotNull DeclarationDescriptor descriptor2) {
        return DeprecationResolver.isHiddenInResolution$default(this, descriptor2, false, 2, null);
    }

    private final List<Deprecation> deprecationsByConstituentTypes(@NotNull KotlinType $receiver) {
        SmartList smartList;
        SmartList deprecations2 = smartList = new SmartList();
        TypeUtils.contains($receiver, new Function1<UnwrappedType, Boolean>(deprecations2, this, $receiver){
            final /* synthetic */ SmartList $deprecations;
            final /* synthetic */ DeprecationResolver this$0;
            final /* synthetic */ KotlinType receiver$0$inlined;
            {
                this.$deprecations = smartList;
                this.this$0 = deprecationResolver;
                this.receiver$0$inlined = kotlinType;
                super(1);
            }

            public final boolean invoke(UnwrappedType type2) {
                block0: {
                    ClassifierDescriptor classifierDescriptor;
                    ClassifierDescriptor it;
                    ClassifierDescriptor classifierDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
                    if (classifierDescriptor2 == null) break block0;
                    ClassifierDescriptor classifierDescriptor3 = it = (classifierDescriptor = classifierDescriptor2);
                    Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor3, "it");
                    this.$deprecations.addAll((Collection)this.this$0.getDeprecations(classifierDescriptor3));
                }
                return false;
            }
        });
        return smartList;
    }

    /*
     * WARNING - void declaration
     */
    private final Deprecation deprecationByOverridden(CallableMemberDescriptor root2) {
        void hasUndeprecatedOverridden;
        HashSet visited2 = new HashSet();
        LinkedHashSet deprecations2 = new LinkedHashSet();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Function1<CallableMemberDescriptor, Unit> traverse$ = new Function1<CallableMemberDescriptor, Unit>(this, visited2, deprecations2, (Ref.BooleanRef)hasUndeprecatedOverridden){
            final /* synthetic */ DeprecationResolver this$0;
            final /* synthetic */ HashSet $visited;
            final /* synthetic */ LinkedHashSet $deprecations;
            final /* synthetic */ Ref.BooleanRef $hasUndeprecatedOverridden;

            public final void invoke(@NotNull CallableMemberDescriptor node) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                if (this.$visited.contains(node)) {
                    return;
                }
                this.$visited.add(node);
                List deprecationsByAnnotation = DeprecationResolver.access$getOwnDeprecations(this.this$0, node);
                CallableMemberDescriptor callableMemberDescriptor = node.getOriginal();
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "node.original");
                Collection<? extends CallableMemberDescriptor> overriddenDescriptors = callableMemberDescriptor.getOverriddenDescriptors();
                Collection collection = deprecationsByAnnotation;
                if (!collection.isEmpty()) {
                    this.$deprecations.addAll(deprecationsByAnnotation);
                } else {
                    if (overriddenDescriptors.isEmpty()) {
                        this.$hasUndeprecatedOverridden.element = true;
                        return;
                    }
                    Collection<? extends CallableMemberDescriptor> collection2 = overriddenDescriptors;
                    Intrinsics.checkExpressionValueIsNotNull(collection2, "overriddenDescriptors");
                    Iterable $receiver$iv = collection2;
                    for (T element$iv : $receiver$iv) {
                        CallableMemberDescriptor p1 = (CallableMemberDescriptor)element$iv;
                        this.invoke(p1);
                    }
                }
            }
            {
                this.this$0 = deprecationResolver;
                this.$visited = hashSet;
                this.$deprecations = linkedHashSet;
                this.$hasUndeprecatedOverridden = booleanRef;
                super(1);
            }
        };
        traverse$.invoke(root2);
        if (hasUndeprecatedOverridden.element || deprecations2.isEmpty()) {
            return null;
        }
        return new DeprecatedByOverridden(deprecations2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Deprecation> getOwnDeprecations(@NotNull DeclarationDescriptor $receiver) {
        if ($receiver instanceof FunctionDescriptor && OperatorCallCheckerKt.isOperatorMod((FunctionDescriptor)$receiver) && KotlinBuiltIns.isUnderKotlinPackage($receiver) && !OperatorCallCheckerKt.shouldWarnAboutDeprecatedModFromBuiltIns(this.languageVersionSettings)) {
            return CollectionsKt.emptyList();
        }
        SmartList result2 = new SmartList();
        Function1<DeclarationDescriptor, Unit> addDeprecationIfPresent$ = new Function1<DeclarationDescriptor, Unit>(this, result2){
            final /* synthetic */ DeprecationResolver this$0;
            final /* synthetic */ SmartList $result;

            public final void invoke(@NotNull DeclarationDescriptor target) {
                block2: {
                    AnnotationDescriptor annotation2;
                    Intrinsics.checkParameterIsNotNull(target, "target");
                    Annotations annotations2 = target.getAnnotations();
                    FqName fqName2 = KotlinBuiltIns.FQ_NAMES.deprecated;
                    Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.deprecated");
                    AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
                    if (annotationDescriptor == null) {
                        annotationDescriptor = annotation2 = target.getAnnotations().findAnnotation(DeprecationUtilKt.access$getJAVA_DEPRECATED$p());
                    }
                    if (annotation2 != null) {
                        DeprecatedByAnnotation deprecatedByAnnotation = new DeprecatedByAnnotation(annotation2, target);
                        DeclarationDescriptor declarationDescriptor = target;
                        Deprecation deprecation = declarationDescriptor instanceof TypeAliasConstructorDescriptor ? (Deprecation)new DeprecatedTypealiasByAnnotation(((TypeAliasConstructorDescriptor)target).getTypeAliasDescriptor(), deprecatedByAnnotation) : (Deprecation)deprecatedByAnnotation;
                        this.$result.add(deprecation);
                    }
                    DeprecatedByVersionRequirement deprecatedByVersionRequirement = DeprecationResolver.access$getDeprecationByVersionRequirement(this.this$0, target);
                    if (deprecatedByVersionRequirement == null) break block2;
                    DeprecatedByVersionRequirement deprecatedByVersionRequirement2 = deprecatedByVersionRequirement;
                    SmartList smartList = this.$result;
                    Deprecation p1 = deprecatedByVersionRequirement2;
                    smartList.add(p1);
                }
            }
            {
                this.this$0 = deprecationResolver;
                this.$result = smartList;
                super(1);
            }
        };
        Function2<DeclarationDescriptor, AnnotationUseSiteTarget, Unit> addUseSiteTargetedDeprecationIfPresent$ = new Function2<DeclarationDescriptor, AnnotationUseSiteTarget, Unit>($receiver, result2){
            final /* synthetic */ DeclarationDescriptor receiver$0;
            final /* synthetic */ SmartList $result;

            public final void invoke(@NotNull DeclarationDescriptor annotatedDescriptor, @Nullable AnnotationUseSiteTarget useSiteTarget) {
                Intrinsics.checkParameterIsNotNull(annotatedDescriptor, "annotatedDescriptor");
                if (useSiteTarget != null) {
                    AnnotationDescriptor annotation2;
                    Annotations annotations2 = annotatedDescriptor.getAnnotations();
                    FqName fqName2 = KotlinBuiltIns.FQ_NAMES.deprecated;
                    Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.deprecated");
                    AnnotationDescriptor annotationDescriptor = Annotations.Companion.findUseSiteTargetedAnnotation(annotations2, useSiteTarget, fqName2);
                    if (annotationDescriptor == null) {
                        annotationDescriptor = annotation2 = Annotations.Companion.findUseSiteTargetedAnnotation(annotatedDescriptor.getAnnotations(), useSiteTarget, DeprecationUtilKt.access$getJAVA_DEPRECATED$p());
                    }
                    if (annotation2 != null) {
                        this.$result.add(new DeprecatedByAnnotation(annotation2, this.receiver$0));
                    }
                }
            }
            {
                this.receiver$0 = declarationDescriptor;
                this.$result = smartList;
                super(2);
            }
        };
        addDeprecationIfPresent$.invoke($receiver);
        addUseSiteTargetedDeprecationIfPresent$.invoke($receiver, AnnotationUseSiteTarget.Companion.getAssociatedUseSiteTarget($receiver));
        DeclarationDescriptor declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof TypeAliasDescriptor) {
            Iterable $receiver$iv = this.deprecationsByConstituentTypes(((TypeAliasDescriptor)$receiver).getExpandedType());
            for (Object item$iv : $receiver$iv) {
                void it;
                Deprecation deprecation = (Deprecation)item$iv;
                Collection collection = result2;
                Deprecation deprecation2 = DeprecationUtilKt.access$wrapInTypeAliasExpansion((Deprecation)it, (TypeAliasDescriptor)$receiver);
                collection.add(deprecation2);
            }
        } else if (declarationDescriptor instanceof DescriptorDerivedFromTypeAlias) {
            result2.addAll(this.getOwnDeprecations(((DescriptorDerivedFromTypeAlias)((Object)$receiver)).getTypeAliasDescriptor()));
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "correspondingProperty");
            addDeprecationIfPresent$.invoke((DeclarationDescriptor)propertyDescriptor);
            PropertyDescriptor propertyDescriptor2 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor2, "correspondingProperty");
            addUseSiteTargetedDeprecationIfPresent$.invoke((DeclarationDescriptor)propertyDescriptor2, $receiver instanceof PropertyGetterDescriptor ? AnnotationUseSiteTarget.PROPERTY_GETTER : AnnotationUseSiteTarget.PROPERTY_SETTER);
        }
        return CollectionsKt.distinct(result2);
    }

    private final DeprecatedByVersionRequirement getDeprecationByVersionRequirement(DeclarationDescriptor target) {
        MavenComparableVersion currentVersion;
        Object object;
        getDeprecationByVersionRequirement.1 createVersion$ = getDeprecationByVersionRequirement.1.INSTANCE;
        DeclarationDescriptor declarationDescriptor = target;
        if (!(declarationDescriptor instanceof DeserializedMemberDescriptor)) {
            declarationDescriptor = null;
        }
        if ((object = (DeserializedMemberDescriptor)declarationDescriptor) == null || (object = object.getVersionRequirement()) == null) {
            DeclarationDescriptor declarationDescriptor2 = target;
            if (!(declarationDescriptor2 instanceof DeserializedClassDescriptor)) {
                declarationDescriptor2 = null;
            }
            DeserializedClassDescriptor deserializedClassDescriptor = (DeserializedClassDescriptor)declarationDescriptor2;
            object = deserializedClassDescriptor != null ? deserializedClassDescriptor.getVersionRequirement() : null;
        }
        if (object == null) {
            return null;
        }
        Object versionRequirement = object;
        MavenComparableVersion requiredVersion = createVersion$.invoke(((VersionRequirement)versionRequirement).getVersion().asString());
        switch (DeprecationResolver$WhenMappings.$EnumSwitchMapping$0[((VersionRequirement)versionRequirement).getKind().ordinal()]) {
            case 1: {
                MavenComparableVersion mavenComparableVersion = new MavenComparableVersion(this.languageVersionSettings.getLanguageVersion().getVersionString());
                break;
            }
            case 2: {
                MavenComparableVersion mavenComparableVersion = this.languageVersionSettings.getApiVersion().getVersion();
                break;
            }
            case 3: {
                MavenComparableVersion mavenComparableVersion;
                String string = KotlinCompilerVersion.getVersion();
                if (string != null && (string = StringsKt.substringBefore$default(string, '-', null, 2, null)) != null) {
                    String string2;
                    String p1 = string2 = string;
                    mavenComparableVersion = getDeprecationByVersionRequirement.1.INSTANCE.invoke(p1);
                    break;
                }
                mavenComparableVersion = null;
                break;
            }
            default: {
                MavenComparableVersion mavenComparableVersion = currentVersion = null;
            }
        }
        if (currentVersion != null && currentVersion.compareTo(requiredVersion) < 0) {
            return new DeprecatedByVersionRequirement((VersionRequirement)versionRequirement, target);
        }
        return null;
    }

    public DeprecationResolver(@NotNull StorageManager storageManager, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
        this.deprecations = storageManager.createMemoizedFunction((Function1)new Function1<DeclarationDescriptor, List<? extends Deprecation>>(this){
            final /* synthetic */ DeprecationResolver this$0;

            @NotNull
            public final List<Deprecation> invoke(@NotNull DeclarationDescriptor descriptor2) {
                Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
                List<T> deprecations2 = DeprecationResolver.access$getOwnDeprecations(this.this$0, descriptor2);
                Collection collection = deprecations2;
                return !collection.isEmpty() ? deprecations2 : (descriptor2 instanceof CallableMemberDescriptor ? CollectionsKt.listOfNotNull(DeprecationResolver.access$deprecationByOverridden(this.this$0, (CallableMemberDescriptor)descriptor2)) : CollectionsKt.emptyList());
            }
            {
                this.this$0 = deprecationResolver;
                super(1);
            }
        });
        this.isHiddenBecauseOfKotlinVersionAccessibility = storageManager.createMemoizedFunction((Function1)new Function1<DeclarationDescriptor, Boolean>(this){
            final /* synthetic */ DeprecationResolver this$0;

            public final boolean invoke(@NotNull DeclarationDescriptor descriptor2) {
                Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
                return SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility$default(descriptor2, DeprecationResolver.access$getLanguageVersionSettings$p(this.this$0), null, 2, null);
            }
            {
                this.this$0 = deprecationResolver;
                super(1);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ List access$getOwnDeprecations(DeprecationResolver $this, @NotNull DeclarationDescriptor $receiver) {
        return $this.getOwnDeprecations($receiver);
    }

    @Nullable
    public static final /* synthetic */ DeprecatedByVersionRequirement access$getDeprecationByVersionRequirement(DeprecationResolver $this, @NotNull DeclarationDescriptor target) {
        return $this.getDeprecationByVersionRequirement(target);
    }

    @Nullable
    public static final /* synthetic */ Deprecation access$deprecationByOverridden(DeprecationResolver $this, @NotNull CallableMemberDescriptor root2) {
        return $this.deprecationByOverridden(root2);
    }

    @NotNull
    public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(DeprecationResolver $this) {
        return $this.languageVersionSettings;
    }
}

