/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_to extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "houa faka\u02bbafelika-loto",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "houa fakal\u016bsia-mosikou taimi totonu",
               "MSK",
               "houa fakal\u016bsia-mosikou taimi liliu",
               "MSD",
               "houa fakal\u016bsia-mosikou",
               "MT",
            };
        final String[] Japan = new String[] {
               "houa fakasiapani taimi totonu",
               "JST",
               "houa fakasiapani taimi liliu",
               "JDT",
               "houa fakasiapani",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "houa fakap\u0101kisitani taimi totonu",
               "PKT",
               "houa fakap\u0101kisitani taimi liliu",
               "PKST",
               "houa fakap\u0101kisitani",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "houa fakataipei taimi totonu",
               "CST",
               "houa fakataipei taimi liliu",
               "CDT",
               "houa fakataipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "houa fakahovite taimi totonu",
               "HOVT",
               "houa fakahovite taimi liliu",
               "HOVST",
               "houa fakahovite",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "houa fakal\u016bsia-makatani taimi totonu",
               "MAGT",
               "houa fakal\u016bsia-makatani taimi liliu",
               "MAGST",
               "houa fakal\u016bsia-makatani",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "houa faka\u02bbaositel\u0113lia-loto-hihifo taimi totonu",
               "ACWST",
               "houa faka\u02bbaositel\u0113lia-loto-hihifo taimi liliu",
               "ACWDT",
               "houa faka\u02bbaositel\u0113lia-loto-hihifo",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "houa faka\u02bbeulope-loto taimi totonu",
               "CET",
               "houa faka\u02bbeulope-loto taimi liliu",
               "CEST",
               "houa faka\u02bbeulope-loto",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "houa fakal\u016bsia-sak\u0101line taimi totonu",
               "SAKT",
               "houa fakal\u016bsia-sak\u0101line taimi liliu",
               "SAKST",
               "houa fakal\u016bsia-sak\u0101line",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "houa fakapalakuai taimi totonu",
               "PYT",
               "houa fakapalakuai taimi liliu",
               "PYST",
               "houa fakapalakuai",
               "PYT",
            };
        final String[] Acre = new String[] {
               "houa faka\u02bbakel\u012b taimi totonu",
               "ACT",
               "houa faka\u02bbakel\u012b taimi fakaliliu",
               "ACST",
               "houa faka\u02bbakel\u012b",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "houa fakamaleisia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "houa faka\u02bbamelika-tokelau hahake taimi totonu",
               "EST",
               "houa faka\u02bbamelika-tokelau hahake taimi liliu",
               "EDT",
               "houa faka\u02bbamelika-tokelau hahake",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "houa fakamotu\u02bbeikihoue taimi totonu",
               "LHST",
               "houa fakamotu\u02bbeikihoue taimi liliu",
               "LHDT",
               "houa fakamotu\u02bbeikihoue",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "houa fakanu\u02bbusila taimi totonu",
               "NZST",
               "houa fakanu\u02bbusila taimi liliu",
               "NZDT",
               "houa fakanu\u02bbusila",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "houa fakamoana\u02bbinitia",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki taimi totonu",
               "YAKT",
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki taimi liliu",
               "YAKST",
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "houa fakamaulitiusi taimi totonu",
               "MUT",
               "houa fakamaulitiusi taimi liliu",
               "MUST",
               "houa fakamaulitiusi",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "houa faka\u02bbafelika-hahake",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "houa fakatimoa-hahake",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "houa faka\u02bbotumotusolomone",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "houa fakakosilae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "houa faka\u02bbotumotumasolo",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "houa faka\u02bbeulope-hahake taimi totonu",
               "EET",
               "houa faka\u02bbeulope-hahake taimi liliu",
               "EEST",
               "houa faka\u02bbeulope-hahake",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "houa fakafonua\u02bbilofo\u02bbou taimi totonu",
               "NST",
               "houa fakafonua\u02bbilofo\u02bbou taimi liliu",
               "NDT",
               "houa fakafonua\u02bbilofo\u02bbou",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "houa faka\u02bbafik\u0101nisitani",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "houa fakahongi-kongi taimi totonu",
               "HKT",
               "houa fakahongi-kongi taimi liliu",
               "HKST",
               "houa fakahongi-kongi",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "houa faka\u02bbasenitina-hihifo taimi totonu",
               "ART",
               "houa faka\u02bbasenitina-hihifo taimi liliu",
               "ARST",
               "houa faka\u02bbasenitina-hihifo",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki taimi totonu",
               "AST",
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki taimi liliu",
               "ADT",
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki",
               "AT",
            };
        final String[] Ponape = new String[] {
               "houa fakap\u014dnap\u0113",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "houa fakapol\u012bvia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "houa fakas\u0101-piea-mo-mikeloni taimi totonu",
               "PMST",
               "houa fakas\u0101-piea-mo-mikeloni taimi liliu",
               "PMDT",
               "houa fakas\u0101-piea-mo-mikeloni",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "houa faka\u02bbinitosiaina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki taimi totonu",
               "YEKT",
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki taimi liliu",
               "YEKST",
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "houa fakamalativisi",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "houa fakatahisi",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "houa faka\u02bbisileli taimi totonu",
               "IST",
               "houa faka\u02bbisileli taimi liliu",
               "IDT",
               "houa faka\u02bbisileli",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "houa faka\u02bbinitonisia-loto",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "houa faka\u02bbuvea mo futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "houa faka\u02bbafelika-tonga",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "houa fakasioua",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "houa faka\u02bbotumotulaine",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "houa faka\u02bbusipekitani taimi totonu",
               "UZT",
               "houa faka\u02bbusipekitani taimi liliu",
               "UZST",
               "houa faka\u02bbusipekitani",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "houa fakal\u016bsia-\u02bbomisiki taimi totonu",
               "OMST",
               "houa fakal\u016bsia-\u02bbomisiki taimi liliu",
               "OMSST",
               "houa fakal\u016bsia-\u02bbomisiki",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "houa faka\u02bbotumotu-seiseli",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "houa faka\u02bbulukuai taimi totonu",
               "UYT",
               "houa faka\u02bbulukuai taimi liliu",
               "UYST",
               "houa faka\u02bbulukuai",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "houa fakanepali",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "houa faka\u02bbul\u0101nip\u0101t\u0101 taimi totonu",
               "ULAT",
               "houa faka\u02bbul\u0101nip\u0101t\u0101 taimi liliu",
               "ULAST",
               "houa faka\u02bbul\u0101nip\u0101t\u0101",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "houa faka\u02bbamelika-tokelau loto taimi totonu",
               "CST",
               "houa faka\u02bbamelika-tokelau loto taimi liliu",
               "CDT",
               "houa faka\u02bbamelika-tokelau loto",
               "CT",
            };
        final String[] Truk = new String[] {
               "houa fakat\u016bke",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "houa fakaniu\u0113",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "houa fakamotuueke",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "houa faka\u02bbotumotu-fokulani taimi totonu",
               "FKT",
               "houa faka\u02bbotumotu-fokulani taimi liliu",
               "FKST",
               "houa faka\u02bbotumotu-fokulani",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "houa fakavanuatu taimi totonu",
               "VUT",
               "houa fakavanuatu taimi liliu",
               "VUST",
               "houa fakavanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "houa fakal\u016bsia-novosip\u012bsiki taimi totonu",
               "NOVT",
               "houa fakal\u016bsia-novosip\u012bsiki taimi liliu",
               "NOVST",
               "houa fakal\u016bsia-novosip\u012bsiki",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "houa fakasingapoa",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "houa faka\u02bb\u0101solesi taimi totonu",
               "AZOT",
               "houa faka\u02bb\u0101solesi taimi liliu",
               "AZOST",
               "houa faka\u02bb\u0101solesi",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "houa fakaapia taimi totonu",
               "WSST",
               "houa fakaapia taimi liliu",
               "WSDT",
               "houa fakaapia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "houa fakap\u016btani",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "houa fakasuliname",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "houa fakanaulu",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "houa fakal\u016bsia-kalasinoi\u0101siki taimi totonu",
               "KRAT",
               "houa fakal\u016bsia-kalasinoi\u0101siki taimi liliu",
               "KRAST",
               "houa fakal\u016bsia-kalasinoi\u0101siki",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "houa fakakasakitani-hihifo",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "houa fakapema",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "houa fakamotukilisimasi",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "houa faka\u02bbamas\u014dne taimi totonu",
               "AMT",
               "houa faka\u02bbamas\u014dne taimi liliu",
               "AMST",
               "houa faka\u02bbamas\u014dne",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "houa fakakasakitani-hahake",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "houa fakafisi taimi totonu",
               "FJT",
               "houa fakafisi taimi liliu",
               "FJST",
               "houa fakafisi",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "houa fakal\u0113unioni",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "houa fakamotukokosi",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "houa fakasatihami taimi totonu",
               "CHAST",
               "houa fakasatihami taimi liliu",
               "CHADT",
               "houa fakasatihami",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "houa fakavositoki",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "houa faka\u02bbasenitina taimi totonu",
               "ART",
               "houa faka\u02bbasenitina taimi liliu",
               "ARST",
               "houa faka\u02bbasenitina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "houa fakakamipi\u0113",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "houa fakal\u016bsia-petelopavilovisiki taimi totonu",
               "PETT",
               "houa fakal\u016bsia-petelopavilovisiki taimi liliu",
               "PETST",
               "houa fakal\u016bsia-petelopavilovisiki",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "houa fakat\u016bvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "houa fakakalapakosi",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "houa fakamotumakuali",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "houa fakavenesuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "houa fakahaua\u02bbi taimi totonu",
               "HAST",
               "houa fakahaua\u02bbi taimi liliu",
               "HADT",
               "houa fakahaua\u02bbi",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "houa faka\u02bbaositel\u0113lia-loto taimi totonu",
               "ACST",
               "houa faka\u02bbaositel\u0113lia-loto taimi liliu",
               "ACDT",
               "houa faka\u02bbaositel\u0113lia-loto",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "houa faka\u02bbamelika-tokelau pasifika taimi totonu",
               "PST",
               "houa faka\u02bbamelika-tokelau pasifika taimi liliu",
               "PDT",
               "houa faka\u02bbamelika-tokelau pasifika",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "houa faka\u02bbotumotufoinikisi",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "houa fakat\u016bkimenisitani taimi totonu",
               "TMT",
               "houa fakat\u016bkimenisitani taimi liliu",
               "TMST",
               "houa fakat\u016bkimenisitani",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "houa faka\u02bbeulope-hihifo taimi totonu",
               "WET",
               "houa faka\u02bbeulope-hihifo taimi liliu",
               "WEST",
               "houa faka\u02bbeulope-hihifo",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "houa fakamui\u02bbi-v\u0113te taimi totonu",
               "CVT",
               "houa fakamui\u02bbi-v\u0113te taimi liliu",
               "CVST",
               "houa fakamui\u02bbi-v\u0113te",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "houa fakanoaf\u014dki",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "houa fakakuiana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "houa fakapitikani",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "houa fakalotela",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "houa fakaha\u02bbamoa taimi totonu",
               "SST",
               "houa fakaha\u02bbamoa taimi liliu",
               "SDT",
               "houa fakaha\u02bbamoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "houa fakapalau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "houa faka\u02bbeulope-hahake-ange",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "houa faka\u02bbasapaisani taimi totonu",
               "AZT",
               "houa faka\u02bbasapaisani taimi liliu",
               "AZST",
               "houa faka\u02bbasapaisani",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "houa fakamausoni",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "houa fakamekisikou-pasifika taimi totonu",
               "MST",
               "houa fakamekisikou-pasifika taimi liliu",
               "MDT",
               "houa fakamekisikou-pasifika",
               "MT",
            };
        final String[] Davis = new String[] {
               "houa fakatavisi",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "houa fakakiupa taimi totonu",
               "CST",
               "houa fakakiupa taimi liliu",
               "CDT",
               "houa fakakiupa",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "houa faka\u02bbafelika-hihifo taimi totonu",
               "WAT",
               "houa faka\u02bbafelika-hihifo taimi liliu",
               "WAST",
               "houa faka\u02bbafelika-hihifo",
               "WAT",
            };
        final String[] GMT = new String[] {
               "houa fakakiliniuisi m\u0101lie",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "houa fakafilipaine taimi totonu",
               "PHT",
               "houa fakafilipaine taimi liliu",
               "PHST",
               "houa fakafilipaine",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "houa faka\u02bbanet\u0101tikafalanis\u0113",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "houa fakasiosiatonga",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "houa fakakalet\u014dniafo\u02bbou taimi totonu",
               "NCT",
               "houa fakakalet\u014dniafo\u02bbou taimi liliu",
               "NCST",
               "houa fakakalet\u014dniafo\u02bbou",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "houa fakapulunei",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "houa faka\u02bbilaani taimi totonu",
               "IRST",
               "houa faka\u02bbilaani taimi liliu",
               "IRDT",
               "houa faka\u02bbilaani",
               "IRT",
            };
        final String[] Easter = new String[] {
               "houa fakalapanui taimi totonu",
               "EAST",
               "houa fakalapanui taimi liliu",
               "EASST",
               "houa fakalapanui",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "houa fakamekisikou-tokelauhihifo taimi totonu",
               "PST",
               "houa fakamekisikou-tokelauhihifo taimi liliu",
               "PDT",
               "houa fakamekisikou-tokelauhihifo",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "houa fakat\u016bmoni-t\u016bvile",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "houa fakatasikitani",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "houa fakatonga taimi totonu",
               "TOT",
               "houa fakatonga taimi liliu",
               "TOST",
               "houa fakatonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "houa fakapengil\u0101tesi taimi totonu",
               "BDT",
               "houa fakapengil\u0101tesi taimi liliu",
               "BDST",
               "houa fakapengil\u0101tesi",
               "BDT",
            };
        final String[] Peru = new String[] {
               "houa fakapel\u016b taimi totonu",
               "PET",
               "houa fakapel\u016b taimi liliu",
               "PEST",
               "houa fakapel\u016b",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "houa fakafonuamata-hihifo taimi totonu",
               "WGT",
               "houa fakafonuamata-hihifo taimi liliu",
               "WGST",
               "houa fakafonuamata-hihifo",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "houa faka\u02bbekuetoa",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "houa fakafonuamata-hahake taimi totonu",
               "EGT",
               "houa fakafonuamata-hahake taimi liliu",
               "EGST",
               "houa fakafonuamata-hahake",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "houa fakak\u016blifi",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "houa faka\u02bbinitonisia-hahake",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "houa fakak\u014dlea taimi totonu",
               "KST",
               "houa fakak\u014dlea taimi liliu",
               "KDT",
               "houa fakak\u014dlea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "houa faka\u02bbaositel\u0113lia-hihifo taimi totonu",
               "AWST",
               "houa faka\u02bbaositel\u0113lia-hihifo taimi liliu",
               "AWDT",
               "houa faka\u02bbaositel\u0113lia-hihifo",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "houa fakak\u012bkisitani",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "houa faka\u02bbinitonisia-hihifo",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "houa faka\u02bbaositel\u0113lia-hahake taimi totonu",
               "AEST",
               "houa faka\u02bbaositel\u0113lia-hahake taimi liliu",
               "AEDT",
               "houa faka\u02bbaositel\u0113lia-hahake",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "houa fakakuiana-fakafalanis\u0113",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "houa fakakolomipia taimi totonu",
               "COT",
               "houa fakakolomipia taimi liliu",
               "COST",
               "houa fakakolomipia",
               "COT",
            };
        final String[] Chile = new String[] {
               "houa fakasili taimi totonu",
               "CLT",
               "houa fakasili taimi liliu",
               "CLST",
               "houa fakasili",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "houa fakakilipasi",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "houa faka\u02bbamelika-tokelau mo\u02bbunga taimi totonu",
               "MST",
               "houa faka\u02bbamelika-tokelau mo\u02bbunga taimi liliu",
               "MDT",
               "houa faka\u02bbamelika-tokelau mo\u02bbunga",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "houa fakam\u0101kesasi",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "houa faka\u02bbalepea taimi totonu",
               "AST",
               "houa faka\u02bbalepea taimi liliu",
               "ADT",
               "houa faka\u02bbalepea",
               "AT",
            };
        final String[] Alaska = new String[] {
               "houa faka\u02bbalasika taimi totonu",
               "AKST",
               "houa faka\u02bbalasika taimi liliu",
               "AKDT",
               "houa faka\u02bbalasika",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "houa fakal\u016bsia-valativositoki taimi totonu",
               "VLAT",
               "houa fakal\u016bsia-valativositoki taimi liliu",
               "VLAST",
               "houa fakal\u016bsia-valativositoki",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "houa fakakamolo",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "houa fakal\u016bsia-\u02bb\u012bkutisiki taimi totonu",
               "IRKT",
               "houa fakal\u016bsia-\u02bb\u012bkutisiki taimi liliu",
               "IRKST",
               "houa fakal\u016bsia-\u02bb\u012bkutisiki",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "houa fakase\u014dsia taimi totonu",
               "GET",
               "houa fakase\u014dsia taimi liliu",
               "GEST",
               "houa fakase\u014dsia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "houa fakatokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "houa fakapapuaniukini",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "houa fakaf\u0113nanito-te-nol\u014dnia taimi totonu",
               "FNT",
               "houa fakaf\u0113nanito-te-nol\u014dnia taimi liliu",
               "FNST",
               "houa fakaf\u0113nanito-te-nol\u014dnia",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "houa fakakoipalisani taimi totonu",
               "CHOT",
               "houa fakakoipalisani taimi liliu",
               "CHOST",
               "houa fakakoipalisani",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "houa fakapal\u0101sila taimi totonu",
               "BRT",
               "houa fakapal\u0101sila taimi liliu",
               "BRST",
               "houa fakapal\u0101sila",
               "BRT",
            };
        final String[] China = new String[] {
               "houa fakasiaina taimi totonu",
               "CST",
               "houa fakasiaina taimi liliu",
               "CDT",
               "houa fakasiaina",
               "CT",
            };
        final String[] Armenia = new String[] {
               "houa faka\u02bb\u0101menia taimi totonu",
               "AMT",
               "houa faka\u02bb\u0101menia taimi liliu",
               "AMST",
               "houa faka\u02bb\u0101menia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "houa fakal\u016bsia-samala taimi totonu",
               "SAMT",
               "houa fakal\u016bsia-samala taimi liliu",
               "SAMST",
               "houa fakal\u016bsia-samala",
               "SAMT",
            };
        final String[] India = new String[] {
               "houa faka\u02bbinitia",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "houa faka\u02bbotumotukuki taimi totonu",
               "CKT",
               "houa faka\u02bbotumotukuki taimi liliu",
               "CKHST",
               "houa faka\u02bbotumotukuki",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa fakapilit\u0101nia taimi liliu",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa faka\u02bbaealani taimi totonu",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
