/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClassesListControllerUI
extends JTitledPanel {
    private static Icon ICON_CLASSES = Icons.getIcon((String)"HeapWalkerIcons.Classes");
    private static final String DATA = "Data";
    private static final String NO_DATA = "No data";
    private String filterValue = "";
    private int filterType = 20;
    private CardLayout contents;
    private ClassesListController classesListController;
    private ClassesListTableModel realClassesListTableModel;
    private ExtendedTableModel classesListTableModel;
    private FilterComponent filterComponent;
    private JExtendedTable classesListTable;
    private JMenuItem showSourceItem;
    private JPanel contentsPanel;
    private JPopupMenu cornerPopup;
    private JPopupMenu tablePopup;
    private String selectedRowContents;
    private final int columnCount;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private int[] columnWidths;
    private Object[][] displayCache;
    private boolean hasProjectContext;
    private boolean retainedSizeSupported;
    private boolean internalCornerButtonClick = false;
    private boolean selectionSaved = false;
    private boolean showZeroInstances = true;
    private boolean showZeroSize = true;
    private boolean sortingOrder = false;
    private int selectedRow;
    private int sortingColumn = 1;
    private boolean isDiff = false;
    private HTMLLabel l;
    private JLabel w;
    private JProgressBar p;

    public ClassesListControllerUI(ClassesListController classesListController) {
        super(Bundle.ClassesListControllerUI_ViewTitle(), ICON_CLASSES, true);
        this.classesListController = classesListController;
        HeapFragmentWalker heapFragmentWalker = classesListController.getClassesController().getHeapFragmentWalker();
        this.hasProjectContext = heapFragmentWalker.getHeapDumpProject() != null;
        this.retainedSizeSupported = heapFragmentWalker.getRetainedSizesStatus() != -1;
        this.columnCount = this.retainedSizeSupported ? 5 : 4;
        this.realClassesListTableModel = new ClassesListTableModel();
        this.classesListTableModel = new ExtendedTableModel((SortableTableModel)this.realClassesListTableModel);
        this.initColumnsData();
        this.initData();
        this.initComponents();
        heapFragmentWalker.addStateListener(new HeapFragmentWalker.StateListener(){

            @Override
            public void stateChanged(HeapFragmentWalker.StateEvent stateEvent) {
                if (stateEvent.getRetainedSizesStatus() == 3 && stateEvent.isMasterChange()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ClassesListControllerUI.this.initData();
                            ClassesListControllerUI.this.setColumnVisibility(4, true);
                        }
                    });
                }
            }
        });
    }

    public void setColumnVisibility(int n, boolean bl) {
        boolean bl2 = this.classesListTableModel.isRealColumnVisible(n);
        if (bl2 == bl) {
            return;
        }
        this.saveSelection();
        boolean bl3 = false;
        int n2 = this.classesListTableModel.getSortingColumn();
        int n3 = this.classesListTableModel.getRealColumn(n2);
        if (bl2 && n == n3) {
            n2 = n2 + 1 == this.classesListTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
            n3 = this.classesListTableModel.getRealColumn(n2);
            bl3 = true;
        }
        this.classesListTableModel.setRealColumnVisibility(n, bl);
        this.classesListTable.createDefaultColumnsFromModel();
        this.classesListTableModel.setTable((JTable)this.classesListTable);
        n2 = this.classesListTableModel.getVirtualColumn(n3);
        if (bl3) {
            this.sortingOrder = this.classesListTableModel.getInitialSorting(n2);
            this.sortingColumn = n3;
            this.initData();
        }
        this.sortingColumn = n3;
        this.classesListTableModel.setInitialSorting(n2, this.sortingOrder);
        this.classesListTable.getTableHeader().repaint();
        this.setColumnsData(true);
        this.restoreSelection();
    }

    public boolean isRetainedVisible() {
        return this.classesListTableModel.isRealColumnVisible(4);
    }

    public void selectClass(JavaClass javaClass) {
        if (!this.selectClassImpl(javaClass)) {
            this.filterComponent.setFilterValue("");
            this.filterValue = this.filterComponent.getFilterValue();
            this.initDataImpl(javaClass);
        }
    }

    private boolean selectClassImpl(JavaClass javaClass) {
        if (this.displayCache == null || this.displayCache.length == 0) {
            return true;
        }
        for (int i = 0; i < this.displayCache.length; ++i) {
            if (!this.displayCache[i][this.columnCount].equals(javaClass)) continue;
            this.classesListTable.setRowSelectionInterval(i, i);
            final int n = i;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassesListControllerUI.this.classesListTable.ensureRowVisible(n);
                }
            });
            return true;
        }
        return false;
    }

    public void updateData() {
        this.initData();
    }

    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.realClassesListTableModel.getColumnCount(); ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.realClassesListTableModel.getColumnName(i));
            jCheckBoxMenuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.classesListTable != null) {
                jCheckBoxMenuItem.setState(this.classesListTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Bundle.ClassesListControllerUI_FilterCheckboxText());
        jCheckBoxMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(jCheckBoxMenuItem);
        if (this.filterComponent == null) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(this.filterComponent.getComponent().isVisible());
        }
        this.cornerPopup.add(jCheckBoxMenuItem);
        this.cornerPopup.pack();
    }

    protected void saveColumnsData() {
        TableColumnModel tableColumnModel = this.classesListTable.getColumnModel();
        for (int i = 0; i < this.classesListTableModel.getColumnCount(); ++i) {
            int n = this.classesListTableModel.getRealColumn(i);
            if (n == 0) continue;
            this.columnWidths[n - 1] = tableColumnModel.getColumn(i).getPreferredWidth();
        }
    }

    private void setColumnsData(boolean bl) {
        TableColumnModel tableColumnModel = this.classesListTable.getColumnModel();
        for (int i = 0; i < this.classesListTableModel.getColumnCount(); ++i) {
            int n = this.classesListTableModel.getRealColumn(i);
            if (bl && n != 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            }
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(final JCheckBoxMenuItem jCheckBoxMenuItem) {
        final boolean[] blArray = new boolean[1];
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Filter")) {
                    ClassesListControllerUI.this.filterComponent.getComponent().setVisible(!ClassesListControllerUI.this.filterComponent.getComponent().isVisible());
                    return;
                }
                if (blArray[0]) {
                    return;
                }
                int n = Integer.parseInt(actionEvent.getActionCommand());
                if (n == 4 && !ClassesListControllerUI.this.classesListTableModel.isRealColumnVisible(n)) {
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            final int n = ClassesListControllerUI.this.classesListController.getClassesController().getHeapFragmentWalker().computeRetainedSizes(true, true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (n != 3) {
                                        blArray[0] = true;
                                        jCheckBoxMenuItem.setSelected(!jCheckBoxMenuItem.isSelected());
                                        blArray[0] = false;
                                    } else {
                                        ClassesListControllerUI.this.initData();
                                        ClassesListControllerUI.this.setColumnVisibility(4, true);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    ClassesListControllerUI.this.setColumnVisibility(n, !ClassesListControllerUI.this.classesListTableModel.isRealColumnVisible(n));
                }
            }
        });
    }

    private JButton createHeaderPopupCornerButton(final JPopupMenu jPopupMenu) {
        final JButton jButton = new JButton(Icons.getIcon((String)"GeneralIcons.HideColumn"));
        jButton.setToolTipText(Bundle.ClassesListControllerUI_ShowHideColumnsString());
        jButton.setDefaultCapable(false);
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 2));
        } else if (UIUtils.isWindowsXPLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 0, 1));
        } else if (UIUtils.isMetalLookAndFeel()) {
            jButton.setMargin(new Insets(0, 0, 2, 1));
        }
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (jPopupMenu.isVisible()) {
                    ClassesListControllerUI.this.internalCornerButtonClick = true;
                    jButton.getModel().setArmed(false);
                } else {
                    ClassesListControllerUI.this.internalCornerButtonClick = false;
                    if (mouseEvent.getModifiers() == 4) {
                        ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16 && !ClassesListControllerUI.this.internalCornerButtonClick) {
                    ClassesListControllerUI.this.showColumnSelectionPopup(jPopupMenu, jButton);
                }
            }
        });
        return jButton;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Bundle.ClassesListControllerUI_ShowInInstancesString());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassesListControllerUI.this.performDefaultAction();
            }
        });
        jMenuItem.setFont(jPopupMenu.getFont().deriveFont(1));
        JMenuItem jMenuItem2 = new JMenuItem(this.hasProjectContext ? Bundle.ClassesListControllerUI_ShowImplementationsString() : Bundle.ClassesListControllerUI_ShowSubclassesString());
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClassesListControllerUI.this.classesListTable.getSelectedRow();
                if (n != -1) {
                    ClassesListControllerUI.this.showSubclassesForClass((JavaClass)ClassesListControllerUI.this.displayCache[n][ClassesListControllerUI.this.columnCount]);
                }
            }
        });
        if (GoToSource.isAvailable()) {
            this.showSourceItem = new JMenuItem(Bundle.ClassesListControllerUI_GoToSourceString());
            this.showSourceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ClassesListControllerUI.this.classesListTable.getSelectedRow();
                    if (n != -1) {
                        String string = BrowserUtils.getArrayBaseType((String)ClassesListControllerUI.this.displayCache[n][0]);
                        Lookup.Provider provider = ClassesListControllerUI.this.classesListController.getClassesController().getHeapFragmentWalker().getHeapDumpProject();
                        GoToSource.openSource((Lookup.Provider)provider, (String)string, null, null);
                    }
                }
            });
        }
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        if (this.showSourceItem != null) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.showSourceItem);
        }
        return jPopupMenu;
    }

    private void initColumnsData() {
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnToolTips = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnNames[0] = Bundle.ClassesListControllerUI_ClassNameColumnText();
        this.columnToolTips[0] = Bundle.ClassesListControllerUI_ClassNameColumnDescr();
        this.columnNames[1] = Bundle.ClassesListControllerUI_InstancesRelColumnText();
        this.columnToolTips[1] = Bundle.ClassesListControllerUI_InstancesRelColumnDescr();
        this.columnNames[2] = Bundle.ClassesListControllerUI_InstancesColumnText();
        this.columnToolTips[2] = Bundle.ClassesListControllerUI_InstancesColumnDescr();
        this.columnNames[3] = Bundle.ClassesListControllerUI_SizeColumnText();
        this.columnToolTips[3] = Bundle.ClassesListControllerUI_SizeColumnDescr();
        if (this.retainedSizeSupported) {
            this.columnNames[4] = Bundle.ClassesListControllerUI_RetainedSizeColumnName();
            this.columnToolTips[4] = Bundle.ClassesListControllerUI_RetainedSizeColumnDescr();
        }
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = classNameTableCellRenderer;
        this.columnWidths[0] = n;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = n;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        this.columnWidths[2] = n;
        this.columnRenderers[3] = labelBracketTableCellRenderer;
        if (this.retainedSizeSupported) {
            this.columnWidths[3] = n;
            this.columnRenderers[4] = labelBracketTableCellRenderer;
        }
    }

    protected Component[] getAdditionalControls() {
        if (this.l == null) {
            this.l = new HTMLLabel(){

                protected void showURL(URL uRL) {
                    if (ClassesListControllerUI.this.classesListController.isDiff()) {
                        ClassesListControllerUI.this.classesListController.resetDiffAction();
                    } else {
                        ClassesListControllerUI.this.classesListController.compareAction();
                    }
                }
            };
            this.l.setBorder(BorderFactory.createEmptyBorder());
            this.l.setFont(UIManager.getFont("ToolTip.font"));
            this.l.setText("<nobr><a href='#'>" + Bundle.ClassesListControllerUI_CompareWithAnotherText() + "</a></nobr>");
        }
        if (this.w == null) {
            this.w = new JLabel(Bundle.ClassesListControllerUI_ComparingMsg());
            this.w.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.w.setFont(UIManager.getFont("ToolTip.font"));
        }
        if (this.p == null) {
            this.p = new JProgressBar(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = ClassesListControllerUI.this.l.getPreferredSize();
                    dimension.width = 130;
                    return dimension;
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
        }
        JPanel jPanel = new JPanel(null);
        jPanel.setOpaque(false);
        jPanel.setPreferredSize(new Dimension(5, 5));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        this.w.setVisible(false);
        this.p.setVisible(false);
        this.l.setVisible(true);
        return new Component[]{this.w, this.p, this.l, jPanel};
    }

    public void showDiffProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassesListControllerUI.this.w.setVisible(true);
                ClassesListControllerUI.this.p.setIndeterminate(true);
                ClassesListControllerUI.this.p.setVisible(true);
                ClassesListControllerUI.this.l.setVisible(false);
            }
        });
    }

    public void hideDiffProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassesListControllerUI.this.w.setVisible(false);
                ClassesListControllerUI.this.p.setVisible(false);
                ClassesListControllerUI.this.p.setIndeterminate(false);
                if (ClassesListControllerUI.this.classesListController.isDiff()) {
                    ClassesListControllerUI.this.l.setText("<nobr>" + NbBundle.getMessage(ClassesListControllerUI.class, (String)"ClassesListControllerUI_ShowingDiffText", (Object)"<a href='#'>", (Object)"</a>") + "</nobr>");
                } else {
                    ClassesListControllerUI.this.l.setText("<nobr><a href='#'>" + Bundle.ClassesListControllerUI_CompareWithAnotherText() + "</a></nobr>");
                }
                ClassesListControllerUI.this.l.setVisible(true);
            }
        });
    }

    private void initComponents() {
        Object object;
        if (this.retainedSizeSupported) {
            object = this.classesListController.getClassesController().getHeapFragmentWalker();
            this.classesListTableModel.setRealColumnVisibility(4, ((HeapFragmentWalker)object).getRetainedSizesStatus() == 3);
        }
        this.classesListTable = new JExtendedTable((TableModel)this.classesListTableModel){

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < ClassesListControllerUI.this.classesListTableModel.getColumnCount(); ++i) {
                    if (ClassesListControllerUI.this.classesListTableModel.getRealColumn(i) == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(this.getWidth() - n);
                }
                super.doLayout();
            }
        };
        this.classesListTable.setSelectionMode(0);
        this.classesListTable.addMouseListener((MouseListener)new ClassesListTableMouseListener());
        this.classesListTable.addKeyListener((KeyListener)new ClassesListTableKeyListener());
        this.classesListTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.classesListTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.classesListTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.classesListTable.setShowHorizontalLines(false);
        this.classesListTable.setShowVerticalLines(true);
        this.classesListTable.setRowMargin(0);
        this.classesListTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.classesListTableModel.setTable((JTable)this.classesListTable);
        this.classesListTableModel.setInitialSorting(this.sortingColumn, this.sortingOrder);
        this.classesListTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.classesListTable.getAccessibleContext().setAccessibleName(Bundle.ClassesListControllerUI_ClassesTableAccessName());
        this.classesListTable.getAccessibleContext().setAccessibleDescription(Bundle.ClassesListControllerUI_ClassesTableAccessDescr());
        this.classesListTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.classesListTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassesListControllerUI.this.performDefaultAction();
            }
        });
        object = new HashSet(this.classesListTable.getFocusTraversalKeys(0));
        object.add(KeyStroke.getKeyStroke(9, 0));
        this.classesListTable.setFocusTraversalKeys(0, (Set)object);
        object = new HashSet<KeyStroke>(this.classesListTable.getFocusTraversalKeys(1));
        object.add(KeyStroke.getKeyStroke(9, 1));
        this.classesListTable.setFocusTraversalKeys(1, object);
        this.setColumnsData(true);
        this.filterComponent = FilterComponent.create((boolean)true, (boolean)true);
        this.filterComponent.addFilterType(this.hasProjectContext ? Bundle.ClassesListControllerUI_FilterImplementation() : Bundle.ClassesListControllerUI_FilterSubclass(), 1001);
        this.filterComponent.setHint(Bundle.ClassesListControllerUI_DefaultFilterText());
        this.filterComponent.setFilter(this.filterValue, this.filterType);
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ClassesListControllerUI.this.filterValue = ClassesListControllerUI.this.filterComponent.getFilterValue();
                ClassesListControllerUI.this.filterType = ClassesListControllerUI.this.filterComponent.getFilterType();
                ClassesListControllerUI.this.initData();
            }
        });
        this.tablePopup = this.createTablePopup();
        this.cornerPopup = new JPopupMenu();
        JExtendedTablePanel jExtendedTablePanel = new JExtendedTablePanel(this.classesListTable);
        jExtendedTablePanel.setCorner("UPPER_RIGHT_CORNER", (Component)this.createHeaderPopupCornerButton(this.cornerPopup));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        HTMLTextArea hTMLTextArea = new HTMLTextArea();
        hTMLTextArea.setBorder(BorderFactory.createEmptyBorder(10, 8, 8, 8));
        String string = Icons.getResource((String)"HeapWalkerIcons.Progress");
        String string2 = "<img border='0' align='bottom' src='nbresloc:/" + string + "'>&nbsp;&nbsp;" + Bundle.ClassesListControllerUI_FilteringProgressText();
        hTMLTextArea.setText(string2);
        jPanel.add((Component)hTMLTextArea, "Center");
        this.contents = new CardLayout();
        this.contentsPanel = new JPanel(this.contents);
        this.contentsPanel.add((Component)jExtendedTablePanel, DATA);
        this.contentsPanel.add((Component)jPanel, NO_DATA);
        this.contents.show(this.contentsPanel, NO_DATA);
        this.add(this.contentsPanel, "Center");
        this.add(this.filterComponent.getComponent(), "South");
        this.classesListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClassesListControllerUI.this.classesListController.classSelected(ClassesListControllerUI.this.classesListTable.getSelectedRow() == -1 ? null : (JavaClass)ClassesListControllerUI.this.displayCache[ClassesListControllerUI.this.classesListTable.getSelectedRow()][ClassesListControllerUI.this.columnCount]);
            }
        });
    }

    private void initData() {
        this.initDataImpl(null);
    }

    private void initDataImpl(final JavaClass javaClass) {
        if (this.displayCache == null) {
            this.displayCache = new Object[0][this.columnCount + 1];
        }
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ClassesListControllerUI.this.contents != null && atomicBoolean.get()) {
                                    ClassesListControllerUI.this.contents.show(ClassesListControllerUI.this.contentsPanel, ClassesListControllerUI.NO_DATA);
                                }
                            }
                        });
                    }
                }, 100);
                if (javaClass == null) {
                    ClassesListControllerUI.this.saveSelection();
                }
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        atomicBoolean.set(true);
                        final Object[][] objectArray = ClassesListControllerUI.this.classesListController.getData(FilterComponent.getFilterValues((String)ClassesListControllerUI.this.filterValue), ClassesListControllerUI.this.filterType, ClassesListControllerUI.this.showZeroInstances, ClassesListControllerUI.this.showZeroSize, ClassesListControllerUI.this.sortingColumn, ClassesListControllerUI.this.sortingOrder, ClassesListControllerUI.this.columnCount);
                        atomicBoolean.set(false);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ClassesListControllerUI.this.isDiff != ClassesListControllerUI.this.classesListController.isDiff()) {
                                    ClassesListControllerUI.this.isDiff = !ClassesListControllerUI.this.isDiff;
                                    DiffBarCellRenderer diffBarCellRenderer = ClassesListControllerUI.this.isDiff ? new DiffBarCellRenderer(((ClassesListControllerUI)ClassesListControllerUI.this).classesListController.minDiff, ((ClassesListControllerUI)ClassesListControllerUI.this).classesListController.maxDiff) : new CustomBarCellRenderer(0L, 100L);
                                    ((ClassesListControllerUI)ClassesListControllerUI.this).columnRenderers[1] = diffBarCellRenderer;
                                    LabelTableCellRenderer labelTableCellRenderer = ClassesListControllerUI.this.isDiff ? new LabelTableCellRenderer(11) : new LabelBracketTableCellRenderer(11);
                                    ((ClassesListControllerUI)ClassesListControllerUI.this).columnRenderers[2] = labelTableCellRenderer;
                                    ((ClassesListControllerUI)ClassesListControllerUI.this).columnRenderers[3] = labelTableCellRenderer;
                                    ((ClassesListControllerUI)ClassesListControllerUI.this).columnRenderers[4] = labelTableCellRenderer;
                                    ClassesListControllerUI.this.setColumnsData(false);
                                }
                                ClassesListControllerUI.access$502(ClassesListControllerUI.this, objectArray);
                                ClassesListControllerUI.this.classesListTableModel.fireTableDataChanged();
                                if (javaClass == null) {
                                    ClassesListControllerUI.this.restoreSelection();
                                } else {
                                    ClassesListControllerUI.this.selectClassImpl(javaClass);
                                }
                                if (ClassesListControllerUI.this.isDiff && ClassesListControllerUI.this.classesListController.compareRetained()) {
                                    ClassesListControllerUI.this.setColumnVisibility(4, true);
                                }
                                if (ClassesListControllerUI.this.contents != null) {
                                    ClassesListControllerUI.this.contents.show(ClassesListControllerUI.this.contentsPanel, ClassesListControllerUI.DATA);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void performDefaultAction() {
        int n = this.classesListTable.getSelectedRow();
        if (n != -1) {
            this.showInstancesForClass((JavaClass)this.displayCache[n][this.columnCount]);
        }
    }

    private void restoreSelection() {
        if (this.selectedRowContents != null) {
            this.classesListTable.selectRowByContents(this.selectedRowContents, 0, true);
        }
        this.selectionSaved = false;
    }

    private void saveSelection() {
        if (this.selectionSaved) {
            return;
        }
        this.selectedRow = this.classesListTable == null ? -1 : this.classesListTable.getSelectedRow();
        this.selectedRowContents = null;
        if (this.selectedRow != -1) {
            this.selectedRowContents = (String)this.classesListTable.getValueAt(this.selectedRow, 0);
        }
        this.selectionSaved = true;
    }

    private void showColumnSelectionPopup(JPopupMenu jPopupMenu, JButton jButton) {
        this.initColumnSelectorItems();
        jPopupMenu.show(jButton, jButton.getWidth() - jPopupMenu.getPreferredSize().width, jButton.getHeight());
    }

    private void showPopupMenu(int n, int n2, int n3) {
        if (n == -1) {
            return;
        }
        if (this.showSourceItem != null) {
            String string = BrowserUtils.getArrayBaseType((String)this.displayCache[n][0]);
            this.showSourceItem.setEnabled(!BrowserUtils.isPrimitiveType(string));
        }
        this.tablePopup.show((Component)this.classesListTable, n2, n3);
    }

    private void showInstancesForClass(JavaClass javaClass) {
        if (this.classesListController.isDiff() && javaClass == null) {
            ProfilerDialogs.displayInfo((String)Bundle.ClassesListControllerUI_NoClassInBaseMsg());
        } else if (javaClass.getInstancesCount() == 0) {
            ProfilerDialogs.displayInfo((String)Bundle.ClassesListControllerUI_NoInstancesMsg(javaClass.getName()));
        } else {
            this.classesListController.getClassesController().getHeapFragmentWalker().showInstancesForClass(javaClass);
        }
    }

    private void showSubclassesForClass(JavaClass javaClass) {
        this.filterComponent.setFilter(javaClass.getName(), 1001);
    }

    static /* synthetic */ Object[][] access$502(ClassesListControllerUI classesListControllerUI, Object[][] objectArray) {
        classesListControllerUI.displayCache = objectArray;
        return objectArray;
    }

    private class ClassesListTableMouseListener
    extends MouseAdapter {
        private ClassesListTableMouseListener() {
        }

        private void updateSelection(int n) {
            ClassesListControllerUI.this.classesListTable.requestFocusInWindow();
            if (n != -1) {
                ClassesListControllerUI.this.classesListTable.setRowSelectionInterval(n, n);
            } else {
                ClassesListControllerUI.this.classesListTable.clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = ClassesListControllerUI.this.classesListTable.rowAtPoint(mouseEvent.getPoint());
            this.updateSelection(n);
            if (mouseEvent.isPopupTrigger()) {
                ClassesListControllerUI.this.showPopupMenu(n, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = ClassesListControllerUI.this.classesListTable.rowAtPoint(mouseEvent.getPoint());
            this.updateSelection(n);
            if (mouseEvent.isPopupTrigger()) {
                ClassesListControllerUI.this.showPopupMenu(n, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n = ClassesListControllerUI.this.classesListTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
                ClassesListControllerUI.this.showInstancesForClass((JavaClass)ClassesListControllerUI.this.displayCache[n][ClassesListControllerUI.this.columnCount]);
            }
        }
    }

    private class ClassesListTableModel
    extends SortableTableModel {
        private ClassesListTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return Object.class;
        }

        public int getColumnCount() {
            return ClassesListControllerUI.this.columnCount;
        }

        public String getColumnName(int n) {
            return ClassesListControllerUI.this.columnNames[n];
        }

        public String getColumnToolTipText(int n) {
            return ClassesListControllerUI.this.columnToolTips[n];
        }

        public boolean getInitialSorting(int n) {
            switch (n) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        public int getRowCount() {
            return ClassesListControllerUI.this.displayCache.length;
        }

        public Object getValueAt(int n, int n2) {
            return ClassesListControllerUI.this.displayCache[n][n2];
        }

        public void sortByColumn(int n, boolean bl) {
            ClassesListControllerUI.this.sortingColumn = n;
            ClassesListControllerUI.this.sortingOrder = bl;
            ClassesListControllerUI.this.initData();
            ClassesListControllerUI.this.repaint();
        }
    }

    private class ClassesListTableKeyListener
    extends KeyAdapter {
        private ClassesListTableKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = ClassesListControllerUI.this.classesListTable.getSelectedRow()) != -1) {
                Rectangle rectangle = ClassesListControllerUI.this.classesListTable.getCellRect(n, 0, true);
                ClassesListControllerUI.this.showPopupMenu(n, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            }
        }
    }
}

