# Copyright 2017 MongoDB Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set (MONGOC_MAJOR_VERSION 1)
set (MONGOC_MINOR_VERSION 9)
set (MONGOC_MICRO_VERSION 5)
set (MONGOC_VERSION 1.9.5)

find_package (libbson-1.0 "1.9" REQUIRED)

# In a pure-CMake project this is inserted by configure_package_config_file(),
# but we want to be able to build this file the same from the Autotools, so
# let's manually insert this code.
get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

set_and_check (MONGOC_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/libmongoc-1.0")
list (APPEND MONGOC_INCLUDE_DIRS ${BSON_INCLUDE_DIRS})

# We want to provide an absolute path to the library and we know the
# directory and the base name, but not the suffix, so we use CMake's
# find_library() to pick that up.  Users can override this by configuring
# MONGOC_LIBRARY themselves.
find_library(MONGOC_LIBRARY mongoc-1.0 PATHS "${PACKAGE_PREFIX_DIR}/lib" NO_DEFAULT_PATH)
set (MONGOC_LIBRARIES ${MONGOC_LIBRARY} ${BSON_LIBRARIES})

# If this file is generated by the Autotools on Mac, SSL_LIBS might be
# "-framework CoreFoundation -framework Security". Split into a CMake array
# like "-framework CoreFoundation;-framework Security".
set (IS_FRAMEWORK_VAR 0)
foreach (LIB -lsasl2 -lssl -lcrypto -lrt -lresolv -lsnappy)
   if (LIB STREQUAL "-framework")
      set (IS_FRAMEWORK_VAR 1)
      continue ()
   elseif (IS_FRAMEWORK_VAR)
      list (APPEND MONGOC_LIBRARIES "-framework ${LIB}")
      set (IS_FRAMEWORK_VAR 0)
   else ()
      list (APPEND MONGOC_LIBRARIES ${LIB})
   endif ()
endforeach ()

set (MONGOC_DEFINITIONS ${BSON_DEFINITIONS})
