/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestiska";
        final String metaValue_ar = "arabiska";
        final String metaValue_bo = "tibetanska";
        final String metaValue_el = "grekiska";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebreiska";
        final String metaValue_hy = "armeniska";
        final String metaValue_ja = "japanska";
        final String metaValue_ka = "georgiska";
        final String metaValue_ko = "koreanska";
        final String metaValue_lo = "laotiska";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongoliska";
        final String metaValue_my = "burmesiska";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singalesiska";
        final String metaValue_su = "sundanesiska";
        final String metaValue_th = "thail\u00e4ndska";
        final String metaValue_tl = "tagalog";
        final String metaValue_ban = "balinesiska";
        final String metaValue_bax = "bamunska";
        final String metaValue_bug = "buginesiska";
        final String metaValue_cop = "koptiska";
        final String metaValue_gez = "etiopiska";
        final String metaValue_got = "gotiska";
        final String metaValue_men = "mende";
        final String metaValue_nqo = "n-k\u00e5";
        final String metaValue_peo = "fornpersiska";
        final String metaValue_saz = "saurashtra";
        final String metaValue_sco = "skotska";
        final String metaValue_syr = "syriska";
        final String metaValue_uga = "ugaritiska";
        final String metaValue_vai = "vaj";
        final String metaValue_zbl = "blissymboler";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lniska" },
            { "Ogam", "ogham" },
            { "mwl", "mirandesiska" },
            { "Zsym", "symboler" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "egl", "emiliska" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwa" },
            { "%%NJIVA", "Njiva-dialekt" },
            { "xmf", "mingrelianska" },
            { "egy", "fornegyptiska" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension" },
            { "rar", "rarotonganska" },
            { "tet", "tetum" },
            { "%%BARLA", "barlavento-dialekt" },
            { "AD", "Andorra" },
            { "AE", "F\u00f6renade Arabemiraten" },
            { "nl_BE", "flaml\u00e4ndska" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua och Barbuda" },
            { "glk", "gilaki" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "Prti", "tidig parthianska" },
            { "AS", "Amerikanska Samoa" },
            { "AT", "\u00d6sterrike" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "en_US", "amerikansk engelska" },
            { "AX", "\u00c5land" },
            { "mye", "myene" },
            { "AZ", "Azerbajdzjan" },
            { "%%AREVELA", "\u00f6starmeniska" },
            { "BA", "Bosnien och Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumykiska" },
            { "BE", "Belgien" },
            { "gmh", "medelh\u00f6gtyska" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S:t Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenaj" },
            { "myv", "erjya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibiska Nederl\u00e4nderna" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "xog", "lusoga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f6n" },
            { "BW", "Botswana" },
            { "BY", "Vitryssland" },
            { "BZ", "Belize" },
            { "Visp", "synligt tal" },
            { "CA", "Kanada" },
            { "CC", "Kokos\u00f6arna" },
            { "mzn", "mazanderani" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralafrikanska republiken" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "Elfenbenskusten" },
            { "CK", "Cook\u00f6arna" },
            { "CL", "Chile" },
            { "Kthi", "kaithiska" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f6n" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Jul\u00f6n" },
            { "CY", "Cypern" },
            { "CZ", "Tjeckien" },
            { "eka", "ekajuk" },
            { "Ahom", "ahom" },
            { "Pauc", "Pau Cin Hau-skrift" },
            { "vls", "v\u00e4stflaml\u00e4ndska" },
            { "%%RIGIK", "rigik-stavning" },
            { "DE", "Tyskland" },
            { "goh", "fornh\u00f6gtyska" },
            { "ace", "acehnesiska" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Goa-konkani" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "ach", "acholi" },
            { "gon", "gondi" },
            { "Brai", "punktskrift" },
            { "Brah", "brami" },
            { "DM", "Dominica" },
            { "DO", "Dominikanska republiken" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Main-frankiska" },
            { "Mtei", "meitei-mayek" },
            { "zun", "zuni" },
            { "tig", "tigr\u00e9" },
            { "Takr", "takritiska" },
            { "DZ", "Algeriet" },
            { "pag", "pangasinan" },
            { "pal", "medelpersiska" },
            { "EA", "Ceuta och Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estland" },
            { "tiv", "tivi" },
            { "EG", "Egypten" },
            { "EH", "V\u00e4stsahara" },
            { "chg", "chagatai" },
            { "pau", "palau" },
            { "chk", "chuukesiska" },
            { "chn", "chinook" },
            { "chm", "mariska" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", "cherokesiska" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Etiopien" },
            { "EU", "Europeiska unionen" },
            { "elx", "elamitiska" },
            { "chy", "cheyenne" },
            { "Inds", "indus" },
            { "ady", "adygeiska" },
            { "aeb", "tunisisk arabiska" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f6arna" },
            { "FM", "Mikronesien" },
            { "FO", "F\u00e4r\u00f6arna" },
            { "Taml", "tamilska" },
            { "FR", "Frankrike" },
            { "Kpel", "kpell\u00e9" },
            { "pcd", "pikardiska" },
            { "tkl", "tokelauiska" },
            { "grb", "grebo" },
            { "root", "rot" },
            { "%%DAJNKO", "Dajnko-alfabetet" },
            { "rgn", "romagnol" },
            { "grc", "forngrekiska" },
            { "GA", "Gabon" },
            { "tkr", "tsakhur" },
            { "vot", "votiska" },
            { "GB", "Storbritannien" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Franska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f6nland" },
            { "enm", "medelengelska" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorialguinea" },
            { "GR", "Grekland" },
            { "GS", "Sydgeorgien och Sydsandwich\u00f6arna" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvaniatyska" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingonska" },
            { "Talu", "tai lue" },
            { "GY", "Guyana" },
            { "ckb", "soranisk kurdiska" },
            { "zxx", "inget spr\u00e5kligt inneh\u00e5ll" },
            { "Jurc", "jurchenska" },
            { "tly", "talysh" },
            { "pdt", "mennonitisk l\u00e5gtyska" },
            { "de_AT", "\u00f6sterrikisk tyska" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong, S.A.R. Kina" },
            { "HM", "Heard\u00f6n och McDonald\u00f6arna" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "agq", "aghem" },
            { "gsw", "schweizertyska" },
            { "HT", "Haiti" },
            { "HU", "Ungern" },
            { "rif", "riffianska" },
            { "tmh", "tamashek" },
            { "IC", "Kanarie\u00f6arna" },
            { "nan", "min nan" },
            { "peo", metaValue_peo },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "nap", "napolitanska" },
            { "%%NDYUKA", "Ndyuka-dialekt" },
            { "naq", "nama" },
            { "zza", "zazaiska" },
            { "Tang", "tangutiska" },
            { "IL", "Israel" },
            { "Nbat", "nabatateiska" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IO", "Brittiska territoriet i Indiska oceanen" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "Zmth", "matematisk notation" },
            { "vro", "v\u00f5ru" },
            { "guc", "wayuu" },
            { "%%POSIX", "Posix" },
            { "pfl", "Pfalz-tyska" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "Beng", "bengaliska" },
            { "%%EKAVSK", "ekavisk dialekt" },
            { "JO", "Jordanien" },
            { "gur", "farefare" },
            { "JP", "Japan" },
            { "%%1606NICT", "1606 \u00e5rs stavning" },
            { "ain", "ainu" },
            { "%%KOCIEWIE", "kociewiska" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "nyasatonganska" },
            { "Kali", "kaya li" },
            { "Sidd", "siddhamska" },
            { "de_CH", "schweizisk h\u00f6gtyska" },
            { "izh", "ingriska" },
            { "KE", "Kenya" },
            { "419", "Latinamerika" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komorerna" },
            { "KN", "S:t Kitts och Nevis" },
            { "Knda", "kanaresiska" },
            { "Zinh", "\u00e4rvda" },
            { "fr_CA", "kanadensisk franska" },
            { "KP", "Nordkorea" },
            { "KR", "Sydkorea" },
            { "Plrd", "pollardtecken" },
            { "fr_CH", "schweizisk franska" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Cayman\u00f6arna" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "kyrilliska" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "S:t Lucia" },
            { "phn", "feniciska" },
            { "Cyrs", "fornkyrkoslavisk kyrilliska" },
            { "gwi", "gwichin" },
            { "%%LUNA1918", "1918 \u00e5rs stavning" },
            { "nds", "l\u00e5gtyska" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadiska" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "esu", "centralalaskisk jupiska" },
            { "LS", "Lesotho" },
            { "Phlv", "bokpahlavi" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "Libyen" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "akz", "Alabama-muskogee" },
            { "%%LAUKIKA", "laukika-dialekt" },
            { "lah", "lahnda" },
            { "Mahj", "mahajaniska" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Marocko" },
            { "MC", "Monaco" },
            { "MD", "Moldavien" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "S:t Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall\u00f6arna" },
            { "ale", "aleutiska" },
            { "MK", "Makedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongoliet" },
            { "new", "newariska" },
            { "MO", "Macao, S.A.R. Kina" },
            { "aln", "gegiska" },
            { "MP", "Nordmarianerna" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "kapisnon" },
            { "MU", "Mauritius" },
            { "alt", "sydaltaiska" },
            { "MV", "Maldiverna" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mo\u00e7ambique" },
            { "Phli", "tidig pahlavi" },
            { "NA", "Namibia" },
            { "NC", "Nya Kaledonien" },
            { "%%WADEGILE", "Wade-Giles" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "reviderad unifierad stavning" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f6n" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "psaltaren-pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahaw mong" },
            { "NL", "Nederl\u00e4nderna" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "tsakodiska" },
            { "NU", "Niue" },
            { "Phnx", "fenikiska" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Nya Zeeland" },
            { "Merc", "kursiv-meroitiska" },
            { "rom", "romani" },
            { "Mero", "meroitiska" },
            { "crh", "krimtatariska" },
            { "ang", "fornengelska" },
            { "OM", "Oman" },
            { "%%PETR1708", "1708 \u00e5rs stavning" },
            { "anp", "angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "csb", "kasjubiska" },
            { "en_GB", "brittisk engelska" },
            { "PE", "Peru" },
            { "ttt", "muslimsk tatariska" },
            { "PF", "Franska Polynesien" },
            { "PG", "Papua Nya Guinea" },
            { "PH", "Filippinerna" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "ewondo" },
            { "PM", "S:t Pierre och Miquelon" },
            { "PN", "Pitcairn\u00f6arna" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestinska territorierna" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", metaValue_sco },
            { "jam", "jamaikansk engelsk kreol" },
            { "pms", "piemontesiska" },
            { "niu", "niueanska" },
            { "QO", "yttre \u00f6ar i Oceanien" },
            { "ext", "extremaduriska" },
            { "lez", "lezghien" },
            { "%%FONUPA", "uralisk fonetisk notation" },
            { "tvl", "tuvaluanska" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "sotavento-dialekt" },
            { "001", "v\u00e4rlden" },
            { "002", "Afrika" },
            { "njo", "ao-naga" },
            { "003", "Nordamerika" },
            { "RE", "R\u00e9union" },
            { "005", "Sydamerika" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "pontiska" },
            { "Rjng", "rejang" },
            { "009", "Oceanien" },
            { "%%SURSILV", "sursilvan-dialekt" },
            { "RO", "Rum\u00e4nien" },
            { "RS", "Serbien" },
            { "Mroo", "mru" },
            { "RU", "Ryssland" },
            { "RW", "Rwanda" },
            { "%%METELKO", "Metelko-alfabetet" },
            { "Ugar", metaValue_uga },
            { "Mani", "manikeanska" },
            { "Khar", "kharoshti" },
            { "SA", "Saudiarabien" },
            { "pon", "ponape" },
            { "Mand", "manda\u00e9iska" },
            { "SB", "Salomon\u00f6arna" },
            { "twq", "tasawaq" },
            { "011", "V\u00e4stafrika" },
            { "SC", "Seychellerna" },
            { "SD", "Sudan" },
            { "013", "Centralamerika" },
            { "SE", "Sverige" },
            { "014", "\u00d6stafrika" },
            { "arc", "arameiska" },
            { "Loma", "loma" },
            { "015", "Nordafrika" },
            { "SG", "Singapore" },
            { "SH", "S:t Helena" },
            { "017", "Centralafrika" },
            { "SI", "Slovenien" },
            { "018", "s\u00f6dra Afrika" },
            { "SJ", "Svalbard och Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Nord- och Sydamerika" },
            { "SK", "Slovakien" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "araukanska" },
            { "arp", "arapaho" },
            { "SR", "Surinam" },
            { "aro", "araoniska" },
            { "SS", "Sydsudan" },
            { "ST", "S\u00e3o Tom\u00e9 och Pr\u00edncipe" },
            { "arq", "algerisk arabiska" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "yao", "kiyao" },
            { "SZ", "Swaziland" },
            { "arw", "arawakiska" },
            { "arz", "egyptisk arabiska" },
            { "ary", "marockansk arabiska" },
            { "yap", "japetiska" },
            { "rtm", "rotum\u00e4nska" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "norra Amerika" },
            { "TC", "Turks- och Caicos\u00f6arna" },
            { "yav", "yangben" },
            { "TD", "Tchad" },
            { "TF", "Franska sydterritorierna" },
            { "ase", "amerikanskt teckenspr\u00e5k" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadzjikistan" },
            { "029", "Karibien" },
            { "TK", "Tokelau" },
            { "TL", "\u00d6sttimor" },
            { "ybb", "bamilek\u00e9-jemba" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisien" },
            { "TO", "Tonga" },
            { "%%NULIK", "nulik-stavning" },
            { "TR", "Turkiet" },
            { "TT", "Trinidad och Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturiska" },
            { "rue", "rusyn" },
            { "rug", "rovianska" },
            { "Orkh", "orkon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "ok\u00e4nt skriftsystem" },
            { "Sind", "sindhiska" },
            { "UA", "Ukraina" },
            { "lij", "liguriska" },
            { "rup", "arum\u00e4nska" },
            { "030", "\u00d6stasien" },
            { "tyv", "tuviniska" },
            { "sw_CD", "Kongo-swahili" },
            { "034", "Sydasien" },
            { "hai", "haida" },
            { "035", "Sydostasien" },
            { "UG", "Uganda" },
            { "hak", "hakka" },
            { "039", "Sydeuropa" },
            { "Sinh", metaValue_si },
            { "UM", "USA:s yttre \u00f6ar" },
            { "liv", "livoniska" },
            { "US", "USA" },
            { "haw", "hawaiiska" },
            { "%%1959ACAD", "1959 \u00e5rs stavning" },
            { "UY", "Uruguay" },
            { "prg", "fornpreussiska" },
            { "UZ", "Uzbekistan" },
            { "tzm", "centralmarockansk tamazight" },
            { "nnh", "bamilek\u00e9-ngiemboon" },
            { "VA", "Vatikanstaten" },
            { "pro", "fornprovensalska" },
            { "VC", "S:t Vincent och Grenadinerna" },
            { "VE", "Venezuela" },
            { "VG", "Brittiska Jungfru\u00f6arna" },
            { "VI", "Amerikanska Jungfru\u00f6arna" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "fornnordiska" },
            { "053", "Australasien" },
            { "%%AREVMDA", "v\u00e4starmeniska" },
            { "054", "Melanesien" },
            { "WF", "Wallis- och Futuna\u00f6arna" },
            { "057", "Mikronesiska \u00f6arna" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "avk", "kotava" },
            { "%%HEPBURN", "Hepburn" },
            { "wae", "walsertyska" },
            { "WS", "Samoa" },
            { "Bass", "bassaiska vah" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polynesien" },
            { "%%KSCOR", "standardstavning" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "oskrivet spr\u00e5k" },
            { "Olck", "ol-chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "lmo", "lombardiska" },
            { "fan", "fang" },
            { "%%BALANKA", "balanka-dialekt" },
            { "%%ROZAJ", "resisk dialekt" },
            { "%%SUTSILV", "sutsilvan-dialekt" },
            { "fat", "fanti" },
            { "Sgnw", "teckningsskrift" },
            { "YT", "Mayotte" },
            { "ZA", "Sydafrika" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ok\u00e4nd region" },
            { "Runr", "runor" },
            { "lol", "mongo" },
            { "nso", "nordsotho" },
            { "loz", "lozi" },
            { "Nkgb", "naxi geba" },
            { "jmc", "kimashami" },
            { "hif", "Fiji-hindi" },
            { "hil", "hiligaynon" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "hit", "hettitiska" },
            { "dar", "darginska" },
            { "dav", "taita" },
            { "Maya", "mayahieroglyfer" },
            { "lrc", "nordluri" },
            { "Copt", metaValue_cop },
            { "nwc", "klassisk newariska" },
            { "udm", "udmurtiska" },
            { "Khmr", "khmeriska" },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "sah", "jakutiska" },
            { "ltg", "lettgalliska" },
            { "sam", "samaritanska" },
            { "Aghb", "kaukasiska albanska" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinaghiska" },
            { "saz", metaValue_saz },
            { "jpr", "judisk persiska" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "Aluku-dialekt" },
            { "lua", "luba-lulua" },
            { "%%BISCAYAN", "Biscaya-dialekt" },
            { "sbp", "sangu" },
            { "lui", "luise\u00f1o" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filippinska" },
            { "hmn", "hmongspr\u00e5k" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "baluchiska" },
            { "den", "slavej" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "fit", "me\u00e4nkieli" },
            { "luy", "luhya" },
            { "bar", "bayerska" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "jrb", "judisk arabiska" },
            { "es_ES", "europeisk spanska" },
            { "nzi", "nzima" },
            { "sco", metaValue_sco },
            { "scn", "sicilianska" },
            { "aa", "afar" },
            { "ab", "abchaziska" },
            { "bbc", "batak-toba" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "amhariska" },
            { "Arab", metaValue_ar },
            { "an", "aragonesiska" },
            { "%%SOLBA", "Solbica-dialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana/hiragana" },
            { "as", "assamesiska" },
            { "sdc", "sassaresisk sardiska" },
            { "Lina", "linj\u00e4r A" },
            { "av", "avariska" },
            { "Linb", "linj\u00e4r B" },
            { "sdh", "sydkurdiska" },
            { "ay", "aymara" },
            { "az", "azerbajdzjanska" },
            { "Khoj", "khojkiska" },
            { "%%OSOJS", "Osojane-dialekt" },
            { "%%UNIFON", "unifon-skrift" },
            { "ba", "basjkiriska" },
            { "be", "vitryska" },
            { "bg", "bulgariska" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretonska" },
            { "bs", "bosniska" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "sei", "seri" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "katalanska" },
            { "ses", "Gao-songhay" },
            { "ce", "tjetjenska" },
            { "ch", "chamorro" },
            { "%%REVISED", "reformerad stavning" },
            { "co", "korsikanska" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tjeckiska" },
            { "cu", "kyrkslaviska" },
            { "yrl", "nheengatu" },
            { "cv", "tjuvasjiska" },
            { "cy", "walesiska" },
            { "Yiii", "yi" },
            { "da", "danska" },
            { "pt_PT", "europeisk portugisiska" },
            { "de", "tyska" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "jut", "jyll\u00e4ndska" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "forniriska" },
            { "dv", "divehi" },
            { "es_419", "latinamerikansk spanska" },
            { "bew", "betawiska" },
            { "dz", "bhutanesiska" },
            { "bez", "bena" },
            { "lzh", "litter\u00e4r kineiska" },
            { "Lisu", "Fraser" },
            { "dje", "zarma" },
            { "sgs", "samogitiska" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "ro_MD", "moldaviska" },
            { "el", metaValue_el },
            { "en", "engelska" },
            { "eo", "esperanto" },
            { "bfq", "bagada" },
            { "lzz", "laziska" },
            { "es", "spanska" },
            { "et", "estniska" },
            { "eu", "baskiska" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritiska" },
            { "shi", "tachelhit" },
            { "hsb", "h\u00f6gsorbiska" },
            { "Hani", "han" },
            { "%%ULSTER", "Ulster-dialekt" },
            { "shn", "shan" },
            { "Hano", "hanun\u00e5" },
            { "fa", "persiska" },
            { "Hans", "f\u00f6renklade" },
            { "Hant", "traditionella" },
            { "ff", "fulani" },
            { "shu", "Chad-arabiska" },
            { "hsn", "xiang" },
            { "fi", "finska" },
            { "fj", "fijianska" },
            { "fon", "fonspr\u00e5ket" },
            { "bgn", "v\u00e4stbaluchiska" },
            { "yue", "kantonesiska" },
            { "fo", "f\u00e4r\u00f6iska" },
            { "umb", "umbundu" },
            { "fr", "franska" },
            { "sid", "sidamo" },
            { "fy", "v\u00e4stfrisiska" },
            { "ga", "iriska" },
            { "gd", "skotsk g\u00e4liska" },
            { "gl", "galiciska" },
            { "gn", "guaran\u00ed" },
            { "bho", "bhojpuri" },
            { "und", "obest\u00e4mt spr\u00e5k" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hirimotu" },
            { "hr", "kroatiska" },
            { "ht", "haitiska" },
            { "hu", "ungerska" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "cajun-franska" },
            { "%%FONIPA", "internationell fonetisk notation - IPA" },
            { "ia", "interlingua" },
            { "id", "indonesiska" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "szezuan i" },
            { "frm", "medelfranska" },
            { "%%RUMGR", "grischun-dialekt" },
            { "ik", "inupiak" },
            { "fro", "fornfranska" },
            { "frp", "frankoprovensalska" },
            { "io", "ido" },
            { "frs", "\u00f6stfrisiska" },
            { "bjn", "banjariska" },
            { "frr", "nordfrisiska" },
            { "is", "isl\u00e4ndska" },
            { "it", "italienska" },
            { "iu", "inuktitut" },
            { "sli", "l\u00e5gsilesiska" },
            { "%%HOGNORSK", "h\u00f6gnorsk dialekt" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "fornsydarabiska" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "bkm", "bamekon" },
            { "sma", "sydsamiska" },
            { "jv", "javanesiska" },
            { "Shaw", "shawiska" },
            { "%%BAUDDHA", "bauddha-dialekt" },
            { "mad", "maduresiska" },
            { "smj", "lulesamiska" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "enaresamiska" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu" },
            { "sms", "skoltsamiska" },
            { "man", "mande" },
            { "kg", "kikongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "massajiska" },
            { "kj", "kuanyama" },
            { "kk", "kazakiska" },
            { "kl", "gr\u00f6nl\u00e4ndska" },
            { "km", "kambodjanska" },
            { "kn", "kannada" },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiriska" },
            { "Cirt", "cirt" },
            { "Lepc", "rong" },
            { "Avst", metaValue_ae },
            { "ku", "kurdiska" },
            { "kv", "kome" },
            { "kw", "korniska" },
            { "ky", "kirgisiska" },
            { "snk", "soninke" },
            { "Mult", "multaniska" },
            { "la", "latin" },
            { "Hatr", "hatran" },
            { "lb", "luxemburgiska" },
            { "lg", "luganda" },
            { "Roro", "rongo-rongo" },
            { "li", "limburgiska" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulianska" },
            { "lo", metaValue_lo },
            { "lt", "litauiska" },
            { "lu", "luba-katanga" },
            { "lv", "lettiska" },
            { "sog", "sogdiska" },
            { "mg", "malagassiska" },
            { "mh", "marshalliska" },
            { "mi", "maori" },
            { "mk", "makedonska" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malajiska" },
            { "mt", "maltesiska" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "moksja" },
            { "mde", "maba" },
            { "dsb", "l\u00e5gsorbiska" },
            { "Armi", "imperisk arameiska" },
            { "na", "nauru" },
            { "nb", "norskt bokm\u00e5l" },
            { "nd", "nordndebele" },
            { "ne", "nepalesiska" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "nederl\u00e4ndska" },
            { "nn", "nynorska" },
            { "no", "norska" },
            { "nr", "sydndebele" },
            { "nv", "navaho" },
            { "kaa", "karakalpakiska" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabyliska" },
            { "%%POLYTON", "polytonisk stavning" },
            { "oc", "occitanska" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "tidig modern engelska" },
            { "oj", "odjibwa" },
            { "mer", "meru" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "dtp", "centraldusun" },
            { "or", metaValue_or },
            { "Modi", "modiska" },
            { "os", "ossetiska" },
            { "%%ALALC97", "1997 \u00e5rs ALA-LC" },
            { "bpy", "bishnupriya" },
            { "kbd", "kabardinska" },
            { "mfe", "mauritansk kreol" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "Lipovaz-dialekt" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "bqi", "bakhtiari" },
            { "pl", "polska" },
            { "dum", "medelnederl\u00e4ndska" },
            { "%%VALLADER", "vallader-dialekt" },
            { "ps", "afghanska" },
            { "pt", "portugisiska" },
            { "mga", "medeliriska" },
            { "pt_BR", "brasiliansk portugisiska" },
            { "%%BOHORIC", "Bohori\u010d-alfabetet" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "bra", "braj" },
            { "%%JAUER", "jauer-dialekt" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "surmiran-dialekt" },
            { "mgo", "meta\u2019" },
            { "ssy", "saho" },
            { "brh", "brahuiska" },
            { "qu", "quechua" },
            { "zap", "zapotek" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "vedisk dialekt" },
            { "Ethi", metaValue_gez },
            { "stq", "saterfrisiska" },
            { "%%JYUTPING", "jyutping" },
            { "rm", "r\u00e4toromanska" },
            { "rn", "rundi" },
            { "ro", "rum\u00e4nska" },
            { "%%SAAHO", "saho-dialekt" },
            { "ru", "ryska" },
            { "bss", "bakossi" },
            { "zbl", metaValue_zbl },
            { "rw", "kinjarwanda" },
            { "kea", "kapverdiska" },
            { "mic", "mi\u2019kmaq" },
            { "suk", "sukuma" },
            { "en_AU", "australisk engelska" },
            { "Dupl", "Duploy\u00e9stenografiska" },
            { "sa", "sanskrit" },
            { "%%UCCOR", "unifierad stavning" },
            { "sc", "sardiska" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "nordsamiska" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroatiska" },
            { "ken", "kenjang" },
            { "si", metaValue_si },
            { "sux", "sumeriska" },
            { "sk", "slovakiska" },
            { "sl", "slovenska" },
            { "Gran", "gammaltamilska" },
            { "sm", "samoanska" },
            { "sn", "shona" },
            { "so", "somaliska" },
            { "sq", "albanska" },
            { "sr", "serbiska" },
            { "ss", "swati" },
            { "st", "sydsotho" },
            { "Java", "javanska" },
            { "su", metaValue_su },
            { "%%NEDIS", "natisonsk dialekt" },
            { "sv", "svenska" },
            { "sw", "swahili" },
            { "ibb", "ibibio" },
            { "iba", "ibanska" },
            { "ta", "tamil" },
            { "142", "Asien" },
            { "bua", "burj\u00e4tiska" },
            { "143", "Centralasien" },
            { "te", "telugiska" },
            { "145", "V\u00e4stasien" },
            { "tg", "tadzjikiska" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigrinja" },
            { "kfo", "koro" },
            { "en_CA", "kanadensisk engelska" },
            { "tk", "turkmeniska" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganska" },
            { "bum", "boulou" },
            { "dyo", "jola-fonyi" },
            { "tr", "turkiska" },
            { "ts", "tsonga" },
            { "swb", "shimaor\u00e9" },
            { "Cakm", "chakma" },
            { "tt", "tatariska" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitiska" },
            { "%%BISKE", "Bila-dialekt" },
            { "150", "Europa" },
            { "151", "\u00d6steuropa" },
            { "154", "Nordeuropa" },
            { "dzg", "dazaga" },
            { "155", "V\u00e4steuropa" },
            { "ug", "uiguriska" },
            { "Kore", metaValue_ko },
            { "Ital", "fornitaliska" },
            { "kgp", "kaingang" },
            { "Zyyy", "gemensamma" },
            { "uk", "ukrainska" },
            { "zea", "zeel\u00e4ndska" },
            { "ur", "urdu" },
            { "%%1994", "1994 \u00e5rs resisk stavning" },
            { "xal", "kalmuckiska" },
            { "zen", "zenaga" },
            { "uz", "uzbekiska" },
            { "kha", "khasi" },
            { "%%1996", "1996 \u00e5rs reformerad tysk stavning" },
            { "nds_NL", "l\u00e5gsaxiska" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "vi", "vietnamesiska" },
            { "kho", "khotanesiska" },
            { "khq", "Timbuktu-songhoy" },
            { "%%TARASK", "Taraskievika-stavning" },
            { "vo", "volap\u00fck" },
            { "khw", "khowar" },
            { "syc", "klassisk syriska" },
            { "Osma", "osmanja" },
            { "quc", "quich\u00e9" },
            { "qug", "Chimborazo-h\u00f6glandskichwa" },
            { "gaa", "g\u00e3" },
            { "wa", "vallonska" },
            { "gag", "gagauziska" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "kiu", "kirmanjki" },
            { "Lydi", "lydiska" },
            { "Xsux", "sumeo-akkadisk kilskrift" },
            { "wo", "wolof" },
            { "zgh", "marockansk standard-tamazight" },
            { "ar_001", "modern standardarabiska" },
            { "Cans", "kanadensiska stavelsetecken" },
            { "%%FONXSAMP", "X-SAMPA fonetisk notation" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manchuriska" },
            { "Latf", "frakturlatin" },
            { "szl", "silesiska" },
            { "Hluw", "hittitiska hieroglyfer" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", "latinska" },
            { "Latg", "gaeliskt latin" },
            { "xh", "xhosa" },
            { "byn", "blin" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "Lyci", "lykiska" },
            { "osa", "osage" },
            { "byv", "bagangte" },
            { "gbz", "zoroastrisk dari" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "mkako" },
            { "%%1694ACAD", "1694 \u00e5rs stavning" },
            { "Syrc", metaValue_syr },
            { "yi", "jiddisch" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "es_MX", "mexikansk spanska" },
            { "Syrj", "v\u00e4stsyriska" },
            { "ota", "ottomanska" },
            { "Syre", "estrangelosyriska" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "kariska" },
            { "kln", "kalenjin" },
            { "zh", "kinesiska" },
            { "Afak", "afakiska" },
            { "Bopo", "bopomofo" },
            { "Perm", "fornpermiska" },
            { "zu", "zulu" },
            { "%%MONOTON", "monotonisk stavning" },
            { "Geor", metaValue_ka },
            { "Shrd", "sharada" },
            { "kmb", "kimbundu" },
            { "Cham", "cham" },
            { "gez", metaValue_gez },
            { "mrj", "v\u00e4stmariska" },
            { "Syrn", "\u00f6stsyriska" },
            { "Elba", "elbasiska" },
            { "Narb", "fornnordarabiska" },
            { "Tglg", metaValue_tl },
            { "Egyd", "demotiska" },
            { "Egyh", "hieratiska" },
            { "%%ITIHASA", "itihasa-dialekt" },
            { "Palm", "palmyreniska" },
            { "ebu", "embu" },
            { "Egyp", "egyptiska hieroglyfer" },
            { "Geok", "kutsuri" },
            { "zh_Hans", "f\u00f6renklad kinesiska" },
            { "koi", "komi-permjakiska" },
            { "Hung", "fornungerska" },
            { "kok", "konkani" },
            { "%%1901", "traditionell tysk stavning" },
            { "kos", "kosreanska" },
            { "vec", "venetianska" },
            { "zh_Hant", "traditionell kinesiska" },
            { "Sund", metaValue_su },
            { "vep", "veps" },
            { "kpe", "kpelle" },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valensisk dialekt" },
            { "Cprt", "cypriotiska" },
            { "%%BAKU1926", "1926 \u00e5rs stavning" },
            { "%%IJEKAVSK", "ijekavisk dialekt" },
            { "mua", "mundang" },
            { "mul", "flera spr\u00e5k" },
            { "%%PUTER", "puter-dialekt" },
            { "cad", "caddo" },
            { "mus", "muskogee" },
            { "Glag", "glagolitiska" },
            { "gil", "gilbertiska" },
            { "%%KKCOR", "vanlig stavning" },
            { "Cher", "cherokee" },
            { "car", "karibiska" },
            { "cay", "cayuga" },
            { "krc", "karachay-balkar" },
            { "inh", "ingusjiska" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "krl", "karelska" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "kru", "kurukh" },
            { "ksb", "kisambaa" },
            { "Telu", "telugu" },
            { "ksf", "bafia" },
        };
        return data;
    }
}
