/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.JBHiDPIScaledImage;
import org.jetbrains.kotlin.com.intellij.util.RetinaImage;
import org.jetbrains.kotlin.com.intellij.util.SVGLoader;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.ImageUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;
import org.jetbrains.kotlin.com.intellij.util.ui.UIUtil;

public class ImageLoader
implements Serializable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");
    public static final int CACHED_IMAGE_MAX_SIZE = (int)Math.round(Registry.doubleValue("ide.cached.image.max.size") * 1024.0 * 1024.0);
    private static final ConcurrentMap<String, Image> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    public static final Component ourComponent = new Component(){};

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, final boolean allowFloatScaling, boolean useCache, ImageFilter[] filters, final JBUI.ScaleContext ctx) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(3);
        }
        return ImageDescList.create(url.toString(), null, UIUtil.isUnderDarcula(), allowFloatScaling, ctx).load(ImageConverterChain.create().withFilter(filters).with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDesc desc) {
                if (source != null && desc.type != ImageDesc.Type.SVG) {
                    double scale = ImageLoader.adjustScaleFactor(allowFloatScaling, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
                    if (desc.scale > 1.0) {
                        scale /= desc.scale;
                    }
                    source = ImageLoader.scaleImage(source, scale);
                }
                return source;
            }
        }).withHiDPI(ctx), useCache);
    }

    private static double adjustScaleFactor(boolean allowFloatScaling, double scale) {
        return allowFloatScaling ? scale : (JBUI.isHiDPI(scale) ? 2.0 : 1.0);
    }

    @NotNull
    public static Image scaleImage(Image image, double scale) {
        if (scale == 1.0) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(4);
            }
            return image2;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(5);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image3 = image;
            if (image3 == null) {
                ImageLoader.$$$reportNull$$$0(6);
            }
            return image3;
        }
        int width = (int)Math.ceil(scale * (double)w);
        int height = (int)Math.ceil(scale * (double)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(7);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image load(@NotNull InputStream inputStream, double scale) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(14);
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be 1 or greater");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream2 = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream2.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream2.getInternalBuffer(), 0, outputStream2.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ImageLoader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ImageLoader";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        public ImageConverterChain withFilter(ImageFilter[] filters) {
            ImageConverterChain chain = this;
            for (ImageFilter filter2 : filters) {
                chain = chain.withFilter(filter2);
            }
            return chain;
        }

        public ImageConverterChain withFilter(final ImageFilter filter2) {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.filter(source, filter2);
                }
            });
        }

        public ImageConverterChain withHiDPI(final JBUI.ScaleContext ctx) {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    if (source != null && UIUtil.isJreHiDPI(ctx)) {
                        return RetinaImage.createFrom(source, ctx.getScale(JBUI.ScaleType.SYS_SCALE), ourComponent);
                    }
                    return source;
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDesc desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDesc var2);
    }

    private static class ImageDescList
    extends ArrayList<ImageDesc> {
        private ImageDescList() {
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters, boolean useCache) {
            if (converters == null) {
                ImageDescList.$$$reportNull$$$0(1);
            }
            for (ImageDesc desc : this) {
                try {
                    Image image = desc.load(useCache);
                    if (image == null) continue;
                    LOG.debug("Loaded image: " + desc);
                    return converters.convert(image, desc);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        public static ImageDescList create(@NotNull String file2, @Nullable Class cls, boolean dark, boolean allowFloatScaling, JBUI.ScaleContext ctx) {
            if (file2 == null) {
                ImageDescList.$$$reportNull$$$0(2);
            }
            ImageDescList vars = new ImageDescList();
            boolean ideSvgIconSupport = Registry.is("ide.svg.icon");
            boolean retina = JBUI.isHiDPI(ctx.getScale(JBUI.ScaleType.PIX_SCALE));
            if (retina || dark || ideSvgIconSupport) {
                String name = FileUtil.getNameWithoutExtension(file2);
                String ext = FileUtilRt.getExtension(file2);
                double scale = ImageLoader.adjustScaleFactor(allowFloatScaling, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
                if (ideSvgIconSupport && dark) {
                    vars.add(new ImageDesc(name + "_dark.svg", cls, scale, ImageDesc.Type.SVG));
                }
                if (ideSvgIconSupport) {
                    vars.add(new ImageDesc(name + ".svg", cls, scale, ImageDesc.Type.SVG));
                }
                if (dark && retina) {
                    vars.add(new ImageDesc(name + "@2x_dark." + ext, cls, 2.0, ImageDesc.Type.PNG));
                }
                if (dark) {
                    vars.add(new ImageDesc(name + "_dark." + ext, cls, 1.0, ImageDesc.Type.PNG));
                }
                if (retina) {
                    vars.add(new ImageDesc(name + "@2x." + ext, cls, 2.0, ImageDesc.Type.PNG));
                }
            }
            vars.add(new ImageDesc(file2, cls, 1.0, ImageDesc.Type.PNG, true));
            return vars;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ImageLoader$ImageDescList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ImageDesc {
        public final String path;
        @Nullable
        public final Class cls;
        public final double scale;
        public final Type type;
        public final boolean original;

        public ImageDesc(String path2, Class cls, double scale, Type type2) {
            this(path2, cls, scale, type2, false);
        }

        public ImageDesc(String path2, Class cls, double scale, Type type2, boolean original) {
            this.path = path2;
            this.cls = cls;
            this.scale = scale;
            this.type = type2;
            this.original = original;
        }

        @Nullable
        public Image load(boolean useCache) throws IOException {
            Image image;
            String cacheKey = null;
            InputStream stream2 = null;
            URL url = null;
            if (this.cls != null && (stream2 = this.cls.getResourceAsStream(this.path)) == null) {
                return null;
            }
            if (stream2 == null) {
                URLConnection connection;
                if (useCache) {
                    cacheKey = this.path + (this.type == Type.SVG ? "_@" + this.scale + "x" : "");
                    image = (Image)ourCache.get(cacheKey);
                    if (image != null) {
                        return image;
                    }
                }
                if ((connection = (url = new URL(this.path)).openConnection()) instanceof HttpURLConnection) {
                    if (!this.original) {
                        return null;
                    }
                    connection.addRequestProperty("User-Agent", "IntelliJ");
                }
                stream2 = connection.getInputStream();
            }
            if ((image = this.type.load(url, stream2, this.scale)) != null && cacheKey != null && image.getWidth(null) * image.getHeight(null) * 4 <= CACHED_IMAGE_MAX_SIZE) {
                ourCache.put(cacheKey, image);
            }
            return image;
        }

        public String toString() {
            return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
        }

        public static enum Type {
            PNG,
            SVG{

                @Override
                public Image load(URL url, InputStream is, double scale) throws IOException {
                    return SVGLoader.load(url, is, scale);
                }
            }
            ,
            UNDEFINED;


            public Image load(URL url, InputStream stream2, double scale) throws IOException {
                return ImageLoader.load(stream2, scale);
            }
        }
    }
}

