/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.xmlb.AccessorBindingWrapper;
import org.jetbrains.kotlin.com.intellij.util.xmlb.AttributeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.CompactCollectionBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.FieldAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMElementBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NotNullDeserializeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.OptionTagBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.PropertyAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Serializer;
import org.jetbrains.kotlin.com.intellij.util.xmlb.TagBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.TextBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.AbstractCollection;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.CollectionBean;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.MapAnnotation;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.OptionTag;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Property;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Text;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.kotlin.org.jdom.Comment;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;

public class BeanBinding
extends NotNullDeserializeBinding {
    private static final Map<Class, List<MutableAccessor>> ourAccessorCache = ContainerUtil.createConcurrentSoftValueMap();
    private final String myTagName;
    private Binding[] myBindings;
    protected final Class<?> myBeanClass;
    ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass, @Nullable MutableAccessor accessor) {
        if (beanClass == null) {
            BeanBinding.$$$reportNull$$$0(0);
        }
        super(accessor);
        this.compareByFields = ThreeState.UNSURE;
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            BeanBinding.$$$reportNull$$$0(1);
        }
        if (serializer == null) {
            BeanBinding.$$$reportNull$$$0(2);
        }
        assert (this.myBindings == null);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new Binding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = BeanBinding.createBinding(accessors.get(i), serializer);
            binding.init(originalType, serializer);
            this.myBindings[i] = binding;
        }
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(6);
        }
        Object instance = ReflectionUtil.newInstance(this.myBeanClass);
        this.deserializeInto(instance, element);
        Object obj = instance;
        if (obj == null) {
            BeanBinding.$$$reportNull$$$0(7);
        }
        return obj;
    }

    public void deserializeInto(@NotNull Object result2, @NotNull Element element) {
        if (result2 == null) {
            BeanBinding.$$$reportNull$$$0(14);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(15);
        }
        this.deserializeInto(result2, element, null);
    }

    public void deserializeInto(@NotNull Object result2, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (result2 == null) {
            BeanBinding.$$$reportNull$$$0(16);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(17);
        }
        block0: for (org.jetbrains.kotlin.org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtil.isEmpty(attribute.getNamespaceURI())) continue;
            for (Binding binding : this.myBindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).myName.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result2, attribute.getValue());
                continue block0;
            }
        }
        MultiMap<Binding, Element> data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (Binding binding : this.myBindings) {
                if (content instanceof org.jetbrains.kotlin.org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result2, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = MultiMap.createLinked();
                    }
                    data.putValue(binding, child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserializeUnsafe(result2, child);
                continue block2;
            }
        }
        for (Binding binding : this.myBindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat()) continue;
            ((AccessorBindingWrapper)binding).deserialize(result2, element);
        }
        if (data != null) {
            for (Binding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result2, (List)data.get(binding));
            }
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(18);
        }
        return element.getName().equals(this.myTagName);
    }

    @NotNull
    private static String getTagName(@NotNull Class<?> aClass2) {
        int lastIndexOf2;
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(19);
        }
        for (Class<?> c = aClass2; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            String string = name;
            if (string == null) {
                BeanBinding.$$$reportNull$$$0(20);
            }
            return string;
        }
        String name = aClass2.getSimpleName();
        if (name.isEmpty()) {
            name = aClass2.getSuperclass().getSimpleName();
        }
        if ((lastIndexOf2 = name.lastIndexOf(36)) > 0 && name.length() > lastIndexOf2 + 1) {
            String string = name.substring(lastIndexOf2 + 1);
            if (string == null) {
                BeanBinding.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            BeanBinding.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static String getTagNameFromAnnotation(Class<?> aClass2) {
        Tag tag = aClass2.getAnnotation(Tag.class);
        return tag != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass2) {
        List<MutableAccessor> accessors;
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(23);
        }
        if ((accessors = ourAccessorCache.get(aClass2)) != null) {
            List<MutableAccessor> list2 = accessors;
            if (list2 == null) {
                BeanBinding.$$$reportNull$$$0(24);
            }
            return list2;
        }
        accessors = ContainerUtil.newArrayList();
        Map<Object, Object> nameToAccessors = aClass2 != Rectangle.class ? BeanBinding.collectPropertyAccessors(aClass2, accessors) : Collections.emptyMap();
        int propertyAccessorCount = accessors.size();
        BeanBinding.collectFieldAccessors(aClass2, accessors);
        block0: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = accessors.get(j).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!accessors.get(i).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block0;
            }
        }
        ourAccessorCache.put(aClass2, accessors);
        List<MutableAccessor> list3 = accessors;
        if (list3 == null) {
            BeanBinding.$$$reportNull$$$0(25);
        }
        return list3;
    }

    @NotNull
    private static Map<String, Couple<Method>> collectPropertyAccessors(@NotNull Class<?> aClass2, @NotNull List<MutableAccessor> accessors) {
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(26);
        }
        if (accessors == null) {
            BeanBinding.$$$reportNull$$$0(27);
        }
        TreeMap<String, Couple<Method>> candidates2 = ContainerUtilRt.newTreeMap();
        for (Method method : aClass2.getMethods()) {
            Pair<String, Boolean> propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || ((String)propertyData.first).equals("class") || method.getParameterTypes().length != ((Boolean)propertyData.second != false ? 1 : 0)) continue;
            Couple<Object> candidate2 = (Couple)candidates2.get(propertyData.first);
            if (candidate2 == null) {
                candidate2 = Couple.getEmpty();
            }
            if (((Boolean)propertyData.second != false ? (Method)candidate2.second : (Method)candidate2.first) != null) continue;
            candidate2 = Couple.of((Boolean)propertyData.second != false ? (Method)candidate2.first : method, (Boolean)propertyData.second != false ? method : (Method)candidate2.second);
            candidates2.put((String)propertyData.first, (Couple<Method>)candidate2);
        }
        Iterator iterator2 = candidates2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry candidate3 = iterator2.next();
            Couple methods2 = (Couple)candidate3.getValue();
            if (methods2.first != null && methods2.second != null && ((Method)methods2.first).getReturnType().equals(((Method)methods2.second).getParameterTypes()[0]) && ((Method)methods2.first).getAnnotation(Transient.class) == null && ((Method)methods2.second).getAnnotation(Transient.class) == null) {
                accessors.add(new PropertyAccessor((String)candidate3.getKey(), ((Method)methods2.first).getReturnType(), (Method)methods2.first, (Method)methods2.second));
                continue;
            }
            iterator2.remove();
        }
        TreeMap<String, Couple<Method>> treeMap = candidates2;
        if (treeMap == null) {
            BeanBinding.$$$reportNull$$$0(28);
        }
        return treeMap;
    }

    private static boolean hasStoreAnnotations(@NotNull AccessibleObject object) {
        if (object == null) {
            BeanBinding.$$$reportNull$$$0(29);
        }
        return object.getAnnotation(OptionTag.class) != null || object.getAnnotation(Tag.class) != null || object.getAnnotation(Attribute.class) != null || object.getAnnotation(Property.class) != null || object.getAnnotation(Text.class) != null || object.getAnnotation(CollectionBean.class) != null || object.getAnnotation(MapAnnotation.class) != null || object.getAnnotation(AbstractCollection.class) != null;
    }

    private static void collectFieldAccessors(@NotNull Class<?> aClass2, @NotNull List<MutableAccessor> accessors) {
        if (aClass2 == null) {
            BeanBinding.$$$reportNull$$$0(30);
        }
        if (accessors == null) {
            BeanBinding.$$$reportNull$$$0(31);
        }
        Class<?> currentClass = aClass2;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                int modifiers2 = field.getModifiers();
                if (Modifier.isStatic(modifiers2) || !BeanBinding.hasStoreAnnotations(field) && (!Modifier.isPublic(modifiers2) || Modifier.isFinal(modifiers2) && !Collection.class.isAssignableFrom(field.getType()) || Modifier.isTransient(modifiers2) || field.getAnnotation(Transient.class) != null)) continue;
                accessors.add(new FieldAccessor(field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass.getAnnotation(Transient.class) == null);
    }

    @Nullable
    private static Pair<String, Boolean> getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            BeanBinding.$$$reportNull$$$0(32);
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3, methodName.length());
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2, methodName.length());
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3, methodName.length());
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            part = part.substring(0, suffixIndex);
        }
        return Pair.create(Introspector.decapitalize(part), isSetter);
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static Binding createBinding(@NotNull MutableAccessor accessor, @NotNull Serializer serializer) {
        Binding binding;
        if (accessor == null) {
            BeanBinding.$$$reportNull$$$0(33);
        }
        if (serializer == null) {
            BeanBinding.$$$reportNull$$$0(34);
        }
        if ((binding = serializer.getBinding(accessor)) instanceof JDOMElementBinding) {
            Binding binding2 = binding;
            if (binding2 == null) {
                BeanBinding.$$$reportNull$$$0(35);
            }
            return binding2;
        }
        Attribute attribute = accessor.getAnnotation(Attribute.class);
        if (attribute != null) {
            AttributeBinding attributeBinding = new AttributeBinding(accessor, attribute);
            if (attributeBinding == null) {
                BeanBinding.$$$reportNull$$$0(36);
            }
            return attributeBinding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            TagBinding tagBinding = new TagBinding(accessor, tag);
            if (tagBinding == null) {
                BeanBinding.$$$reportNull$$$0(37);
            }
            return tagBinding;
        }
        Text text2 = accessor.getAnnotation(Text.class);
        if (text2 != null) {
            TextBinding textBinding = new TextBinding(accessor);
            if (textBinding == null) {
                BeanBinding.$$$reportNull$$$0(38);
            }
            return textBinding;
        }
        if (binding instanceof CompactCollectionBinding) {
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding, false);
            if (accessorBindingWrapper == null) {
                BeanBinding.$$$reportNull$$$0(39);
            }
            return accessorBindingWrapper;
        }
        boolean surroundWithTag = true;
        boolean inline = false;
        Property property = accessor.getAnnotation(Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
            inline = property.flat();
        }
        if (!surroundWithTag || inline) {
            if (inline && !(binding instanceof BeanBinding)) {
                throw new XmlSerializationException("inline supported only for BeanBinding: " + accessor);
            }
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding, inline);
            if (accessorBindingWrapper == null) {
                BeanBinding.$$$reportNull$$$0(40);
            }
            return accessorBindingWrapper;
        }
        OptionTagBinding optionTagBinding = new OptionTagBinding(accessor, accessor.getAnnotation(OptionTag.class));
        if (optionTagBinding == null) {
            BeanBinding.$$$reportNull$$$0(41);
        }
        return optionTagBinding;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorNameTracker";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weights";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: 
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeBindingWeights";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPropertyAccessors";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeInto";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalByFields";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeBindingWeights";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortBindings";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deserializeInto";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertyAccessors";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasStoreAnnotations";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldAccessors";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyData";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

