/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator$isSetterVisible$;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002Jr\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00162\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\t2.\u0010\u0019\u001a*\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u001aH\u0002J&\u0010\u001b\u001a\u00020\u0004*\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J8\u0010\u001e\u001a\u00020\u0004*\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallableReferenceTranslator;", "", "()V", "bindIfNecessary", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "receiver", "isSetterVisible", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translate", "expression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "translateForFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "translateForProperty", "translateForPropertyAccessor", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isSetter", "translator", "Lkotlin/Function4;", "wrapFunctionCallableRef", "name", "", "wrapPropertyCallableRef", "getter", "setter", "js.translator"})
public final class CallableReferenceTranslator {
    public static final CallableReferenceTranslator INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final JsExpression translate(@NotNull KtCallableReferenceExpression expression2, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        JsExpression receiver;
        JsExpression jsExpression2;
        Object object;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.callableReference");
        KtElement ktElement = ktSimpleNameExpression;
        BindingContext bindingContext = context.bindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.bindingContext()");
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilKt.getResolvedCallWithAssert(ktElement, bindingContext);
        CallableDescriptor descriptor2 = referencedFunction.getResultingDescriptor();
        ReceiverValue extensionReceiver = referencedFunction.getExtensionReceiver();
        ReceiverValue dispatchReceiver = referencedFunction.getDispatchReceiver();
        boolean bl2 = bl = dispatchReceiver == null || extensionReceiver == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Cannot generate reference with both receivers: " + descriptor2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ReceiverValue receiverValue = dispatchReceiver;
        if (receiverValue == null) {
            receiverValue = extensionReceiver;
        }
        if (receiverValue != null) {
            object = receiverValue;
            Object it = object;
            ReceiverValue receiverValue2 = it;
            if (receiverValue2 instanceof TransientReceiver) {
                jsExpression2 = null;
            } else if (receiverValue2 instanceof ImplicitClassReceiver || receiverValue2 instanceof ExtensionReceiver) {
                jsExpression2 = context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver((ReceiverValue)it));
            } else {
                if (!(receiverValue2 instanceof ExpressionReceiver)) throw (Throwable)new UnsupportedOperationException("Unsupported receiver value: " + it);
                jsExpression2 = Translation.translateAsExpression(((ExpressionReceiver)it).getExpression(), context);
            }
        } else {
            jsExpression2 = receiver = null;
        }
        if ((object = descriptor2) instanceof PropertyDescriptor) {
            jsExpression = this.translateForProperty((PropertyDescriptor)descriptor2, context, expression2, receiver);
            return jsExpression;
        } else {
            if (!(object instanceof FunctionDescriptor)) throw (Throwable)new IllegalArgumentException("Expected property or function: " + descriptor2 + ", expression=" + expression2.getText());
            jsExpression = this.translateForFunction((FunctionDescriptor)descriptor2, context, expression2, receiver);
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression translateForFunction(FunctionDescriptor descriptor2, TranslationContext context, KtCallableReferenceExpression expression2, JsExpression receiver) {
        TranslationContext functionContext;
        JsNameRef jsNameRef;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.callableReference");
        KtExpression ktExpression = ktSimpleNameExpression;
        BindingContext bindingContext = context.bindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.bindingContext()");
        ResolvedCall<? extends FunctionDescriptor> realResolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(ktExpression, bindingContext);
        Project project = expression2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"expression.project");
        KtCallExpression fakeExpression = CodegenUtil.constructFakeFunctionCall(project, descriptor2.getValueParameters().size());
        Call fakeCall = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeExpression.getValueArguments());
        DelegatingResolvedCall<FunctionDescriptor> fakeResolvedCall2 = new DelegatingResolvedCall<FunctionDescriptor>(fakeCall, receiver, descriptor2, realResolvedCall, realResolvedCall){
            @NotNull
            private final List<ExpressionValueArgument> valueArgumentList;
            @NotNull
            private final Map<ValueParameterDescriptor, ExpressionValueArgument> valueArgumentMap;
            final /* synthetic */ Call $fakeCall;
            final /* synthetic */ JsExpression $receiver;
            final /* synthetic */ FunctionDescriptor $descriptor;
            final /* synthetic */ ResolvedCall $realResolvedCall;

            @NotNull
            public final List<ExpressionValueArgument> getValueArgumentList() {
                return this.valueArgumentList;
            }

            @NotNull
            public final Map<ValueParameterDescriptor, ExpressionValueArgument> getValueArgumentMap() {
                return this.valueArgumentMap;
            }

            @NotNull
            public Call getCall() {
                return this.$fakeCall;
            }

            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                return this.valueArgumentList;
            }

            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                return this.valueArgumentMap;
            }

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                if (this.$receiver != null) {
                    return DescriptorUtilsKt.isExtension(this.$descriptor) ? ExplicitReceiverKind.EXTENSION_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
                }
                ExplicitReceiverKind explicitReceiverKind = super.getExplicitReceiverKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)explicitReceiverKind), (String)"super.getExplicitReceiverKind()");
                return explicitReceiverKind;
            }
            {
                void $receiver$iv$iv;
                Object object;
                void $receiver$iv$iv2;
                Iterable $receiver$iv;
                this.$fakeCall = $captured_local_variable$0;
                this.$receiver = $captured_local_variable$1;
                this.$descriptor = $captured_local_variable$2;
                this.$realResolvedCall = $captured_local_variable$3;
                super($super_call_param$4);
                Call call2 = $captured_local_variable$0;
                Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"fakeCall");
                List<? extends ValueArgument> list2 = call2.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"fakeCall.valueArguments");
                Iterable iterable = list2;
                translateForFunction.fakeResolvedCall.1 var20_7 = this;
                void var7_8 = $receiver$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv2) {
                    void p1;
                    ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                    object = destination$iv$iv;
                    ExpressionValueArgument expressionValueArgument = new ExpressionValueArgument((ValueArgument)p1);
                    object.add(expressionValueArgument);
                }
                object = (List)destination$iv$iv;
                var20_7.valueArgumentList = object;
                $receiver$iv = CollectionsKt.withIndex((Iterable)this.valueArgumentList);
                var20_7 = this;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
                destination$iv$iv = $receiver$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                for (T element$iv$iv : $receiver$iv$iv) {
                    Map map2 = destination$iv$iv2;
                    IndexedValue $index_arg = (IndexedValue)element$iv$iv;
                    int index2 = $index_arg.component1();
                    ExpressionValueArgument arg = (ExpressionValueArgument)$index_arg.component2();
                    Pair pair = TuplesKt.to((Object)this.$descriptor.getValueParameters().get(index2), (Object)arg);
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                var20_7.valueArgumentMap = object = destination$iv$iv2;
            }
        };
        JsFunction function2 = new JsFunction(context.scope(), new JsBlock(), "");
        function2.setSource(expression2);
        if (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null || receiver != null) {
            JsName paramName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Collection collection = function2.getParameters();
            JsParameter jsParameter = new JsParameter(paramName);
            collection.add(jsParameter);
            jsNameRef = paramName.makeRef();
        } else {
            jsNameRef = null;
        }
        JsNameRef receiverParam = jsNameRef;
        FunctionDescriptor functionDescriptor = realResolvedCall.getResultingDescriptor();
        Map aliases = new LinkedHashMap();
        boolean bl = false;
        Call call2 = fakeCall;
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"fakeCall");
        List<? extends ValueArgument> list2 = call2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"fakeCall.valueArguments");
        for (ValueArgument valueArg : (Iterable)list2) {
            JsExpression jsExpression;
            KtExpression ktExpression2;
            JsNameRef paramRef;
            void index2;
            ValueParameterDescriptor valueParameterDescriptor = descriptor2.getValueParameters().get((int)index2);
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"descriptor.valueParameters[index]");
            JsName paramName = JsScope.declareTemporaryName(valueParameterDescriptor.getName().asString());
            Collection collection = function2.getParameters();
            JsParameter jsParameter = new JsParameter(paramName);
            collection.add(jsParameter);
            JsNameRef jsNameRef2 = paramRef = paramName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef2, (String)"paramRef");
            MetadataProperties.setType(jsNameRef2, context.getCurrentModule().getBuiltIns().getAnyType());
            ValueParameterDescriptor valueParameterDescriptor2 = functionDescriptor.getValueParameters().get((int)index2);
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor2, (String)"functionDescriptor.valueParameters[index]");
            KotlinType type2 = valueParameterDescriptor2.getType();
            Map map2 = aliases;
            if (valueArg.getArgumentExpression() == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)TranslationUtils.coerce(context, paramRef, type2), (String)"TranslationUtils.coerce(context, paramRef, type)");
            map2.put(ktExpression2, jsExpression);
            ++index2;
        }
        TranslationContext translationContext = functionContext = context.innerBlock(function2.getBody()).innerContextWithAliasesForExpressions(aliases);
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"functionContext");
        JsExpression invocation = CallTranslator.translate(translationContext, (ResolvedCall<? extends FunctionDescriptor>)fakeResolvedCall2, receiverParam);
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"function.body");
        Collection collection = jsBlock.getStatements();
        JsReturn jsReturn = new JsReturn(TranslationUtils.coerce(context, invocation, context.getCurrentModule().getBuiltIns().getAnyType()));
        collection.add(jsReturn);
        JsExpression rawCallableRef = this.bindIfNecessary(function2, receiver);
        return this.wrapFunctionCallableRef(context, receiver, expression2.getCallableReference().getReferencedName(), rawCallableRef);
    }

    private final JsExpression translateForProperty(PropertyDescriptor descriptor2, TranslationContext context, KtCallableReferenceExpression expression2, JsExpression receiver) {
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.callableReference");
        KtExpression ktExpression = ktSimpleNameExpression;
        BindingContext bindingContext = context.bindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.bindingContext()");
        ResolvedCall<? extends PropertyDescriptor> realCall = CallUtilKt.getPropertyResolvedCallWithAssert(ktExpression, bindingContext);
        DelegatingResolvedCall<PropertyDescriptor> call2 = new DelegatingResolvedCall<PropertyDescriptor>(receiver, descriptor2, realCall, realCall){
            final /* synthetic */ JsExpression $receiver;
            final /* synthetic */ PropertyDescriptor $descriptor;
            final /* synthetic */ ResolvedCall $realCall;

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                if (this.$receiver != null) {
                    return DescriptorUtilsKt.isExtension(this.$descriptor) ? ExplicitReceiverKind.EXTENSION_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
                }
                ExplicitReceiverKind explicitReceiverKind = super.getExplicitReceiverKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)explicitReceiverKind), (String)"super.getExplicitReceiverKind()");
                return explicitReceiverKind;
            }
            {
                this.$receiver = $captured_local_variable$0;
                this.$descriptor = $captured_local_variable$1;
                this.$realCall = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        JsExpression getter2 = this.translateForPropertyAccessor((ResolvedCall<? extends PropertyDescriptor>)call2, expression2, descriptor2, context, receiver, false, (Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function4)translateForProperty.getter.1.INSTANCE));
        JsExpression setter2 = this.isSetterVisible(descriptor2, context) ? this.translateForPropertyAccessor((ResolvedCall<? extends PropertyDescriptor>)call2, expression2, descriptor2, context, receiver, true, (Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function4)new Function4<TranslationContext, ResolvedCall<? extends VariableDescriptor>, JsExpression, JsExpression, JsExpression>(CallTranslator.INSTANCE){

            @NotNull
            public final JsExpression invoke(@NotNull TranslationContext p1, @NotNull ResolvedCall<? extends VariableDescriptor> p2, @NotNull JsExpression p3, @Nullable JsExpression p4) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull(p2, (String)"p2");
                Intrinsics.checkParameterIsNotNull((Object)p3, (String)"p3");
                return ((CallTranslator)this.receiver).translateSet(p1, p2, p3, p4);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(CallTranslator.class);
            }

            public final String getName() {
                return "translateSet";
            }

            public final String getSignature() {
                return "translateSet(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;";
            }
        })) : null;
        return this.wrapPropertyCallableRef(context, receiver, descriptor2, expression2.getCallableReference().getReferencedName(), getter2, setter2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSetterVisible(PropertyDescriptor descriptor2, TranslationContext context) {
        void $receiver$iv;
        PropertySetterDescriptor setter2;
        PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
        if (propertySetterDescriptor == null) {
            return false;
        }
        PropertySetterDescriptor propertySetterDescriptor2 = setter2 = propertySetterDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor2, (String)"setter");
        if (Intrinsics.areEqual((Object)propertySetterDescriptor2.getVisibility(), (Object)Visibilities.PRIVATE) ^ true) {
            return true;
        }
        ClassDescriptor classDescriptor = context.getClassDescriptor();
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        Sequence sequence2 = SequencesKt.generateSequence((Object)classDescriptor2, (Function1)isSetterVisible.outerClasses.1.INSTANCE);
        Sequence sequence3 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)isSetterVisible$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence outerClasses2 = sequence3;
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        return SequencesKt.contains((Sequence)outerClasses2, (Object)declarationDescriptor);
    }

    private final JsExpression translateForPropertyAccessor(ResolvedCall<? extends PropertyDescriptor> call2, KtExpression expression2, PropertyDescriptor descriptor2, TranslationContext context, JsExpression receiver, boolean isSetter, Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression> translator) {
        JsStatement jsStatement;
        JsExpression jsExpression;
        JsNode jsNode;
        JsNameRef receiverParam;
        JsNameRef jsNameRef;
        Object object;
        JsFunction accessorFunction = new JsFunction(context.scope(), new JsBlock(), "");
        accessorFunction.setSource(UtilsKt.getFinalElement(expression2));
        TranslationContext accessorContext = context.innerBlock(accessorFunction.getBody());
        if (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null) {
            JsName name = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Collection collection = accessorFunction.getParameters();
            object = new JsParameter(name);
            collection.add(object);
            jsNameRef = name.makeRef();
        } else {
            jsNameRef = receiverParam = null;
        }
        if (isSetter) {
            JsName name = JsScope.declareTemporaryName("value");
            object = accessorFunction.getParameters();
            jsNode = new JsParameter(name);
            object.add(jsNode);
            JsNameRef jsNameRef2 = name.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef2, (String)"name.makeRef()");
            jsExpression = jsNameRef2;
        } else {
            jsExpression = new JsNullLiteral();
        }
        JsExpression valueParam = jsExpression;
        TranslationContext translationContext = accessorContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"accessorContext");
        JsExpression accessorResult = (JsExpression)translator.invoke((Object)translationContext, call2, (Object)valueParam, (Object)receiverParam);
        JsBlock jsBlock = accessorFunction.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"accessorFunction.body");
        object = jsBlock.getStatements();
        if (isSetter) {
            JsStatement jsStatement2 = accessorResult.makeStmt();
            jsStatement = jsStatement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"accessorResult.makeStmt()");
        } else {
            jsStatement = new JsReturn(accessorResult);
        }
        jsNode = jsStatement;
        object.add(jsNode);
        return this.bindIfNecessary(accessorFunction, receiver);
    }

    private final JsExpression bindIfNecessary(JsFunction function2, JsExpression receiver) {
        return receiver != null ? (JsExpression)new JsInvocation((JsExpression)new JsNameRef("bind", (JsExpression)function2), new JsNullLiteral(), receiver) : (JsExpression)function2;
    }

    private final JsExpression wrapPropertyCallableRef(@NotNull TranslationContext $receiver, JsExpression receiver, PropertyDescriptor descriptor2, String name, JsExpression getter2, JsExpression setter2) {
        int argCount;
        int n = argCount = descriptor2.getContainingDeclaration() instanceof ClassDescriptor || descriptor2.getExtensionReceiverParameter() != null ? 1 : 0;
        if (receiver != null) {
            --argCount;
        }
        JsStringLiteral nameLiteral = new JsStringLiteral(name);
        JsIntLiteral argCountLiteral = new JsIntLiteral(argCount);
        JsExpression invokeFun = $receiver.getReferenceToIntrinsic("getPropertyCallableRef");
        JsInvocation invocation = new JsInvocation(invokeFun, nameLiteral, argCountLiteral, getter2);
        if (setter2 != null) {
            Collection collection = invocation.getArguments();
            collection.add(setter2);
        }
        MetadataProperties.setCallableReferenceReceiver(invocation, receiver);
        return invocation;
    }

    private final JsExpression wrapFunctionCallableRef(@NotNull TranslationContext $receiver, JsExpression receiver, String name, JsExpression function2) {
        JsExpression invokeFun;
        JsStringLiteral nameLiteral = new JsStringLiteral(name);
        JsExpression jsExpression = invokeFun = $receiver.getReferenceToIntrinsic("getCallableRef");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"invokeFun");
        MetadataProperties.setSideEffects(jsExpression, SideEffectKind.PURE);
        JsInvocation invocation = new JsInvocation(invokeFun, nameLiteral, function2);
        MetadataProperties.setCallableReference(invocation, true);
        MetadataProperties.setSideEffects(invocation, SideEffectKind.PURE);
        MetadataProperties.setCallableReferenceReceiver(invocation, receiver);
        return invocation;
    }

    private CallableReferenceTranslator() {
    }

    static {
        CallableReferenceTranslator callableReferenceTranslator;
        INSTANCE = callableReferenceTranslator = new CallableReferenceTranslator();
    }
}

