/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.CollectionUtils;

class EdgeState
implements DependencyGraphEdge {
    private final DependencyState dependencyState;
    private final DependencyMetadata dependencyMetadata;
    private final NodeState from;
    private final SelectorState selector;
    private final ResolveState resolveState;
    private final ModuleExclusion transitiveExclusions;
    private final List<NodeState> targetNodes = Lists.newLinkedList();
    private ComponentState targetModuleRevision;
    private ModuleVersionResolveException targetNodeSelectionFailure;

    EdgeState(NodeState from, DependencyState dependencyState, ModuleExclusion transitiveExclusions, ResolveState resolveState) {
        this.from = from;
        this.dependencyState = dependencyState;
        this.dependencyMetadata = dependencyState.getDependency();
        this.transitiveExclusions = transitiveExclusions;
        this.resolveState = resolveState;
        this.selector = resolveState.getSelector(dependencyState, dependencyState.getModuleIdentifier());
    }

    public String toString() {
        return String.format("%s -> %s", this.from.toString(), this.dependencyMetadata);
    }

    @Override
    public NodeState getFrom() {
        return this.from;
    }

    DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    ComponentState getTargetComponent() {
        return this.targetModuleRevision;
    }

    @Override
    public SelectorState getSelector() {
        return this.selector;
    }

    public boolean isTransitive() {
        return this.from.isTransitive() && this.dependencyMetadata.isTransitive();
    }

    public void attachToTargetConfigurations() {
        if (!this.targetModuleRevision.isSelected()) {
            return;
        }
        this.calculateTargetConfigurations();
        for (NodeState targetConfiguration : this.targetNodes) {
            targetConfiguration.addIncomingEdge(this);
        }
        if (!this.targetNodes.isEmpty()) {
            this.selector.getTargetModule().removeUnattachedDependency(this);
        }
    }

    public void removeFromTargetConfigurations() {
        for (NodeState targetConfiguration : this.targetNodes) {
            targetConfiguration.removeIncomingEdge(this);
        }
        this.targetNodes.clear();
        this.targetNodeSelectionFailure = null;
        if (this.targetModuleRevision != null) {
            this.selector.getTargetModule().removeUnattachedDependency(this);
        }
    }

    public void restart(ComponentState selected) {
        this.removeFromTargetConfigurations();
        this.targetModuleRevision = selected;
        this.attachToTargetConfigurations();
    }

    public void start(ComponentState selected) {
        this.targetModuleRevision = selected;
    }

    private void calculateTargetConfigurations() {
        List<ConfigurationMetadata> targetConfigurations;
        this.targetNodes.clear();
        this.targetNodeSelectionFailure = null;
        ComponentResolveMetadata targetModuleVersion = this.targetModuleRevision.getMetadata();
        if (targetModuleVersion == null) {
            return;
        }
        ImmutableAttributes attributes = this.resolveState.getRoot().getMetadata().getAttributes();
        try {
            targetConfigurations = this.dependencyMetadata.selectConfigurations(attributes, targetModuleVersion, this.resolveState.getAttributesSchema());
        }
        catch (Throwable t) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyState.getRequested(), t);
            return;
        }
        for (ConfigurationMetadata targetConfiguration : targetConfigurations) {
            NodeState targetNodeState = this.resolveState.getNode(this.targetModuleRevision, targetConfiguration);
            this.targetNodes.add(targetNodeState);
        }
    }

    @Override
    public ModuleExclusion getExclusions() {
        List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
        if (excludes.isEmpty()) {
            return this.transitiveExclusions;
        }
        ModuleExclusion edgeExclusions = this.resolveState.getModuleExclusions().excludeAny((ImmutableList<ExcludeMetadata>)ImmutableList.copyOf(excludes));
        return this.resolveState.getModuleExclusions().intersect(edgeExclusions, this.transitiveExclusions);
    }

    @Override
    public boolean contributesArtifacts() {
        return !this.dependencyMetadata.isPending();
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependencyState.getRequested();
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        if (this.targetNodeSelectionFailure != null) {
            return this.targetNodeSelectionFailure;
        }
        return this.selector.getFailure();
    }

    @Override
    public Long getSelected() {
        return this.selector.getSelected().getResultId();
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.selector.getSelectionReason();
    }

    @Override
    public Dependency getOriginalDependency() {
        if (this.dependencyMetadata instanceof DslOriginDependencyMetadata) {
            return ((DslOriginDependencyMetadata)this.dependencyMetadata).getSource();
        }
        return null;
    }

    @Override
    public List<ComponentArtifactMetadata> getArtifacts(final ConfigurationMetadata targetConfiguration) {
        return CollectionUtils.collect(this.dependencyMetadata.getArtifacts(), (Transformer)new Transformer<ComponentArtifactMetadata, IvyArtifactName>(){

            public ComponentArtifactMetadata transform(IvyArtifactName ivyArtifactName) {
                return targetConfiguration.artifact(ivyArtifactName);
            }
        });
    }
}

