/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import javax.annotation.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.ImperativeOnlyPluginTarget;
import org.gradle.api.internal.plugins.PluginAwareInternal;
import org.gradle.api.internal.plugins.PluginTarget;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.model.internal.inspect.ExtractedRuleSource;
import org.gradle.model.internal.inspect.ModelRuleExtractor;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.registry.ModelRegistryScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBasedPluginTarget<T extends ModelRegistryScope & PluginAwareInternal>
implements PluginTarget {
    private final T target;
    private final PluginTarget imperativeTarget;
    private final ModelRuleExtractor ruleInspector;
    private final ModelRuleSourceDetector ruleDetector;

    public RuleBasedPluginTarget(T target, ModelRuleExtractor ruleInspector, ModelRuleSourceDetector ruleDetector) {
        this.target = target;
        this.ruleInspector = ruleInspector;
        this.ruleDetector = ruleDetector;
        this.imperativeTarget = new ImperativeOnlyPluginTarget<PluginAwareInternal>((PluginAwareInternal)target);
    }

    @Override
    public ConfigurationTargetIdentifier getConfigurationTargetIdentifier() {
        return this.imperativeTarget.getConfigurationTargetIdentifier();
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        this.imperativeTarget.applyImperative(pluginId, plugin);
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        ModelRegistry modelRegistry = this.target.getModelRegistry();
        Iterable declaredSources = this.ruleDetector.getDeclaredSources(clazz);
        for (Class ruleSource : declaredSources) {
            ExtractedRuleSource rules = this.ruleInspector.extract(ruleSource);
            for (Class dependency : rules.getRequiredPlugins()) {
                ((PluginAwareInternal)this.target).getPluginManager().apply(dependency);
            }
            modelRegistry.getRoot().applyToSelf(rules);
        }
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin) {
        this.applyImperative(pluginId, plugin);
        this.applyRules(pluginId, plugin.getClass());
    }

    public String toString() {
        return this.target.toString();
    }
}

