/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.internal.hash.HashCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DebuggingTaskOutputCachingBuildCacheKeyBuilder
implements TaskOutputCachingBuildCacheKeyBuilder {
    private static final Logger LOGGER = Logging.getLogger(DebuggingTaskOutputCachingBuildCacheKeyBuilder.class);
    private final TaskOutputCachingBuildCacheKeyBuilder delegate;

    public DebuggingTaskOutputCachingBuildCacheKeyBuilder(TaskOutputCachingBuildCacheKeyBuilder delegate) {
        this.delegate = delegate;
    }

    @Override
    public void appendTaskImplementation(ImplementationSnapshot taskImplementation) {
        this.log("taskClass", taskImplementation.getTypeName());
        if (!taskImplementation.hasUnknownClassLoader()) {
            this.log("classLoaderHash", taskImplementation.getClassLoaderHash());
        }
        this.delegate.appendTaskImplementation(taskImplementation);
    }

    @Override
    public void appendTaskActionImplementations(Collection<ImplementationSnapshot> taskActionImplementations) {
        for (ImplementationSnapshot actionImpl : taskActionImplementations) {
            this.log("actionType", actionImpl.getTypeName());
            this.log("actionClassLoaderHash", actionImpl.hasUnknownClassLoader() ? null : actionImpl.getClassLoaderHash());
        }
        this.delegate.appendTaskActionImplementations(taskActionImplementations);
    }

    @Override
    public void appendInputPropertyHash(String propertyName, HashCode hashCode) {
        LOGGER.lifecycle("Appending inputPropertyHash for '{}' to build cache key: {}", new Object[]{propertyName, hashCode});
        this.delegate.appendInputPropertyHash(propertyName, hashCode);
    }

    @Override
    public void inputPropertyLoadedByUnknownClassLoader(String propertyName) {
        LOGGER.lifecycle("The implementation of '{}' cannot be determined, because it was loaded by an unknown classloader", new Object[]{propertyName});
        this.delegate.inputPropertyLoadedByUnknownClassLoader(propertyName);
    }

    @Override
    public void appendOutputPropertyName(String propertyName) {
        this.log("outputPropertyName", propertyName);
        this.delegate.appendOutputPropertyName(propertyName);
    }

    @Override
    public TaskOutputCachingBuildCacheKey build() {
        return this.delegate.build();
    }

    private void log(String name, @Nullable Object value) {
        LOGGER.lifecycle("Appending {} to build cache key: {}", new Object[]{name, value});
    }
}

