/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.composite.internal.DefaultIncludedBuild;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultIncludedBuildFactory
implements IncludedBuildFactory {
    private final Instantiator instantiator;
    private final WorkerLeaseService workerLeaseService;

    public DefaultIncludedBuildFactory(Instantiator instantiator, WorkerLeaseService workerLeaseService) {
        this.instantiator = instantiator;
        this.workerLeaseService = workerLeaseService;
    }

    private void validateBuildDirectory(File dir) {
        if (!dir.exists()) {
            throw new InvalidUserDataException(String.format("Included build '%s' does not exist.", dir));
        }
        if (!dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Included build '%s' is not a directory.", dir));
        }
    }

    @Override
    public IncludedBuildInternal createBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        this.validateBuildDirectory(buildDefinition.getBuildRootDir());
        return (IncludedBuildInternal)this.instantiator.newInstance(DefaultIncludedBuild.class, new Object[]{buildDefinition, nestedBuildFactory, this.workerLeaseService.getCurrentWorkerLease()});
    }
}

