/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.specs.Spec;
import org.gradle.initialization.ProjectPathRegistry;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

public class DefaultProjectPathRegistry
implements ProjectPathRegistry {
    private final Map<Path, ProjectPathEntry> allProjects = Maps.newLinkedHashMap();

    void add(Path projectIdentityPath, String projectName, ProjectComponentIdentifier identifier, boolean isImplicitBuild) {
        this.allProjects.put(projectIdentityPath, new ProjectPathEntry(projectName, identifier, isImplicitBuild));
    }

    public Set<Path> getAllProjectPaths() {
        return this.allProjects.keySet();
    }

    public Set<Path> getAllExplicitProjectPaths() {
        return this.filterProjectPaths(false);
    }

    public Set<Path> getAllImplicitProjectPaths() {
        return this.filterProjectPaths(true);
    }

    private Set<Path> filterProjectPaths(final boolean isAddedImplicitly) {
        return CollectionUtils.collect((Set)CollectionUtils.filter(this.allProjects.entrySet(), (Spec)new Spec<Map.Entry<Path, ProjectPathEntry>>(){

            public boolean isSatisfiedBy(Map.Entry<Path, ProjectPathEntry> entry) {
                return isAddedImplicitly == entry.getValue().isAddedImplicitly;
            }
        }), (Transformer)new Transformer<Path, Map.Entry<Path, ProjectPathEntry>>(){

            public Path transform(Map.Entry<Path, ProjectPathEntry> entry) {
                return entry.getKey();
            }
        });
    }

    public ProjectComponentIdentifier getProjectComponentIdentifier(Path identityPath) {
        return this.allProjects.get(identityPath).identifier;
    }

    public String getProjectName(Path identityPath) {
        return this.allProjects.get(identityPath).projectName;
    }

    private static class ProjectPathEntry {
        private final String projectName;
        private final ProjectComponentIdentifier identifier;
        private final boolean isAddedImplicitly;

        ProjectPathEntry(String projectName, ProjectComponentIdentifier identifier, boolean isAddedImplicitly) {
            this.projectName = projectName;
            this.identifier = identifier;
            this.isAddedImplicitly = isAddedImplicitly;
        }
    }
}

