/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javajs.util.PT;
import javax.swing.JApplet;
import org.jmol.applet.ClassPreloader;
import org.jmol.applet.WrappedApplet;
import org.jmol.applet.WrappedAppletLoader;
import org.jmol.util.GenericApplet;
import org.jmol.util.Logger;

public class AppletWrapper
extends JApplet {
    public WrappedApplet wrappedApplet;
    private String preloadImageName;
    private String preloadTextMessage;
    private String previousClassName;
    private int preloadThreadCount;
    private String[] preloadClassNames;
    private int preloadClassIndex;
    private boolean isSigned;
    private boolean needToCompleteInitialization;
    private boolean preloadImageReadyForDisplay;
    private boolean preloadImagePainted;
    private Color bgcolor;
    private Color textColor;
    private Image preloadImage;
    private MediaTracker mediaTracker;
    private long startTime;
    private int clockX;
    private int clockBaseline;
    private int clockWidth;
    private static int MINIMUM_ELAPSED_SECONDS = 1;
    private static String fontFace = "sansserif";
    private static int fontSizeDivisor = 18;
    private int fontSize;
    private Font font;
    private FontMetrics fontMetrics;
    private int fontAscent;
    private int fontHeight;
    private static final String[] colorNames = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow"};
    private static final Color[] colors = new Color[]{Color.cyan, Color.black, Color.blue, Color.magenta, Color.gray, new Color(0, 128, 0), Color.green, new Color(128, 0, 0), new Color(0, 0, 128), new Color(128, 128, 0), new Color(128, 0, 128), Color.red, Color.lightGray, new Color(0, 128, 128), Color.white, Color.yellow};

    @Override
    public void destroy() {
        try {
            ((GenericApplet)((Object)this.wrappedApplet)).destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wrappedApplet = null;
        super.destroy();
    }

    public AppletWrapper(String preloadImageName, int preloadThreadCount, String[] preloadClassNames) {
        this.preloadImageName = preloadImageName;
        this.preloadTextMessage = "Loading Jmol applet ...";
        this.preloadThreadCount = preloadThreadCount;
        this.preloadClassNames = preloadClassNames;
        this.needToCompleteInitialization = true;
        this.isSigned = false;
        try {
            String imagePath = "" + this.getClass().getClassLoader().getResource(preloadImageName);
            this.isSigned = imagePath.indexOf("Signed") >= 0;
            System.out.println("appletwrapper isSigned = " + this.isSigned);
        }
        catch (Exception e) {
            Logger.error("isSigned false: " + e);
        }
    }

    public boolean isSigned() {
        System.out.println("appletwrapper2 isSigned = " + this.isSigned);
        return this.isSigned;
    }

    @Override
    public String getAppletInfo() {
        return this.wrappedApplet != null ? ((GenericApplet)((Object)this.wrappedApplet)).getAppletInfo() : null;
    }

    @Override
    public void init() {
        this.startTime = System.currentTimeMillis();
        new WrappedAppletLoader(this, this.isSigned).start();
        int i = this.preloadThreadCount;
        while (--i >= 0) {
            new ClassPreloader(this).start();
        }
    }

    @Override
    public void update(Graphics g) {
        long elapsedTime;
        int imageHeight;
        if (this.wrappedApplet != null) {
            this.mediaTracker = null;
            this.preloadImage = null;
            this.fontMetrics = null;
            this.wrappedApplet.update(g);
            return;
        }
        Dimension dim = this.getSize();
        if (this.needToCompleteInitialization) {
            this.completeInitialization(g, dim);
        }
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(this.textColor);
        int imageBottom = 0;
        if (!this.preloadImageReadyForDisplay && this.mediaTracker != null) {
            this.preloadImageReadyForDisplay = this.mediaTracker.checkID(0, true);
        }
        if (this.preloadImageReadyForDisplay && (imageHeight = this.preloadImage.getHeight(null)) > 0 && 10 + imageHeight + this.fontHeight <= dim.height) {
            g.drawImage(this.preloadImage, 10, 10, null);
            this.preloadImagePainted = true;
            imageBottom = 10 + imageHeight;
        }
        if ((elapsedTime = (System.currentTimeMillis() - this.startTime) / 1000L) >= (long)MINIMUM_ELAPSED_SECONDS) {
            int messageBaseline = imageBottom + this.fontAscent;
            if (messageBaseline < dim.height / 2) {
                messageBaseline = dim.height / 2;
            } else if (messageBaseline >= dim.height) {
                messageBaseline = dim.height - 1;
            }
            g.setFont(this.font);
            g.drawString(this.preloadTextMessage, 10, messageBaseline);
            String clockText = "  " + elapsedTime + " seconds";
            this.clockWidth = this.fontMetrics.stringWidth(clockText);
            this.clockX = dim.width - this.clockWidth - 5;
            if (this.clockX < 0) {
                this.clockX = 0;
            }
            this.clockBaseline = dim.height - 5;
            if (Logger.debugging) {
                Logger.debug(clockText);
            }
            g.drawString(clockText, this.clockX, this.clockBaseline);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.wrappedApplet != null) {
            this.wrappedApplet.paint(g);
            return;
        }
        this.update(g);
    }

    @Override
    public boolean handleEvent(Event e) {
        if (this.wrappedApplet != null) {
            return ((GenericApplet)((Object)this.wrappedApplet)).handleEvent(e);
        }
        return false;
    }

    public synchronized String getNextPreloadClassName() {
        String className;
        if (this.preloadClassNames == null || this.preloadClassIndex == this.preloadClassNames.length) {
            return null;
        }
        if ((className = this.preloadClassNames[this.preloadClassIndex++]).charAt(0) == '.') {
            int lastDot = this.previousClassName.lastIndexOf(46);
            String previousPackageName = this.previousClassName.substring(0, lastDot);
            className = previousPackageName + className;
        }
        this.previousClassName = className;
        return this.previousClassName;
    }

    protected void repaintClock() {
        if (!this.preloadImagePainted || this.clockBaseline == 0) {
            this.repaint();
        } else {
            this.repaint(this.clockX, this.clockBaseline - this.fontAscent, this.clockWidth, this.fontHeight);
        }
    }

    private boolean completeInitialization(Graphics g, Dimension dim) {
        this.needToCompleteInitialization = false;
        try {
            if (Logger.debugging) {
                Logger.debug("loadImage:" + this.preloadImageName);
            }
            URL urlImage = this.getClass().getClassLoader().getResource(this.preloadImageName);
            Logger.info("urlImage=" + urlImage);
            if (urlImage != null) {
                this.preloadImage = Toolkit.getDefaultToolkit().getImage(urlImage);
                if (Logger.debugging) {
                    Logger.debug("successfully loaded " + this.preloadImageName);
                    Logger.debug("preloadImage=" + this.preloadImage);
                }
                this.mediaTracker = new MediaTracker(this);
                this.mediaTracker.addImage(this.preloadImage, 0);
                this.mediaTracker.checkID(0, true);
            }
        }
        catch (Exception e) {
            Logger.error("getImage failed: " + e);
        }
        String bgcolorName = this.getParameter("boxbgcolor");
        if (bgcolorName == null) {
            bgcolorName = this.getParameter("bgcolor");
        }
        this.bgcolor = this.getColorFromName(bgcolorName);
        this.textColor = this.getContrastingBlackOrWhite(this.bgcolor);
        this.fontSize = dim.height / fontSizeDivisor;
        if (this.fontSize < 7) {
            this.fontSize = 7;
        }
        if (this.fontSize > 30) {
            this.fontSize = 30;
        }
        while (true) {
            this.font = new Font(fontFace, 0, this.fontSize);
            this.fontMetrics = g.getFontMetrics(this.font);
            if (this.fontMetrics.stringWidth(this.preloadTextMessage) + 10 < dim.width || this.fontSize < 8) break;
            this.fontSize -= 2;
        }
        this.fontHeight = this.fontMetrics.getHeight();
        this.fontAscent = this.fontMetrics.getAscent();
        return this.isSigned;
    }

    private Color getColorFromName(String strColor) {
        if (strColor != null) {
            if (strColor.length() == 7 && strColor.charAt(0) == '#') {
                try {
                    int red = PT.parseIntRadix(strColor.substring(1, 3), 16);
                    int grn = PT.parseIntRadix(strColor.substring(3, 5), 16);
                    int blu = PT.parseIntRadix(strColor.substring(5, 7), 16);
                    return new Color(red, grn, blu);
                }
                catch (NumberFormatException e) {}
            } else {
                strColor = strColor.toLowerCase().intern();
                int i = colorNames.length;
                while (--i >= 0) {
                    if (strColor != colorNames[i]) continue;
                    return colors[i];
                }
            }
        }
        return Color.black;
    }

    private Color getContrastingBlackOrWhite(Color color) {
        int argb = color.getRGB();
        int grayscale = ((2989 * (argb >> 16) & 0xFF) + (5870 * (argb >> 8) & 0xFF) + 1140 * (argb & 0xFF) + 500) / 1000;
        return grayscale < 128 ? Color.white : Color.black;
    }
}

