/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmChangeCompressedTask
extends DownloadOsmChangeTask {
    private static final String PATTERN_COMPRESS = "https?://.*/(.*\\.osc.(gz|xz|bz2?|zip))";

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_COMPRESS};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download Compressed OSM Change", new Object[0]);
    }

    @Override
    public Future<?> loadUrl(boolean newLayer, final String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadOsmChangeTask.DownloadTask(newLayer, (OsmServerReader)new OsmServerLocationReader(url), progressMonitor){

            @Override
            protected DataSet parseDataSet() throws OsmTransferException {
                ProgressMonitor subTaskMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                return this.reader.parseOsmChange(subTaskMonitor, Compression.byExtension(url));
            }
        };
        this.currentBounds = null;
        this.extractOsmFilename(PATTERN_COMPRESS, url);
        return MainApplication.worker.submit(this.downloadTask);
    }
}

