/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformer;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.inline.clean.LabeledBlockToDoWhileTransformation;
import org.jetbrains.kotlin.js.inline.clean.RemoveDuplicateImportsKt;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedImportsKt;
import org.jetbrains.kotlin.js.inline.clean.ResolveTemporaryNamesKt;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.translate.general.AstGenerationResult;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.ExpandIsCallsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ast.JsAstSerializer;

public final class K2JSTranslator {
    @NotNull
    private final JsConfig config;
    @Nullable
    private final IncrementalResultsConsumer incrementalResults;

    public K2JSTranslator(@NotNull JsConfig config) {
        this.config = config;
        this.incrementalResults = config.getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
    }

    @NotNull
    public TranslationResult translate(@NotNull JsConfig.Reporter reporter, @NotNull List<KtFile> files2, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        return this.translate(reporter, files2, mainCallParameters, null);
    }

    @NotNull
    public TranslationResult translate(@NotNull JsConfig.Reporter reporter, @NotNull List<KtFile> files2, @NotNull MainCallParameters mainCallParameters, @Nullable JsAnalysisResult analysisResult2) throws TranslationException {
        ArrayList<TranslationUnit> units = new ArrayList<TranslationUnit>();
        for (KtFile file2 : files2) {
            units.add(new TranslationUnit.SourceFile(file2));
        }
        return this.translateUnits(reporter, units, mainCallParameters, analysisResult2);
    }

    @NotNull
    public TranslationResult translateUnits(@NotNull JsConfig.Reporter reporter, @NotNull List<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        return this.translateUnits(reporter, units, mainCallParameters, null);
    }

    @NotNull
    public TranslationResult translateUnits(@NotNull JsConfig.Reporter reporter, @NotNull List<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters, @Nullable JsAnalysisResult analysisResult2) throws TranslationException {
        ArrayList<KtFile> files2 = new ArrayList<KtFile>();
        for (TranslationUnit unit : units) {
            if (!(unit instanceof TranslationUnit.SourceFile)) continue;
            files2.add(((TranslationUnit.SourceFile)unit).getFile());
        }
        if (analysisResult2 == null) {
            analysisResult2 = TopDownAnalyzerFacadeForJS.analyzeFiles(files2, this.config);
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
        BindingTrace bindingTrace = analysisResult2.getBindingTrace();
        TopDownAnalyzerFacadeForJS.checkForErrors(files2, bindingTrace.getBindingContext());
        ModuleDescriptor moduleDescriptor = analysisResult2.getModuleDescriptor();
        Diagnostics diagnostics2 = bindingTrace.getBindingContext().getDiagnostics();
        SourceFilePathResolver pathResolver = SourceFilePathResolver.create(this.config);
        AstGenerationResult translationResult = Translation.generateAst(bindingTrace, units, mainCallParameters, moduleDescriptor, this.config, pathResolver);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics2)) {
            return new TranslationResult.Fail(diagnostics2);
        }
        ArrayList<JsProgramFragment> newFragments = new ArrayList<JsProgramFragment>(translationResult.getNewFragments());
        ArrayList<JsProgramFragment> allFragments = new ArrayList<JsProgramFragment>(translationResult.getFragments());
        JsInliner.process(reporter, this.config, analysisResult2.getBindingTrace(), translationResult.getInnerModuleName(), allFragments, newFragments, translationResult.getImportStatements());
        LabeledBlockToDoWhileTransformation.INSTANCE.apply(newFragments);
        CoroutineTransformer coroutineTransformer = new CoroutineTransformer();
        for (JsProgramFragment fragment : newFragments) {
            coroutineTransformer.accept(fragment.getDeclarationBlock());
            coroutineTransformer.accept(fragment.getInitializerBlock());
        }
        RemoveUnusedImportsKt.removeUnusedImports(translationResult.getProgram());
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics2)) {
            return new TranslationResult.Fail(diagnostics2);
        }
        ExpandIsCallsKt.expandIsCalls(newFragments);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        JsAstSerializer serializer = new JsAstSerializer(file2 -> {
            try {
                return pathResolver.getPathRelativeToSourceRoots((File)file2);
            }
            catch (IOException e) {
                throw new RuntimeException("IO error occurred resolving path to source file", e);
            }
        });
        if (this.incrementalResults != null) {
            KotlinJavascriptSerializationUtil serializationUtil = KotlinJavascriptSerializationUtil.INSTANCE;
            for (KtFile file3 : files2) {
                JsProgramFragment fragment = translationResult.getFragmentMap().get(file3);
                assert (fragment != null) : "Could not find AST for file: " + file3;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                serializer.serialize(fragment, output);
                byte[] binaryAst = output.toByteArray();
                List<DeclarationDescriptor> scope = translationResult.getFileMemberScopes().get(file3);
                assert (scope != null) : "Could not find descriptors for file: " + file3;
                ProtoBuf.PackageFragment packagePart = serializationUtil.serializeDescriptors(bindingTrace.getBindingContext(), moduleDescriptor, scope, file3.getPackageFqName());
                File ioFile = VfsUtilCore.virtualToIoFile(file3.getVirtualFile());
                this.incrementalResults.processPackagePart(ioFile, packagePart.toByteArray(), binaryAst);
            }
            LanguageVersionSettings settings2 = CommonConfigurationKeysKt.getLanguageVersionSettings(this.config.getConfiguration());
            this.incrementalResults.processHeader(serializationUtil.serializeHeader(moduleDescriptor, null, settings2).toByteArray());
        }
        RemoveDuplicateImportsKt.removeDuplicateImports(translationResult.getProgram());
        ResolveTemporaryNamesKt.resolveTemporaryNames(translationResult.getProgram());
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics2)) {
            return new TranslationResult.Fail(diagnostics2);
        }
        ArrayList<String> importedModules = new ArrayList<String>();
        for (JsImportedModule module2 : translationResult.getImportedModuleList()) {
            importedModules.add(module2.getExternalName());
        }
        return new TranslationResult.Success(this.config, files2, translationResult.getProgram(), diagnostics2, importedModules, moduleDescriptor, bindingTrace.getBindingContext());
    }
}

