/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ManagedPixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Screen;
import com.tigervnc.rfb.ScreenSet;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class CMsgReader {
    public int imageBufIdealSize = 0;
    protected CMsgHandler handler;
    protected InStream is;
    protected int nUpdateRectsLeft;
    protected int[] imageBuf;
    protected int imageBufSize;
    static LogWriter vlog = new LogWriter("CMsgReader");

    protected CMsgReader(CMsgHandler cMsgHandler, InStream inStream) {
        this.handler = cMsgHandler;
        this.is = inStream;
        this.imageBuf = null;
        this.imageBufSize = 0;
        this.nUpdateRectsLeft = 0;
    }

    public void readServerInit() {
        int n = this.is.readU16();
        int n2 = this.is.readU16();
        this.handler.setDesktopSize(n, n2);
        PixelFormat pixelFormat = new PixelFormat();
        pixelFormat.read(this.is);
        this.handler.setPixelFormat(pixelFormat);
        String string = this.is.readString();
        this.handler.setName(string);
        this.handler.serverInit();
    }

    public void readMsg() {
        if (this.nUpdateRectsLeft == 0) {
            int n = this.is.readU8();
            switch (n) {
                case 1: {
                    this.readSetColourMapEntries();
                    break;
                }
                case 2: {
                    this.readBell();
                    break;
                }
                case 3: {
                    this.readServerCutText();
                    break;
                }
                case 0: {
                    this.readFramebufferUpdate();
                    break;
                }
                case 248: {
                    this.readFence();
                    break;
                }
                case 150: {
                    this.readEndOfContinuousUpdates();
                    break;
                }
                default: {
                    throw new Exception("unknown message type");
                }
            }
        } else {
            int n = this.is.readU16();
            int n2 = this.is.readU16();
            int n3 = this.is.readU16();
            int n4 = this.is.readU16();
            int n5 = this.is.readS32();
            switch (n5) {
                case -224: {
                    this.nUpdateRectsLeft = 1;
                    break;
                }
                case -240: {
                    this.readSetXCursor(n3, n4, new Point(n, n2));
                    break;
                }
                case -239: {
                    this.readSetCursor(n3, n4, new Point(n, n2));
                    break;
                }
                case -314: {
                    this.readSetCursorWithAlpha(n3, n4, new Point(n, n2));
                    break;
                }
                case -307: {
                    this.readSetDesktopName(n, n2, n3, n4);
                    break;
                }
                case -223: {
                    this.handler.setDesktopSize(n3, n4);
                    break;
                }
                case -308: {
                    this.readExtendedDesktopSize(n, n2, n3, n4);
                    break;
                }
                case -311: {
                    this.nUpdateRectsLeft = 0;
                    this.readClientRedirect(n, n2, n3, n4);
                    return;
                }
                default: {
                    this.readRect(new Rect(n, n2, n + n3, n2 + n4), n5);
                }
            }
            --this.nUpdateRectsLeft;
            if (this.nUpdateRectsLeft == 0) {
                this.handler.framebufferUpdateEnd();
            }
        }
    }

    protected void readSetColourMapEntries() {
        this.is.skip(1);
        int n = this.is.readU16();
        int n2 = this.is.readU16();
        int[] nArray = new int[n2 * 3];
        for (int i = 0; i < n2 * 3; ++i) {
            nArray[i] = this.is.readU16();
        }
        this.handler.setColourMapEntries(n, n2, nArray);
    }

    protected void readBell() {
        this.handler.bell();
    }

    protected void readServerCutText() {
        this.is.skip(3);
        int n = this.is.readU32();
        if (n > 262144) {
            this.is.skip(n);
            vlog.error("cut text too long (" + n + " bytes) - ignoring");
            return;
        }
        byte[] byArray = new byte[n];
        this.is.readBytes(byArray, 0, n);
        Charset charset = Charset.forName("ISO-8859-1");
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(byArray));
        this.handler.serverCutText(charBuffer.toString(), n);
    }

    protected void readFence() {
        byte[] byArray = new byte[64];
        this.is.skip(3);
        int n = this.is.readU32();
        int n2 = this.is.readU8();
        if (n2 > byArray.length) {
            System.out.println("Ignoring fence with too large payload\n");
            this.is.skip(n2);
            return;
        }
        this.is.readBytes(byArray, 0, n2);
        this.handler.fence(n, n2, byArray);
    }

    protected void readEndOfContinuousUpdates() {
        this.handler.endOfContinuousUpdates();
    }

    protected void readFramebufferUpdate() {
        this.is.skip(1);
        this.nUpdateRectsLeft = this.is.readU16();
        this.handler.framebufferUpdateStart();
    }

    protected void readRect(Rect rect, int n) {
        if (rect.br.x > this.handler.cp.width || rect.br.y > this.handler.cp.height) {
            vlog.error("Rect too big: " + rect.width() + "x" + rect.height() + " at " + rect.tl.x + "," + rect.tl.y + " exceeds " + this.handler.cp.width + "x" + this.handler.cp.height);
            throw new Exception("Rect too big");
        }
        if (rect.is_empty()) {
            vlog.error("Ignoring zero size rect");
        }
        this.handler.dataRect(rect, n);
    }

    protected void readSetXCursor(int n, int n2, Point point) {
        int n3 = (n + 7) / 8 * n2;
        int n4 = (n + 7) / 8 * n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n4);
        byte[] byArray = new byte[n * n2 * 4];
        if (n * n2 == 0) {
            return;
        }
        byte by = (byte)this.is.readU8();
        byte by2 = (byte)this.is.readU8();
        byte by3 = (byte)this.is.readU8();
        byte by4 = (byte)this.is.readU8();
        byte by5 = (byte)this.is.readU8();
        byte by6 = (byte)this.is.readU8();
        this.is.readBytes(byteBuffer, n3);
        this.is.readBytes(byteBuffer2, n4);
        int n5 = (n + 7) / 8;
        ByteBuffer byteBuffer3 = ByteBuffer.wrap(byArray);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6 = i * n5 + j / 8;
                int n7 = 7 - j % 8;
                if ((byteBuffer.get(n6) & 1 << n7) > 0) {
                    byteBuffer3.put(byteBuffer3.position() + 1, by);
                    byteBuffer3.put(byteBuffer3.position() + 2, by2);
                    byteBuffer3.put(byteBuffer3.position() + 3, by3);
                } else {
                    byteBuffer3.put(byteBuffer3.position() + 1, by4);
                    byteBuffer3.put(byteBuffer3.position() + 2, by5);
                    byteBuffer3.put(byteBuffer3.position() + 3, by6);
                }
                if ((byteBuffer2.get(n6) & 1 << n7) > 0) {
                    byteBuffer3.put(byteBuffer3.position() + 0, (byte)-1);
                } else {
                    byteBuffer3.put(byteBuffer3.position() + 0, (byte)0);
                }
                byteBuffer3.position(byteBuffer3.position() + 4);
            }
        }
        this.handler.setCursor(n, n2, point, byArray);
    }

    protected void readSetCursor(int n, int n2, Point point) {
        int n3 = n * n2 * (this.handler.cp.pf().bpp / 8);
        int n4 = (n + 7) / 8 * n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n4);
        byte[] byArray = new byte[n * n2 * 4];
        this.is.readBytes(byteBuffer, n3);
        this.is.readBytes(byteBuffer2, n4);
        int n5 = (n + 7) / 8;
        ByteBuffer byteBuffer3 = (ByteBuffer)byteBuffer.duplicate().mark();
        ByteBuffer byteBuffer4 = (ByteBuffer)ByteBuffer.wrap(byArray).mark();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6 = i * n5 + j / 8;
                int n7 = 7 - j % 8;
                if ((byteBuffer2.get(n6) & 1 << n7) != 0) {
                    byteBuffer4.put((byte)-1);
                } else {
                    byteBuffer4.put((byte)0);
                }
                this.handler.cp.pf().rgbFromBuffer(byteBuffer4, byteBuffer3.duplicate(), 1);
                byteBuffer3.position(byteBuffer3.position() + this.handler.cp.pf().bpp / 8);
                byteBuffer4.position(byteBuffer4.reset().position() + 4).mark();
            }
        }
        this.handler.setCursor(n, n2, point, byArray);
    }

    protected void readSetCursorWithAlpha(int n, int n2, Point point) {
        PixelFormat pixelFormat = new PixelFormat(32, 32, false, true, 255, 255, 255, 16, 8, 0);
        ManagedPixelBuffer managedPixelBuffer = new ManagedPixelBuffer(pixelFormat, n, n2);
        int n3 = this.is.readS32();
        PixelFormat pixelFormat2 = this.handler.cp.pf();
        this.handler.cp.setPF(pixelFormat);
        this.handler.readAndDecodeRect(managedPixelBuffer.getRect(), n3, managedPixelBuffer);
        this.handler.cp.setPF(pixelFormat2);
        if (managedPixelBuffer.getRect().area() == 0) {
            return;
        }
        DataBufferInt dataBufferInt = (DataBufferInt)managedPixelBuffer.getBufferRW(managedPixelBuffer.getRect()).getDataBuffer();
        ByteBuffer byteBuffer = ByteBuffer.allocate(managedPixelBuffer.area() * 4).order(pixelFormat.getByteOrder());
        byteBuffer.asIntBuffer().put(dataBufferInt.getData()).flip().mark();
        for (int i = 0; i < managedPixelBuffer.area(); ++i) {
            byte by = byteBuffer.get(byteBuffer.position() + 3);
            byteBuffer.put(i * 4 + 3, byteBuffer.get(i * 4 + 2));
            byteBuffer.put(i * 4 + 2, byteBuffer.get(i * 4 + 1));
            byteBuffer.put(i * 4 + 1, byteBuffer.get(i * 4 + 0));
            byteBuffer.put(i * 4 + 0, by);
            byteBuffer.position(byteBuffer.position() + 4);
        }
        this.handler.setCursor(n, n2, point, byteBuffer.array());
    }

    protected void readSetDesktopName(int n, int n2, int n3, int n4) {
        String string = this.is.readString();
        if (n != 0 || n2 != 0 || n3 != 0 || n4 != 0) {
            vlog.error("Ignoring DesktopName rect with non-zero position/size");
        } else {
            this.handler.setName(string);
        }
    }

    protected void readExtendedDesktopSize(int n, int n2, int n3, int n4) {
        ScreenSet screenSet = new ScreenSet();
        int n5 = this.is.readU8();
        this.is.skip(3);
        for (int i = 0; i < n5; ++i) {
            int n6 = this.is.readU32();
            int n7 = this.is.readU16();
            int n8 = this.is.readU16();
            int n9 = this.is.readU16();
            int n10 = this.is.readU16();
            int n11 = this.is.readU32();
            screenSet.add_screen(new Screen(n6, n7, n8, n9, n10, n11));
        }
        this.handler.setExtendedDesktopSize(n, n2, n3, n4, screenSet);
    }

    protected void readClientRedirect(int n, int n2, int n3, int n4) {
        int n5 = this.is.readU16();
        String string = this.is.readString();
        String string2 = this.is.readString();
        if (n != 0 || n2 != 0 || n3 != 0 || n4 != 0) {
            vlog.error("Ignoring ClientRedirect rect with non-zero position/size");
        } else {
            this.handler.clientRedirect(n5, string, string2);
        }
    }

    public int[] getImageBuf(int n) {
        return this.getImageBuf(n, 0, 0);
    }

    public int[] getImageBuf(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        int n6 = n5;
        if (n6 > this.imageBufIdealSize) {
            n6 = this.imageBufIdealSize;
        }
        if (n6 < n4) {
            n6 = n4;
        }
        if (this.imageBufSize < n6) {
            this.imageBufSize = n6;
            this.imageBuf = new int[this.imageBufSize];
        }
        if (n3 != 0) {
            n3 = this.imageBufSize / (this.handler.cp.pf().bpp / 8);
        }
        return this.imageBuf;
    }

    public InStream getInStream() {
        return this.is;
    }
}

