/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public class RecoveryPrepareForTranslogOperationsRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private int totalTranslogOps = -1;
    private boolean createNewTranslog;

    public RecoveryPrepareForTranslogOperationsRequest() {
    }

    RecoveryPrepareForTranslogOperationsRequest(long recoveryId, ShardId shardId, int totalTranslogOps, boolean createNewTranslog) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.totalTranslogOps = totalTranslogOps;
        this.createNewTranslog = createNewTranslog;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    boolean createNewTranslog() {
        return this.createNewTranslog;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        this.totalTranslogOps = in.readVInt();
        if (in.getVersion().before(Version.V_6_0_0_alpha1)) {
            in.readLong();
        }
        this.createNewTranslog = in.getVersion().onOrAfter(Version.V_6_2_0) ? in.readBoolean() : true;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.totalTranslogOps);
        if (out.getVersion().before(Version.V_6_0_0_alpha1)) {
            out.writeLong(-1L);
        }
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeBoolean(this.createNewTranslog);
        }
    }
}

