/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import naga.ChannelResponder;
import naga.ExceptionObserver;
import naga.NIOServerSocket;
import naga.NIOServerSocketSSL;
import naga.NIOSocket;
import naga.NIOSocketSSL;
import naga.NIOUtils;
import naga.SSLServerSocketChannelResponder;
import naga.SSLSocketChannelResponder;
import naga.ServerSocketChannelResponder;
import naga.SocketChannelResponder;

public class NIOService {
    public static final int DEFAULT_IO_BUFFER_SIZE = 65536;
    private final Selector m_selector = Selector.open();
    private final Queue<Runnable> m_internalEventQueue = new ConcurrentLinkedQueue<Runnable>();
    private ByteBuffer m_sharedBuffer;
    private ExceptionObserver m_exceptionObserver = ExceptionObserver.DEFAULT;

    public NIOService() throws IOException {
        this(65536);
    }

    public NIOService(int n) throws IOException {
        this.setBufferSize(n);
    }

    public synchronized void selectBlocking() throws IOException {
        this.executeQueue();
        if (this.m_selector.select() > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public synchronized void selectNonBlocking() throws IOException {
        this.executeQueue();
        if (this.m_selector.selectNow() > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public synchronized void selectBlocking(long l) throws IOException {
        this.executeQueue();
        if (this.m_selector.select(l) > 0) {
            this.handleSelectedKeys();
        }
        this.executeQueue();
    }

    public NIOSocket openSocket(String string, int n) throws IOException {
        return this.openSocket(InetAddress.getByName(string), n);
    }

    public NIOSocket openSSLSocket(SSLEngine sSLEngine, String string, int n) throws IOException {
        return this.openSSLSocket(sSLEngine, InetAddress.getByName(string), n);
    }

    public NIOSocket openSocket(InetAddress inetAddress, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        socketChannel.connect(inetSocketAddress);
        return this.registerSocketChannel(socketChannel, inetSocketAddress);
    }

    public NIOSocketSSL openSSLSocket(SSLEngine sSLEngine, InetAddress inetAddress, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        socketChannel.connect(inetSocketAddress);
        return new SSLSocketChannelResponder(this, this.registerSocketChannel(socketChannel, inetSocketAddress), sSLEngine, true);
    }

    public NIOServerSocket openServerSocket(int n, int n2) throws IOException {
        return this.openServerSocket(new InetSocketAddress(n), n2);
    }

    public NIOServerSocketSSL openSSLServerSocket(SSLContext sSLContext, int n, int n2) throws IOException {
        return this.openSSLServerSocket(sSLContext, new InetSocketAddress(n), n2);
    }

    public NIOServerSocket openServerSocket(int n) throws IOException {
        return this.openServerSocket(n, -1);
    }

    public NIOServerSocketSSL openSSLServerSocket(SSLContext sSLContext, int n) throws IOException {
        return this.openSSLServerSocket(sSLContext, n, -1);
    }

    public NIOServerSocketSSL openSSLServerSocket(SSLContext sSLContext, InetSocketAddress inetSocketAddress, int n) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().setReuseAddress(true);
        serverSocketChannel.socket().bind(inetSocketAddress, n);
        serverSocketChannel.configureBlocking(false);
        SSLServerSocketChannelResponder sSLServerSocketChannelResponder = new SSLServerSocketChannelResponder(sSLContext, this, serverSocketChannel, inetSocketAddress);
        this.queue(new RegisterChannelEvent(sSLServerSocketChannelResponder));
        return sSLServerSocketChannelResponder;
    }

    public NIOServerSocket openServerSocket(InetSocketAddress inetSocketAddress, int n) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.socket().setReuseAddress(true);
        serverSocketChannel.socket().bind(inetSocketAddress, n);
        serverSocketChannel.configureBlocking(false);
        ServerSocketChannelResponder serverSocketChannelResponder = new ServerSocketChannelResponder(this, serverSocketChannel, inetSocketAddress);
        this.queue(new RegisterChannelEvent(serverSocketChannelResponder));
        return serverSocketChannelResponder;
    }

    NIOSocket registerSocketChannel(SocketChannel socketChannel, InetSocketAddress inetSocketAddress) throws IOException {
        socketChannel.configureBlocking(false);
        SocketChannelResponder socketChannelResponder = new SocketChannelResponder(this, socketChannel, inetSocketAddress);
        this.queue(new RegisterChannelEvent(socketChannelResponder));
        return socketChannelResponder;
    }

    private void executeQueue() {
        Runnable runnable;
        while ((runnable = this.m_internalEventQueue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                this.notifyException(throwable);
            }
        }
    }

    private void handleSelectedKeys() {
        Iterator<SelectionKey> iterator = this.m_selector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            iterator.remove();
            try {
                this.handleKey(selectionKey);
            }
            catch (Throwable throwable) {
                this.notifyException(throwable);
            }
        }
    }

    public void setBufferSize(int n) {
        if (n < 256) {
            throw new IllegalArgumentException("The buffer must at least hold 256 bytes");
        }
        this.m_sharedBuffer = ByteBuffer.allocate(n);
    }

    public int getBufferSize() {
        return this.m_sharedBuffer.capacity();
    }

    ByteBuffer getSharedBuffer() {
        return this.m_sharedBuffer;
    }

    private void handleKey(SelectionKey selectionKey) {
        ChannelResponder channelResponder = (ChannelResponder)selectionKey.attachment();
        try {
            if (selectionKey.isReadable()) {
                channelResponder.socketReadyForRead();
            }
            if (selectionKey.isWritable()) {
                channelResponder.socketReadyForWrite();
            }
            if (selectionKey.isAcceptable()) {
                channelResponder.socketReadyForAccept();
            }
            if (selectionKey.isConnectable()) {
                channelResponder.socketReadyForConnect();
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            channelResponder.close(cancelledKeyException);
        }
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.queue(new ShutdownEvent());
    }

    public boolean isOpen() {
        return this.m_selector.isOpen();
    }

    public void queue(Runnable runnable) {
        this.m_internalEventQueue.add(runnable);
        this.wakeup();
    }

    public Queue<Runnable> getQueue() {
        return new LinkedList<Runnable>(this.m_internalEventQueue);
    }

    public void wakeup() {
        this.m_selector.wakeup();
    }

    public void setExceptionObserver(ExceptionObserver exceptionObserver) {
        final ExceptionObserver exceptionObserver2 = exceptionObserver == null ? ExceptionObserver.DEFAULT : exceptionObserver;
        this.queue(new Runnable(){

            @Override
            public void run() {
                NIOService.this.m_exceptionObserver = exceptionObserver2;
            }
        });
    }

    public void notifyException(Throwable throwable) {
        try {
            this.m_exceptionObserver.notifyExceptionThrown(throwable);
        }
        catch (Exception exception) {
            System.err.println("Failed to log the following exception to the exception observer:");
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    private class ShutdownEvent
    implements Runnable {
        private ShutdownEvent() {
        }

        @Override
        public void run() {
            if (!NIOService.this.isOpen()) {
                return;
            }
            for (SelectionKey selectionKey : NIOService.this.m_selector.keys()) {
                try {
                    NIOUtils.cancelKeySilently(selectionKey);
                    ((ChannelResponder)selectionKey.attachment()).close();
                }
                catch (Exception exception) {}
            }
            try {
                NIOService.this.m_selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class RegisterChannelEvent
    implements Runnable {
        private final ChannelResponder m_channelResponder;

        private RegisterChannelEvent(ChannelResponder channelResponder) {
            this.m_channelResponder = channelResponder;
        }

        @Override
        public void run() {
            try {
                SelectionKey selectionKey = this.m_channelResponder.getChannel().register(NIOService.this.m_selector, this.m_channelResponder.getChannel().validOps());
                this.m_channelResponder.setKey(selectionKey);
                selectionKey.attach(this.m_channelResponder);
            }
            catch (Exception exception) {
                this.m_channelResponder.close(exception);
            }
        }

        public String toString() {
            return "Register[" + this.m_channelResponder + "]";
        }
    }
}

