/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Context;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class SpotLightRetained
extends PointLightRetained {
    static final int DIRECTION_CHANGED = 512;
    static final int ANGLE_CHANGED = 1024;
    static final int CONCENTRATION_CHANGED = 2048;
    Vector3f direction = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);
    float spreadAngle = (float)Math.PI;
    float concentration = 0.0f;

    SpotLightRetained() {
        this.nodeType = 8;
        this.lightType = 4;
    }

    void initSpreadAngle(float f) {
        this.spreadAngle = (double)f < 0.0 ? 0.0f : (f > 1.5707964f ? (float)Math.PI : f);
    }

    void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        J3dMessage j3dMessage = super.initMessage(12);
        Object[] objectArray = (Object[])j3dMessage.args[4];
        objectArray[9] = new Float(this.spreadAngle);
        objectArray[10] = new Float(this.concentration);
        objectArray[11] = new Vector3f(this.direction);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setSpreadAngle(float f) {
        this.initSpreadAngle(f);
        this.sendMessage(1024, new Float(this.spreadAngle));
    }

    float getSpreadAngle() {
        return this.spreadAngle;
    }

    void initConcentration(float f) {
        this.concentration = f;
    }

    void setConcentration(float f) {
        this.initConcentration(f);
        this.sendMessage(2048, new Float(f));
    }

    float getConcentration() {
        return this.concentration;
    }

    void initDirection(Vector3f vector3f) {
        this.direction.set((Tuple3f)vector3f);
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(Vector3f vector3f) {
        this.initDirection(vector3f);
        this.sendMessage(512, new Vector3f(vector3f));
    }

    void initDirection(float f, float f2, float f3) {
        this.direction.x = f;
        this.direction.y = f2;
        this.direction.z = f3;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(float f, float f2, float f3) {
        this.setDirection(new Vector3f(f, f2, f3));
    }

    void getDirection(Vector3f vector3f) {
        vector3f.set((Tuple3f)this.direction);
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(vector3f, vector3f);
        }
    }

    void update(Context context, int n, double d) {
        this.validateAttenuationInEc(d);
        Pipeline.getPipeline().updateSpotLight(context, n, this.color.x, this.color.y, this.color.z, this.attenuation.x, this.linearAttenuationInEc, this.quadraticAttenuationInEc, this.xformPosition.x, this.xformPosition.y, this.xformPosition.z, this.spreadAngle, this.concentration, this.xformDirection.x, this.xformDirection.y, this.xformDirection.z);
    }

    void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        int n2 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        if ((n & 0x200) != 0) {
            for (int i = 0; i < n2; ++i) {
                if (lightRetainedArray[i].nodeType != 8) continue;
                SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[i];
                spotLightRetained.direction = (Vector3f)objectArray[4];
                spotLightRetained.getLastLocalToVworld().transform(spotLightRetained.direction, spotLightRetained.xformDirection);
                spotLightRetained.xformDirection.normalize();
            }
        } else if ((n & 0x400) != 0) {
            for (int i = 0; i < n2; ++i) {
                if (lightRetainedArray[i].nodeType != 8) continue;
                SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[i];
                spotLightRetained.spreadAngle = ((Float)objectArray[4]).floatValue();
            }
        } else if ((n & 0x800) != 0) {
            for (int i = 0; i < n2; ++i) {
                if (lightRetainedArray[i].nodeType != 8) continue;
                SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[i];
                spotLightRetained.concentration = ((Float)objectArray[4]).floatValue();
            }
        } else if ((n & 0x20) != 0) {
            for (int i = 0; i < n2; ++i) {
                if (lightRetainedArray[i].nodeType != 8) continue;
                SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[i];
                spotLightRetained.spreadAngle = ((Float)((Object[])objectArray[4])[9]).floatValue();
                spotLightRetained.concentration = ((Float)((Object[])objectArray[4])[10]).floatValue();
                spotLightRetained.direction = (Vector3f)((Object[])objectArray[4])[11];
                spotLightRetained.getLastLocalToVworld().transform(spotLightRetained.direction, spotLightRetained.xformDirection);
                spotLightRetained.xformDirection.normalize();
            }
        }
        super.updateMirrorObject(objectArray);
    }

    protected Object clone() {
        SpotLightRetained spotLightRetained = (SpotLightRetained)super.clone();
        spotLightRetained.direction = new Vector3f(this.direction);
        spotLightRetained.xformDirection = new Vector3f();
        return spotLightRetained;
    }

    void updateTransformChange() {
        super.updateTransformChange();
        this.getLastLocalToVworld().transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 19;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.direction, this.direction);
    }
}

