// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceMX;

/**
 * Provide measurements for proxy invocations. Proxy invocations can
 * either be sent over the wire or be collocated.
 *
 **/
public class InvocationMetrics extends Metrics
{
    public InvocationMetrics()
    {
        super();
        this.retry = 0;
        this.userException = 0;
    }

    public InvocationMetrics(String id, long total, int current, long totalLifetime, int failures, int retry, int userException, Metrics[] remotes, Metrics[] collocated)
    {
        super(id, total, current, totalLifetime, failures);
        this.retry = retry;
        this.userException = userException;
        this.remotes = remotes;
        this.collocated = collocated;
    }

    private static class _F implements Ice.ValueFactory
    {
        public Ice.Object create(String type)
        {
            assert(type.equals(ice_staticId()));
            return new InvocationMetrics();
        }
    }
    private static Ice.ValueFactory _factory = new _F();

    public static Ice.ValueFactory
    ice_factory()
    {
        return _factory;
    }

    private static final String[] _ids =
    {
        "::Ice::Object",
        "::IceMX::InvocationMetrics",
        "::IceMX::Metrics"
    };

    public boolean ice_isA(String s)
    {
        return java.util.Arrays.binarySearch(_ids, s) >= 0;
    }

    public boolean ice_isA(String s, Ice.Current current)
    {
        return java.util.Arrays.binarySearch(_ids, s) >= 0;
    }

    public String[] ice_ids()
    {
        return _ids;
    }

    public String[] ice_ids(Ice.Current current)
    {
        return _ids;
    }

    public String ice_id()
    {
        return _ids[1];
    }

    public String ice_id(Ice.Current current)
    {
        return _ids[1];
    }

    public static String ice_staticId()
    {
        return _ids[1];
    }

    protected void _iceWriteImpl(Ice.OutputStream ostr_)
    {
        ostr_.startSlice(ice_staticId(), -1, false);
        ostr_.writeInt(retry);
        ostr_.writeInt(userException);
        MetricsMapHelper.write(ostr_, remotes);
        MetricsMapHelper.write(ostr_, collocated);
        ostr_.endSlice();
        super._iceWriteImpl(ostr_);
    }

    protected void _iceReadImpl(Ice.InputStream istr_)
    {
        istr_.startSlice();
        retry = istr_.readInt();
        userException = istr_.readInt();
        remotes = MetricsMapHelper.read(istr_);
        collocated = MetricsMapHelper.read(istr_);
        istr_.endSlice();
        super._iceReadImpl(istr_);
    }

    /**
     * The number of retries for the invocation(s).
     *
     **/
    public int retry;

    /**
     * The number of invocations that failed with a user exception.
     *
     **/
    public int userException;

    /**
     * The remote invocation metrics map.
     *
     * @see RemoteMetrics
     *
     **/
    public Metrics[] remotes;

    /**
     * The collocated invocation metrics map.
     *
     * @see CollocatedMetrics
     *
     **/
    public Metrics[] collocated;

    public InvocationMetrics
    clone()
    {
        return (InvocationMetrics)super.clone();
    }

    public static final long serialVersionUID = -1227589572L;
}
