/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/BuilderFunctionsCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class BuilderFunctionsCallChecker
implements CallChecker {
    public static final BuilderFunctionsCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        block6: {
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object obj = resolvedCall2.getCandidateDescriptor();
            if (!(obj instanceof FunctionDescriptor)) {
                obj = null;
            }
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)obj;
            if (functionDescriptor == null) {
                return;
            }
            FunctionDescriptor descriptor2 = functionDescriptor;
            List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor it;
                    ValueParameterDescriptor valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                    if (!CoroutineUtilKt.getHasSuspendFunctionType(valueParameterDescriptor)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            CoroutineCallCheckerKt.checkCoroutinesFeature(context.getLanguageVersionSettings(), context.getTrace(), reportOn);
        }
    }

    private BuilderFunctionsCallChecker() {
    }

    static {
        BuilderFunctionsCallChecker builderFunctionsCallChecker;
        INSTANCE = builderFunctionsCallChecker = new BuilderFunctionsCallChecker();
    }
}

