/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.RealizableTaskCollection;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskReferenceResolver;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskReference;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Cast;
import org.gradle.internal.Transformers;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Set<String> VALID_TASK_ARGUMENTS = ImmutableSet.of((Object)"action", (Object)"dependsOn", (Object)"description", (Object)"group", (Object)"name", (Object)"overwrite", (Object[])new String[]{"type", "constructorArgs"});
    private static final Set<String> MANDATORY_TASK_ARGUMENTS = ImmutableSet.of((Object)"name", (Object)"type");
    private final MutableModelNode modelNode;
    private final ITaskFactory taskFactory;
    private final ProjectAccessListener projectAccessListener;
    private final Set<String> placeholders = Sets.newHashSet();

    public DefaultTaskContainer(MutableModelNode modelNode, ProjectInternal project, Instantiator instantiator, ITaskFactory taskFactory, ProjectAccessListener projectAccessListener) {
        super(Task.class, instantiator, project);
        this.modelNode = modelNode;
        this.taskFactory = taskFactory;
        this.projectAccessListener = projectAccessListener;
    }

    public Task create(Map<String, ?> options) {
        Object action;
        Object group;
        Object description;
        Map<String, ?> actualArgs;
        String name;
        Map<String, ?> factoryOptions = options;
        boolean replace = false;
        if (options.containsKey("overwrite")) {
            factoryOptions = new HashMap(options);
            Object replaceStr = factoryOptions.remove("overwrite");
            replace = "true".equals(replaceStr.toString());
        }
        if (!GUtil.isTrue((Object)(name = (actualArgs = DefaultTaskContainer.checkTaskArgsAndCreateDefaultValues(factoryOptions)).get("name").toString()))) {
            throw new InvalidUserDataException("The task name must be provided.");
        }
        Class type = (Class)Cast.uncheckedCast(actualArgs.get("type"));
        Object[] constructorArgs = DefaultTaskContainer.getConstructorArgs(actualArgs);
        TaskInternal task = (TaskInternal)this.createTask(name, type, constructorArgs);
        Object dependsOnTasks = actualArgs.get("dependsOn");
        if (dependsOnTasks != null) {
            task.dependsOn(new Object[]{dependsOnTasks});
        }
        if ((description = actualArgs.get("description")) != null) {
            task.setDescription(description.toString());
        }
        if ((group = actualArgs.get("group")) != null) {
            task.setGroup(group.toString());
        }
        if ((action = actualArgs.get("action")) instanceof Action) {
            Action taskAction = (Action)Cast.uncheckedCast(action);
            task.doFirst(taskAction);
        } else if (action != null) {
            Closure closure = (Closure)action;
            task.doFirst(closure);
        }
        return this.addTask(task, replace);
    }

    private static Object[] getConstructorArgs(Map<String, ?> args) {
        Object constructorArgs = args.get("constructorArgs");
        if (constructorArgs instanceof List) {
            List asList = (List)constructorArgs;
            return asList.toArray(new Object[asList.size()]);
        }
        if (constructorArgs instanceof Object[]) {
            return (Object[])constructorArgs;
        }
        if (constructorArgs != null) {
            throw new IllegalArgumentException(String.format("%s must be a List or Object[].  Received %s", "constructorArgs", constructorArgs.getClass()));
        }
        return NO_ARGS;
    }

    private static Map<String, ?> checkTaskArgsAndCreateDefaultValues(Map<String, ?> args) {
        DefaultTaskContainer.validateArgs(args);
        if (!args.keySet().containsAll(MANDATORY_TASK_ARGUMENTS)) {
            HashMap argsWithDefaults = Maps.newHashMap(args);
            DefaultTaskContainer.setIfNull(argsWithDefaults, "name", "");
            DefaultTaskContainer.setIfNull(argsWithDefaults, "type", DefaultTask.class);
            return argsWithDefaults;
        }
        return args;
    }

    private static void validateArgs(Map<String, ?> args) {
        if (!VALID_TASK_ARGUMENTS.containsAll(args.keySet())) {
            HashMap unknownArguments = new HashMap(args);
            unknownArguments.keySet().removeAll(VALID_TASK_ARGUMENTS);
            throw new InvalidUserDataException(String.format("Could not create task '%s': Unknown argument(s) in task definition: %s", args.get("name"), unknownArguments.keySet()));
        }
    }

    private static void setIfNull(Map<String, Object> map, String key, Object defaultValue) {
        if (map.get(key) == null) {
            map.put(key, defaultValue);
        }
    }

    private <T extends Task> T addTask(T task, boolean replaceExisting) {
        Task existing;
        String name = task.getName();
        if (this.placeholders.remove(name)) {
            this.modelNode.removeLink(name);
        }
        if ((existing = (Task)this.findByNameWithoutRules(name)) != null) {
            if (replaceExisting) {
                this.remove(existing);
            } else {
                throw new InvalidUserDataException(String.format("Cannot add %s as a task with that name already exists.", task));
            }
        }
        this.add(task);
        return task;
    }

    public <U extends Task> U maybeCreate(String name, Class<U> type) throws InvalidUserDataException {
        Task existing = this.findByName(name);
        if (existing != null) {
            return (U)((Task)Transformers.cast(type).transform((Object)existing));
        }
        return this.create(name, type);
    }

    public Task create(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        return this.create(options).configure(configureClosure);
    }

    public <T extends Task> T create(String name, Class<T> type) {
        return this.create(name, type, NO_ARGS);
    }

    public <T extends Task> T create(String name, Class<T> type, Object ... constructorArgs) throws InvalidUserDataException {
        T task = this.createTask(name, type, constructorArgs);
        return this.addTask(task, false);
    }

    private <T extends Task> T createTask(String name, Class<T> type, Object ... constructorArgs) throws InvalidUserDataException {
        for (int i = 0; i < constructorArgs.length; ++i) {
            if (constructorArgs[i] != null) continue;
            throw new NullPointerException(String.format("Received null for %s constructor argument #%s", type.getName(), i + 1));
        }
        return this.taskFactory.create(name, type, constructorArgs);
    }

    public Task create(String name) {
        return this.create(name, DefaultTask.class);
    }

    public Task create(String name, Action<? super Task> configureAction) throws InvalidUserDataException {
        Task task = this.create(name);
        configureAction.execute((Object)task);
        return task;
    }

    public Task maybeCreate(String name) {
        Task task = this.findByName(name);
        if (task != null) {
            return task;
        }
        return this.create(name);
    }

    public Task replace(String name) {
        return this.replace(name, DefaultTask.class);
    }

    public Task create(String name, Closure configureClosure) {
        return this.create(name).configure(configureClosure);
    }

    public <T extends Task> T create(String name, Class<T> type, Action<? super T> configuration) throws InvalidUserDataException {
        T task = this.create(name, type);
        configuration.execute(task);
        return task;
    }

    public <T extends Task> T replace(String name, Class<T> type) {
        Task task = (Task)this.taskFactory.create(name, type);
        return (T)this.addTask(task, true);
    }

    public Task findByPath(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!path.contains(":")) {
            return this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        ProjectInternal project = this.project.findProject(Strings.isNullOrEmpty((String)projectPath) ? ":" : projectPath);
        if (project == null) {
            return null;
        }
        this.projectAccessListener.beforeRequestingTaskByPath(project);
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    @Override
    public Task resolveTask(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getByPath(path);
    }

    @Override
    public Task resolveTask(TaskReference reference) {
        for (TaskReferenceResolver taskResolver : this.project.getServices().getAll(TaskReferenceResolver.class)) {
            Task constructed = taskResolver.constructTask(reference, this);
            if (constructed == null) continue;
            return constructed;
        }
        throw new UnknownTaskException(String.format("Task reference '%s' could not be resolved in %s.", reference.getName(), this.project));
    }

    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }

    public TaskContainerInternal configure(Closure configureClosure) {
        return ConfigureUtil.configureSelf(configureClosure, this, new NamedDomainObjectContainerConfigureDelegate(configureClosure, (NamedDomainObjectContainer)this));
    }

    @Override
    public NamedEntityInstantiator<Task> getEntityInstantiator() {
        return this.taskFactory;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }

    @Override
    public SortedSet<String> getNames() {
        return Sets.newTreeSet((Iterable)this.modelNode.getLinkNames());
    }

    @Override
    public void realize() {
        this.project.getModelRegistry().realizeNode(this.modelNode.getPath());
    }

    @Override
    public void discoverTasks() {
        this.project.fireDeferredConfiguration();
        this.project.getModelRegistry().atStateOrLater(this.modelNode.getPath(), ModelNode.State.SelfClosed);
    }

    @Override
    public void prepareForExecution(Task task) {
        assert (task.getProject() == this.project);
        if (this.modelNode.hasLink(task.getName())) {
            this.realizeTask(MODEL_PATH.child(task.getName()), ModelNode.State.GraphClosed);
        }
    }

    private boolean maybeCreateTasks(String name) {
        if (this.modelNode.hasLink(name)) {
            this.realizeTask(MODEL_PATH.child(name), ModelNode.State.Initialized);
            return true;
        }
        return false;
    }

    @Override
    public Task findByName(String name) {
        Task task = (Task)super.findByName(name);
        if (task != null) {
            return task;
        }
        if (!this.maybeCreateTasks(name)) {
            return null;
        }
        this.placeholders.remove(name);
        return (Task)super.findByNameWithoutRules(name);
    }

    private Task realizeTask(ModelPath taskPath, ModelNode.State minState) {
        return (Task)this.project.getModelRegistry().atStateOrLater(taskPath, ModelType.of(Task.class), minState);
    }

    @Override
    public <T extends TaskInternal> void addPlaceholderAction(String placeholderName, Class<T> taskType, Action<? super T> configure) {
        if (!this.modelNode.hasLink(placeholderName)) {
            ModelType taskModelType = ModelType.of(taskType);
            ModelPath path = MODEL_PATH.child(placeholderName);
            this.modelNode.addLink(ModelRegistrations.of((ModelPath)path).action(ModelActionRole.Create, new TaskCreator<T>(placeholderName, taskType, configure, taskModelType)).withProjection((ModelProjection)new UnmanagedModelProjection(taskModelType)).descriptor((ModelRuleDescriptor)new SimpleModelRuleDescriptor("tasks.addPlaceholderAction(" + placeholderName + ")")).build());
        }
        if (this.findByNameWithoutRules(placeholderName) == null) {
            this.placeholders.add(placeholderName);
        }
    }

    public <U extends Task> NamedDomainObjectContainer<U> containerWithType(Class<U> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<? extends Class<? extends Task>> getCreateableTypes() {
        return Collections.singleton(this.getType());
    }

    @Override
    public <S extends Task> TaskCollection<S> withType(Class<S> type) {
        return new RealizableTaskCollection<S>(type, super.withType(type), this.modelNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskCreator<T extends TaskInternal>
    implements Action<MutableModelNode> {
        private final String placeholderName;
        private final Class<T> taskType;
        private final Action<? super T> configure;
        private final ModelType<T> taskModelType;

        public TaskCreator(String placeholderName, Class<T> taskType, Action<? super T> configure, ModelType<T> taskModelType) {
            this.placeholderName = placeholderName;
            this.taskType = taskType;
            this.configure = configure;
            this.taskModelType = taskModelType;
        }

        public void execute(MutableModelNode mutableModelNode) {
            DefaultTaskContainer taskContainer = (DefaultTaskContainer)mutableModelNode.getParent().getPrivateData(ModelType.of(DefaultTaskContainer.class));
            TaskInternal task = (TaskInternal)taskContainer.taskFactory.create(this.placeholderName, this.taskType);
            this.configure.execute((Object)task);
            taskContainer.add(task);
            mutableModelNode.setPrivateData(this.taskModelType, (Object)task);
        }
    }
}

