/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Desktop;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.core.IDESettings;
import org.netbeans.core.ui.SwingBrowser;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public final class NbURLDisplayer
extends HtmlBrowser.URLDisplayer {
    private static final RequestProcessor RP = new RequestProcessor("URLDisplayer");
    private NbBrowser htmlViewer;

    public void showURL(final URL uRL) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                NbURLDisplayer.this.warmBrowserUp(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (NbURLDisplayer.this.htmlViewer == null) {
                            NbURLDisplayer.this.htmlViewer = new NbBrowser();
                        }
                        NbURLDisplayer.this.htmlViewer.showUrl(uRL);
                    }
                });
            }
        });
    }

    public void showURLExternal(final URL uRL) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                NbURLDisplayer.this.warmBrowserUp(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (NbURLDisplayer.this.htmlViewer == null) {
                            NbURLDisplayer.this.htmlViewer = new NbBrowser();
                        }
                        NbURLDisplayer.this.htmlViewer.showUrlExternal(uRL);
                    }
                });
            }
        });
    }

    private void warmBrowserUp(boolean bl) {
        if (bl && (null == this.htmlViewer || null == this.htmlViewer.externalBrowser) || !bl && (null == this.htmlViewer || null == this.htmlViewer.brComp)) {
            HtmlBrowser.Impl impl;
            HtmlBrowser.Factory factory;
            HtmlBrowser.Factory factory2 = factory = bl ? IDESettings.getExternalWWWBrowser() : IDESettings.getWWWBrowser();
            if (null != factory && null != (impl = factory.createHtmlBrowserImpl())) {
                impl.getLookup();
            }
        }
    }

    private static final class DesktopBrowser
    implements HtmlBrowser.Factory {
        private final Desktop desktop;

        public DesktopBrowser(Desktop desktop) {
            this.desktop = desktop;
        }

        public HtmlBrowser.Impl createHtmlBrowserImpl() {
            return new HtmlBrowser.Impl(){
                private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
                private URL url;

                public void setURL(URL uRL) {
                    this.url = uRL;
                    URL uRL2 = DesktopBrowser.externalize(uRL);
                    try {
                        DesktopBrowser.this.desktop.browse(uRL2.toURI());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(NbURLDisplayer.class.getName()).log(Level.INFO, "showing: " + uRL2, exception);
                    }
                }

                public URL getURL() {
                    return this.url;
                }

                public void reloadDocument() {
                    this.setURL(this.url);
                }

                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                    this.pcs.addPropertyChangeListener(propertyChangeListener);
                }

                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                    this.pcs.removePropertyChangeListener(propertyChangeListener);
                }

                public Component getComponent() {
                    return null;
                }

                public void stopLoading() {
                }

                public String getStatusMessage() {
                    return "";
                }

                public String getTitle() {
                    return "";
                }

                public boolean isForward() {
                    return false;
                }

                public void forward() {
                }

                public boolean isBackward() {
                    return false;
                }

                public void backward() {
                }

                public boolean isHistory() {
                    return false;
                }

                public void showHistory() {
                }
            };
        }

        private static URL externalize(URL uRL) {
            String string = uRL.getProtocol();
            if (string == null || string.equals("file") || string.equals("http") || string.equals("https")) {
                return uRL;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) {
                return uRL;
            }
            URL uRL2 = URLMapper.findURL((FileObject)fileObject, (int)2);
            if (uRL2 == null) {
                return uRL;
            }
            try {
                String string2;
                String string3 = uRL.getQuery();
                if (string3 != null) {
                    uRL2 = new URL(uRL2, "?" + string3);
                }
                if ((string2 = uRL.getRef()) != null) {
                    uRL2 = new URL(uRL2, "#" + string2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                return uRL;
            }
            return uRL2;
        }
    }

    private static class NbBrowser {
        private HtmlBrowserComponent brComp;
        private HtmlBrowserComponent externalBrowser;
        private PreferenceChangeListener idePCL;
        private static Lookup.Result factoryResult = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);

        public NbBrowser() {
            this.setListener();
        }

        private void showUrl(URL uRL) {
            if (null == this.brComp) {
                this.brComp = this.createDefaultBrowser();
            }
            this.brComp.setURLAndOpen(uRL);
        }

        private void showUrlExternal(URL uRL) {
            if (null == this.externalBrowser) {
                this.externalBrowser = this.createExternalBrowser();
            }
            this.externalBrowser.setURLAndOpen(uRL);
        }

        private HtmlBrowserComponent createDefaultBrowser() {
            HtmlBrowser.Factory factory = IDESettings.getWWWBrowser();
            if (factory == null) {
                factory = new SwingBrowser();
            }
            HtmlBrowserComponent htmlBrowserComponent = new HtmlBrowserComponent(factory, true, true);
            htmlBrowserComponent.putClientProperty("TabPolicy", "HideWhenAlone");
            return htmlBrowserComponent;
        }

        private HtmlBrowserComponent createExternalBrowser() {
            Object object = IDESettings.getExternalWWWBrowser();
            if (object == null) {
                Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                object = desktop != null && desktop.isSupported(Desktop.Action.BROWSE) ? new DesktopBrowser(desktop) : new SwingBrowser();
            }
            return new HtmlBrowserComponent((HtmlBrowser.Factory)object, true, true);
        }

        private void setListener() {
            if (this.idePCL != null) {
                return;
            }
            try {
                this.idePCL = new PreferenceChangeListener(){

                    @Override
                    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                        if ("WWWBrowser".equals(preferenceChangeEvent.getKey())) {
                            ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                            if (NbBrowser.this.idePCL != null) {
                                IDESettings.getPreferences().removePreferenceChangeListener(NbBrowser.this.idePCL);
                                NbBrowser.this.idePCL = null;
                                NbBrowser.this.brComp = null;
                                NbBrowser.this.externalBrowser = null;
                            }
                        }
                    }
                };
                IDESettings.getPreferences().addPreferenceChangeListener(this.idePCL);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        static {
            factoryResult.allItems();
            factoryResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                }
            });
        }
    }
}

