/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls;

import info.monitorenter.util.MathUtil;
import info.monitorenter.util.Range;
import infovis.panel.DoubleBoundedRangeModel;
import infovis.panel.dqinter.DoubleRangeSlider;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RangeChooserPanel
extends JPanel {
    protected NumberFormat m_nf = NumberFormat.getNumberInstance(Locale.getDefault());
    protected DoubleRangeSlider m_slider;

    public RangeChooserPanel(Range range) {
        this.m_nf.setMinimumFractionDigits(2);
        this.m_nf.setMaximumFractionDigits(2);
        double min = range.getMin();
        double max = range.getMax();
        double minBound = min;
        double maxBound = max;
        if (minBound == Double.NEGATIVE_INFINITY || Double.isNaN(minBound) || minBound == Double.POSITIVE_INFINITY || minBound == -1.7976931348623157E308) {
            min = -100.0;
        }
        minBound = min - (max - min) / 2.0;
        if (MathUtil.isDouble(maxBound)) {
            max = 100.0;
        }
        maxBound = max + (max - min) / 2.0;
        this.m_slider = new DoubleRangeSlider(minBound, maxBound, min, max);
        this.setLayout(new BoxLayout(this, 1));
        this.m_slider.setMaximumSize(new Dimension(300, 40));
        this.m_slider.setEnabled(true);
        this.add(Box.createVerticalStrut(10));
        this.add(this.m_slider);
        final JTextField rangeMinView = new JTextField();
        rangeMinView.setText(this.m_nf.format(new Double(this.m_slider.getLowValue())));
        DoubleBoundedRangeModel rangeModel = this.m_slider.getModel();
        rangeMinView.setEditable(true);
        rangeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                rangeMinView.setText(RangeChooserPanel.this.m_nf.format(new Double(RangeChooserPanel.this.m_slider.getLowValue())));
            }
        });
        rangeMinView.setPreferredSize(new Dimension(120, 20));
        rangeMinView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JTextField textField = (JTextField)ae.getSource();
                try {
                    Number entered = RangeChooserPanel.this.m_nf.parse(textField.getText());
                    double low = entered.doubleValue();
                    double high = RangeChooserPanel.this.m_slider.getHighValue();
                    double minSlider = low - (high - low) / 2.0;
                    RangeChooserPanel.this.m_slider.setMinimum(minSlider);
                    RangeChooserPanel.this.m_slider.setLowValue(low);
                }
                catch (ParseException e) {
                    textField.setText(RangeChooserPanel.this.m_nf.format(RangeChooserPanel.this.m_slider.getLowValue()));
                }
            }
        });
        rangeMinView.setToolTipText("Enter a number and hit Return.");
        final JTextField rangeMaxView = new JTextField();
        rangeMaxView.setText(new Double(this.m_slider.getHighValue()).toString());
        rangeMaxView.setEditable(true);
        rangeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                rangeMaxView.setText(RangeChooserPanel.this.m_nf.format(new Double(RangeChooserPanel.this.m_slider.getHighValue())));
            }
        });
        rangeMaxView.setPreferredSize(new Dimension(120, 20));
        rangeMaxView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JTextField textField = (JTextField)ae.getSource();
                try {
                    Number entered = RangeChooserPanel.this.m_nf.parse(textField.getText());
                    double low = RangeChooserPanel.this.m_slider.getLowValue();
                    double high = entered.doubleValue();
                    double maxSlider = high + (high - low) / 2.0;
                    RangeChooserPanel.this.m_slider.setMaximum(maxSlider);
                    RangeChooserPanel.this.m_slider.setHighValue(high);
                }
                catch (ParseException e) {
                    textField.setText(RangeChooserPanel.this.m_nf.format(RangeChooserPanel.this.m_slider.getHighValue()));
                }
            }
        });
        rangeMaxView.setToolTipText("Enter a number and hit Return.");
        JPanel rangeViewPanel = new JPanel();
        rangeViewPanel.setMaximumSize(new Dimension(300, 30));
        rangeViewPanel.setLayout(new BoxLayout(rangeViewPanel, 0));
        rangeViewPanel.add(Box.createHorizontalGlue());
        rangeViewPanel.add(rangeMinView);
        rangeViewPanel.add(Box.createHorizontalStrut(10));
        rangeViewPanel.add(rangeMaxView);
        rangeViewPanel.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(10));
        this.add(rangeViewPanel);
        this.add(Box.createVerticalGlue());
    }

    public Range getRange() {
        return new Range(this.m_slider.getLowValue(), this.m_slider.getHighValue());
    }
}

