/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.util.GeoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TileFactory {
    private TileFactoryInfo info;

    protected TileFactory(TileFactoryInfo info) {
        this.info = info;
    }

    public int getTileSize(int zoom) {
        int tilezoom = this.getTileZoom(zoom);
        return this.getInfo().getTileSize(tilezoom) << tilezoom - zoom;
    }

    public Dimension getMapSize(int zoom) {
        zoom = this.getTileZoom(zoom);
        return GeoUtil.getMapSize(zoom, this.getInfo());
    }

    public abstract Tile getTile(String var1, String var2);

    public String getTileKey(int x, int y, int zoom) {
        zoom = this.getTileZoom(zoom);
        return Tile.getKey(this.info.getName(), x, y, zoom, this.info.getTileUrl(x, y, zoom), this.info.getTileBaseKey(x, y, zoom));
    }

    public Tile getTileInstance(int x, int y, int zoom) {
        zoom = this.getTileZoom(zoom);
        return new Tile(this.info.getName(), x, y, zoom, this.info.getTileUrl(x, y, zoom), this.info.getTileBaseKey(x, y, zoom));
    }

    protected int getTileZoom(int zoom) {
        int minzoom = this.getInfo().getMinimumZoomLevel();
        int extrazoom = minzoom - zoom;
        int tilezoom = zoom;
        if (extrazoom <= 0) {
            extrazoom = 0;
        } else {
            tilezoom = zoom + extrazoom;
        }
        return tilezoom;
    }

    public GeoPosition pixelToGeo(Point2D pixelCoordinate, int zoom) {
        int tilezoom = this.getTileZoom(zoom);
        int scale = 1 << tilezoom - zoom;
        Point2D p = (Point2D)pixelCoordinate.clone();
        if (scale != 1) {
            p.setLocation(p.getX() / (double)scale, p.getY() / (double)scale);
        }
        return this.getInfo().getPosition(p, tilezoom);
    }

    public Point2D geoToPixel(GeoPosition c, int zoom) {
        int tilezoom = this.getTileZoom(zoom);
        int scale = 1 << tilezoom - zoom;
        Point2D p = GeoUtil.getBitmapCoordinate(c, tilezoom, this.getInfo());
        if (scale != 1) {
            p.setLocation(p.getX() * (double)scale, p.getY() * (double)scale);
        }
        return p;
    }

    public TileFactoryInfo getInfo() {
        return this.info;
    }

    public abstract void setRequiredTiles(Collection<Tile> var1, String var2);

    public void removeRequiredTiles(String mapName) {
    }
}

