/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import accessories.plugins.ClonePlugin;
import freemind.common.OptionalDontShowMeAgainDialog;
import freemind.controller.MenuItemEnabledListener;
import freemind.controller.MindMapNodesSelection;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.CutNodeAction;
import freemind.controller.actions.generated.instance.DeleteNodeAction;
import freemind.controller.actions.generated.instance.HookNodeAction;
import freemind.controller.actions.generated.instance.MoveNodeXmlAction;
import freemind.controller.actions.generated.instance.MoveNodesAction;
import freemind.controller.actions.generated.instance.NewNodeAction;
import freemind.controller.actions.generated.instance.NodeAction;
import freemind.controller.actions.generated.instance.NodeListMember;
import freemind.controller.actions.generated.instance.PasteNodeAction;
import freemind.controller.actions.generated.instance.UndoPasteNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookRegistration;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeHookAction;
import freemind.modes.mindmapmode.actions.xml.ActionFilter;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.hooks.MindMapNodeHookAdapter;
import freemind.view.mindmapview.NodeView;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public class ClonePasteAction
extends MindMapNodeHookAdapter {
    @Override
    public void invoke(MindMapNode pNode) {
        super.invoke(pNode);
        Vector mindMapNodes = this.getMindMapNodes();
        this.logger.fine("Clones for nodes: " + Tools.listToString(mindMapNodes));
        for (MindMapNode copiedNode : mindMapNodes) {
            ClonePlugin clonePlugin = ClonePlugin.getHook(copiedNode);
            if (clonePlugin == null) {
                int showResult = new OptionalDontShowMeAgainDialog(this.getMindMapController().getFrame().getJFrame(), this.getMindMapController().getSelectedView(), "choose_clone_type", "clone_type_question", this.getMindMapController(), new OptionalDontShowMeAgainDialog.StandardPropertyHandler(this.getMindMapController().getController(), "complete_cloning"), 1).show().getResult();
                Properties properties = new Properties();
                properties.setProperty("CLONE_ITSELF", showResult == 0 ? "true" : "false");
                Vector selecteds = Tools.getVectorWithSingleElement(copiedNode);
                this.getMindMapController().addHook(copiedNode, selecteds, "accessories/plugins/ClonePlugin.properties", properties);
            }
            Transferable copy = this.getMindMapController().copy(copiedNode, true);
            this.addNewClone(copiedNode, pNode, copy);
        }
    }

    public void addNewClone(MindMapNode originalNode, MindMapNode pDestinationNode, Transferable copy) {
        String originalNodeId = this.getMindMapController().getNodeID(originalNode);
        this.logger.fine("Original node " + originalNode + ", id " + originalNodeId);
        if (originalNode.isRoot()) {
            this.getMindMapController().getController().errorMessage(this.getMindMapController().getText("clone_plugin_no_root_cloning"));
            return;
        }
        List listOfChilds = pDestinationNode.getChildren();
        Vector<String> listOfChildIds = new Vector<String>();
        Iterator it = listOfChilds.iterator();
        while (it.hasNext()) {
            String nodeID = this.getMindMapController().getNodeID((MindMapNode)it.next());
            listOfChildIds.add(nodeID);
            this.logger.fine("Old child id:" + nodeID);
        }
        this.getMindMapController().paste(copy, pDestinationNode);
    }

    public Vector getMindMapNodes() {
        return this.getRegistration().getMindMapNodes();
    }

    protected Registration getRegistration() {
        return (Registration)this.getPluginBaseClass();
    }

    public static class Registration
    implements HookRegistration,
    MenuItemEnabledListener,
    ActionFilter,
    ModeController.NodeSelectionListener {
        private static final String PLUGIN_NAME = "accessories/plugins/ClonePasteAction.properties";
        private static ImageIcon sCloneIcon;
        private static ImageIcon sOriginalIcon;
        private static boolean sShowIcon;
        private HashMap mCloneIdsMap = new HashMap();
        private HashMap mClonesMap = new HashMap();
        private HashMap mClonePropertiesMap = new HashMap();
        private final MindMapController controller;
        private final MindMap mMap;
        private final Logger logger;
        private Vector mLastMarkedNodeViews = new Vector();

        public Registration(ModeController controller, MindMap map) {
            this.controller = (MindMapController)controller;
            this.mMap = map;
            this.logger = controller.getFrame().getLogger(this.getClass().getName());
        }

        @Override
        public void register() {
            if (sCloneIcon == null) {
                sCloneIcon = new ImageIcon(this.controller.getResource("images/clone.png"));
                sOriginalIcon = new ImageIcon(this.controller.getResource("images/clone_original.png"));
                sShowIcon = Resources.getInstance().getBoolProperty("resources_don_t_show_clone_icons");
            }
            this.controller.getActionFactory().registerFilter(this);
            this.controller.registerNodeSelectionListener(this, false);
        }

        @Override
        public void deRegister() {
            this.controller.deregisterNodeSelectionListener(this);
            this.controller.getActionFactory().deregisterFilter(this);
        }

        @Override
        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            if (this.controller == null) {
                return false;
            }
            String hookName = ((NodeHookAction)pAction).getHookName();
            if (PLUGIN_NAME.equals(hookName)) {
                Vector mindMapNodes = this.getMindMapNodes();
                return !mindMapNodes.isEmpty();
            }
            List selecteds = this.controller.getSelecteds();
            for (MindMapNode node : selecteds) {
                if (ClonePlugin.getHook(node) == null) continue;
                return true;
            }
            return false;
        }

        public Vector getMindMapNodes() {
            Vector<NodeAdapter> mindMapNodes = new Vector<NodeAdapter>();
            Transferable clipboardContents = this.controller.getClipboardContents();
            if (clipboardContents != null) {
                try {
                    List transferData = (List)clipboardContents.getTransferData(MindMapNodesSelection.copyNodeIdsFlavor);
                    for (String nodeId : transferData) {
                        NodeAdapter node = this.controller.getNodeFromID(nodeId);
                        mindMapNodes.add(node);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return mindMapNodes;
        }

        public String generateNewCloneId(String pProposedID) {
            return Tools.generateID(pProposedID, this.mCloneIdsMap, "CLONE_");
        }

        public boolean registerClone(String pCloneId, ClonePlugin pPlugin) {
            boolean vectorPresent = this.mCloneIdsMap.containsKey(pCloneId);
            HashSet v = this.getHashSetToCloneId(pCloneId);
            MindMapNode node = pPlugin.getNode();
            Iterator it = v.iterator();
            while (it.hasNext()) {
                MindMapNode otherCloneNode = (MindMapNode)it.next();
                ClonePlugin otherClone = ClonePlugin.getHook(otherCloneNode);
                if (otherClone == null) {
                    it.remove();
                    this.logger.warning("Found clone node " + this.controller.getNodeID(otherCloneNode) + " which isn't a clone any more.");
                    continue;
                }
                otherClone.addClone(node);
                pPlugin.addClone(otherCloneNode);
            }
            v.add(node);
            this.mClonesMap.put(node, pCloneId);
            this.selectShadowNode(node, true, node);
            if (!this.mClonePropertiesMap.containsKey(pCloneId)) {
                this.mClonePropertiesMap.put(pCloneId, new CloneProperties());
            }
            return !vectorPresent;
        }

        public void deregisterClone(String pCloneId, ClonePlugin pPlugin) {
            HashSet cloneSet = this.getHashSetToCloneId(pCloneId);
            MindMapNode node = pPlugin.getNode();
            cloneSet.remove(node);
            this.mClonesMap.remove(node);
            Iterator it = cloneSet.iterator();
            while (it.hasNext()) {
                MindMapNode otherCloneNode = (MindMapNode)it.next();
                ClonePlugin otherClone = ClonePlugin.getHook(otherCloneNode);
                if (otherClone == null) {
                    it.remove();
                    this.logger.warning("Found clone node " + this.controller.getNodeID(otherCloneNode) + " which isn't a clone any more.");
                    continue;
                }
                otherClone.removeClone(node);
            }
            if (cloneSet.isEmpty()) {
                this.mCloneIdsMap.remove(cloneSet);
                this.mClonePropertiesMap.remove(pCloneId);
            }
        }

        public CloneProperties getCloneProperties(String pCloneId) {
            if (this.mClonePropertiesMap.containsKey(pCloneId)) {
                return (CloneProperties)this.mClonePropertiesMap.get(pCloneId);
            }
            throw new IllegalArgumentException("Clone properties not found for " + pCloneId);
        }

        protected HashSet getHashSetToCloneId(String pCloneId) {
            HashSet v = null;
            if (!this.mCloneIdsMap.containsKey(pCloneId)) {
                v = new HashSet();
                this.mCloneIdsMap.put(pCloneId, v);
            } else {
                v = (HashSet)this.mCloneIdsMap.get(pCloneId);
            }
            return v;
        }

        @Override
        public ActionPair filterAction(ActionPair pair) {
            if (this.mCloneIdsMap.isEmpty()) {
                return pair;
            }
            XmlAction doAction = pair.getDoAction();
            doAction = this.cloneAction(doAction);
            pair.setDoAction(doAction);
            return pair;
        }

        private XmlAction cloneAction(XmlAction doAction) {
            this.logger.fine("Found do action: " + doAction.getClass().getName());
            if (doAction instanceof NodeAction) {
                NodeAction nodeAction = (NodeAction)doAction;
                NodeAdapter node = this.controller.getNodeFromID(nodeAction.getNode());
                doAction = this.cloneAction(nodeAction, node);
            } else if (doAction instanceof CompoundAction) {
                CompoundAction compoundAction = (CompoundAction)doAction;
                List choiceList = compoundAction.getListChoiceList();
                int index = 0;
                for (XmlAction subAction : choiceList) {
                    subAction = this.cloneAction(subAction);
                    compoundAction.setAtChoice(index, (Object)subAction);
                    ++index;
                }
            }
            return doAction;
        }

        private XmlAction cloneAction(NodeAction nodeAction, MindMapNode node) {
            List correspondingNodes = this.getCorrespondingNodes(nodeAction, node);
            if (correspondingNodes.isEmpty()) {
                return nodeAction;
            }
            CompoundAction compound = new CompoundAction();
            compound.addChoice((Object)nodeAction);
            for (Tools.MindMapNodePair pair : correspondingNodes) {
                this.getNewCompoundAction(nodeAction, pair, compound);
            }
            return compound;
        }

        private void getNewCompoundAction(NodeAction nodeAction, Tools.MindMapNodePair correspondingNodePair, CompoundAction compound) {
            NodeListMember member;
            int i;
            NodeAction copiedNodeAction = (NodeAction)Tools.deepCopy((XmlAction)nodeAction);
            if (copiedNodeAction instanceof MoveNodesAction) {
                MoveNodesAction moveAction = (MoveNodesAction)copiedNodeAction;
                for (i = 0; i < moveAction.getListNodeListMemberList().size(); ++i) {
                    member = moveAction.getNodeListMember(i);
                    this.changeNodeListMember(correspondingNodePair, (NodeAction)moveAction, member);
                }
            }
            if (copiedNodeAction instanceof HookNodeAction) {
                HookNodeAction hookAction = (HookNodeAction)copiedNodeAction;
                for (i = 0; i < hookAction.getListNodeListMemberList().size(); ++i) {
                    member = hookAction.getNodeListMember(i);
                    this.changeNodeListMember(correspondingNodePair, (NodeAction)hookAction, member);
                }
            }
            if (copiedNodeAction instanceof NewNodeAction) {
                NewNodeAction newNodeAction = (NewNodeAction)copiedNodeAction;
                String newId = this.mMap.getLinkRegistry().generateUniqueID(null);
                newNodeAction.setNewId(newId);
            }
            copiedNodeAction.setNode(this.controller.getNodeID(correspondingNodePair.getCorresponding()));
            if (copiedNodeAction instanceof PasteNodeAction) {
                compound.addChoice((Object)copiedNodeAction);
            } else {
                compound.addAtChoice(0, (Object)copiedNodeAction);
            }
        }

        public void changeNodeListMember(Tools.MindMapNodePair correspondingNodePair, NodeAction pAction, NodeListMember member) {
            NodeAdapter memberNode = this.controller.getNodeFromID(member.getNode());
            List correspondingMoveNodes = this.getCorrespondingNodes(pAction, memberNode);
            if (!correspondingMoveNodes.isEmpty()) {
                for (Tools.MindMapNodePair pair : correspondingMoveNodes) {
                    if (pair.getCloneNode() != correspondingNodePair.getCloneNode()) continue;
                    member.setNode(this.controller.getNodeID(pair.getCorresponding()));
                    break;
                }
            }
        }

        public List getCorrespondingNodes(NodeAction nodeAction, MindMapNode node) {
            boolean startWithParent = false;
            if (this.mClonesMap.containsKey(node)) {
                String cloneId = (String)this.mClonesMap.get(node);
                if (this.getCloneProperties(cloneId).isCloneItself()) {
                    UndoPasteNodeAction pna;
                    if (nodeAction instanceof MoveNodesAction || nodeAction instanceof MoveNodeXmlAction || nodeAction instanceof DeleteNodeAction || nodeAction instanceof CutNodeAction) {
                        startWithParent = true;
                    } else if (nodeAction instanceof PasteNodeAction) {
                        PasteNodeAction pna2 = (PasteNodeAction)nodeAction;
                        if (pna2.getAsSibling()) {
                            startWithParent = true;
                        }
                    } else if (nodeAction instanceof UndoPasteNodeAction && (pna = (UndoPasteNodeAction)nodeAction).getAsSibling()) {
                        startWithParent = true;
                    }
                } else if (!(nodeAction instanceof NewNodeAction)) {
                    if (nodeAction instanceof PasteNodeAction) {
                        PasteNodeAction pna = (PasteNodeAction)nodeAction;
                        if (pna.getAsSibling()) {
                            startWithParent = true;
                        }
                    } else if (nodeAction instanceof UndoPasteNodeAction) {
                        UndoPasteNodeAction pna = (UndoPasteNodeAction)nodeAction;
                        if (pna.getAsSibling()) {
                            startWithParent = true;
                        }
                    } else {
                        startWithParent = true;
                    }
                }
            }
            List correspondingNodes = this.getCorrespondingNodes(node, startWithParent);
            return correspondingNodes;
        }

        public List getCorrespondingNodes(MindMapNode pNode, boolean pStartWithParent) {
            if (this.mClonesMap.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            MindMapNode child = pStartWithParent ? pNode.getParentNode() : pNode;
            while (!this.mClonesMap.containsKey(child)) {
                if (child.isRoot()) {
                    return Collections.EMPTY_LIST;
                }
                child = child.getParentNode();
            }
            MindMapNode clone = child;
            Vector indexVector = new Vector();
            if (pStartWithParent) {
                this.addNodePosition(indexVector, pNode);
                child = pNode.getParentNode();
            } else {
                child = pNode;
            }
            while (clone != child) {
                this.addNodePosition(indexVector, child);
                child = child.getParentNode();
            }
            Vector<Tools.MindMapNodePair> returnValue = new Vector<Tools.MindMapNodePair>();
            MindMapNode originalNode = child;
            HashSet targets = (HashSet)this.mCloneIdsMap.get(this.mClonesMap.get(child));
            Iterator itClone = targets.iterator();
            block2: while (itClone.hasNext()) {
                MindMapNode cloneNode;
                MindMapNode target = cloneNode = (MindMapNode)itClone.next();
                if (cloneNode == originalNode) continue;
                for (int i = indexVector.size() - 1; i >= 0; --i) {
                    int index = (Integer)indexVector.get(i);
                    if (target.getChildCount() <= index) {
                        this.logger.warning("Index " + index + " in other tree not found from " + this.printNodeIds(targets) + " originating from " + this.printNodeId(cloneNode) + " start at parent " + pStartWithParent);
                        continue block2;
                    }
                    target = (MindMapNode)target.getChildAt(index);
                }
                returnValue.add(new Tools.MindMapNodePair(target, cloneNode));
            }
            return returnValue;
        }

        private void addNodePosition(Vector indexVector, MindMapNode child) {
            indexVector.add(new Integer(child.getParentNode().getChildPosition(child)));
        }

        private String printNodeId(MindMapNode pCloneNode) {
            try {
                return this.controller.getNodeID(pCloneNode) + ": '" + pCloneNode.getShortText(this.controller) + "'";
            }
            catch (Exception e) {
                return "NOT FOUND: '" + pCloneNode + "'";
            }
        }

        private String printNodeIds(HashSet pClones) {
            Vector<String> strings = new Vector<String>();
            for (MindMapNode pluginNode : pClones) {
                strings.add(this.printNodeId(pluginNode));
            }
            return Tools.listToString(strings);
        }

        @Override
        public void onFocusNode(NodeView node) {
            this.markShadowNode(node, true);
        }

        @Override
        public void onLostFocusNode(NodeView node) {
            this.markShadowNode(node, false);
        }

        public void markShadowNode(NodeView pNode, boolean pEnableShadow) {
            if (pNode == null || pNode.getModel() == null) {
                return;
            }
            if (!pEnableShadow) {
                if (!this.mLastMarkedNodeViews.isEmpty()) {
                    for (MindMapNode node : this.mLastMarkedNodeViews) {
                        if (this.mClonesMap.containsKey(node)) {
                            this.setIcon(node, sOriginalIcon);
                            continue;
                        }
                        this.setIcon(node, null);
                    }
                    this.mLastMarkedNodeViews.clear();
                }
            } else {
                this.markShadowNode(pNode.getModel(), pEnableShadow);
            }
        }

        public void markShadowNode(MindMapNode model, boolean pEnableShadow) {
            this.mLastMarkedNodeViews.clear();
            try {
                List shadowNodes = this.getCorrespondingNodes(model, false);
                for (Tools.MindMapNodePair shadowNode : shadowNodes) {
                    MindMapNode correspondingNode = shadowNode.getCorresponding();
                    this.mLastMarkedNodeViews.add(correspondingNode);
                    this.selectShadowNode(correspondingNode, pEnableShadow, shadowNode.getCloneNode());
                }
            }
            catch (IllegalArgumentException e) {
                Resources.getInstance().logException(e);
            }
        }

        private void selectShadowNode(MindMapNode node, boolean pEnableShadow, MindMapNode pCloneNode) {
            block3: {
                ImageIcon i;
                if (!sShowIcon) {
                    return;
                }
                if (node == null) break block3;
                ImageIcon imageIcon = i = pEnableShadow ? sCloneIcon : null;
                if (node == pCloneNode) {
                    i = sOriginalIcon;
                }
                this.setIcon(node, i);
                if (node != pCloneNode) {
                    node = node.getParentNode();
                }
            }
        }

        public void setIcon(MindMapNode node, ImageIcon i) {
            node.setStateIcon("accessories/plugins/ClonePlugin.properties", i);
            this.controller.nodeRefresh(node);
        }

        @Override
        public void onSelectionChange(NodeView pNode, boolean pIsSelected) {
        }

        @Override
        public void onUpdateNodeHook(MindMapNode pNode) {
        }

        @Override
        public void onSaveNode(MindMapNode pNode) {
        }

        static {
            sShowIcon = true;
        }
    }

    public static class CloneProperties {
        boolean mCloneItself = false;
        private HashSet mObserverSet = new HashSet();
        protected static Logger logger = null;

        public CloneProperties() {
            if (logger == null) {
                logger = Resources.getInstance().getLogger(this.getClass().getName());
            }
        }

        public boolean isCloneItself() {
            return this.mCloneItself;
        }

        public void setCloneItself(boolean pCloneItself) {
            logger.finest("Setting mCloneItself to " + pCloneItself);
            boolean fire = false;
            if (pCloneItself != this.mCloneItself) {
                fire = true;
            }
            this.mCloneItself = pCloneItself;
            if (fire) {
                this.firePropertiesChanged();
            }
        }

        public void registerObserver(ClonePropertiesObserver pObserver) {
            this.mObserverSet.add(pObserver);
        }

        public void deregisterObserver(ClonePropertiesObserver pObserver) {
            this.mObserverSet.remove(pObserver);
        }

        private void firePropertiesChanged() {
            for (ClonePropertiesObserver observer : this.mObserverSet) {
                observer.propertiesChanged(this);
            }
        }
    }

    public static interface ClonePropertiesObserver {
        public void propertiesChanged(CloneProperties var1);
    }
}

