/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.process;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.TimeRepresentation;
import org.joda.time.DateTimeZone;

public class SpreadsheetGeneralConfiguration {
    protected final Map<String, Class> columnsClasses = new LinkedHashMap<String, Class>();
    protected Mode mode = Mode.NODES_TABLE;
    protected TimeRepresentation timeRepresentation = TimeRepresentation.INTERVAL;
    protected DateTimeZone timeZone = DateTimeZone.UTC;

    public Mode getMode() {
        return this.mode;
    }

    public void setTable(Mode table) {
        this.mode = table;
    }

    public TimeRepresentation getTimeRepresentation() {
        return this.timeRepresentation;
    }

    public void setTimeRepresentation(TimeRepresentation timeRepresentation) {
        this.timeRepresentation = timeRepresentation;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Map<String, Class> getColumnsClasses() {
        return new LinkedHashMap<String, Class>(this.columnsClasses);
    }

    public void setColumnsClasses(Map<String, Class> columnsClasses) {
        this.columnsClasses.clear();
        if (columnsClasses != null) {
            for (String column : columnsClasses.keySet()) {
                this.setColumnClass(column, columnsClasses.get(column));
            }
        }
    }

    public Class getColumnClass(String column) {
        return this.columnsClasses.get(column);
    }

    public void setColumnClass(String column, Class clazz) {
        this.columnsClasses.put(column.trim(), clazz);
    }

    public static enum Mode {
        NODES_TABLE(Arrays.asList("id", "label")),
        EDGES_TABLE(Arrays.asList("id", "kind", "label", "source", "target", "type")),
        ADJACENCY_LIST,
        MATRIX;

        private final Set<String> specialColumnNames;

        private Mode() {
            this.specialColumnNames = Collections.emptySet();
        }

        private Mode(List<String> specialColumnNames) {
            this.specialColumnNames = Collections.unmodifiableSet(new HashSet<String>(specialColumnNames));
        }

        public Set<String> getSpecialColumnNames() {
            return this.specialColumnNames;
        }

        public boolean isSpecialColumn(String column) {
            return this.specialColumnNames.contains(column.trim().toLowerCase());
        }
    }
}

