/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.forcefield.AtomType;
import org.jmol.minimize.forcefield.CalculationsMMFF;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolAsyncException;

public class ForceFieldMMFF
extends ForceField {
    private static final int A4_VDW = 122;
    private static final int A4_BNDK = 123;
    private static final int A4_CHRG = 124;
    private static final int A4_SB = 125;
    private static final int A4_SBDEF = 126;
    private static final int KEY_SBDEF = 0;
    private static final int KEY_PBCI = 0;
    private static final int KEY_VDW = 0;
    private static final int KEY_BNDK = 0;
    private static final int KEY_OOP = 6;
    private static final int TYPE_PBCI = 1;
    private static final int TYPE_VDW = 17;
    private static final int TYPE_BNDK = 546;
    private static final int TYPE_CHRG = 34;
    private static final int TYPE_BOND = 3;
    private static final int TYPE_ANGLE = 5;
    private static final int TYPE_SB = 21;
    private static final int TYPE_SBDEF = 37;
    private static final int TYPE_TORSION = 9;
    private static final int TYPE_OOP = 13;
    private static Lst<AtomType> atomTypes;
    private static Map<Object, Object> ffParams;
    private int[] rawAtomTypes;
    private int[] rawBondTypes;
    private float[] rawMMFF94Charges;
    private Lst<BS>[] vRings;
    private static final String names = "END.BCI.CHG.ANG.NDK.OND.OOP.TBN.FSB.TOR.VDW.";
    private static final int[] types;
    private String line;
    private static final int[] sbMap;
    private int[] typeData = new int[4];
    private static final int[] equivalentTypes;

    public String[] getAtomTypeDescriptions() {
        return ForceFieldMMFF.getAtomTypeDescs(this.rawAtomTypes);
    }

    public float[] getPartialCharges() {
        return this.rawMMFF94Charges;
    }

    public ForceFieldMMFF(Minimizer m) throws JmolAsyncException {
        this.minimizer = m;
        this.name = "MMFF";
        this.getParameters();
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean setModel(BS bsElements, int elemnoMax) {
        Minimizer m = this.minimizer;
        if (!this.setArrays(m.atoms, m.bsAtoms, m.bonds, m.rawBondCount, false, false)) {
            return false;
        }
        this.setModelFields();
        if (!this.fixTypes()) {
            return false;
        }
        this.calc = new CalculationsMMFF(this, ffParams, this.minAtoms, this.minBonds, this.minAngles, this.minTorsions, this.minPositions, this.minimizer.constraints);
        this.calc.setLoggingEnabled(true);
        return this.calc.setupCalculations();
    }

    public boolean setArrays(Atom[] atoms, BS bsAtoms, Bond[] bonds, int rawBondCount, boolean doRound, boolean allowUnknowns) {
        Minimizer m = this.minimizer;
        this.vRings = AU.createArrayOfArrayList(4);
        this.rawAtomTypes = ForceFieldMMFF.setAtomTypes(atoms, bsAtoms, m.vwr.getSmilesMatcher(), this.vRings, allowUnknowns);
        if (this.rawAtomTypes == null) {
            return false;
        }
        this.rawBondTypes = this.setBondTypes(bonds, rawBondCount, bsAtoms);
        this.rawMMFF94Charges = ForceFieldMMFF.calculatePartialCharges(bonds, this.rawBondTypes, atoms, this.rawAtomTypes, bsAtoms, doRound);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getParameters() throws JmolAsyncException {
        if (ffParams != null) {
            return;
        }
        this.getAtomTypes();
        Hashtable<Object, Object> data = new Hashtable<Object, Object>();
        String resourceName = "mmff94.par.txt";
        if (Logger.debugging) {
            Logger.debug("reading data from " + resourceName);
        }
        BufferedReader br = null;
        String line = null;
        try {
            br = this.getBufferedReader(resourceName);
            int pt = 0;
            int dataType = 0;
            while (true) {
                if ((pt = (line = br.readLine()).indexOf(".PAR")) < 0) {
                    continue;
                }
                dataType = types[names.indexOf(line.substring(pt - 3, pt + 1)) / 4];
                if (dataType < 1) break;
                this.readParams(br, dataType, data);
            }
            br.close();
        }
        catch (JmolAsyncException e) {
            throw new JmolAsyncException(e.getFileName());
        }
        catch (Exception e) {
            System.err.println("Exception " + e.toString() + " in getResource " + resourceName + " line=" + line);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception e) {}
        }
        ffParams = data;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readParams(BufferedReader br, int dataType, Map<Object, Object> data) throws Exception {
        Object value = null;
        int a1 = 0;
        int a2 = 127;
        int a3 = 127;
        int a4 = 127;
        int type = 0;
        switch (dataType) {
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 34: {
                a4 = 124;
                break;
            }
            case 21: {
                a4 = 125;
                break;
            }
            case 546: {
                a4 = 123;
                type = 0;
                break;
            }
            case 13: {
                type = 6;
                break;
            }
            case 1: {
                type = 0;
                break;
            }
            case 37: {
                a4 = 126;
                type = 0;
                break;
            }
            case 17: {
                a4 = 122;
                type = 0;
                break;
            }
        }
        while (!br.readLine().startsWith("*")) {
        }
        while ((this.line = br.readLine()).startsWith("*")) {
        }
        block35: do {
            switch (dataType) {
                case 1: 
                case 13: 
                case 37: 
                case 546: {
                    break;
                }
                case 17: {
                    if (this.line.charAt(5) == ' ') break;
                    continue block35;
                }
                case 34: {
                    if (this.line.charAt(0) == '4') continue block35;
                }
                case 3: 
                case 5: 
                case 9: 
                case 21: {
                    type = this.line.charAt(0) - 48;
                }
            }
            switch (dataType) {
                case 9: 
                case 13: {
                    a4 = this.ival(18, 20);
                }
                case 5: 
                case 21: 
                case 37: {
                    a3 = this.ival(13, 15);
                }
                case 3: 
                case 34: 
                case 546: {
                    a2 = this.ival(8, 10);
                }
                case 1: 
                case 17: {
                    a1 = this.ival(3, 5);
                    break;
                }
            }
            switch (dataType) {
                case 546: {
                    value = new double[]{this.dval(19, 25), this.dval(13, 18)};
                    break;
                }
                case 3: {
                    value = new double[]{this.dval(14, 20), this.dval(25, 31)};
                    break;
                }
                case 5: 
                case 21: {
                    value = new double[]{this.dval(19, 25), this.dval(28, 35)};
                    break;
                }
                case 34: {
                    value = Float.valueOf(this.fval(10, 20));
                    break;
                }
                case 13: {
                    value = new double[]{this.dval(24, 30)};
                    break;
                }
                case 1: {
                    value = Float.valueOf(this.fval(5, 15));
                    break;
                }
                case 37: {
                    double v1 = this.dval(19, 25);
                    double v2 = this.dval(28, 35);
                    value = new double[]{v1, v2};
                    Integer key = MinObject.getKey(type, a1, a2, a3, a4);
                    data.put(key, value);
                    value = new double[]{v2, v1};
                    int a = a1;
                    a1 = a3;
                    a3 = a;
                    break;
                }
                case 9: {
                    value = new double[]{this.dval(22, 28), this.dval(30, 36), this.dval(38, 44)};
                    break;
                }
                case 17: {
                    value = new double[]{this.dval(10, 15), this.dval(20, 25), this.dval(30, 35), this.dval(40, 45), this.line.charAt(46)};
                    break;
                }
            }
            Integer key = MinObject.getKey(type, a1, a2, a3, a4);
            data.put(key, value);
            if (!Logger.debugging) continue;
            Logger.debug(MinObject.decodeKey(key) + " " + (value instanceof Float ? value : Escape.eAD((double[])value)));
        } while (!(this.line = br.readLine()).startsWith("$"));
    }

    private int ival(int i, int j) {
        return PT.parseInt(this.line.substring(i, j).trim());
    }

    private float fval(int i, int j) {
        return PT.fVal(this.line.substring(i, j).trim());
    }

    private double dval(int i, int j) {
        return PT.dVal(this.line.substring(i, j).trim());
    }

    private void getAtomTypes() throws JmolAsyncException {
        String resourceName = "MMFF94-smarts.txt";
        Lst<AtomType> types = new Lst<AtomType>();
        try {
            BufferedReader br = this.getBufferedReader(resourceName);
            types.addLast(new AtomType(0, 0, 0, 0.0f, 1, "H or NOT FOUND", ""));
            while ((this.line = br.readLine()) != null) {
                if (this.line.length() == 0 || this.line.startsWith("#")) continue;
                int elemNo = this.ival(3, 5);
                int mmType = this.ival(6, 8);
                int hType = this.ival(9, 11);
                float formalCharge = this.fval(12, 15) / 12.0f;
                int val = this.ival(16, 18);
                String desc = this.line.substring(19, 44).trim();
                String smarts = this.line.substring(45).trim();
                AtomType at = new AtomType(elemNo, mmType, hType, formalCharge, val, desc, smarts);
                types.addLast(at);
                ForceFieldMMFF.setFlags(at);
            }
            br.close();
        }
        catch (JmolAsyncException e) {
            throw new JmolAsyncException(e.getFileName());
        }
        catch (Exception e) {
            System.err.println("Exception " + e.toString() + " in getResource " + resourceName + " line=" + this.line);
        }
        Logger.info(types.size() - 1 + " SMARTS-based atom types read");
        atomTypes = types;
    }

    private static void setFlags(AtomType at) {
        switch (at.mmType) {
            case 32: 
            case 35: 
            case 72: {
                at.fcadj = 0.5f;
                break;
            }
            case 62: 
            case 76: {
                at.fcadj = 0.25f;
            }
        }
        switch (at.mmType) {
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 78: 
            case 79: 
            case 81: 
            case 82: {
                at.arom = true;
            }
        }
        switch (at.mmType) {
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 30: 
            case 37: 
            case 39: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 75: 
            case 78: 
            case 80: 
            case 81: {
                at.sbmb = true;
            }
        }
        switch (at.mmType) {
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 32: 
            case 35: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 59: 
            case 62: 
            case 70: 
            case 72: 
            case 76: {
                at.pilp = true;
            }
        }
        switch (at.mmType) {
            case 10: 
            case 32: 
            case 35: 
            case 39: 
            case 41: 
            case 44: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 69: 
            case 72: 
            case 81: 
            case 82: {
                at.mltb = 1;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 30: 
            case 37: 
            case 38: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 53: 
            case 54: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: {
                at.mltb = 2;
                break;
            }
            case 4: 
            case 42: 
            case 60: 
            case 61: {
                at.mltb = 3;
            }
        }
    }

    public static float[] calculatePartialCharges(Bond[] bonds, int[] bTypes, Atom[] atoms, int[] aTypes, BS bsAtoms, boolean doRound) {
        float[] partialCharges = new float[atoms.length];
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            partialCharges[i] = ((AtomType)ForceFieldMMFF.atomTypes.get((int)Math.max((int)0, (int)aTypes[i]))).formalCharge;
            i = bsAtoms.nextSetBit(i + 1);
        }
        Atom a1 = null;
        int i2 = bTypes.length;
        while (--i2 >= 0) {
            float dq;
            a1 = bonds[i2].atom1;
            Atom a2 = bonds[i2].atom2;
            boolean ok1 = bsAtoms.get(a1.i);
            boolean ok2 = bsAtoms.get(a2.i);
            if (!ok1 && !ok2) continue;
            int it = aTypes[a1.i];
            AtomType at1 = (AtomType)atomTypes.get(Math.max(0, it));
            int type1 = it < 0 ? -it : at1.mmType;
            it = aTypes[a2.i];
            AtomType at2 = (AtomType)atomTypes.get(Math.max(0, it));
            int type2 = it < 0 ? -it : at2.mmType;
            try {
                float bci;
                String msg;
                int bondType = bTypes[i2];
                float bFactor = type1 < type2 ? -1 : 1;
                Integer key = MinObject.getKey(bondType, bFactor == 1.0f ? type2 : type1, bFactor == 1.0f ? type1 : type2, 127, 124);
                Float bciValue = (Float)ffParams.get(key);
                String string = msg = Logger.debugging ? a1 + "/" + a2 + " mmTypes=" + type1 + "/" + type2 + " formalCharges=" + at1.formalCharge + "/" + at2.formalCharge + " bci = " : null;
                if (bciValue == null) {
                    float pa = ((Float)ffParams.get(MinObject.getKey(0, type1, 127, 127, 127))).floatValue();
                    float pb = ((Float)ffParams.get(MinObject.getKey(0, type2, 127, 127, 127))).floatValue();
                    bci = pa - pb;
                    if (Logger.debugging) {
                        msg = msg + pa + " - " + pb + " = ";
                    }
                } else {
                    bci = bFactor * bciValue.floatValue();
                }
                if (Logger.debugging) {
                    msg = msg + bci;
                    Logger.debug(msg);
                }
                dq = at2.fcadj * at2.formalCharge - at1.fcadj * at1.formalCharge + bci;
            }
            catch (Exception e) {
                dq = Float.NaN;
            }
            if (ok1) {
                int n = a1.i;
                partialCharges[n] = partialCharges[n] + dq;
            }
            if (!ok2) continue;
            int n = a2.i;
            partialCharges[n] = partialCharges[n] - dq;
        }
        if (doRound) {
            float abscharge = 0.0f;
            int i3 = partialCharges.length;
            while (--i3 >= 0) {
                partialCharges[i3] = (float)Math.round(partialCharges[i3] * 1000.0f) / 1000.0f;
                abscharge += Math.abs(partialCharges[i3]);
            }
            if (abscharge == 0.0f && a1 != null) {
                partialCharges[a1.i] = -0.0f;
            }
        }
        return partialCharges;
    }

    private static boolean isBondType1(AtomType at1, AtomType at2) {
        return at1.sbmb && at2.sbmb || at1.arom && at2.arom;
    }

    private int getBondType(Bond bond, AtomType at1, AtomType at2, int index1, int index2) {
        return ForceFieldMMFF.isBondType1(at1, at2) && bond.getCovalentOrder() == 1 && !this.isAromaticBond(index1, index2) ? 1 : 0;
    }

    private boolean isAromaticBond(int a1, int a2) {
        if (this.vRings[3] != null) {
            int i = this.vRings[3].size();
            while (--i >= 0) {
                BS bsRing = (BS)this.vRings[3].get(i);
                if (!bsRing.get(a1) || !bsRing.get(a2)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getAtomTypeDescs(int[] types) {
        String[] stypes = new String[types.length];
        int i = types.length;
        while (--i >= 0) {
            stypes[i] = String.valueOf(types[i] < 0 ? -types[i] : ((AtomType)ForceFieldMMFF.atomTypes.get((int)types[i])).mmType);
        }
        return stypes;
    }

    private static int[] setAtomTypes(Atom[] atoms, BS bsAtoms, SmilesMatcherInterface smartsMatcher, Lst<BS>[] vRings, boolean allowUnknowns) {
        Lst<BS> bitSets = new Lst<BS>();
        String[] smarts = new String[atomTypes.size()];
        int[] types = new int[atoms.length];
        BS bsElements = new BS();
        BS bsHydrogen = new BS();
        BS bsConnected = BSUtil.copy(bsAtoms);
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = atoms[i];
            Bond[] bonds = a.bonds;
            if (bonds != null) {
                int j = bonds.length;
                while (--j >= 0) {
                    if (!bonds[j].isCovalent()) continue;
                    bsConnected.set(bonds[j].getOtherAtom((Atom)a).i);
                }
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        i = bsConnected.nextSetBit(0);
        while (i >= 0) {
            int n = atoms[i].getElementNumber();
            switch (n) {
                case 1: {
                    bsHydrogen.set(i);
                    break;
                }
                default: {
                    bsElements.set(n);
                }
            }
            i = bsConnected.nextSetBit(i + 1);
        }
        int nUsed = 0;
        for (int i2 = 1; i2 < atomTypes.size(); ++i2) {
            AtomType at = (AtomType)atomTypes.get(i2);
            if (!bsElements.get(at.elemNo)) continue;
            smarts[i2] = at.smartsCode;
            ++nUsed;
        }
        Logger.info(nUsed + " SMARTS matches used");
        try {
            smartsMatcher.getMMFF94AtomTypes(smarts, atoms, atoms.length, bsConnected, bitSets, vRings);
        }
        catch (Exception e) {
            Logger.error(e.toString());
        }
        BS bsDone = new BS();
        for (int j = 0; j < bitSets.size(); ++j) {
            BS bs = (BS)bitSets.get(j);
            if (bs == null) continue;
            bs.andNot(bsDone);
            int i3 = bs.nextSetBit(0);
            while (i3 >= 0) {
                types[i3] = j;
                i3 = bs.nextSetBit(i3 + 1);
            }
            bsDone.or(bs);
        }
        int i4 = bsHydrogen.nextSetBit(0);
        while (i4 >= 0) {
            Bond[] bonds = atoms[i4].bonds;
            if (bonds != null) {
                int j = types[bonds[0].getOtherAtom((Atom)atoms[i4]).i];
                if (j != 0) {
                    bsDone.set(i4);
                }
                types[i4] = -((AtomType)ForceFieldMMFF.atomTypes.get((int)j)).hType;
            }
            i4 = bsHydrogen.nextSetBit(i4 + 1);
        }
        if (Logger.debugging) {
            i4 = bsConnected.nextSetBit(0);
            while (i4 >= 0) {
                Logger.debug("atom " + atoms[i4] + "\ttype " + (types[i4] < 0 ? "" + -types[i4] : ((AtomType)ForceFieldMMFF.atomTypes.get((int)types[i4])).mmType + "\t" + ((AtomType)ForceFieldMMFF.atomTypes.get((int)types[i4])).smartsCode + "\t" + ((AtomType)ForceFieldMMFF.atomTypes.get((int)types[i4])).descr));
                i4 = bsConnected.nextSetBit(i4 + 1);
            }
        }
        if (!allowUnknowns && bsDone.cardinality() != bsConnected.cardinality()) {
            return null;
        }
        return types;
    }

    private int[] setBondTypes(Bond[] bonds, int bondCount, BS bsAtoms) {
        int[] bTypes = new int[bondCount];
        int i = bondCount;
        while (--i >= 0) {
            Atom a1 = bonds[i].atom1;
            Atom a2 = bonds[i].atom2;
            boolean ok1 = bsAtoms.get(a1.i);
            boolean ok2 = bsAtoms.get(a2.i);
            if (!ok1 && !ok2) continue;
            int it = this.rawAtomTypes[a1.i];
            AtomType at1 = (AtomType)atomTypes.get(Math.max(0, it));
            it = this.rawAtomTypes[a2.i];
            AtomType at2 = (AtomType)atomTypes.get(Math.max(0, it));
            bTypes[i] = this.getBondType(bonds[i], at1, at2, a1.i, a2.i);
        }
        return bTypes;
    }

    private boolean fixTypes() {
        int i = this.minAtomCount;
        while (--i >= 0) {
            int type;
            MinAtom a = this.minAtoms[i];
            int rawIndex = a.atom.i;
            int it = this.rawAtomTypes[rawIndex];
            a.ffAtomType = (AtomType)atomTypes.get(Math.max(0, it));
            a.ffType = type = it < 0 ? -it : ((AtomType)ForceFieldMMFF.atomTypes.get((int)it)).mmType;
            a.vdwKey = MinObject.getKey(0, type, 127, 127, 122);
            a.partialCharge = this.rawMMFF94Charges[rawIndex];
        }
        i = this.minBonds.length;
        while (--i >= 0) {
            MinBond bond = this.minBonds[i];
            bond.type = this.rawBondTypes[bond.rawIndex];
            bond.key = this.getKey(bond, bond.type, 3);
            if (bond.key != null) continue;
            return false;
        }
        i = this.minAngles.length;
        while (--i >= 0) {
            MinAngle angle = this.minAngles[i];
            angle.key = this.getKey(angle, angle.type, 5);
            angle.sbKey = this.getKey(angle, angle.sbType, 21);
        }
        i = this.minTorsions.length;
        while (--i >= 0) {
            MinTorsion torsion = this.minTorsions[i];
            torsion.key = this.getKey(torsion, torsion.type, 9);
        }
        return true;
    }

    private int setAngleType(MinAngle angle) {
        angle.type = this.minBonds[angle.data[3]].type + this.minBonds[angle.data[4]].type;
        if (this.checkRings(this.vRings[0], angle.data, 3)) {
            angle.type = angle.type + (angle.type == 0 ? 3 : 4);
        } else if (this.checkRings(this.vRings[1], angle.data, 3)) {
            angle.type = angle.type + (angle.type == 0 ? 4 : 6);
        }
        angle.sbType = sbMap[angle.type];
        switch (angle.type) {
            case 1: 
            case 5: 
            case 7: {
                angle.sbType += this.minBonds[angle.data[4]].type;
            }
        }
        return angle.type;
    }

    private int setTorsionType(MinTorsion t) {
        if (this.checkRings(this.vRings[1], t.data, 4)) {
            t.type = 4;
            return 4;
        }
        int n = this.minBonds[t.data[5]].type == 1 ? 1 : (t.type = this.minBonds[t.data[4]].type == 0 && this.minBonds[t.data[6]].type == 0 ? 0 : 2);
        if (t.type == 0 && this.checkRings(this.vRings[2], t.data, 4)) {
            t.type = 5;
        }
        return t.type;
    }

    private int typeOf(int iAtom) {
        return this.minAtoms[iAtom].ffType;
    }

    private boolean checkRings(Lst<BS> v, int[] minlist, int n) {
        if (v != null) {
            int i = v.size();
            while (--i >= 0) {
                BS bs = (BS)v.get(i);
                if (!bs.get(this.minAtoms[minlist[0]].atom.i) || !bs.get(this.minAtoms[minlist[1]].atom.i) || n >= 3 && !bs.get(this.minAtoms[minlist[2]].atom.i) || n >= 4 && !bs.get(this.minAtoms[minlist[3]].atom.i)) continue;
                return true;
            }
        }
        return false;
    }

    private Integer getKey(Object obj, int type, int ktype) {
        MinObject o = obj instanceof MinObject ? (MinObject)obj : null;
        int[] data = o == null ? (int[])obj : o.data;
        int n = 4;
        switch (ktype) {
            case 3: {
                this.fixOrder(data, 0, 1);
                n = 2;
                break;
            }
            case 5: {
                if (this.fixOrder(data, 0, 2) == -1) {
                    ForceFieldMMFF.swap(data, 3, 4);
                }
                type = this.setAngleType((MinAngle)o);
                n = 3;
                break;
            }
            case 21: {
                n = 3;
                break;
            }
            case 9: {
                switch (this.fixOrder(data, 1, 2)) {
                    case 1: {
                        break;
                    }
                    case -1: {
                        ForceFieldMMFF.swap(data, 0, 3);
                        ForceFieldMMFF.swap(data, 4, 6);
                        break;
                    }
                    case 0: {
                        if (this.fixOrder(data, 0, 3) != -1) break;
                        ForceFieldMMFF.swap(data, 4, 6);
                    }
                }
                type = this.setTorsionType((MinTorsion)o);
            }
        }
        Integer key = null;
        for (int i = 0; i < 4; ++i) {
            this.typeData[i] = i < n ? this.typeOf(data[i]) : 127;
        }
        switch (ktype) {
            case 21: {
                this.typeData[3] = 125;
                break;
            }
            case 13: {
                ForceFieldMMFF.sortOop(this.typeData);
            }
        }
        key = MinObject.getKey(type, this.typeData[0], this.typeData[1], this.typeData[2], this.typeData[3]);
        double[] ddata = (double[])ffParams.get(key);
        switch (ktype) {
            case 3: {
                return ddata != null && ddata[0] > 0.0 ? key : this.applyEmpiricalRules(o, ddata, 3);
            }
            case 5: {
                if (ddata == null || ddata[0] == 0.0) break;
                return key;
            }
            case 9: {
                if (ddata == null) {
                    key = this.getTorsionKey(type, 0, 2);
                    if (!(ffParams.containsKey(key) || ffParams.containsKey(key = this.getTorsionKey(type, 2, 0)) || ffParams.containsKey(key = this.getTorsionKey(type, 2, 2)))) {
                        key = this.getTorsionKey(0, 2, 2);
                    }
                    ddata = (double[])ffParams.get(key);
                }
                return ddata != null ? key : this.applyEmpiricalRules(o, ddata, 9);
            }
            case 21: {
                if (ddata != null) {
                    return key;
                }
                int r1 = this.getRowFor(data[0]);
                int r2 = this.getRowFor(data[1]);
                int r3 = this.getRowFor(data[2]);
                return MinObject.getKey(0, r1, r2, r3, 126);
            }
            case 13: {
                if (ddata == null) break;
                return key;
            }
        }
        boolean isSwapped = false;
        boolean haveKey = false;
        for (int i = 0; i < 3 && !haveKey; ++i) {
            int j = 0;
            int bit = 1;
            while (j < n) {
                if ((ktype & bit) == bit) {
                    this.typeData[j] = ForceFieldMMFF.getEquivalentType(this.typeOf(data[j]), i);
                }
                ++j;
                bit <<= 1;
            }
            switch (ktype) {
                case 3: {
                    isSwapped = ForceFieldMMFF.fixTypeOrder(this.typeData, 0, 1);
                    break;
                }
                case 5: {
                    isSwapped = ForceFieldMMFF.fixTypeOrder(this.typeData, 0, 2);
                    break;
                }
                case 13: {
                    ForceFieldMMFF.sortOop(this.typeData);
                }
            }
            key = MinObject.getKey(type, this.typeData[0], this.typeData[1], this.typeData[2], this.typeData[3]);
            haveKey = ffParams.containsKey(key);
        }
        if (haveKey) {
            if (isSwapped) {
                switch (ktype) {
                    case 5: {
                        ForceFieldMMFF.swap(data, 0, 2);
                        ForceFieldMMFF.swap(data, 3, 4);
                        this.setAngleType((MinAngle)o);
                    }
                }
            }
        } else if (type != 0 && ktype == 5) {
            key = key ^ 0xFF;
        }
        ddata = (double[])ffParams.get(key);
        switch (ktype) {
            case 5: {
                return ddata != null && ddata[0] != 0.0 ? key : this.applyEmpiricalRules(o, ddata, 5);
            }
        }
        return key;
    }

    private Integer getTorsionKey(int type, int i, int j) {
        return MinObject.getKey(type, ForceFieldMMFF.getEquivalentType(this.typeData[0], i), this.typeData[1], this.typeData[2], ForceFieldMMFF.getEquivalentType(this.typeData[3], j));
    }

    private Integer applyEmpiricalRules(MinObject o, double[] ddata, int ktype) {
        double beta = 0.0;
        switch (ktype) {
            case 3: {
                MinAtom a = this.minAtoms[o.data[0]];
                MinAtom b = this.minAtoms[o.data[1]];
                int elemno1 = a.atom.getElementNumber();
                int elemno2 = b.atom.getElementNumber();
                Integer key = MinObject.getKey(0, Math.min(elemno1, elemno2), Math.max(elemno1, elemno2), 127, 123);
                ddata = (double[])ffParams.get(key);
                if (ddata == null) {
                    return null;
                }
                double kbref = ddata[0];
                double r0ref = ddata[1];
                double r0 = ForceFieldMMFF.getRuleBondLength(a, b, ((MinBond)o).order, this.isAromaticBond(o.data[0], o.data[1]));
                if (r0 == 0.0) {
                    return null;
                }
                double rr = r0ref / r0;
                double rr2 = rr * rr;
                double rr4 = rr2 * rr2;
                double rr6 = rr4 * rr2;
                double kb = kbref * rr6;
                o.ddata = new double[]{kb, r0};
                return -1;
            }
            case 5: {
                double theta0;
                if (ddata == null || (theta0 = ddata[1]) == 0.0) {
                    MinAtom b = this.minAtoms[o.data[1]];
                    Atom atom = b.atom;
                    int elemno = atom.getElementNumber();
                    block5 : switch (o.type) {
                        case 3: 
                        case 5: 
                        case 6: {
                            theta0 = 60.0;
                            beta *= 0.05;
                            break;
                        }
                        case 4: 
                        case 7: 
                        case 8: {
                            theta0 = 90.0;
                            break;
                        }
                        default: {
                            theta0 = 120.0;
                            int crd = atom.getCovalentBondCount();
                            switch (crd) {
                                case 2: {
                                    if (MinAtom.isLinear(b)) {
                                        theta0 = 180.0;
                                        break block5;
                                    }
                                    if (elemno == 8) {
                                        theta0 = 105.0;
                                        break block5;
                                    }
                                    if (elemno <= 10) break block5;
                                    theta0 = 95.0;
                                    break block5;
                                }
                                case 3: {
                                    if (b.ffAtomType.mltb != 0 || b.ffAtomType.val != 3) break block5;
                                    theta0 = elemno == 7 ? 107 : 92;
                                    break block5;
                                }
                                case 4: {
                                    theta0 = 109.45;
                                }
                            }
                        }
                    }
                }
                beta = 1.75;
                switch (o.type) {
                    case 3: 
                    case 5: 
                    case 6: {
                        beta *= 0.05;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        beta *= 0.85;
                    }
                }
                double za = ForceFieldMMFF.getZParam(this.minAtoms[o.data[0]].atom.getElementNumber());
                double cb = ForceFieldMMFF.getCParam(this.minAtoms[o.data[1]].atom.getElementNumber());
                double zc = ForceFieldMMFF.getZParam(this.minAtoms[o.data[2]].atom.getElementNumber());
                double r0ab = ForceFieldMMFF.getR0(this.minBonds[o.data[3]]);
                double r0bc = ForceFieldMMFF.getR0(this.minBonds[o.data[4]]);
                double rr = r0ab + r0bc;
                double rr2 = rr * rr;
                double D = (r0ab - r0bc) / rr2;
                double theta2 = theta0 * (Math.PI / 180);
                theta2 *= theta2;
                double ka = beta * za * cb * zc * Math.exp(-2.0 * D) / (rr * theta2);
                o.ddata = new double[]{ka, theta0};
                return -1;
            }
            case 9: {
                int ib = o.data[1];
                int ic = o.data[2];
                MinAtom b = this.minAtoms[ib];
                MinAtom c = this.minAtoms[ic];
                if (MinAtom.isLinear(b) || MinAtom.isLinear(c)) {
                    return null;
                }
                MinBond bondBC = this.minBonds[o.data[5]];
                int elemnoB = b.atom.getElementNumber();
                int elemnoC = c.atom.getElementNumber();
                double ub = ForceFieldMMFF.getUParam(elemnoB);
                double uc = ForceFieldMMFF.getUParam(elemnoC);
                double vb = ForceFieldMMFF.getVParam(elemnoB);
                double vc = ForceFieldMMFF.getVParam(elemnoC);
                double v1 = 0.0;
                double v2 = 0.0;
                double v3 = 0.0;
                double pi_bc = -1.0;
                double n_bc = -1.0;
                double wb = -1.0;
                double wc = 0.0;
                int valB = b.ffAtomType.val;
                int valC = c.ffAtomType.val;
                boolean pilpB = b.ffAtomType.pilp;
                boolean pilpC = c.ffAtomType.pilp;
                int mltbB = b.ffAtomType.mltb;
                int mltbC = c.ffAtomType.mltb;
                if (this.isAromaticBond(ib, ic)) {
                    pi_bc = pilpB || pilpC ? 0.3 : 0.5;
                    beta = valB + valC == 7 ? 3 : 6;
                } else if (bondBC.order == 2) {
                    beta = 6.0;
                    pi_bc = mltbB == 2 && mltbC == 2 ? 1.0 : 0.4;
                } else {
                    int crdB = b.atom.getCovalentBondCount();
                    int crdC = c.atom.getCovalentBondCount();
                    if (crdB == 4 && crdC == 4) {
                        vb = ForceFieldMMFF.getVParam(elemnoB);
                        vc = ForceFieldMMFF.getVParam(elemnoC);
                        n_bc = 9.0;
                    } else {
                        boolean case3;
                        if (crdB != 4 && (valB > crdB || mltbB > 0) || crdC != 4 && (valC > crdC || mltbC > 0)) {
                            return null;
                        }
                        boolean case2 = pilpB && mltbC > 0;
                        boolean bl = case3 = pilpC && mltbB > 0;
                        if (bondBC.order == 1 && (mltbB > 0 && mltbC > 0 || case2 || case3)) {
                            if (pilpB && pilpC) {
                                return null;
                            }
                            beta = 6.0;
                            pi_bc = case2 ? (mltbC == 1 ? 0.5 : (elemnoB <= 10 && elemnoC <= 10 ? 0.3 : 0.15)) : (case3 ? (mltbB == 1 ? 0.5 : (elemnoB <= 10 && elemnoC <= 10 ? 0.3 : 0.15)) : (!(mltbB != 1 && mltbC != 1 || elemnoB != 6 && elemnoC != 6) ? 0.4 : 0.15));
                        } else {
                            switch (elemnoB << 8 + elemnoC) {
                                case 2056: {
                                    wc = 2.0;
                                    wb = 2.0;
                                    break;
                                }
                                case 2064: {
                                    wb = 2.0;
                                    wc = 8.0;
                                    break;
                                }
                                case 4104: {
                                    wb = 8.0;
                                    wc = 2.0;
                                    break;
                                }
                                case 4112: {
                                    wc = 8.0;
                                    wb = 8.0;
                                    break;
                                }
                                default: {
                                    n_bc = crdB * crdC;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (pi_bc > 0.0) {
                    v2 = beta * pi_bc * Math.sqrt(ub * uc);
                } else if (n_bc > 0.0) {
                    v3 = Math.sqrt(vb * vc) / n_bc;
                } else if (wb != 0.0) {
                    v2 = -Math.sqrt(wb * wc);
                }
                o.ddata = new double[]{v1, v2, v3};
                return -1;
            }
        }
        return null;
    }

    private static double getR0(MinBond b) {
        return (b.ddata == null ? (double[])ffParams.get(b.key) : b.ddata)[1];
    }

    private int getRowFor(int i) {
        int elemno = this.minAtoms[i].atom.getElementNumber();
        return elemno < 3 ? 0 : (elemno < 11 ? 1 : (elemno < 19 ? 2 : (elemno < 37 ? 3 : 4)));
    }

    double getOutOfPlaneParameter(int[] data) {
        double[] ddata = (double[])ffParams.get(this.getKey(data, 6, 13));
        return ddata == null ? 0.0 : ddata[0];
    }

    private static void sortOop(int[] typeData) {
        ForceFieldMMFF.fixTypeOrder(typeData, 0, 2);
        ForceFieldMMFF.fixTypeOrder(typeData, 0, 3);
        ForceFieldMMFF.fixTypeOrder(typeData, 2, 3);
    }

    private static boolean fixTypeOrder(int[] a, int i, int j) {
        if (a[i] > a[j]) {
            ForceFieldMMFF.swap(a, i, j);
            return true;
        }
        return false;
    }

    private int fixOrder(int[] a, int i, int j) {
        int test = this.typeOf(a[j]) - this.typeOf(a[i]);
        if (test < 0) {
            ForceFieldMMFF.swap(a, i, j);
        }
        return test < 0 ? -1 : (test > 0 ? 1 : 0);
    }

    private static void swap(int[] a, int i, int j) {
        int t = a[i];
        a[i] = a[j];
        a[j] = t;
    }

    private static int getEquivalentType(int type, int level) {
        return type == 0 ? 0 : (type == 70 || type > 82 ? type : (level == 2 ? 0 : equivalentTypes[(type - 1 << 1) + level]));
    }

    private static double getZParam(int elemno) {
        switch (elemno) {
            case 1: {
                return 1.395;
            }
            case 6: {
                return 2.494;
            }
            case 7: {
                return 2.711;
            }
            case 8: {
                return 3.045;
            }
            case 9: {
                return 2.847;
            }
            case 14: {
                return 2.35;
            }
            case 15: {
                return 2.35;
            }
            case 16: {
                return 2.98;
            }
            case 17: {
                return 2.909;
            }
            case 35: {
                return 3.017;
            }
            case 53: {
                return 3.086;
            }
        }
        return 0.0;
    }

    private static double getCParam(int elemno) {
        switch (elemno) {
            case 5: {
                return 0.704;
            }
            case 6: {
                return 1.016;
            }
            case 7: {
                return 1.113;
            }
            case 8: {
                return 1.337;
            }
            case 14: {
                return 0.811;
            }
            case 15: {
                return 1.068;
            }
            case 16: {
                return 1.249;
            }
            case 17: {
                return 1.078;
            }
            case 33: {
                return 0.825;
            }
        }
        return 0.0;
    }

    private static double getUParam(int elemno) {
        switch (elemno) {
            case 6: 
            case 7: 
            case 8: {
                return 2.0;
            }
            case 14: 
            case 15: 
            case 16: {
                return 1.25;
            }
        }
        return 0.0;
    }

    private static double getVParam(int elemno) {
        switch (elemno) {
            case 6: {
                return 2.12;
            }
            case 7: {
                return 1.5;
            }
            case 8: {
                return 0.2;
            }
            case 14: {
                return 1.22;
            }
            case 15: {
                return 2.4;
            }
            case 16: {
                return 0.49;
            }
        }
        return 0.0;
    }

    private static double getCovalentRadius(int elemno) {
        switch (elemno) {
            case 1: {
                return 0.33;
            }
            case 5: {
                return 0.81;
            }
            case 6: {
                return 0.77;
            }
            case 7: {
                return 0.73;
            }
            case 8: {
                return 0.72;
            }
            case 9: {
                return 0.74;
            }
            case 13: {
                return 1.22;
            }
            case 14: {
                return 1.15;
            }
            case 15: {
                return 1.09;
            }
            case 16: {
                return 1.03;
            }
            case 17: {
                return 1.01;
            }
            case 31: {
                return 1.19;
            }
            case 32: {
                return 1.2;
            }
            case 33: {
                return 1.2;
            }
            case 34: {
                return 1.16;
            }
            case 35: {
                return 1.15;
            }
            case 44: {
                return 1.46;
            }
            case 50: {
                return 1.4;
            }
            case 51: {
                return 1.41;
            }
            case 52: {
                return 1.35;
            }
            case 53: {
                return 1.33;
            }
            case 81: {
                return 1.51;
            }
            case 82: {
                return 1.53;
            }
            case 83: {
                return 1.55;
            }
        }
        return Elements.getBondingRadius(elemno, 0);
    }

    private static double getRuleBondLength(MinAtom a, MinAtom b, int boAB, boolean isAromatic) {
        switch (boAB) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                return 0.0;
            }
        }
        int elemnoA = a.atom.getElementNumber();
        int elemnoB = b.atom.getElementNumber();
        double r0a = ForceFieldMMFF.getCovalentRadius(elemnoA);
        double r0b = ForceFieldMMFF.getCovalentRadius(elemnoB);
        double Xa = Elements.getAllredRochowElectroNeg(elemnoA);
        double Xb = Elements.getAllredRochowElectroNeg(elemnoB);
        double c = elemnoA == 1 || elemnoB == 1 ? 0.05 : 0.085;
        double n = 1.4;
        double r = r0a + r0b;
        if (isAromatic) {
            boAB = a.ffAtomType.pilp || b.ffAtomType.pilp ? 5 : 4;
        } else {
            switch (a.ffAtomType.mltb << 4 + b.ffAtomType.mltb) {
                case 17: {
                    boAB = 4;
                    break;
                }
                case 18: 
                case 33: {
                    boAB = 5;
                }
            }
        }
        block8 : switch (boAB) {
            case 1: {
                switch (a.ffAtomType.mltb) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                switch (b.ffAtomType.mltb) {
                    case 0: {
                        break block8;
                    }
                    case 1: 
                    case 2: {
                        break block8;
                    }
                }
                break;
            }
        }
        return r -= c * Math.pow(Math.abs(Xa - Xb), n);
    }

    static {
        types = new int[]{0, 1, 34, 5, 546, 3, 13, 21, 37, 9, 17};
        sbMap = new int[]{0, 1, 3, 5, 4, 6, 8, 9, 11};
        equivalentTypes = new int[]{1, 1, 2, 1, 3, 1, 4, 1, 5, 5, 6, 6, 7, 6, 8, 8, 9, 8, 10, 8, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 15, 17, 15, 18, 15, 19, 19, 1, 1, 21, 5, 22, 1, 23, 5, 24, 5, 25, 25, 26, 25, 28, 5, 28, 5, 29, 5, 2, 1, 31, 31, 7, 6, 21, 5, 8, 8, 6, 6, 36, 5, 2, 1, 9, 8, 10, 8, 10, 8, 3, 1, 42, 8, 10, 8, 16, 15, 10, 8, 9, 8, 42, 8, 9, 8, 6, 6, 21, 5, 7, 6, 21, 5, 42, 8, 9, 8, 10, 8, 10, 8, 2, 1, 10, 8, 6, 6, 4, 1, 42, 8, 10, 8, 2, 1, 2, 1, 9, 8, 9, 8, 9, 8, 8, 8, 9, 8, 70, 70, 5, 5, 16, 15, 18, 15, 17, 15, 26, 25, 9, 8, 12, 12, 2, 1, 9, 8, 2, 1, 10, 8, 9, 8};
    }
}

