/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awtjs.swing;

import javajs.awt.Container;
import javajs.util.SB;
import org.jmol.awtjs.swing.JComponent;
import org.jmol.awtjs.swing.JComponentImp;

public class JSplitPane
extends JComponent {
    public static final int HORIZONTAL_SPLIT = 1;
    boolean isH = true;
    private int split = 1;
    private Container right;
    private Container left;

    public JSplitPane(int n) {
        super("JSpP");
        this.split = n;
        this.isH = n == 1;
    }

    public void setRightComponent(JComponent jComponent) {
        this.right = new JComponentImp(null);
        this.right.add(jComponent);
    }

    public void setLeftComponent(JComponent jComponent) {
        this.left = new JComponentImp(null);
        this.left.add(jComponent);
    }

    @Override
    public int getSubcomponentWidth() {
        int n = this.width;
        if (n == 0) {
            int n2 = this.left.getSubcomponentWidth();
            int n3 = this.right.getSubcomponentWidth();
            if (n2 > 0 && n3 > 0) {
                n = this.isH ? n2 + n3 : Math.max(n2, n3);
            }
        }
        return n;
    }

    @Override
    public int getSubcomponentHeight() {
        int n = this.height;
        if (n == 0) {
            int n2 = this.left.getSubcomponentHeight();
            int n3 = this.right.getSubcomponentHeight();
            if (n2 > 0 && n3 > 0) {
                n = this.isH ? Math.max(n2, n3) : n2 + n3;
            }
        }
        return n;
    }

    @Override
    public String toHTML() {
        boolean bl;
        if (this.left == null || this.right == null) {
            return "";
        }
        boolean bl2 = bl = this.split == 1;
        if (this.width == 0) {
            this.width = this.getSubcomponentWidth();
        }
        if (this.height == 0) {
            this.height = this.getSubcomponentHeight();
        }
        SB sB = new SB();
        sB.append("<div id='" + this.id + "' class='JSplitPane' style='" + this.getCSSstyle(100, 100) + "'>");
        if (bl) {
            sB.append("<div id='" + this.id + "_left' style='width:50%;height:100%;position:absolute;top:0%;left:0%'>");
        } else {
            sB.append("<div id='" + this.id + "_top' style='width:100%;height:50%;position:absolute;top:0%;left:0%'>");
        }
        sB.append(this.left.getComponents()[0].toHTML());
        if (bl) {
            sB.append("</div><div id='" + this.id + "_right' style='width:50%;height:100%;position:absolute;top:0%;left:50%'>");
        } else {
            sB.append("</div><div id='" + this.id + "_bottom' style='width:100%;height:50%;position:absolute;top:50%;left:0%'>");
        }
        sB.append(this.right.getComponents()[0].toHTML());
        sB.append("</div></div>\n");
        return sB.toString();
    }
}

