/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Queue;
import javajs.util.AU;
import javajs.util.PT;
import org.gennbo.NBOConfig;
import org.gennbo.NBODialog;
import org.gennbo.NBORequest;
import org.jmol.viewer.Viewer;

public class NBOService {
    static final int MODE_ERROR = -1;
    static final int MODE_RAW = 0;
    private Viewer vwr;
    private Object lock;
    private String serverPath;
    private boolean doConnect;
    protected NBODialog dialog;
    protected String exeName = "NBOServe.exe";
    private String gennboPath = "gennbo.bat";
    protected Queue<NBORequest> requestQueue;
    protected NBORequest currentRequest;
    protected boolean cantStartServer;
    protected boolean haveLicense;
    private NBOListener nboListener;
    private boolean allowRequestQueing = true;

    boolean isReady() {
        return this.nboListener != null && this.nboListener.isReady;
    }

    public NBOService(NBODialog nboDialog, Viewer vwr, boolean doConnect) {
        this.dialog = nboDialog;
        this.vwr = vwr;
        this.doConnect = doConnect;
        this.setServerPath(nboDialog.nboPlugin.getNBOProperty("serverPath", System.getProperty("user.home") + "/NBOServe"));
        this.requestQueue = new ArrayDeque<NBORequest>();
        this.lock = new Object();
    }

    String getServerPath(String fileName) {
        return fileName == null ? this.serverPath : this.serverPath + "/" + fileName;
    }

    protected void setServerPath(String path) {
        this.serverPath = path.replace('\\', '/');
        this.dialog.nboPlugin.setNBOProperty("serverPath", path);
    }

    protected boolean isEnabled() {
        return this.serverPath != null;
    }

    public int getWorkingMode() {
        return this.currentRequest == null ? 0 : this.currentRequest.dialogMode;
    }

    boolean startListener() {
        this.cantStartServer = true;
        if (!this.doConnect) {
            return false;
        }
        if (this.nboListener != null) {
            this.nboListener.disconnect();
        }
        this.nboListener = null;
        boolean trying = false;
        for (int i = 0; i < 3; ++i) {
            if (this.nboListener != null) {
                this.nboListener.disconnect();
            }
            this.nboListener = new NBOListener();
            boolean connected = this.nboListener.connect();
            if (connected) {
                if (trying) {
                    this.dialog.logError("Connection successful");
                }
                this.cantStartServer = false;
                return true;
            }
            trying = true;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.dialog.logError("Cannot start NBOServe process");
        this.nboListener = null;
        return false;
    }

    public synchronized void closeProcess(boolean andPause) {
        if (this.nboListener != null) {
            System.out.flush();
            System.out.println("CLOSING PROCESS " + Thread.currentThread());
            this.nboListener.disconnect();
            this.nboListener = null;
            if (andPause) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.currentRequest = null;
        this.haveLicense = false;
        this.dialog.setLicense("\n\n");
    }

    boolean restart() {
        this.closeProcess(false);
        System.out.println("NBO restart");
        return this.startListener();
    }

    public boolean restartIfNecessary() {
        return this.nboListener != null || this.startListener();
    }

    public boolean haveGenNBO() {
        if (!this.doConnect) {
            return true;
        }
        File f = new File(this.getServerPath(this.gennboPath));
        if (!f.exists()) {
            this.vwr.alert(f + " not found, make sure gennbo.bat is in same directory as " + this.exeName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postToNBO(NBORequest request) {
        Object object = this.lock;
        synchronized (object) {
            this.restartIfNecessary();
            if (this.nboListener != null && this.nboListener.isReady && this.requestQueue.isEmpty() && this.currentRequest == null) {
                this.currentRequest = request;
                this.requestQueue.add(this.currentRequest);
                this.startRequest(this.currentRequest);
            } else if (this.allowRequestQueing) {
                this.requestQueue.add(request);
                System.out.println("NBOService request queued " + this.requestQueue.size());
            } else {
                System.out.println("request denied " + request);
            }
        }
    }

    public void clearQueue() {
        this.requestQueue.clear();
    }

    protected void startRequest(NBORequest request) {
        if (request == null) {
            return;
        }
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.nboListener == null && !this.startListener() || this.nboListener.destroyed) {
            return;
        }
        System.out.println("starting request for " + request.statusInfo + " " + request);
        if (request.timeStamp != 0L) {
            System.out.println("SENDING TWICE?");
            this.nboListener.disconnect();
            this.nboListener = null;
            this.clearQueue();
            return;
        }
        request.timeStamp = System.currentTimeMillis();
        this.currentRequest = request;
        String cmdFileName = null;
        String data = null;
        int n = request.fileData.length;
        for (int i = 2; i < n + 2; i += 2) {
            cmdFileName = request.fileData[i % n];
            data = request.fileData[(i + 1) % n];
            if (cmdFileName == null) continue;
            this.dialog.inputFileHandler.writeToFile(this.getServerPath(cmdFileName), data);
            System.out.println("saved file " + cmdFileName + "\n" + data + "\n");
        }
        this.dialog.setStatus(request.statusInfo);
        String cmd = "<" + cmdFileName + ">";
        System.out.println("sending " + cmd);
        this.nboListener.submitRequest(cmd);
    }

    protected void logServerLine(String line, int level) {
        this.dialog.logInfo(line, level);
        if (level == 2) {
            this.dialog.setStatus("");
        }
    }

    protected boolean isFortranError(String line) {
        return line.indexOf("Permission denied") >= 0 || line.indexOf("PGFIO-F") >= 0 || line.indexOf("Invalid command") >= 0;
    }

    class NBOListener
    extends Thread {
        public static final int NBO_STATUS_UNINITIALIZED = 0;
        public static final int NBO_STATUS_INITIALIZING = 1;
        public static final int NBO_STATUS_READY = 2;
        public static final int NBO_STATUS_LISTENING = 3;
        public static final int NBO_STATUS_WORKING = 4;
        public static final int NBO_STATUS_REPLYING = 5;
        public static final int NBO_STATUS_BAD_REPLY = 6;
        public static final int NBO_STATUS_DEAD = 7;
        public int nboStatus = 0;
        protected boolean isReady;
        protected boolean destroyed;
        private byte[] buffer = new byte[1024];
        private String cachedReply = "";
        private long lastTime;
        private BufferedInputStream nboOut;
        private Process nboProcess;
        private PrintWriter nboIn;

        NBOListener() {
        }

        @Override
        public void run() {
            System.out.println("NBORunnable run()");
            while (!this.destroyed && !Thread.currentThread().isInterrupted()) {
                if (NBOConfig.debugVerbose && System.currentTimeMillis() - this.lastTime > 1000L) {
                    this.lastTime = System.currentTimeMillis();
                    NBOService.this.dialog.logStatus("NBORunnable looping");
                }
                try {
                    String s;
                    Thread.sleep(10L);
                    if (this.nboOut == null || this.destroyed || (s = this.getNBOMessage()) == null || !this.processServerReturn(s)) continue;
                    this.cachedReply = "";
                    if (this.destroyed || !NBOService.this.haveLicense) continue;
                    NBOService.this.currentRequest = NBOService.this.requestQueue.peek();
                    NBOService.this.startRequest(NBOService.this.currentRequest);
                }
                catch (Throwable e1) {
                    NBOService.this.clearQueue();
                    if (("" + e1.getMessage()).indexOf("sleep") < 0) {
                        e1.printStackTrace();
                    }
                    NBOService.this.dialog.setStatus(e1.getMessage());
                }
            }
            System.out.println("NBORunnable done " + this.destroyed);
            if (this.destroyed) {
                NBOService.this.closeProcess(false);
            }
            System.out.println("NBORunnable exiting run()");
        }

        public void submitRequest(String cmd) {
            this.nboStatus = 4;
            this.nboIn.println(cmd);
            this.nboIn.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processServerReturn(String s) {
            if (s.indexOf("FORTRAN STOP") >= 0) {
                System.out.println(s);
                NBOService.this.dialog.alertError("NBOServe has stopped working - restarting");
                NBOService.this.currentRequest = null;
                NBOService.this.clearQueue();
                this.nboStatus = 7;
                return NBOService.this.restart();
            }
            if (NBOService.this.isFortranError(s) || s.indexOf("missing or invalid") >= 0) {
                if (!s.contains("end of file")) {
                    NBOService.this.dialog.alertError(s);
                }
                boolean wasWorking = NBOService.this.getWorkingMode() == 2;
                NBOService.this.currentRequest = null;
                NBOService.this.clearQueue();
                this.nboStatus = 7;
                if (wasWorking) {
                    NBOService.this.dialog.inputFileHandler.checkNBOComplete(true);
                }
                NBOService.this.dialog.setStatus("");
                return NBOService.this.restart();
            }
            boolean removeRequest = true;
            try {
                int pt = s.lastIndexOf("*start*");
                if (pt < 0) {
                    if (!NBOService.this.currentRequest.isMessy) {
                        this.nboStatus = 6;
                    }
                    removeRequest = !NBOService.this.currentRequest.isMessy;
                    boolean bl = removeRequest;
                    return bl;
                }
                if ((pt = (s = s.substring(pt + 8)).indexOf("*end*")) < 0) {
                    this.nboStatus = 5;
                    System.out.println("...listening...");
                    removeRequest = false;
                    boolean bl = false;
                    return bl;
                }
                if (NBOService.this.currentRequest == null) {
                    if (NBOService.this.haveLicense) {
                        this.nboStatus = 6;
                        System.out.println("TRANSMISSION ERROR: UNSOLICITED!>>>>" + s + "<<<<<");
                    } else {
                        System.out.println("license found:" + s);
                        NBOService.this.haveLicense = true;
                        NBOService.this.dialog.setLicense(s);
                        this.nboStatus = 2;
                    }
                    boolean bl = true;
                    return bl;
                }
                if (s.indexOf("***errmess***") >= 0) {
                    try {
                        s = PT.split(s, "\n")[1];
                        NBOService.this.logServerLine(s.substring(s.indexOf("\n") + 1), 2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    NBOService.this.logServerLine("NBOPro can't do that.", 3);
                    boolean bl = true;
                    return bl;
                }
                this.nboStatus = 3;
                NBOService.this.currentRequest.sendReply(s.substring(0, pt));
                boolean bl = true;
                return bl;
            }
            finally {
                if (NBOService.this.currentRequest != null && removeRequest) {
                    try {
                        NBOService.this.requestQueue.remove();
                    }
                    catch (Exception e) {
                        System.out.println("NBOService requestQueue empty");
                    }
                    NBOService.this.currentRequest = null;
                    NBOService.this.dialog.setStatus("");
                }
            }
        }

        protected boolean connect() {
            try {
                this.nboStatus = 1;
                String path = NBOService.this.getServerPath(NBOService.this.exeName);
                System.out.flush();
                System.out.println("startProcess: " + path + " " + Thread.currentThread());
                ProcessBuilder builder = new ProcessBuilder(path);
                builder.directory(new File(new File(path).getParent()));
                builder.redirectErrorStream(true);
                System.out.println("creating new runnable");
                this.setName("NBOServiceThread" + System.currentTimeMillis());
                this.nboOut = null;
                System.out.println("creating new nboOut");
                this.nboProcess = builder.start();
                this.nboOut = (BufferedInputStream)this.nboProcess.getInputStream();
                System.out.println("creating new nboIn");
                this.nboIn = new PrintWriter(this.nboProcess.getOutputStream());
                this.start();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    System.err.println(e);
                }
                System.out.println("checking nboOut");
                if (this.nboOut.available() > 0) {
                    System.out.println("OK!");
                }
                System.out.println("startProcess:" + this.nboProcess + " " + this.nboOut.available());
                this.nboStatus = 3;
                return true;
            }
            catch (IOException e) {
                String s = e.getMessage();
                System.out.println(s);
                if (s.contains("error=1455")) {
                    s = "low on memory -- retrying";
                }
                NBOService.this.dialog.logError(s);
                NBOService.this.closeProcess(false);
                return false;
            }
        }

        public void taskKillNBO() {
            String cmd = "taskKill /im " + NBOService.this.exeName + " /t /f  ";
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                System.out.println("NBOService cannot taskKill " + cmd);
            }
        }

        protected void disconnect() {
            this.destroyed = true;
            try {
                this.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.nboProcess = null;
                this.taskKillNBO();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.out.println("??" + e);
            }
        }

        private synchronized String getNBOMessage() throws IOException, InterruptedException {
            int n;
            int n2 = n = this.nboOut == null ? 0 : this.nboOut.available();
            if (n <= 0) {
                return null;
            }
            this.isReady = true;
            while (n > this.buffer.length) {
                this.buffer = AU.doubleLengthByte(this.buffer);
            }
            n = this.nboOut.read(this.buffer, 0, n);
            String s = PT.rep(new String(this.buffer, 0, n), "\r", "");
            System.out.println(">> " + s + "<<");
            this.cachedReply = this.cachedReply + s;
            return this.cachedReply;
        }
    }
}

