/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Map;
import javajs.util.BS;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gennbo.NBOConfig;
import org.gennbo.NBODialog;
import org.gennbo.NBORequest;
import org.gennbo.NBOUtil;
import org.jmol.awt.AwtColor;
import org.jmol.util.C;
import org.jmol.viewer.Viewer;

class NBOView {
    protected NBODialog dialog;
    protected Viewer vwr;
    private static final int MODE_VIEW_IMAGE = 13;
    private static final int MODE_VIEW_LIST = 23;
    protected final int BASIS_AO = 0;
    protected final int BASIS_PNAO = 1;
    protected final int BASIS_NAO = 2;
    protected final int BASIS_PNHO = 3;
    protected final int BASIS_NHO = 4;
    protected final int BASIS_PNBO = 5;
    protected final int BASIS_NBO = 6;
    protected final int BASIS_PNLMO = 7;
    protected final int BASIS_NLMO = 8;
    protected final int BASIS_MO = 9;
    protected static final String[] basSet = new String[]{"AO", "PNAO", "NAO", "PNHO", "NHO", "PNBO", "NBO", "PNLMO", "NLMO", "MO"};
    protected static final int[] basisLabelKey = new int[]{0, 1, 1, 2, 2, 3, 3, 3, 3, 4, 0, 1, 1, 5, 5, 6, 6, 6, 6, 7};
    private String[][] orbitalLabels;
    private JScrollPane orbScroll;
    private Box centerBox;
    private Box bottomBox;
    private Box axisBox;
    private Box planeBox;
    private JRadioButton btn1D;
    private JRadioButton btn2D;
    private JRadioButton btn3D;
    private JRadioButton atomOrient;
    private JRadioButton jmolOrient;
    private DefaultListModel<String> alphaList;
    private DefaultListModel<String> betaList;
    private boolean jmolView;
    protected OrbitalList orbitals;
    protected int viewState;
    protected static final int VIEW_STATE_MAIN = 0;
    protected static final int VIEW_STATE_PLANE = 1;
    protected static final int VIEW_STATE_VECTOR = 2;
    protected static final int VIEW_STATE_CAMERA = 3;
    protected JComboBox<String> comboBasis1;
    protected JRadioButton alphaSpin;
    protected JRadioButton betaSpin;
    protected boolean isNewModel = true;
    protected String currOrb = "";
    protected int currOrbIndex;
    private String[] plVal;
    private String[] vecVal;
    private String[] lineVal;
    private final JTextField[] vectorFields = new JTextField[8];
    private final JTextField[] planeFields = new JTextField[12];
    private final JTextField[] camFields = new JTextField[53];
    private final JTextField[] lineFields = new JTextField[7];
    private String[] camVal = new String[]{"6.43", "0.0", "0.0", "50.0", "2.0", "2.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.5", "1.0", "1.0", "1.0", "0.8", "0.0", "0.0", "1.0", "0.8", "0.4", "0.0", "1.0", "1.0", "0.5", "0.5", "0.5", "0.0", "0.7", "1.0", "0.22", "0.40", "0.10", "0.05", "0.0316", "0.0001", "0.4000", "1"};
    private String[] camFieldIDs = new String[]{"1a", "1b", "1c", "1d", "1e", "1f", "1g", "2a", "2b", "2c", "2d", "2e", "2f", "2g", "2h", "2i", "2j", "2k", "2l", "2m", "2n", "2o", "2p", "2q", "2r", "2s", "2t", "3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j", "3k", "3l", "3m", "3n", "3o", "3p", "3q", "3r", "4a", "4b", "4c", "4d", "5a", "5b", "5c", "6"};
    private int viewVectorPt = 0;
    private int viewPlanePt = 0;
    private boolean includeRydberg = false;

    protected NBOView(NBODialog dialog) {
        this.dialog = dialog;
        this.vwr = dialog.vwr;
    }

    private void clearLabelSet() {
        this.orbitalLabels = new String[8][];
    }

    private String[] getLabelSet(int ibas, boolean isAlpha) {
        return this.orbitalLabels[this.getIbasKey(ibas, isAlpha)];
    }

    private int getIbasKey(int ibas, boolean isBeta) {
        return basisLabelKey[ibas + (isBeta ? 10 : 0)];
    }

    private void addBasisLabel(int ikey, String[] tokens) {
        this.orbitalLabels[ikey] = tokens;
    }

    protected void setDefaultParameterArrays() {
        this.plVal = new String[]{"1", "2", "3", "0.5", "0.0", "0.0", "0.0", "-3.0", "3.0", "-3.0", "3.0", "25"};
        this.vecVal = new String[]{"1", "2", "0.5", "-2.0", "2.0", "-1.0", "1.0", "100"};
        this.lineVal = new String[]{"0.03", "0.05", "4", "0.05", "0.05", "0.1", "0.1"};
    }

    protected JPanel buildViewPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.viewState = 0;
        this.dialog.runScriptQueued("set bondpicking true");
        Box b = this.createViewSearchJobBox();
        if (!this.dialog.jmolOptionNONBO) {
            panel.add((Component)b, "North");
        }
        this.centerBox = NBOUtil.createTitleBox(" Select Orbital(s) ", this.createSelectOrbitalBox());
        this.centerBox.setVisible(false);
        this.centerBox.add(this.createOrbitalPanel());
        panel.add((Component)this.centerBox, "Center");
        panel.add(this.createBottomBox(), "South");
        this.updateViewSettings();
        this.dialog.inputFileHandler.setBrowseEnabled(true);
        return panel;
    }

    protected Box createViewSearchJobBox() {
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        Box topBox = NBOUtil.createTitleBox(" Select Job ", nBODialog.new NBODialog.HelpBtn("view_job_help.htm"));
        Box inputBox = NBOUtil.createBorderBox(true);
        inputBox.setPreferredSize(new Dimension(360, 50));
        inputBox.setMaximumSize(new Dimension(360, 50));
        topBox.add(inputBox);
        this.dialog.getNewInputFileHandler(3, null);
        inputBox.add(Box.createVerticalStrut(5));
        inputBox.add(this.dialog.inputFileHandler);
        return topBox;
    }

    private Component createBottomBox() {
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        this.bottomBox = NBOUtil.createTitleBox(" Display Type ", nBODialog.new NBODialog.HelpBtn("view_display_help.htm"));
        JPanel profBox = new JPanel(new GridLayout(2, 3, 0, 0));
        profBox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        profBox.setAlignmentX(0.0f);
        final JButton goBtn = new JButton("GO");
        goBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doGoPressed();
            }
        });
        ActionListener goEnableAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.setEnabled(goBtn);
            }
        };
        ButtonGroup bg = new ButtonGroup();
        this.btn1D = new JRadioButton("1D Profile");
        this.btn1D.setToolTipText("Produce profile plot from axis parameters");
        this.btn1D.addActionListener(goEnableAction);
        profBox.add(this.btn1D);
        bg.add(this.btn1D);
        this.btn2D = new JRadioButton("2D Contour");
        this.btn2D.setToolTipText("Produce contour plot from plane parameters");
        profBox.add(this.btn2D);
        this.btn2D.addActionListener(goEnableAction);
        bg.add(this.btn2D);
        this.btn3D = new JRadioButton("3D view");
        profBox.add(this.btn3D);
        this.btn3D.addActionListener(goEnableAction);
        bg.add(this.btn3D);
        this.axisBox = Box.createHorizontalBox();
        this.axisBox.setAlignmentX(0.0f);
        this.axisBox.setMaximumSize(new Dimension(120, 25));
        profBox.add(this.axisBox);
        this.planeBox = Box.createHorizontalBox();
        this.planeBox.setAlignmentX(0.0f);
        this.planeBox.setMaximumSize(new Dimension(120, 25));
        profBox.add(this.planeBox);
        profBox.add(goBtn);
        this.bottomBox.add(profBox);
        this.bottomBox.setVisible(false);
        this.setEnabled(goBtn);
        return this.bottomBox;
    }

    protected void setEnabled(JButton goBtn) {
        if (goBtn != null) {
            goBtn.setEnabled(true);
        }
        boolean axisVis = false;
        boolean planeVis = false;
        if (this.btn1D.isSelected()) {
            axisVis = true;
            planeVis = false;
        } else if (this.btn2D.isSelected()) {
            axisVis = false;
            planeVis = true;
        } else if (this.btn3D.isSelected()) {
            axisVis = false;
            planeVis = false;
        }
        this.axisBox.setVisible(axisVis && !this.jmolView);
        this.planeBox.setVisible(planeVis && !this.jmolView);
        this.dialog.repaint();
    }

    private Component createSelectOrbitalBox() {
        Box horizBox = Box.createHorizontalBox();
        this.betaList = null;
        this.alphaList = null;
        this.comboBasis1 = new JComboBox<String>(basSet);
        this.comboBasis1.setMaximumSize(new Dimension(70, 25));
        horizBox.add(this.comboBasis1);
        this.comboBasis1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBOView.this.comboBasis1.isEnabled()) {
                    NBOView.this.doSetNewBasis(false, true);
                }
            }
        });
        this.betaSpin = new JRadioButton("<html>&#x3B2</html>");
        this.alphaSpin = new JRadioButton("<html>&#x3B1</html>");
        this.alphaSpin.setSelected(true);
        ActionListener spinListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (NBOConfig.nboView) {
                    NBOView.this.dialog.runScriptQueued("select *;color bonds lightgrey");
                }
                NBOView.this.doSetNewBasis(false, true);
            }
        };
        this.alphaSpin.addActionListener(spinListener);
        this.betaSpin.addActionListener(spinListener);
        ButtonGroup spinSelection = new ButtonGroup();
        spinSelection.add(this.alphaSpin);
        spinSelection.add(this.betaSpin);
        horizBox.add(this.alphaSpin);
        horizBox.add(this.betaSpin);
        this.alphaSpin.setVisible(this.dialog.isOpenShell());
        this.betaSpin.setVisible(this.dialog.isOpenShell());
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        horizBox.add(nBODialog.new NBODialog.HelpBtn("view_orbital_help.htm"));
        return horizBox;
    }

    private Component createOrbitalPanel() {
        JPanel orbPanel = new JPanel(new BorderLayout());
        orbPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.orbScroll = new JScrollPane();
        this.orbScroll.setMaximumSize(new Dimension(355, 400));
        this.orbScroll.getViewport().setMinimumSize(new Dimension(250, 400));
        this.orbScroll.setVerticalScrollBarPolicy(21);
        orbPanel.add((Component)this.orbScroll, "Center");
        orbPanel.setAlignmentX(0.0f);
        orbPanel.add((Component)new JLabel("click to turn up to 9 orbitals on/off; hold to reverse phase"), "South");
        this.newOrbitals();
        return orbPanel;
    }

    protected void doGoPressed() {
        int n = this.orbitals.bsOn.cardinality();
        if (n > 9) {
            this.vwr.alert("More than 9 orbitals are selected!");
            return;
        }
        if (this.orbitals.bsOn.isEmpty()) {
            this.vwr.alert("Pick an orbital to plot.");
            return;
        }
        this.initializeImage();
        if (this.btn1D.isSelected()) {
            this.createImage1or2D(true);
        } else if (this.btn2D.isSelected()) {
            this.createImage1or2D(false);
        } else if (this.btn3D.isSelected()) {
            this.createImage3D();
        }
    }

    private File ensurePlotFile(int fileNum) {
        File f;
        if (fileNum == 0) {
            fileNum = 31 + this.comboBasis1.getSelectedIndex();
        }
        if (!(f = this.dialog.inputFileHandler.newNBOFile("" + fileNum)).exists() || f.length() == 0L) {
            this.dialog.runPanel.doRunGenNBOJob("PLOT");
            return null;
        }
        return f;
    }

    protected void doViewPlane() {
        this.viewPlanePt = 0;
        this.dialog.runScriptQueued("set bondpicking false");
        this.viewState = 1;
        Box box = NBOUtil.createTitleBox(" Definiton of Plane ", null);
        JPanel plane = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(6, 1, 5, 0));
        labs.add(new JLabel("Enter fraction to locate origin:"));
        labs.add(new JLabel("Enter two rotation angles:"));
        labs.add(new JLabel("Enter shift of plane along normal:"));
        labs.add(new JLabel("Enter min and max X values:"));
        labs.add(new JLabel("Enter min and max Y values:"));
        labs.add(new JLabel("Enter number of steps NX:"));
        plane.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(6, 1, 5, 0));
        in.add(this.planeFields[3]);
        Box bo = Box.createHorizontalBox();
        bo.add(this.planeFields[4]);
        bo.add(this.planeFields[5]);
        in.add(bo);
        in.add(this.planeFields[6]);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[7]);
        bo.add(this.planeFields[8]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[9]);
        bo.add(this.planeFields[10]);
        in.add(bo);
        in.add(this.planeFields[11]);
        plane.add((Component)in, "Center");
        JButton b = new JButton("OK");
        plane.add((Component)b, "South");
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(plane);
        box2.setAlignmentX(0.0f);
        box2.setMaximumSize(new Dimension(355, 250));
        box.add(box2);
        final JDialog d = new JDialog((Dialog)this.dialog, "Vector definition");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        this.centerDialog(d, 175);
        this.showSelected(this.planeFields, 3);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBOView.this.dialog.runScriptQueued("select off;set bondpicking true");
                NBOView.this.viewState = 0;
            }
        });
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBOView.this.dialog.runScriptQueued("select off;set bondpicking true");
                NBOView.this.viewState = 0;
            }
        });
        plane.setVisible(true);
    }

    private void showSelected(JTextField[] t, int n) {
        String s = "";
        int i = n;
        while (--i >= 0) {
            s = s + " " + t[i].getText();
        }
        this.dialog.showSelected(s);
    }

    protected void doViewAxis() {
        this.dialog.runScriptQueued("set bondpicking false");
        this.viewState = 2;
        this.viewVectorPt = 0;
        Box box = NBOUtil.createTitleBox(" Vector Definition ", null);
        JPanel vect = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(4, 1, 4, 0));
        labs.add(new JLabel("Enter fraction to locate origin:"));
        labs.add(new JLabel("Enter min and max X values:"));
        labs.add(new JLabel("Enter min and max function values:"));
        labs.add(new JLabel("Enter number of steps NX:"));
        vect.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 4, 0));
        in.add(this.vectorFields[2]);
        Box bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[3]);
        bo.add(this.vectorFields[4]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[5]);
        bo.add(this.vectorFields[6]);
        in.add(bo);
        in.add(this.vectorFields[7]);
        vect.add((Component)in, "Center");
        JButton b = new JButton("OK");
        Box box2 = Box.createVerticalBox();
        vect.add((Component)b, "South");
        vect.setAlignmentX(0.0f);
        box2.setAlignmentX(0.0f);
        box.setAlignmentX(0.0f);
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(vect);
        box2.setMaximumSize(new Dimension(355, 250));
        box.add(box2);
        final JDialog d = new JDialog((Dialog)this.dialog, "Vector definition");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        this.centerDialog(d, 150);
        this.showSelected(this.vectorFields, 2);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBOView.this.dialog.runScriptQueued("select off;set bondpicking true");
                NBOView.this.viewState = 0;
            }
        });
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBOView.this.dialog.runScriptQueued("select off;set bondpicking true");
                NBOView.this.viewState = 0;
            }
        });
    }

    protected void doViewLines() {
        Box box = NBOUtil.createTitleBox(" Contour lines ", null);
        JPanel lines = new JPanel(new BorderLayout());
        JPanel labs = new JPanel(new GridLayout(5, 1, 5, 0));
        labs.add(new JLabel("Enter first contour line:"));
        labs.add(new JLabel("Enter contour step size:"));
        labs.add(new JLabel("Enter number of contours:"));
        labs.add(new JLabel("Enter length of dash (cm):"));
        labs.add(new JLabel("Enter length of space (cm):"));
        lines.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(5, 1, 5, 0));
        in.add(this.lineFields[0]);
        in.add(this.lineFields[1]);
        in.add(this.lineFields[2]);
        in.add(this.lineFields[3]);
        in.add(this.lineFields[4]);
        lines.add((Component)in, "Center");
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(lines);
        box.add(box2);
        box2.setAlignmentX(0.0f);
        final JDialog d = new JDialog((Dialog)this.dialog, "Line settings");
        d.setSize(new Dimension(300, 300));
        d.setVisible(true);
        d.add(box);
        box = NBOUtil.createTitleBox(" Orbital diagram lines ", null);
        lines = new JPanel(new BorderLayout());
        labs = new JPanel(new GridLayout(2, 1, 5, 0));
        labs.add(new JLabel("Enter length of dash (cm):"));
        labs.add(new JLabel("Enter length of space (cm):"));
        lines.add((Component)labs, "West");
        in = new JPanel(new GridLayout(2, 1, 5, 0));
        in.add(this.lineFields[5]);
        in.add(this.lineFields[6]);
        lines.add((Component)in, "Center");
        box2 = Box.createVerticalBox();
        box2.setAlignmentX(0.0f);
        box2.setBorder(BorderFactory.createLineBorder(Color.black));
        box2.add(lines);
        box.add(box2);
        JButton b = new JButton("OK");
        lines.add((Component)b, "South");
        d.add((Component)box, "South");
        this.centerDialog(d, 150);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
                NBOView.this.viewState = 0;
            }
        });
        lines.setVisible(true);
    }

    private void centerDialog(JDialog d, int h) {
        int x = (this.dialog.getX() + this.dialog.getWidth()) / 2 + 150;
        int y = (this.dialog.getY() + this.dialog.getHeight()) / 2 - h;
        d.setLocation(x, y);
    }

    protected void doCam1() {
        this.viewState = 3;
        JPanel panel = new JPanel();
        JPanel cam1 = new JPanel();
        cam1.setLayout(new BorderLayout());
        cam1.setMinimumSize(new Dimension(350, 200));
        cam1.setVisible(true);
        cam1.setBorder(BorderFactory.createLineBorder(Color.black));
        Box box = NBOUtil.createTitleBox(" Camera and Light-Source ", null);
        JPanel labs = new JPanel(new GridLayout(5, 1, 5, 0));
        labs.add(new JLabel("Bounding sphere radius"));
        labs.add(new JLabel("Camera distance from screen center:"));
        labs.add(new JLabel("Two rotation angles (about X, Y):"));
        labs.add(new JLabel("Camera view angle:"));
        labs.add(new JLabel("Lighting (RL, UD, BF w.r.t. camera):"));
        cam1.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(5, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        in.add(this.camFields[52]);
        in.add(this.camFields[0]);
        bo.add(this.camFields[1]);
        bo.add(this.camFields[2]);
        in.add(bo);
        in.add(this.camFields[3]);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[4]);
        bo.add(this.camFields[5]);
        bo.add(this.camFields[6]);
        in.add(bo);
        cam1.add((Component)in, "Center");
        cam1.setAlignmentX(0.0f);
        box.add(cam1);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(box);
        this.cam2(panel);
        this.cam3(panel);
        this.cam4(panel);
        this.cam5(panel);
        JScrollPane sp = new JScrollPane();
        sp.setMaximumSize(new Dimension(350, 500));
        sp.getViewport().add(panel);
        final JDialog d = new JDialog((Dialog)this.dialog, "Camera parameters");
        d.setSize(new Dimension(360, 500));
        d.setVisible(true);
        d.add((Component)sp, "Center");
        this.centerDialog(d, 250);
        JButton b = new JButton("OK");
        d.add((Component)b, "South");
        b.setAlignmentX(0.0f);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
            }
        });
    }

    private void cam2(JPanel panel) {
        Box box = NBOUtil.createTitleBox(" Surface Optical Parameters: ", null);
        JPanel cam2 = new JPanel(new BorderLayout());
        cam2.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("atoms:"));
        labs.add(new JLabel("bonds:"));
        labs.add(new JLabel("H-bonds:"));
        labs.add(new JLabel("orbitals:"));
        cam2.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.camFields[7]);
        bo.add(this.camFields[8]);
        bo.add(this.camFields[9]);
        bo.add(this.camFields[10]);
        bo.add(this.camFields[11]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[12]);
        bo.add(this.camFields[13]);
        bo.add(this.camFields[14]);
        bo.add(this.camFields[15]);
        bo.add(this.camFields[16]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[17]);
        bo.add(this.camFields[18]);
        bo.add(this.camFields[19]);
        bo.add(this.camFields[20]);
        bo.add(this.camFields[21]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[22]);
        bo.add(this.camFields[23]);
        bo.add(this.camFields[24]);
        bo.add(this.camFields[25]);
        bo.add(this.camFields[26]);
        in.add(bo);
        cam2.add((Component)in, "Center");
        cam2.add((Component)new JLabel("                    amb              diff           spec        pow        transp"), "North");
        cam2.setAlignmentX(0.0f);
        box.add(cam2);
        panel.add(box);
    }

    private void cam3(JPanel panel) {
        JPanel cam3 = new JPanel(new BorderLayout());
        Box box = NBOUtil.createTitleBox(" Color (Blue/Green/Red) Parameters: ", null);
        cam3.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(6, 1, 5, 0));
        labs.add(new JLabel("light source color:"));
        labs.add(new JLabel("background color:"));
        labs.add(new JLabel("orbital (+ phase) color:"));
        labs.add(new JLabel("orbital (- phase) color:"));
        labs.add(new JLabel("bond color"));
        labs.add(new JLabel("H-Bond color"));
        cam3.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(6, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.camFields[27]);
        bo.add(this.camFields[28]);
        bo.add(this.camFields[29]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[30]);
        bo.add(this.camFields[31]);
        bo.add(this.camFields[32]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[33]);
        bo.add(this.camFields[34]);
        bo.add(this.camFields[35]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[36]);
        bo.add(this.camFields[37]);
        bo.add(this.camFields[38]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[39]);
        bo.add(this.camFields[40]);
        bo.add(this.camFields[41]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[42]);
        bo.add(this.camFields[43]);
        bo.add(this.camFields[44]);
        in.add(bo);
        cam3.add((Component)in, "Center");
        cam3.add((Component)new JLabel("                                                 Blue               Green             Red"), "North");
        cam3.setAlignmentX(0.0f);
        box.add(cam3);
        panel.add(box);
    }

    private void cam4(JPanel panel) {
        JPanel cam4 = new JPanel(new BorderLayout());
        Box box = NBOUtil.createTitleBox(" Atomic and Bond Radii: ", null);
        cam4.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("Atomic radius for H:"));
        labs.add(new JLabel("Atomic radius for C:"));
        labs.add(new JLabel("Bond radius:"));
        labs.add(new JLabel("H-bond radius:"));
        cam4.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        in.add(this.camFields[45]);
        in.add(this.camFields[46]);
        in.add(this.camFields[47]);
        in.add(this.camFields[48]);
        cam4.add((Component)in, "Center");
        cam4.setAlignmentX(0.0f);
        box.add(cam4);
        panel.add(box);
    }

    private void cam5(JPanel panel) {
        JPanel cam5 = new JPanel(new BorderLayout());
        Box box = NBOUtil.createTitleBox(" Contour Parameters: ", null);
        cam5.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel labs = new JPanel(new GridLayout(3, 1, 5, 0));
        labs.add(new JLabel("Contour value:"));
        labs.add(new JLabel("Contour tolerance:"));
        labs.add(new JLabel("Stepsize:"));
        cam5.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(3, 1, 5, 0));
        in.add(this.camFields[49]);
        in.add(this.camFields[50]);
        in.add(this.camFields[51]);
        cam5.add((Component)in, "Center");
        cam5.setAlignmentX(0.0f);
        box.add(cam5);
        panel.add(box);
    }

    private void newOrbitals() {
        if (this.orbitals != null) {
            this.orbitals.removeListSelectionListener(this.orbitals);
            this.orbitals.removeMouseListener(this.orbitals);
            this.orbScroll.getViewport().remove(this.orbitals);
        }
        this.orbitals = new OrbitalList();
        this.orbScroll.getViewport().add(this.orbitals);
    }

    private void updateViewSettings() {
        this.dialog.viewSettingsBox.removeAll();
        this.dialog.viewSettingsBox.setLayout(new BorderLayout());
        JLabel lab = new JLabel("Settings:");
        lab.setBackground(Color.black);
        lab.setForeground(Color.white);
        lab.setOpaque(true);
        lab.setFont(NBOConfig.nboFont);
        Box middle = Box.createVerticalBox();
        Box tmp = Box.createHorizontalBox();
        tmp.add(new JLabel("Orientation: "));
        this.atomOrient = new JRadioButton("Atoms");
        this.atomOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBOView.this.doViewByAtoms();
            }
        });
        tmp.add(this.atomOrient);
        this.jmolOrient = new JRadioButton("Jmol");
        this.jmolOrient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBOView.this.doViewByJmol();
            }
        });
        tmp.add(this.jmolOrient);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jmolOrient);
        bg.add(this.atomOrient);
        this.dialog.viewSettingsBox.add((Component)lab, "North");
        middle.add(tmp);
        tmp = Box.createHorizontalBox();
        JButton btnVec = new JButton("Axis");
        JButton btnPla = new JButton("Plane");
        JButton btnLines = new JButton("Lines");
        btnVec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doViewAxis();
            }
        });
        btnPla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doViewPlane();
            }
        });
        btnLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doViewLines();
            }
        });
        btnPla.setMargin(null);
        tmp.add(btnVec);
        tmp.add(btnPla);
        tmp.add(btnLines);
        middle.add(tmp);
        this.dialog.viewSettingsBox.add((Component)middle, "Center");
        JButton btnCam = new JButton("Camera");
        btnCam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOView.this.doCam1();
            }
        });
        this.jmolOrient.setSelected(true);
        this.dialog.viewSettingsBox.add((Component)btnCam, "South");
        this.dialog.repaint();
        this.dialog.revalidate();
    }

    protected void doViewByJmol() {
        this.jmolView = true;
        this.setEnabled(null);
    }

    protected void doViewByAtoms() {
        this.planeBox.setVisible(true);
        this.dialog.nboService.restartIfNecessary();
        this.setDefaultParameterArrays();
        this.jmolView = false;
    }

    protected File doSetNewBasis(boolean isFileLoading, boolean clearAlphaBeta) {
        DefaultListModel<String> list;
        if (clearAlphaBeta) {
            this.betaList = null;
            this.alphaList = null;
        }
        this.dialog.runScriptQueued("isosurface delete");
        this.resetCurrentOrbitalClicked();
        if (this.comboBasis1.getSelectedIndex() == 9 && !this.checkForCMO() || this.orbitals == null) {
            return null;
        }
        this.isNewModel = true;
        this.orbitals.removeAll();
        File f = this.ensurePlotFile(0);
        if (f == null) {
            return null;
        }
        this.alphaSpin.setVisible(this.dialog.isOpenShell());
        this.betaSpin.setVisible(this.dialog.isOpenShell());
        boolean isBeta = !this.isAlphaSpin();
        DefaultListModel<String> defaultListModel = list = isBeta ? this.betaList : this.alphaList;
        if (list != null && list.size() > 0) {
            this.orbitals.setModelList(list, false);
            return null;
        }
        list = new DefaultListModel();
        if (isBeta) {
            this.betaList = list;
        } else {
            this.alphaList = list;
        }
        if (isFileLoading) {
            return f;
        }
        this.dialog.logCmd("select " + this.comboBasis1.getSelectedItem() + " " + (isBeta ? "beta" : (this.dialog.isOpenShell() ? "alpha" : "")));
        int ibasis = this.comboBasis1.getSelectedIndex();
        String[] tokens = this.getLabelSet(ibasis, isBeta);
        if (tokens != null) {
            this.orbitals.loadList(tokens, list);
            return f;
        }
        if (this.dialog.jmolOptionNONBO) {
            return f;
        }
        this.postNBO_v(NBOUtil.postAddCmd(this.getMetaHeader(true, true), "LABEL"), 23, this.getIbasKey(ibasis, isBeta), list, "Getting list", null, null);
        return null;
    }

    protected boolean checkForCMO() {
        String keywords = this.dialog.runPanel.cleanNBOKeylist(this.dialog.inputFileHandler.get47KeywordsNoFile(), true);
        if (!(keywords = NBOUtil.cleanKeywordsNo_XXX(keywords)).contains("CMO")) {
            this.dialog.runPanel.doRunGenNBOJob("CMO");
            return false;
        }
        return true;
    }

    protected SB getMetaHeader(boolean addBasis, boolean addPathAndJobStem) {
        SB sb = new SB();
        if (addPathAndJobStem) {
            NBOUtil.postAddGlobalC(sb, "PATH", this.dialog.inputFileHandler.file47.getParent());
            NBOUtil.postAddGlobalC(sb, "JOBSTEM", this.dialog.inputFileHandler.jobStem);
        }
        if (addBasis) {
            NBOUtil.postAddGlobalI(sb, "BAS_1", 1, this.comboBasis1);
        }
        System.out.println("VIEW spin " + this.dialog.isOpenShell() + " " + this.isAlphaSpin());
        NBOUtil.postAddGlobalI(sb, "SPIN", !this.dialog.isOpenShell() ? 0 : (this.isAlphaSpin() ? 1 : -1), null);
        return sb;
    }

    private void appendCameraParams(SB sb) {
        int n = this.camFields.length;
        for (int i = 0; i < n; ++i) {
            NBOUtil.postAddGlobalT(sb, "CAMERA_" + this.camFieldIDs[i], this.camFields[i]);
        }
    }

    private void appendOrbitalPhaseSign(SB sb, int i) {
        NBOUtil.postAddGlobal(sb, "SIGN", this.orbitals.bsNeg.get(i) ? "-1" : "+1");
    }

    protected void createImage1or2D(boolean oneD) {
        if (this.jmolView) {
            this.setJmolView(true);
        }
        if (this.orbitals.bsOn.cardinality() > 1) {
            this.createImage1or2DMultiple(oneD);
            return;
        }
        SB sb = this.getMetaHeader(true, true);
        int ind = this.orbitals.bsOn.nextSetBit(0);
        this.appendOrbitalPhaseSign(sb, ind);
        this.appendOrientationParams(sb, oneD);
        String cmd = (oneD ? "Profile " : "Contour ") + (ind + 1);
        this.dialog.logCmd(cmd);
        NBOUtil.postAddCmd(sb, cmd);
        this.postNBO_v(sb, 13, -1, null, oneD ? "Profiling.." : "Contouring..", null, null);
    }

    private void appendOrientationParams(SB sb, boolean oneD) {
        this.appendLineParams(sb);
        if (oneD) {
            this.appendVectorParams(sb);
        } else {
            this.appendPlaneParams(sb);
        }
    }

    private void appendLineParams(SB sb) {
        for (int i = 0; i < this.lineFields.length; ++i) {
            this.lineVal[i] = this.lineFields[i].getText();
            NBOUtil.postAddGlobal(sb, "LINES_" + (char)(97 + i), this.lineVal[i]);
        }
    }

    private void appendVectorParams(SB sb) {
        for (int i = 0; i < this.vectorFields.length; ++i) {
            this.vecVal[i] = this.vectorFields[i].getText();
            NBOUtil.postAddGlobal(sb, "VECTOR_" + (char)(97 + i), this.vecVal[i]);
        }
    }

    private void appendPlaneParams(SB sb) {
        for (int i = 0; i < this.planeFields.length; ++i) {
            this.plVal[i] = this.planeFields[i].getText();
            NBOUtil.postAddGlobal(sb, "PLANE_" + (char)(97 + i), this.plVal[i]);
        }
    }

    private void setJmolView(boolean is2D) {
        String key = is2D ? "a U" : "a V_U";
        SB sb = new SB();
        for (int i = 1; i <= 3; ++i) {
            String tmp2 = "";
            for (int j = 1; j <= 3; ++j) {
                Object oi = this.vwr.getProperty("string", "orientationInfo.rotationMatrix[" + j + "][" + i + "]", null);
                tmp2 = tmp2 + oi.toString() + " ";
            }
            sb.append(key + i + " " + tmp2 + NBOUtil.sep);
        }
        this.postNBO_v(NBOUtil.postAddCmd(this.getMetaHeader(true, true), "LABEL"), 0, -1, null, "", "jview.txt", sb.toString());
        this.postNBO_v(NBOUtil.postAddCmd(new SB(), "JVIEW"), 0, -1, null, "Sending Jmol orientation", null, null);
    }

    protected void createImage1or2DMultiple(boolean oneD) {
        SB sb = new SB();
        String msg = oneD ? "Profile" : "Contour";
        String profileList = "";
        boolean needHeader = true;
        int pt = 0;
        int i = this.orbitals.bsOn.nextSetBit(0);
        while (i >= 0) {
            sb = this.getMetaHeader(needHeader, needHeader);
            needHeader = false;
            this.appendOrbitalPhaseSign(sb, i);
            this.appendOrientationParams(sb, oneD);
            NBOUtil.postAddCmd(sb, (oneD ? "PROFILE " : "CONTOUR ") + (i + 1));
            msg = msg + " " + (i + 1);
            profileList = profileList + " " + ++pt;
            this.postNBO_v(sb, 0, -1, null, "Sending " + msg, null, null);
            i = this.orbitals.bsOn.nextSetBit(i + 1);
        }
        this.dialog.logCmd(msg);
        sb = new SB();
        NBOUtil.postAddCmd(sb, "DRAW" + profileList);
        this.postNBO_v(sb, 13, -1, null, "Drawing...", null, null);
    }

    protected void createImage3D() {
        SB sb = new SB();
        String tmp = "View";
        String list = "";
        BS bs = this.orbitals.bsOn;
        int pt = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            sb = this.getMetaHeader(true, true);
            this.appendOrbitalPhaseSign(sb, i);
            NBOUtil.postAddCmd(sb, "PROFILE " + (i + 1));
            this.postNBO_v(sb, 0, -1, null, "Sending profile " + (i + 1), null, null);
            tmp = tmp + " " + (i + 1);
            list = list + " " + ++pt;
            i = bs.nextSetBit(i + 1);
        }
        this.dialog.logCmd(tmp);
        String jviewData = sb.toString();
        sb = this.getMetaHeader(false, true);
        this.appendCameraParams(sb);
        NBOUtil.postAddCmd(sb, "VIEW" + list);
        this.postNBO_v(sb, 13, -1, null, "Raytracing...", null, jviewData);
    }

    private void initializeImage() {
        if (!this.dialog.nboService.restart()) {
            return;
        }
        this.setDefaultParameterArrays();
        if (this.jmolView) {
            this.setJmolView(false);
        }
    }

    protected void notifyPick_v(int[] picked) {
        this.dialog.runScriptQueued("isosurface delete");
        int at1 = picked[0];
        int at2 = picked[1];
        block0 : switch (this.viewState) {
            case 2: {
                if (at2 != Integer.MIN_VALUE) {
                    return;
                }
                this.vectorFields[this.viewVectorPt++].setText("" + at1);
                this.showSelected(this.vectorFields, 2);
                this.viewVectorPt %= 2;
                break;
            }
            case 1: {
                if (at2 != Integer.MIN_VALUE) {
                    return;
                }
                this.planeFields[this.viewPlanePt++].setText("" + at1);
                this.showSelected(this.planeFields, 3);
                this.viewPlanePt %= 3;
                break;
            }
            case 0: {
                if (at2 == Integer.MIN_VALUE) {
                    this.showOrbital(this.nextOrbitalForAtomPick(at1, (DefaultListModel)this.orbitals.getModel()));
                    return;
                }
                switch (this.comboBasis1.getSelectedIndex()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 9: {
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        String sat1 = this.vwr.ms.at[at1 - 1].getElementSymbol() + at1;
                        String sat2 = this.vwr.ms.at[at2 - 1].getElementSymbol() + at2;
                        this.showOrbital(this.nextOrbitalForBondPick(sat1 + "(" + sat2 + ")", sat2 + "(" + at1 + ")"));
                        break block0;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        String sat1 = this.vwr.ms.at[at1 - 1].getElementSymbol() + at1;
                        String sat2 = this.vwr.ms.at[at2 - 1].getElementSymbol() + at2;
                        this.showOrbital(this.nextOrbitalForBondPick(sat1 + "-" + sat2, sat2 + "-" + sat1));
                    }
                }
            }
        }
    }

    protected int nextOrbitalForAtomPick(int atomno, AbstractListModel<String> list) {
        String at = this.vwr.ms.at[atomno - 1].getElementSymbol() + atomno + "(";
        int curr = this.currOrb.contains(at) ? this.currOrbIndex : -1;
        int size = list.getSize();
        for (int i = curr + 1; i < size + curr; ++i) {
            int ipt = i % size;
            String str = ((String)list.getElementAt(ipt)).replaceAll(" ", "");
            if (!str.contains(at + "lp)") && !str.contains(at + "lv)") && (!this.includeRydberg || !str.contains(at + "ry)"))) continue;
            this.orbitals.setSelectedIndex(ipt);
            this.currOrb = str;
            this.currOrbIndex = ipt;
            return ipt;
        }
        return curr;
    }

    private int nextOrbitalForBondPick(String b1, String b2) {
        int size = this.orbitals.getModel().getSize();
        int curr = this.currOrb.contains(b1) ? this.currOrbIndex : -1;
        for (int i = curr + 1; i < size + curr; ++i) {
            int ipt = i % size;
            String listOrb = (String)this.orbitals.getModel().getElementAt(ipt);
            String str = listOrb.replace(" ", "");
            if (!str.contains(b1) && (b2 == null || !str.contains(b2))) continue;
            this.orbitals.setSelectedIndex(ipt);
            this.currOrb = str;
            this.currOrbIndex = ipt;
            return ipt;
        }
        return curr;
    }

    protected void resetCurrentOrbitalClicked() {
        this.currOrb = "";
        this.currOrbIndex = -1;
    }

    protected void showOrbital(int i) {
        if (i < 0) {
            return;
        }
        this.orbitals.bsOn.clearAll();
        this.orbitals.bsNeg.clearAll();
        this.dialog.runScriptQueued("isosurface * off");
        this.orbitals.updateIsosurfacesInJmol(i);
    }

    protected void notifyList(AbstractListModel<String> list) {
        if (list != null) {
            this.orbitals.setLayoutOrientation(1);
            this.orbitals.requestFocus();
        }
    }

    protected void notifyFileLoaded_v() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        this.clearLabelSet();
        this.centerBox.setVisible(true);
        this.bottomBox.setVisible(!this.dialog.jmolOptionNONBO);
        Map moData = (Map)this.vwr.getCurrentModelAuxInfo().get("moData");
        String type = this.comboBasis1.getSelectedItem().toString();
        int ibas = this.comboBasis1.getSelectedIndex();
        if (type.charAt(0) == 'P') {
            type = type.substring(1);
        }
        boolean isBeta = this.dialog.isOpenShell() && !this.isAlphaSpin() && this.betaList != null;
        try {
            DefaultListModel<String> list;
            int i;
            boolean needab = this.getIbasKey(ibas, true) != this.getIbasKey(ibas, false);
            this.alphaSpin.setVisible(needab && this.dialog.isOpenShell());
            this.betaSpin.setVisible(needab && this.dialog.isOpenShell());
            this.setDefaultParameterArrays();
            for (i = 0; i < this.planeFields.length; ++i) {
                this.planeFields[i] = new JTextField(this.plVal[i]);
            }
            for (i = 0; i < this.vectorFields.length; ++i) {
                this.vectorFields[i] = new JTextField(this.vecVal[i]);
            }
            for (i = 0; i < this.lineFields.length; ++i) {
                this.lineFields[i] = new JTextField(this.lineVal[i]);
            }
            for (i = 0; i < this.camFields.length; ++i) {
                this.camFields[i] = new JTextField(this.camVal[i]);
            }
            this.axisBox.removeAll();
            this.axisBox.add(new JLabel("Axis: "));
            this.axisBox.add(this.vectorFields[0]);
            this.axisBox.add(this.vectorFields[1]);
            this.planeBox.removeAll();
            this.planeBox.add(new JLabel("Plane: "));
            this.planeBox.add(this.planeFields[0]);
            this.planeBox.add(this.planeFields[1]);
            this.planeBox.add(this.planeFields[2]);
            this.dialog.viewSettingsBox.setVisible(!this.dialog.jmolOptionNONBO);
            DefaultListModel<String> defaultListModel = list = isBeta ? this.betaList : this.alphaList;
            if (this.dialog.jmolOptionNONBO) {
                if (type.startsWith("P")) {
                    type = type.substring(1);
                }
                if (type.equalsIgnoreCase("NLMO")) {
                    type = "NBO";
                }
                String[] a = (String[])((Map)moData.get("nboLabelMap")).get((isBeta ? "beta_" : "") + type);
                list.clear();
                for (int i2 = 0; i2 < a.length; ++i2) {
                    list.addElement(i2 + 1 + ". " + a[i2] + "   ");
                }
            } else {
                this.doSetNewBasis(false, true);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        NBODialog.colorMeshes();
    }

    protected void loadNewFileIfAble() {
        if (!this.dialog.nboService.restart()) {
            return;
        }
        this.comboBasis1.setEnabled(false);
        if (this.comboBasis1.getSelectedIndex() != 9) {
            this.comboBasis1.setSelectedIndex(5);
        } else {
            this.comboBasis1.setSelectedIndex(9);
        }
        this.comboBasis1.setEnabled(true);
        File f = this.doSetNewBasis(true, true);
        if (f == null) {
            return;
        }
        this.dialog.loadModelFileQueued(f, NBOUtil.pathWithoutExtension(f.getAbsolutePath()).equals(NBOUtil.pathWithoutExtension(this.dialog.getJmolFilename())));
    }

    protected void showLewisStructure() {
        this.dialog.doSetStructure(this.isAlphaSpin() ? "alpha" : "beta");
    }

    protected boolean isAlphaSpin() {
        return !this.betaSpin.isVisible() || !this.betaSpin.isSelected();
    }

    protected void resetView() {
        this.isNewModel = true;
        this.orbitals.clearOrbitals(true);
        this.clearLabelSet();
    }

    private void postNBO_v(SB sb, final int mode, final int ikey, final DefaultListModel<String> list, String statusMessage, String dataFileName, String fileData) {
        final NBORequest req = new NBORequest();
        req.set(3, new Runnable(){

            @Override
            public void run() {
                NBOView.this.processNBO_v(req, mode, ikey, list);
            }
        }, false, statusMessage, "v_cmd.txt", sb.toString(), dataFileName, fileData);
        this.dialog.nboService.postToNBO(req);
    }

    protected void processNBO_v(NBORequest req, int mode, int ikey, DefaultListModel<String> list) {
        String[] lines = req.getReplyLines();
        switch (mode) {
            case 23: {
                this.addBasisLabel(ikey, lines);
                this.orbitals.loadList(lines, list);
                break;
            }
            case 13: {
                String fname = this.dialog.inputFileHandler.file47.getParent() + "\\" + this.dialog.inputFileHandler.jobStem + ".bmp";
                String script = "image close;image id \"\" " + PT.esc(new File(fname).toString().replace('\\', '/'));
                this.dialog.runScriptQueued(script);
                break;
            }
        }
    }

    class OrbitalList
    extends JList<String>
    implements ListSelectionListener,
    MouseListener,
    KeyListener {
        protected BS bsOn = new BS();
        protected BS bsNeg = new BS();
        protected BS bsKnownAlpha = new BS();
        protected BS bsKnownBeta = new BS();
        private JLabel cellLabel;
        protected boolean myTurn;
        protected boolean toggled;
        private static final int DBLCLICK_THRESHOLD_MS = 300;
        private Timer mouseTimer;

        public OrbitalList() {
            this.setLayoutOrientation(1);
            this.setVisibleRowCount(-1);
            this.setFont(NBOConfig.nboFontLarge);
            this.setFont(NBOConfig.listFont);
            this.setModel(new DefaultListModel<String>(){

                @Override
                public void addElement(String s) {
                    s = s + "   ";
                    super.addElement(s);
                }
            });
            this.setCellRenderer(new ListCellRenderer<String>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                    return OrbitalList.this.renderCell(index);
                }
            });
            this.addListSelectionListener(this);
            this.addMouseListener(this);
        }

        public void loadList(String[] lines, DefaultListModel<String> list) {
            list.clear();
            for (int i = 0; i < lines.length; ++i) {
                list.addElement(lines[i]);
            }
            this.setModelList(list, true);
        }

        void setModelList(DefaultListModel<String> list, boolean isNew) {
            this.setSelectedIndices(new int[0]);
            this.setModel(list);
            this.clearOrbitals(true);
            NBOView.this.showLewisStructure();
            this.updateIsosurfacesInJmol(Integer.MIN_VALUE);
        }

        protected Component renderCell(int index) {
            if (this.cellLabel == null) {
                this.cellLabel = new JLabel(){

                    @Override
                    public void setBackground(Color bg) {
                        if (OrbitalList.this.myTurn) {
                            super.setBackground(bg);
                        }
                    }
                };
                this.cellLabel.setFont(NBOConfig.listFont);
                this.cellLabel.setMinimumSize(new Dimension(180, 20));
                this.cellLabel.setPreferredSize(new Dimension(180, 20));
                this.cellLabel.setMaximumSize(new Dimension(180, 20));
                this.cellLabel.setOpaque(true);
            }
            this.cellLabel.setText((String)this.getModel().getElementAt(index));
            this.myTurn = true;
            Color bgcolor = !this.bsOn.get(index) ? Color.WHITE : (this.bsNeg.get(index) ? NBOConfig.orbColor2 : NBOConfig.orbColor1);
            this.cellLabel.setBackground(bgcolor);
            this.cellLabel.setForeground(this.getContrastColor(bgcolor));
            this.myTurn = false;
            return this.cellLabel;
        }

        private Color getContrastColor(Color bgcolor) {
            return new AwtColor(C.getArgb(C.getBgContrast(bgcolor.getRGB())));
        }

        void clearOrbitals(boolean clearAll) {
            this.bsKnownAlpha.clearAll();
            this.bsKnownBeta.clearAll();
            if (clearAll) {
                this.bsOn.clearAll();
                this.bsNeg.clearAll();
            }
        }

        protected void updateIsosurfacesInJmol(int iClicked) {
            DefaultListModel model = (DefaultListModel)this.getModel();
            String type = NBOView.this.comboBasis1.getSelectedItem().toString();
            String script = "select 1.1;";
            if (iClicked == Integer.MAX_VALUE) {
                script = script + this.updateBitSetFromModel();
            } else {
                this.updateModelFromBitSet();
            }
            boolean isBeta = !NBOView.this.isAlphaSpin();
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                boolean isOn = this.bsOn.get(i);
                if (i != iClicked && (!isOn || this.isKnownIsosurface(i)) && this.isSelectedIndex(i) == isOn) continue;
                String id = "mo" + i + (isBeta ? "beta" : "");
                if (!isOn || this.isKnownIsosurface(i)) {
                    if (isOn && this.bsNeg.get(i)) {
                        this.setKnownIsosurface(i, false);
                        this.bsNeg.clear(i);
                    }
                    isOn = !isOn;
                    this.bsOn.setBitTo(i, isOn);
                }
                if (!this.bsOn.get(i)) {
                    script = script + "isosurface " + id + " off;";
                    continue;
                }
                if (this.isKnownIsosurface(i)) {
                    script = script + "isosurface " + id + " on;";
                    continue;
                }
                this.setKnownIsosurface(i, true);
                script = script + NBOConfig.getJmolIsosurfaceScript(id, type, i + 1, isBeta, this.bsNeg.get(i));
            }
            this.updateModelFromBitSet();
            NBOView.this.dialog.runScriptQueued(script);
        }

        private String updateBitSetFromModel() {
            int[] a = this.getSelectedIndices();
            BS bsModel = new BS();
            int i = a.length;
            while (--i >= 0) {
                bsModel.set(i);
            }
            String script = "";
            int i2 = this.getModel().getSize();
            while (--i2 >= 0) {
                if (bsModel.get(i2) == this.bsOn.get(i2)) continue;
                if (this.bsOn.get(i2)) {
                    script = script + "isosurface mo" + i2 + " off;";
                    this.bsOn.clear(i2);
                    continue;
                }
                this.bsOn.set(i2);
            }
            return script;
        }

        private void updateModelFromBitSet() {
            int[] a = new int[this.bsOn.cardinality()];
            int i = this.bsOn.nextSetBit(0);
            int pt = 0;
            while (i >= 0) {
                a[pt++] = i;
                i = this.bsOn.nextSetBit(i + 1);
            }
            try {
                this.setSelectedIndices(a);
            }
            catch (Exception e) {
                System.out.println("render error " + e);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.killMouseTimer();
            this.mouseTimer = this.getMouseTimer();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.killMouseTimer();
            int i = this.getSelectedIndex();
            this.toggled = false;
            this.updateIsosurfacesInJmol(i);
        }

        private void killMouseTimer() {
            if (this.mouseTimer != null) {
                this.mouseTimer.stop();
            }
            this.mouseTimer = null;
            this.toggled = false;
        }

        private Timer getMouseTimer() {
            Timer t = new Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrbitalList.this.doHoldTimerEvent();
                }
            });
            t.setRepeats(false);
            t.start();
            System.out.println("timer started");
            return t;
        }

        protected void doHoldTimerEvent() {
            int i = this.getSelectedIndex();
            if (this.bsOn.get(i)) {
                this.toggled = true;
                this.bsNeg.setBitTo(i, !this.bsNeg.get(i));
                this.setKnownIsosurface(i, false);
                this.repaint();
            }
        }

        private void setKnownIsosurface(int i, boolean isON) {
            (NBOView.this.isAlphaSpin() ? this.bsKnownAlpha : this.bsKnownBeta).setBitTo(i, isON);
        }

        private boolean isKnownIsosurface(int i) {
            return (NBOView.this.isAlphaSpin() ? this.bsKnownAlpha : this.bsKnownBeta).get(i);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.updateIsosurfacesInJmol(Integer.MAX_VALUE);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

