/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Arrays;
import java.util.Hashtable;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class CrystalReader
extends AtomSetCollectionReader {
    private boolean isVersion3;
    private boolean isPolymer;
    private boolean isSlab;
    private boolean haveCharges;
    private boolean inputOnly;
    private boolean isLongMode;
    private boolean getLastConventional;
    private boolean havePrimitiveMapping;
    private boolean isProperties;
    private static final int STATE_NONE = 0;
    private static final int STATE_INPUT = 1;
    private static final int STATE_INPUT_FROM = 2;
    private static final int STATE_WAVEFUNCTION = 3;
    private static final int STATE_OPT_POINT = 4;
    private static final int STATE_OPT_FINAL = 5;
    private static final int STATE_FREQ = 6;
    private int state = 0;
    private int ac;
    private int atomIndexLast;
    private int[] atomFrag;
    private int[] primitiveToIndex;
    private float[] nuclearCharges;
    private Lst<String> lstCoords;
    private Double energy;
    private P3 ptOriginShift = new P3();
    private M3 primitiveToCryst;
    private V3[] directLatticeVectors;
    private String spaceGroupName;
    private boolean checkModelTrigger;
    private Lst<String> symops = new Lst();
    private final float[] f14 = new float[14];
    private final float[] f16 = new float[16];
    private static final int[] smap = new int[]{2, 3, 4, 11, 5, 6, 7, 12, 8, 9, 10, 13};
    private float primitiveVolume;
    private float primitiveDensity;
    private String firstLine;
    private Lst<String> vPrimitiveMapping;

    protected void initializeReader() throws Exception {
        this.doProcessLines = false;
        this.inputOnly = this.checkFilterKey("INPUT");
        this.isPrimitive = !this.inputOnly && !this.checkFilterKey("CONV");
        this.addVibrations &= !this.inputOnly && this.desiredModelNumber < 0;
        this.getLastConventional = !this.isPrimitive && this.desiredModelNumber == 0;
        this.setFractionalCoordinates(this.readHeader());
        this.asc.checkLatticeOnly = true;
    }

    protected boolean checkLine() throws Exception {
        if (this.firstLine != null) {
            this.line = this.firstLine;
            this.firstLine = null;
        }
        if (this.line.startsWith(" TYPE OF CALCULATION")) {
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.indexOf("DIMENSIONALITY OF THE SYSTEM") >= 0) {
            this.isPolymer = false;
            this.isSlab = false;
            this.isMolecular = false;
            if (this.line.indexOf("2") >= 0) {
                this.isSlab = true;
            } else if (this.line.indexOf("1") >= 0) {
                this.isPolymer = true;
            } else if (this.line.indexOf("0") >= 0) {
                this.isMolecular = true;
            }
            return true;
        }
        if (!this.isPolymer && this.line.indexOf("CONSTRUCTION OF A NANOTUBE FROM A SLAB") >= 0) {
            this.isPolymer = true;
            this.isSlab = false;
            return true;
        }
        if (!this.isMolecular && this.line.indexOf("* CLUSTER CALCULATION") >= 0) {
            this.isMolecular = true;
            this.isSlab = false;
            this.isPolymer = false;
            return true;
        }
        if (this.line.startsWith(" INPUT COORDINATES")) {
            this.state = 1;
            if (this.inputOnly) {
                this.readCoordLines();
                this.processCoordLines();
                this.continuing = false;
            }
            return true;
        }
        if (this.line.startsWith(" GEOMETRY INPUT FROM EXTERNAL")) {
            this.state = 2;
            if (this.inputOnly) {
                this.continuing = false;
            }
            return true;
        }
        if (this.line.startsWith(" GEOMETRY FOR WAVE FUNCTION")) {
            this.state = 3;
            return true;
        }
        if (this.line.startsWith(" COORDINATE OPTIMIZATION - POINT")) {
            this.state = 4;
            return true;
        }
        if (this.line.startsWith(" FINAL OPTIMIZED GEOMETRY")) {
            this.getLastConventional = false;
            this.state = 5;
            return true;
        }
        if (this.addVibrations && this.line.contains(this.isVersion3 ? "EIGENVALUES (EV) OF THE MASS" : "EIGENVALUES (EIGV) OF THE MASS") || this.line.indexOf("LONGITUDINAL OPTICAL (LO)") >= 0) {
            this.state = 6;
            this.isLongMode = this.line.indexOf("LONGITUDINAL OPTICAL (LO)") >= 0;
            this.readFrequencies();
            return true;
        }
        if (this.line.startsWith(" TRANSFORMATION MATRIX")) {
            this.readPrimitiveLatticeVectors();
            return true;
        }
        if (this.line.startsWith(" COORDINATES OF THE EQUIVALENT ATOMS") || this.line.startsWith(" INPUT LIST - ATOM N.")) {
            this.readPrimitiveMapping();
            return true;
        }
        if (this.line.indexOf("SYMMOPS - ") >= 0) {
            this.readSymmetryOperators();
            return true;
        }
        if (this.line.startsWith(" LATTICE PARAMETER")) {
            this.newLattice(this.line.indexOf("- CONVENTIONAL") >= 0);
            return true;
        }
        if (this.line.startsWith(" CRYSTALLOGRAPHIC CELL")) {
            if (!this.isPrimitive) {
                this.newLattice(true);
            }
            return true;
        }
        if (this.line.startsWith(" DIRECT LATTICE VECTOR")) {
            this.getDirect();
            return true;
        }
        if (this.line.startsWith(" COORDINATES IN THE CRYSTALLOGRAPHIC CELL")) {
            boolean bl = this.checkModelTrigger = !this.isPrimitive;
            if (this.checkModelTrigger) {
                this.readCoordLines();
            }
            return true;
        }
        if (this.addVibrations && this.line.startsWith(" FREQUENCIES COMPUTED ON A FRAGMENT")) {
            this.readFreqFragments();
            return true;
        }
        if (this.checkModelTrigger && (this.line.indexOf("CARTESIAN COORDINATES") >= 0 || this.line.indexOf("TOTAL ENERGY") >= 0 || this.line.indexOf("REFERENCE GEOMETRY DEFINED") >= 0)) {
            this.checkModelTrigger = false;
            if (!this.addModel()) {
                return true;
            }
        }
        if (this.line.startsWith(" ATOMS IN THE ASYMMETRIC UNIT")) {
            if (this.isMolecular) {
                if (!this.doGetModel(++this.modelNumber, null)) {
                    return this.checkLastModel();
                }
                return this.readAtoms();
            }
            this.readCoordLines();
            this.checkModelTrigger = true;
        }
        if (this.isProperties && this.line.startsWith("   ATOM N.AT.")) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            return this.readAtoms();
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" TOTAL ENERGY(")) {
            this.line = PT.rep((String)this.line, (String)"( ", (String)"(");
            String[] tokens = this.getTokens();
            this.energy = Double.parseDouble(tokens[2]);
            this.setEnergy();
            this.rd();
            if (this.line.startsWith(" ********")) {
                this.discardLinesUntilContains("SYMMETRY ALLOWED");
            } else if (this.line.startsWith(" TTTTTTTT")) {
                this.discardLinesUntilContains2("PREDICTED ENERGY CHANGE", "HHHHHHH");
            }
            return true;
        }
        if (this.line.startsWith(" MULLIKEN POPULATION ANALYSIS")) {
            return this.readPartialCharges();
        }
        if (this.line.startsWith(" TOTAL ATOMIC CHARGES")) {
            return this.readTotalAtomicCharges();
        }
        if (this.line.startsWith(" MAX GRADIENT")) {
            return this.readGradient();
        }
        if (this.line.startsWith(" ATOMIC SPINS SET")) {
            return this.readData("spin", 3);
        }
        if (this.line.startsWith(" TOTAL ATOMIC SPINS  :")) {
            return this.readData("magneticMoment", 1);
        }
        if (this.line.startsWith(" BORN CHARGE TENSOR.")) {
            return this.readBornChargeTensors();
        }
        if (!this.isProperties) {
            return true;
        }
        if (this.line.startsWith(" DEFINITION OF TRACELESS")) {
            return this.getQuadrupoleTensors();
        }
        if (this.line.startsWith(" MULTIPOLE ANALYSIS BY ATOMS")) {
            this.appendLoadNote("Multipole Analysis");
            return true;
        }
        return true;
    }

    private void newLattice(boolean isConv) throws Exception {
        this.lstCoords = null;
        this.readLatticeParams(!isConv);
        this.symops.clear();
        this.primitiveToCryst = null;
        this.directLatticeVectors = null;
    }

    private boolean addModel() throws Exception {
        if (this.getLastConventional) {
            return true;
        }
        if (!this.doGetModel(++this.modelNumber, null)) {
            this.lstCoords = null;
            this.checkLastModel();
            if (this.asc.iSet >= 0) {
                this.asc.removeAtomSet(this.asc.iSet);
            }
            return false;
        }
        this.processCoordLines();
        return true;
    }

    private void readSymmetryOperators() throws Exception {
        this.symops.clear();
        this.rd();
        this.f16[15] = 1.0f;
        while (this.rd() != null && this.line.length() > 0 && this.line.indexOf("END") < 0) {
            this.fillFloatArray(this.line, 0, this.f14);
            for (int i = 0; i < 12; ++i) {
                this.f16[i] = this.f14[smap[i]];
            }
            String xyz = SymmetryOperation.getXYZFromMatrix((M4)M4.newA16((float[])this.f16), (boolean)false, (boolean)false, (boolean)false);
            this.symops.addLast((Object)xyz);
            Logger.info((String)("state:" + this.state + " Symmop " + this.symops.size() + ": " + xyz));
        }
    }

    private void setSymmOps() {
        if (this.isPrimitive) {
            int n = this.symops.size();
            for (int i = 0; i < n; ++i) {
                this.setSymmetryOperator((String)this.symops.get(i));
            }
        }
    }

    protected void finalizeSubclassReader() throws Exception {
        this.processCoordLines();
        if (this.energy != null) {
            this.setEnergy();
        }
        this.finalizeReaderASCR();
    }

    private void getDirect() throws Exception {
        this.directLatticeVectors = this.read3Vectors(this.line.indexOf("(BOHR") >= 0);
    }

    private void setUnitCellOrientation() {
        if (this.directLatticeVectors == null) {
            return;
        }
        V3 a = new V3();
        V3 b = new V3();
        if (this.isPrimitive) {
            a = this.directLatticeVectors[0];
            b = this.directLatticeVectors[1];
        } else {
            if (this.primitiveToCryst == null) {
                return;
            }
            M3 mp = new M3();
            mp.setColumnV(0, (T3)this.directLatticeVectors[0]);
            mp.setColumnV(1, (T3)this.directLatticeVectors[1]);
            mp.setColumnV(2, (T3)this.directLatticeVectors[2]);
            mp.mul(this.primitiveToCryst);
            a = new V3();
            b = new V3();
            mp.getColumnV(0, (T3)a);
            mp.getColumnV(1, (T3)b);
        }
        this.matUnitCellOrientation = Quat.getQuaternionFrame((P3)new P3(), (T3)a, (T3)b).getMatrix();
        Logger.info((String)("oriented unit cell is in model " + this.asc.atomSetCount));
    }

    private void readPrimitiveLatticeVectors() throws Exception {
        this.primitiveToCryst = M3.newA9((float[])this.fillFloatArray(null, 0, new float[9]));
    }

    private boolean readShift() {
        String[] tokens = this.getTokens();
        int pt = tokens.length - 3;
        this.ptOriginShift.set(PT.parseFloatFraction((String)tokens[pt++]), PT.parseFloatFraction((String)tokens[pt++]), PT.parseFloatFraction((String)tokens[pt]));
        return true;
    }

    private boolean readHeader() throws Exception {
        String name;
        this.havePrimitiveMapping = true;
        this.discardLinesUntilContains("*******************************************************************************");
        this.readLines(2);
        this.isVersion3 = this.line.indexOf("CRYSTAL03") >= 0;
        this.discardLinesUntilContains("EEEEEEEEEE");
        if (this.rd().length() == 0) {
            name = this.readLines(2).trim();
        } else {
            name = this.line.trim();
            this.rd();
        }
        String type = this.rd().trim();
        int pt = type.indexOf("- PROPERTIES");
        if (pt >= 0) {
            this.isProperties = true;
            type = type.substring(0, pt).trim();
        }
        this.asc.setCollectionName(name + (!this.isProperties && this.desiredModelNumber == 0 ? " (optimized)" : ""));
        if (type.indexOf("GEOMETRY INPUT FROM EXTERNAL FILE") >= 0) {
            this.firstLine = this.line;
            type = this.rd().trim();
        }
        this.isPolymer = type.equals("1D - POLYMER") || type.equals("POLYMER CALCULATION");
        boolean bl = this.isSlab = type.equals("2D - SLAB") || type.equals("SLAB CALCULATION");
        this.asc.setInfo("symmetryType", (Object)(this.isSlab ? "2D - SLAB" : (this.isPolymer ? "1D - POLYMER" : type)));
        if ((this.isPolymer || this.isSlab) && !this.isPrimitive) {
            Logger.error((String)"Cannot use FILTER \"conventional\" with POLYMER or SLAB");
            this.isPrimitive = true;
        }
        this.asc.setInfo("unitCellType", (Object)(this.isPrimitive ? "primitive" : "conventional"));
        if (type.indexOf("MOLECULAR") >= 0) {
            this.doProcessLines = true;
            this.isMolecular = true;
            this.rd();
            this.asc.setInfo("molecularCalculationPointGroup", (Object)this.line.substring(this.line.indexOf(" OR ") + 4).trim());
            return false;
        }
        this.discardLinesUntilContains2("SPACE GROUP", "****");
        pt = this.line.indexOf(":");
        if (pt >= 0 && !this.isPrimitive) {
            this.spaceGroupName = this.line.substring(pt + 1).trim();
        }
        this.doApplySymmetry = this.isProperties;
        return !this.isProperties;
    }

    private void readLatticeParams(boolean isNewSet) throws Exception {
        float f;
        float f2 = f = this.line.indexOf("(BOHR") >= 0 ? 0.5291772f : 1.0f;
        if (isNewSet) {
            this.newAtomSet();
        }
        this.primitiveVolume = 0.0f;
        this.primitiveDensity = 0.0f;
        if (this.isPolymer && !this.isPrimitive) {
            this.setUnitCell(this.parseFloatStr(this.line.substring(this.line.indexOf("CELL") + 4)) * f, -1.0f, -1.0f, 90.0f, 90.0f, 90.0f);
        } else {
            while (this.rd().indexOf("GAMMA") < 0) {
                if (this.line.indexOf("VOLUME=") < 0) continue;
                this.primitiveVolume = this.parseFloatStr(this.line.substring(43));
                this.primitiveDensity = this.parseFloatStr(this.line.substring(66));
            }
            String[] tokens = PT.getTokens((String)this.rd());
            if (this.isSlab) {
                if (this.isPrimitive) {
                    this.setUnitCell(this.parseFloatStr(tokens[0]) * f, this.parseFloatStr(tokens[1]) * f, -1.0f, this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[4]), this.parseFloatStr(tokens[5]));
                } else {
                    this.setUnitCell(this.parseFloatStr(tokens[0]) * f, this.parseFloatStr(tokens[1]) * f, -1.0f, 90.0f, 90.0f, this.parseFloatStr(tokens[2]));
                }
            } else if (this.isPolymer) {
                this.setUnitCell(this.parseFloatStr(tokens[0]) * f, -1.0f, -1.0f, this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[4]), this.parseFloatStr(tokens[5]));
            } else {
                this.setUnitCell(this.parseFloatStr(tokens[0]) * f, this.parseFloatStr(tokens[1]) * f, this.parseFloatStr(tokens[2]) * f, this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[4]), this.parseFloatStr(tokens[5]));
            }
        }
    }

    private void readPrimitiveMapping() throws Exception {
        if (this.havePrimitiveMapping) {
            return;
        }
        this.vPrimitiveMapping = new Lst();
        while (this.rd() != null && this.line.indexOf("NUMBER") < 0) {
            this.vPrimitiveMapping.addLast((Object)this.line);
        }
    }

    private void setPrimitiveMapping() throws Exception {
        if (this.havePrimitiveMapping || this.lstCoords == null || this.vPrimitiveMapping == null) {
            return;
        }
    }

    private int getAtomIndexFromPrimitiveIndex(int iPrim) {
        return this.primitiveToIndex == null ? iPrim : this.primitiveToIndex[iPrim];
    }

    private boolean readAtoms() throws Exception {
        if (this.isMolecular) {
            this.newAtomSet();
        }
        this.lstCoords = null;
        while (this.rd() != null && this.line.indexOf("*") < 0) {
            if (this.line.indexOf("X(ANGSTROM") < 0) continue;
            this.setFractionalCoordinates(false);
            this.isMolecular = true;
        }
        int i = this.atomIndexLast;
        boolean doNormalizePrimitive = false;
        this.atomIndexLast = this.asc.ac;
        while (this.rd() != null && this.line.length() > 0 && this.line.indexOf(this.isPrimitive ? "*" : "=") < 0) {
            Atom atom = this.asc.addNewAtom();
            String[] tokens = this.getTokens();
            int pt = this.isProperties ? 1 : 2;
            atom.elementSymbol = CrystalReader.getElementSymbol((int)this.getAtomicNumber(tokens[pt++]));
            atom.atomName = CrystalReader.fixAtomName(tokens[pt++]);
            if (this.isProperties) {
                // empty if block
            }
            int n = ++pt;
            float x = this.parseFloatStr(tokens[n]);
            int n2 = ++pt;
            float y = this.parseFloatStr(tokens[n2]);
            float z = this.parseFloatStr(tokens[++pt]);
            if (this.haveCharges) {
                atom.partialCharge = this.asc.atoms[i++].partialCharge;
            }
            if (this.iHaveFractionalCoordinates && !this.isProperties) {
                if (x < 0.0f && (this.isPolymer || this.isSlab || doNormalizePrimitive)) {
                    x += 1.0f;
                }
                if (y < 0.0f && (this.isSlab || doNormalizePrimitive)) {
                    y += 1.0f;
                }
                if (z < 0.0f && doNormalizePrimitive) {
                    z += 1.0f;
                }
            }
            this.setAtomCoordXYZ(atom, x, y, z);
        }
        this.ac = this.asc.ac - this.atomIndexLast;
        return true;
    }

    private static String fixAtomName(String s) {
        return s.length() > 1 && PT.isLetter((char)s.charAt(1)) ? s.substring(0, 1) + Character.toLowerCase(s.charAt(1)) + s.substring(2) : s;
    }

    private int getAtomicNumber(String token) {
        return this.parseIntStr(token) % 100;
    }

    private void readCoordLines() throws Exception {
        if (this.line.indexOf("  ATOM") < 0) {
            this.discardLinesUntilContains("  ATOM");
        }
        this.lstCoords = new Lst();
        while (this.rd() != null && this.line.length() > 0) {
            if (this.line.indexOf("****") >= 0) continue;
            this.lstCoords.addLast((Object)this.line);
        }
        this.setPrimitiveMapping();
    }

    private void processCoordLines() throws Exception {
        if (this.lstCoords == null) {
            return;
        }
        this.ac = this.lstCoords.size();
        float[] irreducible = null;
        for (int i = 0; i < this.ac; ++i) {
            int offset;
            int atomicNumber;
            Atom atom = this.asc.addNewAtom();
            String[] tokens = PT.getTokens((String)((String)this.lstCoords.get(i)));
            atom.atomSerial = this.parseIntStr(tokens[0]);
            switch (tokens.length) {
                case 7: 
                case 8: {
                    atomicNumber = this.getAtomicNumber(tokens[2]);
                    offset = 4;
                    if (i == 0) {
                        irreducible = new float[this.ac];
                    }
                    if (!tokens[1].equals("T")) break;
                    irreducible[i] = 1.0f;
                    break;
                }
                default: {
                    atomicNumber = this.getAtomicNumber(tokens[1]);
                    offset = 2;
                }
            }
            float x = this.parseFloatStr(tokens[offset++]) + this.ptOriginShift.x;
            float y = this.parseFloatStr(tokens[offset++]) + this.ptOriginShift.y;
            float z = this.parseFloatStr(tokens[offset]) + this.ptOriginShift.z;
            this.setAtomCoordXYZ(atom, x, y, z);
            atom.elementSymbol = CrystalReader.getElementSymbol((int)atomicNumber);
        }
        this.lstCoords = null;
        if (irreducible != null) {
            this.asc.setAtomProperties("irreducible", irreducible, -1, false);
        }
        if (this.primitiveVolume > 0.0f) {
            this.asc.setAtomSetModelProperty("volumePrimitive", DF.formatDecimal((float)this.primitiveVolume, (int)3));
            this.asc.setModelInfoForSet("primitiveVolume", (Object)Float.valueOf(this.primitiveVolume), this.asc.iSet);
        }
        if (this.primitiveDensity > 0.0f) {
            this.asc.setAtomSetModelProperty("densityPrimitive", DF.formatDecimal((float)this.primitiveDensity, (int)3));
            this.asc.setModelInfoForSet("primitiveDensity", (Object)Float.valueOf(this.primitiveDensity), this.asc.iSet);
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        this.setUnitCellOrientation();
        if (!this.isPrimitive) {
            this.setSymmOps();
        }
        this.applySymTrajASCR();
    }

    private void newAtomSet() throws Exception {
        if (this.ac > 0 && this.asc.ac > 0) {
            this.applySymmetryAndSetTrajectory();
            this.asc.newAtomSet();
        }
        if (this.spaceGroupName != null) {
            this.setSpaceGroupName(this.spaceGroupName);
        }
        this.ac = 0;
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.energy, this.energy.floatValue());
        this.asc.setCurrentModelInfo("Energy", (Object)this.energy);
        this.asc.setInfo("Energy", (Object)this.energy);
        this.asc.setAtomSetName("Energy = " + this.energy + " Hartree");
    }

    private boolean readPartialCharges() throws Exception {
        if (this.haveCharges || this.asc.ac == 0) {
            return true;
        }
        this.haveCharges = true;
        this.readLines(3);
        Atom[] atoms = this.asc.atoms;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        int iPrim = 0;
        while (this.rd() != null && this.line.length() > 3) {
            if (this.line.charAt(3) == ' ') continue;
            int iConv = this.getAtomIndexFromPrimitiveIndex(iPrim);
            if (iConv >= 0) {
                atoms[i0 + iConv].partialCharge = this.parseFloatRange(this.line, 9, 11) - this.parseFloatRange(this.line, 12, 18);
            }
            ++iPrim;
        }
        return true;
    }

    private boolean readTotalAtomicCharges() throws Exception {
        SB data = new SB();
        while (this.rd() != null && this.line.indexOf("T") < 0) {
            data.append(this.line);
        }
        String[] tokens = PT.getTokens((String)data.toString());
        float[] charges = new float[tokens.length];
        if (this.nuclearCharges == null) {
            this.nuclearCharges = charges;
        }
        if (this.asc.ac == 0) {
            return true;
        }
        Atom[] atoms = this.asc.atoms;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        for (int i = 0; i < charges.length; ++i) {
            int iConv = this.getAtomIndexFromPrimitiveIndex(i);
            if (iConv < 0) continue;
            charges[i] = this.parseFloatStr(tokens[i]);
            atoms[i0 + iConv].partialCharge = this.nuclearCharges[i] - charges[i];
        }
        return true;
    }

    private void readFreqFragments() throws Exception {
        int numAtomsFrag = this.parseIntRange(this.line, 39, 44);
        if (numAtomsFrag < 0) {
            return;
        }
        this.atomFrag = new int[numAtomsFrag];
        String Sfrag = "";
        while (this.rd() != null && this.line.indexOf("(") >= 0) {
            Sfrag = Sfrag + this.line;
        }
        Sfrag = PT.rep((String)Sfrag, (String)"(", (String)" ");
        Sfrag = PT.rep((String)Sfrag, (String)")", (String)" ");
        String[] tokens = PT.getTokens((String)Sfrag);
        int i = 0;
        int pos = 0;
        while (i < numAtomsFrag) {
            this.atomFrag[i] = this.getAtomIndexFromPrimitiveIndex(this.parseIntStr(tokens[pos]) - 1);
            ++i;
            pos += 3;
        }
        Arrays.sort(this.atomFrag);
    }

    private void readFrequencies() throws Exception {
        this.getLastConventional = false;
        this.addModel();
        this.energy = null;
        this.discardLinesUntilContains("MODES");
        boolean haveIntensities = this.line.indexOf("INTENS") >= 0;
        this.rd();
        Lst vData = new Lst();
        int freqAtomCount = this.ac;
        while (this.rd() != null && this.line.length() > 0) {
            int i0 = this.parseIntRange(this.line, 1, 5);
            int i1 = this.parseIntRange(this.line, 6, 10);
            String irrep = (this.isLongMode ? this.line.substring(48, 51) : this.line.substring(49, 52)).trim();
            String intens = !haveIntensities ? "not available" : (this.isLongMode ? this.line.substring(53, 61) : this.line.substring(59, 69).replace(')', ' ')).trim();
            String irActivity = this.isLongMode ? "A" : this.line.substring(55, 58).trim();
            String ramanActivity = this.isLongMode ? "I" : this.line.substring(71, 73).trim();
            String[] data = new String[]{irrep, intens, irActivity, ramanActivity};
            for (int i = i0; i <= i1; ++i) {
                vData.addLast((Object)data);
            }
        }
        String test = this.isLongMode ? "LO MODES FOR IRREP" : (this.isVersion3 ? "THE CORRESPONDING MODES" : "NORMAL MODES NORMALIZED TO CLASSICAL AMPLITUDES");
        this.rd();
        Lst<String> ramanData = null;
        if (this.line.indexOf("<RAMAN>") >= 0) {
            ramanData = this.readRaman(null);
        }
        if (!this.line.contains(test)) {
            this.discardLinesUntilContains(test);
        }
        this.rd();
        int modelAtomCount = -1;
        while (this.rd() != null && this.line.startsWith(" FREQ(CM**-1)")) {
            String[] tokens = PT.getTokens((String)this.line.substring(15));
            float[] frequencies = new float[tokens.length];
            int frequencyCount = frequencies.length;
            for (int i = 0; i < frequencyCount; ++i) {
                frequencies[i] = this.parseFloatStr(tokens[i]);
                if (!this.debugging) continue;
                Logger.debug((String)(this.vibrationNumber + i + " frequency=" + frequencies[i]));
            }
            boolean[] ignore = new boolean[frequencyCount];
            int iAtom0 = 0;
            int nData = vData.size();
            boolean isFirst = true;
            for (int i = 0; i < frequencyCount; ++i) {
                tokens = (String[])vData.get(this.vibrationNumber % nData);
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber) || tokens == null;
                if (ignore[i]) continue;
                this.applySymmetryAndSetTrajectory();
                if (isFirst) {
                    modelAtomCount = this.asc.getLastAtomSetAtomCount();
                }
                this.cloneLastAtomSet(this.ac, null);
                if (isFirst) {
                    iAtom0 = this.asc.getLastAtomSetAtomIndex();
                    isFirst = false;
                }
                this.setFreqValue(frequencies[i], tokens);
            }
            this.rd();
            this.fillFrequencyData(iAtom0, freqAtomCount, modelAtomCount, ignore, false, 14, 10, this.atomFrag, 0, null);
            this.rd();
        }
        if (ramanData != null) {
            this.readRaman(ramanData);
        }
    }

    private void setFreqValue(float freq, String[] data) {
        String activity = "IR: " + data[2] + ", Ram.: " + data[3];
        this.asc.setAtomSetFrequency(this.vibrationNumber, null, activity, "" + freq, null);
        this.asc.setAtomSetModelProperty("IRintensity", data[1] + " km/Mole");
        this.asc.setAtomSetModelProperty("vibrationalSymmetry", data[0]);
        this.asc.setAtomSetModelProperty("IRactivity", data[2]);
        this.asc.setAtomSetModelProperty("Ramanactivity", data[3]);
        this.asc.setAtomSetName((this.isLongMode ? "LO " : "") + data[0] + " " + DF.formatDecimal((float)freq, (int)2) + " cm-1 (" + DF.formatDecimal((float)Float.parseFloat(data[1]), (int)0) + " km/Mole), " + activity);
    }

    private Lst<String> readRaman(Lst<String> ramanData) throws Exception {
        int mode2;
        int mode1;
        int i;
        if (ramanData == null) {
            ramanData = new Lst();
            this.rd();
            while (this.rd() != null && !this.line.contains("<RAMAN>")) {
                ramanData.addLast((Object)this.line);
            }
            return ramanData;
        }
        int n = ramanData.size();
        for (i = 0; i < n; ++i) {
            this.line = (String)ramanData.get(i);
            if (this.line.contains("---")) break;
        }
        ++i;
        while (i < n) {
            this.line = (String)ramanData.get(i);
            if (this.line.length() == 0) break;
            mode1 = this.parseIntRange(this.line, 1, 5);
            mode2 = this.parseIntRange(this.line, 6, 10);
            float i_tot = this.parseFloatRange(this.line, 30, 40);
            float i_par = this.parseFloatRange(this.line, 40, 50);
            float i_perp = this.parseFloatRange(this.line, 50, 60);
            int i0 = 0;
            for (int mode = mode1; mode <= mode2; ++mode) {
                int imodel = this.getModelForMode(i0, mode);
                if (imodel < 0) continue;
                i0 = imodel + 1;
                Hashtable<String, float[]> info = (Hashtable<String, float[]>)this.asc.getAtomSetAuxiliaryInfoValue(imodel, "ramanInfo");
                if (info == null) {
                    info = new Hashtable<String, float[]>();
                    this.asc.setModelInfoForSet("ramanInfo", info, imodel);
                }
                info.put("isotropicIntensities", new float[]{i_tot, i_par, i_perp});
            }
            ++i;
        }
        while (i < n) {
            this.line = (String)ramanData.get(i);
            if (this.line.contains("---")) break;
            ++i;
        }
        ++i;
        while (i < n) {
            this.line = (String)ramanData.get(i);
            if (this.line.length() == 0) break;
            mode1 = this.parseIntRange(this.line, 1, 5);
            mode2 = this.parseIntRange(this.line, 6, 10);
            float i_xx = this.parseFloatRange(this.line, 30, 38);
            float i_xy = this.parseFloatRange(this.line, 38, 46);
            float i_xz = this.parseFloatRange(this.line, 46, 54);
            float i_yy = this.parseFloatRange(this.line, 54, 62);
            float i_yz = this.parseFloatRange(this.line, 62, 70);
            float i_zz = this.parseFloatRange(this.line, 70, 78);
            int i0 = 0;
            for (int mode = mode1; mode <= mode2; ++mode) {
                int imodel = this.getModelForMode(i0, mode);
                if (imodel < 0) continue;
                i0 = imodel + 1;
                double[][] a = new double[][]{{i_xx, i_xy, i_xz}, {i_xy, i_yy, i_yz}, {i_xz, i_yz, i_zz}};
                this.asc.atoms[this.asc.getAtomSetAtomIndex(imodel)].addTensor(new Tensor().setFromAsymmetricTensor((double[][])a, "raman", "mode" + mode), "raman", false);
            }
            ++i;
        }
        this.appendLoadNote("Ellipsoids set \"raman\": Raman tensors");
        return null;
    }

    private int getModelForMode(int i0, int mode) {
        int n = this.asc.atomSetCount;
        for (int i = i0; i < n; ++i) {
            int m;
            Integer imode = (Integer)this.asc.getAtomSetAuxiliaryInfoValue(i, "vibrationalMode");
            int n2 = m = imode == null ? 0 : imode;
            if (m != mode) continue;
            return i;
        }
        return -1;
    }

    private boolean readGradient() throws Exception {
        String key = null;
        while (this.line != null) {
            String[] tokens = this.getTokens();
            if (this.line.indexOf("MAX GRAD") >= 0) {
                key = "maxGradient";
            } else if (this.line.indexOf("RMS GRAD") >= 0) {
                key = "rmsGradient";
            } else if (this.line.indexOf("MAX DISP") >= 0) {
                key = "maxDisplacement";
            } else {
                if (this.line.indexOf("RMS DISP") < 0) break;
                key = "rmsDisplacement";
            }
            if (this.asc.ac > 0) {
                this.asc.setAtomSetModelProperty(key, tokens[2]);
            }
            this.rd();
        }
        return true;
    }

    private boolean readData(String name, int nfields) throws Exception {
        this.processCoordLines();
        float[] f = new float[this.ac];
        for (int i = 0; i < this.ac; ++i) {
            f[i] = 0.0f;
        }
        String data = "";
        while (this.rd() != null && (this.line.length() < 4 || PT.isDigit((char)this.line.charAt(3)))) {
            data = data + this.line;
        }
        data = PT.rep((String)data, (String)"-", (String)" -");
        String[] tokens = PT.getTokens((String)data);
        int i = 0;
        int pt = nfields - 1;
        while (i < this.ac) {
            int iConv = this.getAtomIndexFromPrimitiveIndex(i);
            if (iConv >= 0) {
                f[iConv] = this.parseFloatStr(tokens[pt]);
            }
            ++i;
            pt += nfields;
        }
        this.asc.setAtomProperties(name, (Object)f, -1, false);
        return true;
    }

    private boolean getQuadrupoleTensors() throws Exception {
        this.readLines(6);
        Atom[] atoms = this.asc.atoms;
        V3[] vectors = new V3[3];
        if (this.directLatticeVectors == null) {
            vectors = new V3[]{V3.new3((float)1.0f, (float)0.0f, (float)0.0f), V3.new3((float)0.0f, (float)1.0f, (float)0.0f), V3.new3((float)0.0f, (float)0.0f, (float)1.0f)};
        } else {
            for (int i = 0; i < 3; ++i) {
                vectors[i] = V3.newV((T3)this.directLatticeVectors[i]);
                vectors[i].normalize();
            }
        }
        while (this.rd() != null && this.line.startsWith(" *** ATOM")) {
            String[] tokens = this.getTokens();
            int index = this.parseIntStr(tokens[3]) - 1;
            tokens = PT.getTokens((String)this.readLines(3));
            atoms[index].addTensor(new Tensor().setFromEigenVectors(vectors, new float[]{this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[3]), this.parseFloatStr(tokens[5])}, "quadrupole", atoms[index].atomName, null), null, false);
            this.rd();
        }
        this.appendLoadNote("Ellipsoids set \"quadrupole\": Quadrupole tensors");
        return true;
    }

    private boolean readBornChargeTensors() throws Exception {
        this.processCoordLines();
        this.rd();
        Atom[] atoms = this.asc.atoms;
        while (this.rd().startsWith(" ATOM")) {
            int index = this.parseIntAt(this.line, 5) - 1;
            Atom atom = atoms[index];
            this.readLines(2);
            double[][] a = new double[3][3];
            for (int i = 0; i < 3; ++i) {
                String[] tokens = PT.getTokens((String)this.rd());
                for (int j = 0; j < 3; ++j) {
                    a[i][j] = this.parseFloatStr(tokens[j + 1]);
                }
            }
            atom.addTensor(new Tensor().setFromAsymmetricTensor(a, "charge", atom.elementSymbol + (index + 1)), null, false);
            this.rd();
        }
        this.appendLoadNote("Ellipsoids set \"charge\": Born charge tensors");
        return false;
    }
}

