/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolNMRInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.Model;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class NMRCalculation
implements JmolNMRInterface {
    private static final int MAGNETOGYRIC_RATIO = 1;
    private static final int QUADRUPOLE_MOMENT = 2;
    private static final double e_charge = 1.60217646E-19;
    private static final double h_planck = 6.62606957E-34;
    private static final double h_bar_planck = 1.0545717253362894E-34;
    private static final double DIPOLAR_FACTOR = 1054.5717253362893;
    private static final double J_FACTOR = 0.0167840302932219;
    private static final double Q_FACTOR = 2.349647144641375E8;
    private Viewer vwr;
    private Map<String, double[]> isotopeData;
    private static final String resource = "nmr_data.txt";
    private Map<String, Float> shiftRefsPPM = new Hashtable<String, Float>();

    public JmolNMRInterface setViewer(Viewer vwr) {
        this.vwr = vwr;
        this.getData();
        return this;
    }

    public float getQuadrupolarConstant(Tensor efg) {
        if (efg == null) {
            return 0.0f;
        }
        Atom a = this.vwr.ms.at[efg.atomIndex1];
        return (float)(this.getIsotopeData(a, 2) * (double)efg.eigenValues[2] * 2.349647144641375E8);
    }

    private Lst<Tensor> getInteractionTensorList(String type, BS bsA) {
        if (type != null) {
            type = type.toLowerCase();
        }
        BS bsModels = this.vwr.ms.getModelBS(bsA, false);
        BS bs1 = this.getAtomSiteBS(bsA);
        int iAtom = bs1.cardinality() == 1 ? bs1.nextSetBit(0) : -1;
        Lst list = new Lst();
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            Lst tensors = (Lst)this.vwr.ms.getInfo(i, "interactionTensors");
            if (tensors != null) {
                int n = tensors.size();
                for (int j = 0; j < n; ++j) {
                    Tensor t = (Tensor)tensors.get(j);
                    if (type != null && (!t.type.equals(type) || !t.isSelected(bs1, iAtom))) continue;
                    list.addLast((Object)t);
                }
            }
            i = bsModels.nextSetBit(i + 1);
        }
        return list;
    }

    private BS getAtomSiteBS(BS bsA) {
        if (bsA == null) {
            return null;
        }
        BS bs = new BS();
        Atom[] atoms = this.vwr.ms.at;
        Model[] models = this.vwr.ms.am;
        int i = bsA.nextSetBit(0);
        while (i >= 0) {
            if (bsA.get(i)) {
                Atom a = atoms[i];
                bs.set(models[a.mi].firstAtomIndex - 1 + a.atomSite);
            }
            i = bsA.nextSetBit(i + 1);
        }
        return bs;
    }

    public BS getUniqueTensorSet(BS bsAtoms) {
        BS bs = new BS();
        Atom[] atoms = this.vwr.ms.at;
        int i = this.vwr.ms.mc;
        while (--i >= 0) {
            BS bsModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(i);
            bsModelAtoms.and(bsAtoms);
            if (this.vwr.ms.getUnitCell(i) == null) continue;
            int j = bsModelAtoms.nextSetBit(0);
            while (j >= 0) {
                if (atoms[j].atomSite != atoms[j].i + 1) {
                    bsModelAtoms.clear(j);
                }
                j = bsModelAtoms.nextSetBit(j + 1);
            }
            bs.or(bsModelAtoms);
            j = bsModelAtoms.nextSetBit(0);
            while (j >= 0) {
                Object[] ta = atoms[j].getTensors();
                if (ta != null) {
                    int jj = ta.length;
                    while (--jj >= 0) {
                        Tensor t = (Tensor)ta[jj];
                        if (t == null) continue;
                        int k = bsModelAtoms.nextSetBit(j + 1);
                        while (k >= 0) {
                            Object[] tb = atoms[k].getTensors();
                            if (tb != null) {
                                int kk = tb.length;
                                while (--kk >= 0) {
                                    if (!t.isEquiv((Tensor)tb[kk])) continue;
                                    bsModelAtoms.clear(k);
                                    bs.clear(k);
                                    break;
                                }
                            }
                            k = bsModelAtoms.nextSetBit(k + 1);
                        }
                    }
                }
                j = bsModelAtoms.nextSetBit(j + 1);
            }
        }
        return bs;
    }

    public float getJCouplingHz(Atom a1, Atom a2, String type, Tensor isc) {
        return this.getIsoOrAnisoHz(true, a1, a2, type, isc);
    }

    public float getIsoOrAnisoHz(boolean isIso, Atom a1, Atom a2, String type, Tensor isc) {
        if (isc == null) {
            if ((type = this.getISCtype(a1, type)) == null || a1.mi != a2.mi) {
                return 0.0f;
            }
            BS bs = new BS();
            bs.set(a1.i);
            bs.set(a2.i);
            Lst<Tensor> list = this.getInteractionTensorList(type, bs);
            if (list.size() == 0) {
                return Float.NaN;
            }
            isc = (Tensor)list.get(0);
        } else {
            a1 = this.vwr.ms.at[isc.atomIndex1];
            a2 = this.vwr.ms.at[isc.atomIndex2];
        }
        return (float)(this.getIsotopeData(a1, 1) * this.getIsotopeData(a2, 1) * (double)(isIso ? isc.isotropy() : isc.anisotropy()) * 0.0167840302932219);
    }

    private String getISCtype(Atom a1, String type) {
        Lst tensors = (Lst)this.vwr.ms.getInfo((int)a1.mi, "interactionTensors");
        if (tensors == null) {
            return null;
        }
        type = type == null ? "" : type.toLowerCase();
        int pt = -1;
        pt = type.indexOf("_hz");
        if (pt >= 0 || (pt = type.indexOf("_khz")) >= 0 || (pt = type.indexOf("hz")) >= 0 || (pt = type.indexOf("khz")) >= 0) {
            type = type.substring(0, pt);
        }
        if (type.length() == 0) {
            type = "isc";
        }
        return type;
    }

    public float getDipolarConstantHz(Atom a1, Atom a2) {
        float v;
        if (Logger.debugging) {
            Logger.debug((String)(a1 + " g=" + this.getIsotopeData(a1, 1) + "; " + a2 + " g=" + this.getIsotopeData(a2, 1)));
        }
        return (v = (float)(-this.getIsotopeData(a1, 1) * this.getIsotopeData(a2, 1) / Math.pow(a1.distance((T3)a2), 3.0) * 1054.5717253362893)) == 0.0f || a1 == a2 ? Float.NaN : v;
    }

    public float getDipolarCouplingHz(Atom a1, Atom a2, V3 vField) {
        V3 v12 = V3.newVsub((T3)a2, (T3)a1);
        double r = v12.length();
        double costheta = (double)v12.dot((T3)vField) / r / (double)vField.length();
        return (float)((double)this.getDipolarConstantHz(a1, a2) * (3.0 * costheta - 1.0) / 2.0);
    }

    private double getIsotopeData(Atom a, int iType) {
        int iso = a.getIsotopeNumber();
        String sym = a.getElementSymbolIso(false);
        double[] d = this.isotopeData.get(iso == 0 ? sym : "" + iso + sym);
        return d == null ? 0.0 : d[iType];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getData() {
        BufferedReader br = null;
        try {
            String line;
            boolean debugging = Logger.debugging;
            br = FileManager.getBufferedReaderForResource((Viewer)this.vwr, (Object)this, (String)"org/jmol/quantum/", (String)resource);
            this.isotopeData = new Hashtable<String, double[]>();
            while ((line = br.readLine()) != null) {
                if (debugging) {
                    Logger.info((String)line);
                }
                if (line.indexOf("#") >= 0) continue;
                String[] tokens = PT.getTokens((String)line);
                String name = tokens[0];
                String defaultIso = tokens[2] + name;
                if (debugging) {
                    Logger.info((String)(name + " default isotope " + defaultIso));
                }
                for (int i = 3; i < tokens.length; i += 3) {
                    int n = Integer.parseInt(tokens[i]);
                    String isoname = n + name;
                    double[] dataGQ = new double[]{n, Double.parseDouble(tokens[i + 1]), Double.parseDouble(tokens[i + 2])};
                    if (debugging) {
                        Logger.info((String)(isoname + "  " + Escape.eAD((double[])dataGQ)));
                    }
                    this.isotopeData.put(isoname, dataGQ);
                }
                double[] defdata = this.isotopeData.get(defaultIso);
                if (defdata == null) {
                    Logger.error((String)("Cannot find default NMR data in nmr_data.txt for " + defaultIso));
                    throw new NullPointerException();
                }
                defdata[0] = -defdata[0];
                this.isotopeData.put(name, defdata);
            }
        }
        catch (Exception e) {
            Logger.error((String)("Exception " + e.toString() + " reading " + resource));
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public Object getInfo(String what) {
        if (what.equals("all")) {
            Hashtable<String, Map<String, Object>> map = new Hashtable<String, Map<String, Object>>();
            map.put("isotopes", this.isotopeData);
            map.put("shiftRefsPPM", this.shiftRefsPPM);
            return map;
        }
        if (PT.isDigit((char)what.charAt(0))) {
            return this.isotopeData.get(what);
        }
        Lst info = new Lst();
        for (Map.Entry<String, double[]> e : this.isotopeData.entrySet()) {
            String key = e.getKey();
            if (!PT.isDigit((char)key.charAt(0)) || !key.endsWith(what)) continue;
            info.addLast((Object)e.getValue());
        }
        return info;
    }

    public float getChemicalShift(Atom atom) {
        float v = this.getMagneticShielding(atom);
        if (Float.isNaN(v)) {
            return v;
        }
        Float ref = this.shiftRefsPPM.get(atom.getElementSymbol());
        return (ref == null ? 0.0f : ref.floatValue()) - v;
    }

    public float getMagneticShielding(Atom atom) {
        Tensor t = this.vwr.ms.getAtomTensor(atom.i, "ms");
        return t == null ? Float.NaN : t.isotropy();
    }

    public boolean getState(SB sb) {
        if (this.shiftRefsPPM.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Float> nuc : this.shiftRefsPPM.entrySet()) {
            sb.append("  set shift_").append(nuc.getKey()).append(" ").appendO((Object)nuc.getValue()).append("\n");
        }
        return true;
    }

    public boolean setChemicalShiftReference(String element, float value) {
        if (element == null) {
            this.shiftRefsPPM.clear();
            return false;
        }
        element = element.substring(0, 1).toUpperCase() + element.substring(1);
        this.shiftRefsPPM.put(element, Float.valueOf(value));
        return true;
    }

    public Lst<Object> getTensorInfo(String tensorType, String infoType, BS bs) {
        if ("".equals(tensorType)) {
            tensorType = null;
        }
        infoType = infoType == null ? ";all." : ";" + infoType + ".";
        Lst data = new Lst();
        if (";dc.".equals(infoType)) {
            Atom[] atoms = this.vwr.ms.at;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                int j = bs.nextSetBit(i + 1);
                while (j >= 0) {
                    Lst list1 = new Lst();
                    list1.addLast((Object)atoms[i].i);
                    list1.addLast((Object)atoms[j].i);
                    list1.addLast((Object)Float.valueOf(this.getDipolarConstantHz(atoms[i], atoms[j])));
                    data.addLast((Object)list1);
                    j = bs.nextSetBit(j + 1);
                }
                i = bs.nextSetBit(i + 1);
            }
            return data;
        }
        if (tensorType == null || tensorType.startsWith("isc")) {
            boolean isJ = infoType.equals(";j.");
            boolean isEta = infoType.equals(";eta.");
            Lst<Tensor> list = this.getInteractionTensorList(tensorType, bs);
            int n = list == null ? 0 : list.size();
            for (int i = 0; i < n; ++i) {
                Tensor t = (Tensor)list.get(i);
                Lst list1 = new Lst();
                list1.addLast((Object)t.atomIndex1);
                list1.addLast((Object)t.atomIndex2);
                list1.addLast(isEta || isJ ? Float.valueOf(this.getIsoOrAnisoHz(isJ, null, null, null, t)) : t.getInfo(infoType));
                data.addLast((Object)list1);
            }
            if (tensorType != null) {
                return data;
            }
        }
        boolean isChi = tensorType != null && tensorType.startsWith("efg") && infoType.equals(";chi.");
        boolean isFloat = isChi || Tensor.isFloatInfo((String)infoType);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (tensorType == null) {
                Object[] a = this.vwr.ms.getAtomTensorList(i);
                if (a != null) {
                    for (int j = 0; j < a.length; ++j) {
                        data.addLast(((Tensor)a[j]).getInfo(infoType));
                    }
                }
            } else {
                Tensor t = this.vwr.ms.getAtomTensor(i, tensorType);
                data.addLast(t == null ? (isFloat ? Float.valueOf(0.0f) : "") : (isChi ? Float.valueOf(this.getQuadrupolarConstant(t)) : t.getInfo(infoType)));
            }
            i = bs.nextSetBit(i + 1);
        }
        return data;
    }

    public Map<String, Integer> getMinDistances(MeasurementData md) {
        BS bsPoints1 = (BS)md.points.get(0);
        int n1 = bsPoints1.cardinality();
        if (n1 == 0 || !(md.points.get(1) instanceof BS)) {
            return null;
        }
        BS bsPoints2 = (BS)md.points.get(1);
        int n2 = bsPoints2.cardinality();
        if (n1 < 2 && n2 < 2) {
            return null;
        }
        Hashtable<String, Integer> htMin = new Hashtable<String, Integer>();
        Atom[] atoms = this.vwr.ms.at;
        int i = bsPoints1.nextSetBit(0);
        while (i >= 0) {
            Atom a1 = atoms[i];
            String name = a1.getAtomName();
            int j = bsPoints2.nextSetBit(0);
            while (j >= 0) {
                Atom a2 = atoms[j];
                int d = (int)(a2.distanceSquared((T3)a1) * 100.0f);
                if (d != 0) {
                    String name1 = a2.getAtomName();
                    String key = name.compareTo(name1) < 0 ? name + name1 : name1 + name;
                    Integer min = (Integer)htMin.get(key);
                    if (min == null) {
                        min = d;
                        htMin.put(key, min);
                    } else if (d < min) {
                        htMin.put(key, d);
                    }
                }
                j = bsPoints2.nextSetBit(j + 1);
            }
            i = bsPoints1.nextSetBit(i + 1);
        }
        return htMin;
    }
}

