/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class MoveToThread
extends JmolThread {
    private boolean isMove;
    private final V3 aaStepCenter = new V3();
    private final V3 aaStepNavCenter = new V3();
    private final A4 aaStep = new A4();
    private final A4 aaTotal = new A4();
    private final M3 matrixStart = new M3();
    private final M3 matrixStartInv = new M3();
    private M3 matrixStep = new M3();
    private final M3 matrixEnd = new M3();
    private P3 center;
    private P3 navCenter;
    private P3 ptMoveToCenter;
    private Slider zoom;
    private Slider xTrans;
    private Slider yTrans;
    private Slider xNav;
    private Slider yNav;
    private Slider navDepth;
    private Slider cameraDepth;
    private Slider cameraX;
    private Slider cameraY;
    private Slider rotationRadius;
    private Slider pixelScale;
    private int fps;
    private long frameTimeMillis;
    private boolean doEndMove;
    private float fStep;
    private TransformManager transformManager;
    private float floatSecondsTotal;
    private int totalSteps;
    private int iStep;
    private int timePerStep;
    private float radiansXStep;
    private float radiansYStep;
    private float radiansZStep;
    private V3 dRot;
    private V3 dTrans;
    private float dZoom;
    private float dSlab;
    private float zoomPercent0;
    private int slab;
    private float transX;
    private float transY;

    @Override
    public int setManager(Object manager, Viewer vwr, Object params) {
        Object[] options = (Object[])params;
        this.isMove = options[0] instanceof V3;
        this.setViewer(vwr, this.isMove ? "moveThread" : "MoveToThread");
        this.transformManager = (TransformManager)manager;
        return this.isMove ? this.setManagerMove(options) : this.setManagerMoveTo(options);
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        if (this.isMove) {
            this.run1Move(mode);
        } else {
            this.run1MoveTo(mode);
        }
    }

    @Override
    public void interrupt() {
        this.doEndMove = false;
        super.interrupt();
    }

    private int setManagerMove(Object[] options) {
        this.dRot = (V3)options[0];
        this.dTrans = (V3)options[1];
        float[] f = (float[])options[2];
        this.dZoom = f[0];
        this.dSlab = f[1];
        this.floatSecondsTotal = f[2];
        int fps = (int)f[3];
        this.slab = this.transformManager.getSlabPercentSetting();
        this.transX = this.transformManager.getTranslationXPercent();
        this.transY = this.transformManager.getTranslationYPercent();
        this.timePerStep = 1000 / fps;
        this.totalSteps = (int)((float)fps * this.floatSecondsTotal);
        if (this.totalSteps <= 0) {
            this.totalSteps = 1;
        }
        float radiansPerDegreePerStep = (float)(Math.PI / 180 / (double)this.totalSteps);
        this.radiansXStep = radiansPerDegreePerStep * this.dRot.x;
        this.radiansYStep = radiansPerDegreePerStep * this.dRot.y;
        this.radiansZStep = radiansPerDegreePerStep * this.dRot.z;
        this.zoomPercent0 = this.transformManager.zmPct;
        this.iStep = 0;
        return this.totalSteps;
    }

    private int setManagerMoveTo(Object[] options) {
        this.center = (P3)options[0];
        this.matrixEnd.setM3((M3)options[1]);
        float[] f = (float[])options[3];
        this.ptMoveToCenter = this.center == null ? this.transformManager.fixedRotationCenter : this.center;
        this.floatSecondsTotal = f[0];
        this.zoom = this.newSlider(this.transformManager.zmPct, f[1]);
        this.xTrans = this.newSlider(this.transformManager.getTranslationXPercent(), f[2]);
        this.yTrans = this.newSlider(this.transformManager.getTranslationYPercent(), f[3]);
        this.rotationRadius = this.newSlider(this.transformManager.modelRadius, this.center == null || Float.isNaN(f[4]) ? this.transformManager.modelRadius : (f[4] <= 0.0f ? this.vwr.ms.calcRotationRadius(this.vwr.am.cmi, this.center, false) : f[4]));
        this.pixelScale = this.newSlider(this.transformManager.scaleDefaultPixelsPerAngstrom, f[5]);
        if (f[6] != 0.0f) {
            this.navCenter = (P3)options[2];
            this.navDepth = this.newSlider(this.transformManager.navigationDepthPercent, f[6]);
            this.xNav = this.newSlider(this.transformManager.getNavigationOffsetPercent('X'), f[7]);
            this.yNav = this.newSlider(this.transformManager.getNavigationOffsetPercent('Y'), f[8]);
        }
        this.cameraDepth = this.newSlider(this.transformManager.getCameraDepth(), f[9]);
        this.cameraX = this.newSlider(this.transformManager.camera.x, f[10]);
        this.cameraY = this.newSlider(this.transformManager.camera.y, f[11]);
        this.transformManager.getRotation(this.matrixStart);
        this.matrixStartInv.invertM(this.matrixStart);
        this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
        this.aaTotal.setM(this.matrixStep);
        this.fps = 30;
        this.totalSteps = (int)(this.floatSecondsTotal * (float)this.fps);
        this.frameTimeMillis = 1000 / this.fps;
        this.targetTime = System.currentTimeMillis();
        this.aaStepCenter.sub2(this.ptMoveToCenter, this.transformManager.fixedRotationCenter);
        this.aaStepCenter.scale(1.0f / (float)this.totalSteps);
        if (this.navCenter != null && this.transformManager.mode == 1) {
            this.aaStepNavCenter.sub2(this.navCenter, this.transformManager.navigationCenter);
            this.aaStepNavCenter.scale(1.0f / (float)this.totalSteps);
        }
        this.iStep = 0;
        return this.totalSteps;
    }

    private Slider newSlider(float start, float value) {
        return Float.isNaN(value) || value == Float.MAX_VALUE ? null : new Slider(start, value);
    }

    private void run1Move(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    if (this.floatSecondsTotal > 0.0f) {
                        this.vwr.setInMotion(true);
                    }
                    mode = 0;
                    break;
                }
                case 0: {
                    int timeAllowed;
                    if (this.stopped || this.iStep >= this.totalSteps) {
                        mode = -2;
                        break;
                    }
                    ++this.iStep;
                    if (this.dRot.x != 0.0f) {
                        this.transformManager.rotateXRadians(this.radiansXStep, null);
                    }
                    if (this.dRot.y != 0.0f) {
                        this.transformManager.rotateYRadians(this.radiansYStep, null);
                    }
                    if (this.dRot.z != 0.0f) {
                        this.transformManager.rotateZRadians(this.radiansZStep);
                    }
                    if (this.dZoom != 0.0f) {
                        this.transformManager.zoomToPercent(this.zoomPercent0 + this.dZoom * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.x != 0.0f) {
                        this.transformManager.translateToPercent('x', this.transX + this.dTrans.x * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.y != 0.0f) {
                        this.transformManager.translateToPercent('y', this.transY + this.dTrans.y * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.z != 0.0f) {
                        this.transformManager.translateToPercent('z', this.dTrans.z * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dSlab != 0.0f) {
                        this.transformManager.slabToPercent((int)Math.floor((float)this.slab + this.dSlab * (float)this.iStep / (float)this.totalSteps));
                    }
                    if (this.iStep == this.totalSteps) {
                        mode = -2;
                        break;
                    }
                    int timeSpent = (int)(System.currentTimeMillis() - this.startTime);
                    if (timeSpent >= (timeAllowed = this.iStep * this.timePerStep)) break;
                    this.vwr.requestRepaintAndWait("moveThread");
                    if (!this.isJS && !this.vwr.isScriptExecuting()) {
                        mode = -2;
                        break;
                    }
                    timeSpent = (int)(System.currentTimeMillis() - this.startTime);
                    this.sleepTime = timeAllowed - timeSpent;
                    if (this.runSleep(this.sleepTime, 0)) break;
                    return;
                }
                case -2: {
                    if (this.floatSecondsTotal > 0.0f) {
                        this.vwr.setInMotion(false);
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void run1MoveTo(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    if (this.totalSteps > 0) {
                        this.vwr.setInMotion(true);
                    }
                    mode = 0;
                    break;
                }
                case 0: {
                    boolean doRender;
                    if (this.stopped || ++this.iStep >= this.totalSteps) {
                        mode = -2;
                        break;
                    }
                    this.doStepTransform();
                    this.doEndMove = true;
                    this.targetTime += this.frameTimeMillis;
                    this.currentTime = System.currentTimeMillis();
                    boolean bl = doRender = this.currentTime < this.targetTime;
                    if (!doRender && this.isJS) {
                        this.targetTime = this.currentTime;
                        doRender = true;
                    }
                    if (doRender) {
                        this.vwr.requestRepaintAndWait("movetoThread");
                    }
                    if (this.transformManager.movetoThread == null || !this.transformManager.movetoThread.name.equals(this.name) || !this.isJS && this.eval != null && !this.vwr.isScriptExecuting()) {
                        this.stopped = true;
                        break;
                    }
                    this.currentTime = System.currentTimeMillis();
                    int sleepTime = (int)(this.targetTime - this.currentTime);
                    if (!this.runSleep(sleepTime, 0)) {
                        return;
                    }
                    mode = 0;
                    break;
                }
                case -2: {
                    if (this.totalSteps <= 0 || this.doEndMove && !this.stopped) {
                        this.doFinalTransform();
                    }
                    if (this.totalSteps > 0) {
                        this.vwr.setInMotion(false);
                    }
                    this.vwr.moveUpdate(this.floatSecondsTotal);
                    if (this.transformManager.movetoThread != null && !this.stopped) {
                        this.transformManager.movetoThread = null;
                        this.vwr.finalizeTransformParameters();
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void doStepTransform() {
        if (!Float.isNaN(this.matrixEnd.m00)) {
            this.transformManager.getRotation(this.matrixStart);
            this.matrixStartInv.invertM(this.matrixStart);
            this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
            this.aaTotal.setM(this.matrixStep);
            this.aaStep.setAA(this.aaTotal);
            this.aaStep.angle /= (float)(this.totalSteps - this.iStep);
            if (this.aaStep.angle == 0.0f) {
                this.matrixStep.setScale(1.0f);
            } else {
                this.matrixStep.setAA(this.aaStep);
            }
            this.matrixStep.mul(this.matrixStart);
        }
        this.fStep = (float)this.iStep / ((float)this.totalSteps - 1.0f);
        if (this.center != null) {
            this.transformManager.fixedRotationCenter.add(this.aaStepCenter);
        }
        if (this.navCenter != null && this.transformManager.mode == 1) {
            P3 pt = P3.newP(this.transformManager.navigationCenter);
            pt.add(this.aaStepNavCenter);
            this.transformManager.setNavigatePt(pt);
        }
        this.setValues(this.matrixStep, null, null);
    }

    private void doFinalTransform() {
        this.fStep = -1.0f;
        this.setValues(this.matrixEnd, this.center, this.navCenter);
    }

    private void setValues(M3 m, P3 center, P3 navCenter) {
        this.transformManager.setAll(center, m, navCenter, this.getVal(this.zoom), this.getVal(this.xTrans), this.getVal(this.yTrans), this.getVal(this.rotationRadius), this.getVal(this.pixelScale), this.getVal(this.navDepth), this.getVal(this.xNav), this.getVal(this.yNav), this.getVal(this.cameraDepth), this.getVal(this.cameraX), this.getVal(this.cameraY));
    }

    private float getVal(Slider s) {
        return s == null ? Float.NaN : s.getVal(this.fStep);
    }

    private class Slider {
        float start;
        float delta;
        float value;

        Slider(float start, float value) {
            this.start = start;
            this.value = value;
            this.delta = value - start;
        }

        float getVal(float fStep) {
            return fStep < 0.0f ? this.value : this.start + fStep * this.delta;
        }
    }
}

