/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ConflictAddCommand
extends Command {
    private final Conflict<? extends OsmPrimitive> conflict;

    public ConflictAddCommand(DataSet ds, Conflict<? extends OsmPrimitive> conflict) {
        super(ds);
        this.conflict = conflict;
    }

    protected void warnBecauseOfDoubleConflict() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Layer ''{0}'' already has a conflict for object<br>''{1}''.<br>This conflict cannot be added.</html>", Utils.escapeReservedCharactersHTML(this.getAffectedDataSet().getName()), Utils.escapeReservedCharactersHTML(this.conflict.getMy().getDisplayName(DefaultNameFormatter.getInstance()))), I18n.tr("Double conflict", new Object[0]), 0);
    }

    @Override
    public boolean executeCommand() {
        try {
            this.getAffectedDataSet().getConflicts().add(this.conflict);
        }
        catch (IllegalStateException e) {
            Logging.error(e);
            this.warnBecauseOfDoubleConflict();
        }
        return true;
    }

    @Override
    public void undoCommand() {
        DataSet ds = this.getAffectedDataSet();
        if (Main.main != null && !Main.main.containsDataSet(ds)) {
            Logging.warn(I18n.tr("Layer ''{0}'' does not exist any more. Cannot remove conflict for object ''{1}''.", ds.getName(), this.conflict.getMy().getDisplayName(DefaultNameFormatter.getInstance())));
            return;
        }
        ds.getConflicts().remove(this.conflict);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Add conflict for ''{0}''", this.conflict.getMy().getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(this.conflict.getMy().getDisplayType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.conflict);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ConflictAddCommand that = (ConflictAddCommand)obj;
        return Objects.equals(this.conflict, that.conflict);
    }
}

