/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Iterator;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class UndoRedoHandler {
    public final LinkedList<Command> commands = new LinkedList();
    public final LinkedList<Command> redoCommands = new LinkedList();
    private final LinkedList<CommandQueueListener> listenerCommands = new LinkedList();

    public Command getLastCommand() {
        return this.commands.peekLast();
    }

    public void addNoRedraw(Command c) {
        CheckParameterUtil.ensureParameterNotNull(c, "c");
        c.executeCommand();
        this.commands.add(c);
        if (this.commands.size() > Config.getPref().getInt("undo.max", 1000)) {
            this.commands.removeFirst();
        }
        this.redoCommands.clear();
    }

    public void afterAdd() {
        this.fireCommandsChanged();
    }

    public synchronized void add(Command c) {
        this.addNoRedraw(c);
        this.afterAdd();
    }

    public void undo() {
        this.undo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undo(int num) {
        if (this.commands.isEmpty()) {
            return;
        }
        DataSet ds = Main.main.getEditDataSet();
        if (ds != null) {
            ds.beginUpdate();
        }
        try {
            for (int i = 1; i <= num; ++i) {
                Command c = this.commands.removeLast();
                c.undoCommand();
                this.redoCommands.addFirst(c);
                if (!this.commands.isEmpty()) continue;
                break;
            }
        }
        finally {
            if (ds != null) {
                ds.endUpdate();
            }
        }
        this.fireCommandsChanged();
    }

    public void redo() {
        this.redo(1);
    }

    public void redo(int num) {
        if (this.redoCommands.isEmpty()) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            Command c = this.redoCommands.removeFirst();
            c.executeCommand();
            this.commands.add(c);
            if (this.redoCommands.isEmpty()) break;
        }
        this.fireCommandsChanged();
    }

    private void fireCommandsChanged() {
        for (CommandQueueListener l : this.listenerCommands) {
            l.commandChanged(this.commands.size(), this.redoCommands.size());
        }
    }

    public void clean() {
        this.redoCommands.clear();
        this.commands.clear();
        this.fireCommandsChanged();
    }

    public void clean(DataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        boolean changed = false;
        Iterator it = this.commands.iterator();
        while (it.hasNext()) {
            if (((Command)it.next()).getAffectedDataSet() != dataSet) continue;
            it.remove();
            changed = true;
        }
        it = this.redoCommands.iterator();
        while (it.hasNext()) {
            if (((Command)it.next()).getAffectedDataSet() != dataSet) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            this.fireCommandsChanged();
        }
    }

    public void removeCommandQueueListener(CommandQueueListener l) {
        this.listenerCommands.remove(l);
    }

    public boolean addCommandQueueListener(CommandQueueListener l) {
        return this.listenerCommands.add(l);
    }

    @FunctionalInterface
    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }
}

