/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class WayPoint
extends WithAttributes
implements Comparable<WayPoint>,
TemplateEngineDataProvider,
ILatLon {
    public double time;
    public Color customColoring;
    public boolean drawLine;
    public int dir;
    private final double lat;
    private final double lon;
    private double east = Double.NaN;
    private double north = Double.NaN;
    private Object eastNorthCacheKey;

    public WayPoint(WayPoint p) {
        this.attr.putAll(p.attr);
        this.lat = p.lat;
        this.lon = p.lon;
        this.east = p.east;
        this.north = p.north;
        this.eastNorthCacheKey = p.eastNorthCacheKey;
        this.time = p.time;
        this.customColoring = p.customColoring;
        this.drawLine = p.drawLine;
        this.dir = p.dir;
    }

    public WayPoint(LatLon ll) {
        this.lat = ll.lat();
        this.lon = ll.lon();
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
    }

    public final LatLon getCoor() {
        return new LatLon(this.lat, this.lon);
    }

    @Override
    public double lon() {
        return this.lon;
    }

    @Override
    public double lat() {
        return this.lat;
    }

    @Override
    public final EastNorth getEastNorth(Projecting projecting) {
        Object newCacheKey = projecting.getCacheKey();
        if (Double.isNaN(this.east) || Double.isNaN(this.north) || !Objects.equals(newCacheKey, this.eastNorthCacheKey)) {
            EastNorth en = projecting.latlon2eastNorth(this);
            this.east = en.east();
            this.north = en.north();
            this.eastNorthCacheKey = newCacheKey;
        }
        return new EastNorth(this.east, this.north);
    }

    public String toString() {
        return "WayPoint (" + (this.attr.containsKey("name") ? this.get("name") + ", " : "") + this.getCoor() + ", " + this.attr + ')';
    }

    public void setTime(Date time) {
        this.time = (double)time.getTime() / 1000.0;
        this.attr.put("time", DateUtils.fromDate(time));
    }

    public void setTime() {
        this.setTimeFromAttribute();
    }

    public void setTime(long time) {
        this.time = (double)time / 1000.0;
    }

    public Date setTimeFromAttribute() {
        if (this.attr.containsKey("time")) {
            try {
                Date time = DateUtils.fromString(this.get("time").toString());
                this.time = (double)time.getTime() / 1000.0;
                return time;
            }
            catch (UncheckedParseException e) {
                Logging.warn(e);
                this.time = 0.0;
            }
        }
        return null;
    }

    @Override
    public int compareTo(WayPoint w) {
        return Double.compare(this.time, w.time);
    }

    public Date getTime() {
        return new Date((long)(this.time * 1000.0));
    }

    @Override
    public Object getTemplateValue(String name, boolean special) {
        if (!special) {
            return this.get(name);
        }
        return null;
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTemplateKeys() {
        return new ArrayList<String>(this.attr.keySet());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.time);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        WayPoint other = (WayPoint)obj;
        return Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(other.lat) && Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(other.lon) && Double.doubleToLongBits(this.time) == Double.doubleToLongBits(other.time);
    }
}

