/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class AbstractStackTransferHandler
extends TransferHandler {
    protected abstract Collection<AbstractOsmDataPaster> getSupportedPasters();

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        for (AbstractOsmDataPaster df : this.getSupportedPasters()) {
            if (!df.supports(support)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        return this.importData(support, MainApplication.getLayerManager().getEditLayer(), null);
    }

    protected boolean importData(TransferHandler.TransferSupport support, OsmDataLayer layer, EastNorth center) {
        for (AbstractOsmDataPaster df : this.getSupportedPasters()) {
            if (!df.supports(support)) continue;
            try {
                if (Logging.isDebugEnabled()) {
                    Logging.debug("{0} pasting {1} at {2}", df.getClass().getSimpleName(), Arrays.toString(support.getDataFlavors()), center);
                }
                if (!df.importData(support, layer, center)) continue;
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                Logging.warn(e);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                BugReport.intercept(e).put("paster", df).put("flavors", support::getDataFlavors).warn();
            }
        }
        return super.importData(support);
    }
}

