/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.AbstractCopyAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class CopyAllKeyValueAction
extends AbstractCopyAction {
    public CopyAllKeyValueAction(JTable tagTable, Function<Integer, String> keyFn, Supplier<Collection<? extends Tagged>> objectSp) {
        super(tagTable, keyFn, objectSp);
        this.putValue("Name", I18n.tr("Copy all Keys/Values", new Object[0]));
        this.putValue("ShortDescription", I18n.tr("Copy the key and value of all the tags to clipboard", new Object[0]));
        Shortcut sc = Shortcut.registerShortcut("system:copytags", I18n.tr("Edit: {0}", I18n.tr("Copy Tags", new Object[0])), 65535, 5000);
        MainApplication.registerActionShortcut(this, sc);
        sc.setAccelerator(this);
    }

    @Override
    protected Collection<String> getString(Tagged p, String key) {
        LinkedList<String> r = new LinkedList<String>();
        for (Map.Entry<String, String> kv : p.getKeys().entrySet()) {
            r.add(new Tag(kv.getKey(), kv.getValue()).toString());
        }
        return r;
    }
}

