/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class TagCellRenderer
extends JLabel
implements TableCellRenderer {
    private final Font fontStandard = UIManager.getFont("Table.font");
    private final Font fontItalic = this.fontStandard.deriveFont(2);

    public TagCellRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    protected void renderTagName(TagModel tag) {
        this.setText(tag.getName());
    }

    protected void renderTagValue(TagModel tag) {
        if (tag.getValueCount() == 0) {
            this.setText("");
        } else if (tag.getValueCount() == 1) {
            this.setText(tag.getValues().get(0));
        } else if (tag.getValueCount() > 1) {
            this.setText(I18n.tr("multiple", new Object[0]));
            this.setFont(this.fontItalic);
        }
    }

    protected void resetRenderer() {
        this.setText("");
        this.setIcon(null);
        this.setFont(this.fontStandard);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        this.resetRenderer();
        if (value == null) {
            return this;
        }
        if (isSelected) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
        switch (vColIndex) {
            case 0: {
                this.renderTagName((TagModel)value);
                break;
            }
            case 1: {
                this.renderTagValue((TagModel)value);
                break;
            }
            default: {
                throw new JosmRuntimeException("unexpected index in switch statement");
            }
        }
        if (hasFocus && isSelected && table.getSelectedColumnCount() == 1 && table.getSelectedRowCount() == 1 && table.getEditorComponent() != null) {
            table.getEditorComponent().requestFocusInWindow();
        }
        return this;
    }
}

