/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.constants.NodeType;

public abstract class Node
implements NodeType {
    public Node parent;
    protected int type;

    Node(int type2) {
        this.type = type2;
    }

    public final int getType() {
        return this.type;
    }

    public final int getType2Bit() {
        return 1 << this.getType();
    }

    protected void setChild(Node tgt) {
    }

    protected Node getChild() {
        return null;
    }

    public void replaceWith(Node with) {
        with.parent = this.parent;
        this.parent.setChild(with);
        this.parent = null;
    }

    public abstract String getName();

    protected abstract String toString(int var1);

    public String getAddressName() {
        return this.getName() + ":0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public final String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("<" + this.getAddressName() + " (" + (this.parent == null ? "NULL" : this.parent.getAddressName()) + ")>");
        return s2 + this.toString(0);
    }

    protected static String pad(Object value2, int level2) {
        if (value2 == null) {
            return "NULL";
        }
        StringBuilder pad = new StringBuilder("  ");
        for (int i2 = 0; i2 < level2; ++i2) {
            pad.append((CharSequence)pad);
        }
        return value2.toString().replace("\n", "\n" + pad);
    }

    public final boolean isSimple() {
        return (this.getType2Bit() & 0x1F) != 0;
    }

    public static TopNode newTop(Node root) {
        return new TopNode(root);
    }

    public static final class TopNode
    extends Node {
        private Node root;

        TopNode(Node root) {
            super(-1);
            root.parent = this;
            this.setChild(root);
        }

        public Node getRoot() {
            return this.root;
        }

        public void setChild(Node node) {
            node.parent = this;
            this.root = node;
        }

        public Node getChild() {
            return this.root;
        }

        public String getName() {
            return "ROOT";
        }

        public String toString(int level2) {
            return "\n" + TopNode.pad(this.root, level2 + 1);
        }
    }
}

