/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.tree.AnnotationNode;
import org.jruby.org.objectweb.asm.tree.FieldNode;
import org.jruby.org.objectweb.asm.tree.InnerClassNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.ModuleNode;
import org.jruby.org.objectweb.asm.tree.TypeAnnotationNode;

public class ClassNode
extends ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List<String> interfaces = new ArrayList<String>();
    public String sourceFile;
    public String sourceDebug;
    public ModuleNode module;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public List<InnerClassNode> innerClasses = new ArrayList<InnerClassNode>();
    public List<FieldNode> fields = new ArrayList<FieldNode>();
    public List<MethodNode> methods = new ArrayList<MethodNode>();

    public ClassNode() {
        this(393216);
        if (this.getClass() != ClassNode.class) {
            throw new IllegalStateException();
        }
    }

    public ClassNode(int api) {
        super(api);
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        this.version = version;
        this.access = access;
        this.name = name2;
        this.signature = signature;
        this.superName = superName;
        if (interfaces2 != null) {
            this.interfaces.addAll(Arrays.asList(interfaces2));
        }
    }

    public void visitSource(String file2, String debug) {
        this.sourceFile = file2;
        this.sourceDebug = debug;
    }

    public ModuleVisitor visitModule(String name2, int access, String version) {
        this.module = new ModuleNode(name2, access, version);
        return this.module;
    }

    public void visitOuterClass(String owner2, String name2, String desc) {
        this.outerClass = owner2;
        this.outerMethod = name2;
        this.outerMethodDesc = desc;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(an);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(an);
        }
        return an;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        TypeAnnotationNode an = new TypeAnnotationNode(typeRef, typePath, desc);
        if (visible) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.visibleTypeAnnotations.add(an);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.invisibleTypeAnnotations.add(an);
        }
        return an;
    }

    public void visitAttribute(Attribute attr2) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(1);
        }
        this.attrs.add(attr2);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        InnerClassNode icn = new InnerClassNode(name2, outerName, innerName, access);
        this.innerClasses.add(icn);
    }

    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value2) {
        FieldNode fn = new FieldNode(access, name2, desc, signature, value2);
        this.fields.add(fn);
        return fn;
    }

    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
        MethodNode mn = new MethodNode(access, name2, desc, signature, exceptions);
        this.methods.add(mn);
        return mn;
    }

    public void visitEnd() {
    }

    public void check(int api) {
        int i2;
        if (api < 393216 && this.module != null) {
            throw new RuntimeException();
        }
        if (api < 327680) {
            if (this.visibleTypeAnnotations != null && this.visibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
            if (this.invisibleTypeAnnotations != null && this.invisibleTypeAnnotations.size() > 0) {
                throw new RuntimeException();
            }
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (i2 = 0; i2 < n; ++i2) {
            this.visibleAnnotations.get(i2).check(api);
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (i2 = 0; i2 < n; ++i2) {
            this.invisibleAnnotations.get(i2).check(api);
        }
        n = this.visibleTypeAnnotations == null ? 0 : this.visibleTypeAnnotations.size();
        for (i2 = 0; i2 < n; ++i2) {
            this.visibleTypeAnnotations.get(i2).check(api);
        }
        n = this.invisibleTypeAnnotations == null ? 0 : this.invisibleTypeAnnotations.size();
        for (i2 = 0; i2 < n; ++i2) {
            this.invisibleTypeAnnotations.get(i2).check(api);
        }
        for (FieldNode f : this.fields) {
            f.check(api);
        }
        for (MethodNode m : this.methods) {
            m.check(api);
        }
    }

    public void accept(ClassVisitor cv) {
        AnnotationNode an;
        int i2;
        String[] interfaces2 = new String[this.interfaces.size()];
        this.interfaces.toArray(interfaces2);
        cv.visit(this.version, this.access, this.name, this.signature, this.superName, interfaces2);
        if (this.sourceFile != null || this.sourceDebug != null) {
            cv.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.module != null) {
            this.module.accept(cv);
        }
        if (this.outerClass != null) {
            cv.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (i2 = 0; i2 < n; ++i2) {
            an = this.visibleAnnotations.get(i2);
            an.accept(cv.visitAnnotation(an.desc, true));
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (i2 = 0; i2 < n; ++i2) {
            an = this.invisibleAnnotations.get(i2);
            an.accept(cv.visitAnnotation(an.desc, false));
        }
        n = this.visibleTypeAnnotations == null ? 0 : this.visibleTypeAnnotations.size();
        for (i2 = 0; i2 < n; ++i2) {
            an = this.visibleTypeAnnotations.get(i2);
            an.accept(cv.visitTypeAnnotation(((TypeAnnotationNode)an).typeRef, ((TypeAnnotationNode)an).typePath, ((TypeAnnotationNode)an).desc, true));
        }
        n = this.invisibleTypeAnnotations == null ? 0 : this.invisibleTypeAnnotations.size();
        for (i2 = 0; i2 < n; ++i2) {
            an = this.invisibleTypeAnnotations.get(i2);
            an.accept(cv.visitTypeAnnotation(((TypeAnnotationNode)an).typeRef, ((TypeAnnotationNode)an).typePath, ((TypeAnnotationNode)an).desc, false));
        }
        n = this.attrs == null ? 0 : this.attrs.size();
        for (i2 = 0; i2 < n; ++i2) {
            cv.visitAttribute(this.attrs.get(i2));
        }
        for (i2 = 0; i2 < this.innerClasses.size(); ++i2) {
            this.innerClasses.get(i2).accept(cv);
        }
        for (i2 = 0; i2 < this.fields.size(); ++i2) {
            this.fields.get(i2).accept(cv);
        }
        for (i2 = 0; i2 < this.methods.size(); ++i2) {
            this.methods.get(i2).accept(cv);
        }
        cv.visitEnd();
    }
}

