/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.ExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ManyCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.NoneCandidatesCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ:\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u001e\u001a\u00020\b*\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020!H\u0002J\u001e\u0010\"\u001a\u00020\u0015*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;", "", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "(Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;)V", "createAllCandidatesResult", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "candidates", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "runCompletion", "", "resolvedCallAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter$ConstraintSystemCompletionMode;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "collectAllCandidatesMode", "", "factory", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "asCallResolutionResult", "type", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult$Type;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder$SimpleHolder;", "prepareForCompletion", "resolution"})
public final class KotlinCallCompleter {
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;

    @NotNull
    public final CallResolutionResult runCompletion(@NotNull SimpleCandidateFactory factory2, @NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType2, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        KotlinResolutionCandidate candidate2;
        Object object;
        Intrinsics.checkParameterIsNotNull(factory2, "factory");
        Intrinsics.checkParameterIsNotNull(candidates2, "candidates");
        Intrinsics.checkParameterIsNotNull(resolutionCallbacks, "resolutionCallbacks");
        KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        if (candidates2.isEmpty()) {
            diagnosticHolder.addDiagnostic(new NoneCandidatesCallDiagnostic(factory2.getKotlinCall()));
        }
        if (candidates2.size() > 1) {
            diagnosticHolder.addDiagnostic(new ManyCandidatesCallDiagnostic(factory2.getKotlinCall(), candidates2));
        }
        if ((object = (candidate2 = (KotlinResolutionCandidate)CollectionsKt.singleOrNull((Iterable)candidates2))) != null && (object = ((KotlinResolutionCandidate)object).getResolvedCall()) != null) {
            Object object2;
            Object it = object2 = object;
            resolutionCallbacks.bindStubResolvedCallForCandidate((ResolvedCallAtom)it);
        }
        if (candidate2 == null || candidate2.getCsBuilder$resolution().getHasContradiction()) {
            KotlinResolutionCandidate kotlinResolutionCandidate = candidate2;
            if (kotlinResolutionCandidate == null) {
                kotlinResolutionCandidate = (KotlinResolutionCandidate)TowerUtilsKt.forceResolution((Candidate)factory2.createErrorCandidate());
            }
            KotlinResolutionCandidate candidateForCompletion = kotlinResolutionCandidate;
            this.prepareForCompletion(candidateForCompletion, expectedType2, resolutionCallbacks);
            KotlinCallCompleter.runCompletion$default(this, candidateForCompletion.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticHolder, candidateForCompletion.getSystem(), resolutionCallbacks, false, 32, null);
            return this.asCallResolutionResult(candidate2, CallResolutionResult.Type.ERROR, diagnosticHolder);
        }
        KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionType = this.prepareForCompletion(candidate2, expectedType2, resolutionCallbacks);
        NewConstraintSystem constraintSystem = candidate2.getSystem();
        KotlinCallCompleter.runCompletion$default(this, candidate2.getResolvedCall(), completionType, diagnosticHolder, constraintSystem, resolutionCallbacks, false, 32, null);
        CallResolutionResult.Type callResolutionType = completionType == KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL ? CallResolutionResult.Type.COMPLETED : CallResolutionResult.Type.PARTIAL;
        return this.asCallResolutionResult(candidate2, callResolutionType, diagnosticHolder);
    }

    @NotNull
    public final CallResolutionResult createAllCandidatesResult(@NotNull Collection<KotlinResolutionCandidate> candidates2, @Nullable UnwrappedType expectedType2, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkParameterIsNotNull(candidates2, "candidates");
        Intrinsics.checkParameterIsNotNull(resolutionCallbacks, "resolutionCallbacks");
        KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        for (KotlinResolutionCandidate candidate2 : candidates2) {
            this.prepareForCompletion(candidate2, expectedType2, resolutionCallbacks);
            this.runCompletion(candidate2.getResolvedCall(), KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL, diagnosticsHolder, candidate2.getSystem(), resolutionCallbacks, true);
        }
        return new CallResolutionResult(CallResolutionResult.Type.ALL_CANDIDATES, null, CollectionsKt.emptyList(), ConstraintStorage.Empty.INSTANCE, candidates2);
    }

    /*
     * WARNING - void declaration
     */
    private final void runCompletion(ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode completionMode, KotlinDiagnosticsHolder diagnosticsHolder, NewConstraintSystem constraintSystem, KotlinResolutionCallbacks resolutionCallbacks, boolean collectAllCandidatesMode) {
        void $receiver$iv;
        UnwrappedType unwrappedType = ResolutionAtomsKt.getFreshReturnType(resolvedCallAtom);
        if (unwrappedType == null) {
            SimpleType simpleType2 = constraintSystem.getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "constraintSystem.builtIns.unitType");
            unwrappedType = simpleType2;
        }
        UnwrappedType returnType = unwrappedType;
        this.kotlinConstraintSystemCompleter.runCompletion(constraintSystem.asConstraintSystemCompleterContext(), completionMode, resolvedCallAtom, returnType, (Function1<? super PostponedResolvedAtom, Unit>)new Function1<PostponedResolvedAtom, Unit>(this, collectAllCandidatesMode, constraintSystem, resolutionCallbacks, diagnosticsHolder){
            final /* synthetic */ KotlinCallCompleter this$0;
            final /* synthetic */ boolean $collectAllCandidatesMode;
            final /* synthetic */ NewConstraintSystem $constraintSystem;
            final /* synthetic */ KotlinResolutionCallbacks $resolutionCallbacks;
            final /* synthetic */ KotlinDiagnosticsHolder $diagnosticsHolder;

            public final void invoke(@NotNull PostponedResolvedAtom it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (this.$collectAllCandidatesMode) {
                    it.setEmptyAnalyzedResults();
                } else {
                    KotlinCallCompleter.access$getPostponedArgumentsAnalyzer$p(this.this$0).analyze(this.$constraintSystem.asPostponedArgumentsAnalyzerContext(), this.$resolutionCallbacks, it, this.$diagnosticsHolder);
                }
            }
            {
                this.this$0 = kotlinCallCompleter;
                this.$collectAllCandidatesMode = bl;
                this.$constraintSystem = newConstraintSystem;
                this.$resolutionCallbacks = kotlinResolutionCallbacks;
                this.$diagnosticsHolder = kotlinDiagnosticsHolder;
                super(1);
            }
        });
        Iterable iterable = constraintSystem.getDiagnostics();
        KotlinDiagnosticsHolder kotlinDiagnosticsHolder = diagnosticsHolder;
        for (Object element$iv : $receiver$iv) {
            KotlinCallDiagnostic p1 = (KotlinCallDiagnostic)element$iv;
            kotlinDiagnosticsHolder.addDiagnostic(p1);
        }
    }

    static /* synthetic */ void runCompletion$default(KotlinCallCompleter kotlinCallCompleter, ResolvedCallAtom resolvedCallAtom, KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode constraintSystemCompletionMode, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, NewConstraintSystem newConstraintSystem, KotlinResolutionCallbacks kotlinResolutionCallbacks, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        kotlinCallCompleter.runCompletion(resolvedCallAtom, constraintSystemCompletionMode, kotlinDiagnosticsHolder, newConstraintSystem, kotlinResolutionCallbacks, bl);
    }

    private final KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode prepareForCompletion(@NotNull KotlinResolutionCandidate $receiver, UnwrappedType expectedType2, KotlinResolutionCallbacks resolutionCallbacks) {
        KotlinType kotlinType = $receiver.getResolvedCall().getCandidateDescriptor().getReturnType();
        if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
            return KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL;
        }
        KotlinType unsubstitutedReturnType = kotlinType;
        ReceiverValueWithSmartCastInfo withSmartCastInfo = resolutionCallbacks.createReceiverWithSmartCastInfo($receiver.getResolvedCall());
        Object object = withSmartCastInfo;
        if (object == null || (object = ArgumentsUtilsKt.getStableType((ReceiverValueWithSmartCastInfo)object)) == null) {
            object = unsubstitutedReturnType;
        }
        Object actualType = object;
        UnwrappedType returnType = $receiver.getResolvedCall().getSubstitutor().substituteKeepAnnotations((UnwrappedType)actualType);
        if (expectedType2 != null && !TypeUtils.noExpectedType(expectedType2) && !resolutionCallbacks.isCompileTimeConstant($receiver.getResolvedCall(), expectedType2)) {
            $receiver.getCsBuilder$resolution().addSubtypeConstraint(returnType, expectedType2, new ExpectedTypeConstraintPosition($receiver.getResolvedCall().getAtom()));
        }
        return expectedType2 != null || $receiver.getCsBuilder$resolution().isProperType(returnType) ? KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.FULL : KotlinConstraintSystemCompleter.ConstraintSystemCompletionMode.PARTIAL;
    }

    private final CallResolutionResult asCallResolutionResult(@Nullable KotlinResolutionCandidate $receiver, CallResolutionResult.Type type2, KotlinDiagnosticsHolder.SimpleHolder diagnosticsHolder) {
        List diagnosticsFromResolutionParts;
        Object object = $receiver;
        List list2 = diagnosticsFromResolutionParts = object != null && (object = ((KotlinResolutionCandidate)object).getDiagnosticsFromResolutionParts()) != null ? (List)object : CollectionsKt.emptyList();
        Object object2 = $receiver;
        if (object2 == null || (object2 = ((KotlinResolutionCandidate)object2).getSystem()) == null || (object2 = object2.asReadOnlyStorage()) == null) {
            object2 = ConstraintStorage.Empty.INSTANCE;
        }
        Object systemStorage = object2;
        KotlinResolutionCandidate kotlinResolutionCandidate = $receiver;
        return new CallResolutionResult(type2, kotlinResolutionCandidate != null ? kotlinResolutionCandidate.getResolvedCall() : null, CollectionsKt.plus((Collection)diagnosticsHolder.getDiagnostics(), (Iterable)diagnosticsFromResolutionParts), (ConstraintStorage)systemStorage, null, 16, null);
    }

    public KotlinCallCompleter(@NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter) {
        Intrinsics.checkParameterIsNotNull(postponedArgumentsAnalyzer, "postponedArgumentsAnalyzer");
        Intrinsics.checkParameterIsNotNull(kotlinConstraintSystemCompleter, "kotlinConstraintSystemCompleter");
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
    }

    @NotNull
    public static final /* synthetic */ PostponedArgumentsAnalyzer access$getPostponedArgumentsAnalyzer$p(KotlinCallCompleter $this) {
        return $this.postponedArgumentsAnalyzer;
    }
}

