/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil$sam$java_util_function_Predicate$0;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUnifier;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J$\u0010 \u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0004J \u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0006H\u0002\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/types/CastDiagnosticsUtil;", "", "()V", "allParametersReified", "", "subtype", "Lorg/jetbrains/kotlin/types/KotlinType;", "castIsUseless", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "targetType", "actualType", "checkExactTypeForUselessCast", "findStaticallyKnownSubtype", "Lorg/jetbrains/kotlin/types/TypeReconstructionResult;", "supertype", "subtypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "isCastErased", "typeChecker", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "isCastPossible", "lhsType", "rhsType", "platformToKotlinClassMap", "Lorg/jetbrains/kotlin/platform/PlatformToKotlinClassMap;", "isExactTypeCast", "candidateType", "isFinal", "type", "isRefinementUseless", "possibleTypes", "", "shouldCheckForExactType", "isRelated", "a", "b", "isTrait", "isUpcast", "mapToPlatformIndependentClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "expectedType", "frontend"})
public final class CastDiagnosticsUtil {
    public static final CastDiagnosticsUtil INSTANCE;

    @JvmStatic
    public static final boolean isCastPossible(@NotNull KotlinType lhsType, @NotNull KotlinType rhsType, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        Intrinsics.checkParameterIsNotNull(lhsType, "lhsType");
        Intrinsics.checkParameterIsNotNull(rhsType, "rhsType");
        Intrinsics.checkParameterIsNotNull(platformToKotlinClassMap, "platformToKotlinClassMap");
        boolean rhsNullable = TypeUtils.isNullableType(rhsType);
        boolean lhsNullable = TypeUtils.isNullableType(lhsType);
        if (KotlinBuiltIns.isNothing(lhsType)) {
            return true;
        }
        if (KotlinBuiltIns.isNullableNothing(lhsType) && !rhsNullable) {
            return false;
        }
        if (KotlinBuiltIns.isNothing(rhsType)) {
            return false;
        }
        if (KotlinBuiltIns.isNullableNothing(rhsType)) {
            return lhsNullable;
        }
        if (lhsNullable && rhsNullable) {
            return true;
        }
        if (KotlinTypeKt.isError(lhsType)) {
            return true;
        }
        if (INSTANCE.isRelated(lhsType, rhsType, platformToKotlinClassMap)) {
            return true;
        }
        if (TypeUtils.isTypeParameter(lhsType) || TypeUtils.isTypeParameter(rhsType)) {
            return true;
        }
        if (INSTANCE.isFinal(lhsType) || INSTANCE.isFinal(rhsType)) {
            return false;
        }
        return INSTANCE.isTrait(lhsType) || INSTANCE.isTrait(rhsType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelated(KotlinType a, KotlinType b, PlatformToKotlinClassMap platformToKotlinClassMap) {
        ClassDescriptor it;
        Object element$iv2;
        boolean bl;
        List<ClassDescriptor> aClasses = this.mapToPlatformIndependentClasses(a, platformToKotlinClassMap);
        List<ClassDescriptor> bClasses = this.mapToPlatformIndependentClasses(b, platformToKotlinClassMap);
        Iterable $receiver$iv = aClasses;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv2 : $receiver$iv) {
                it = (ClassDescriptor)element$iv2;
                if (!DescriptorUtils.isSubtypeOfClass(b, it)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $receiver$iv = bClasses;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!DescriptorUtils.isSubtypeOfClass(a, it = (ClassDescriptor)(element$iv2 = iterator2.next())));
        return true;
    }

    private final List<ClassDescriptor> mapToPlatformIndependentClasses(KotlinType type2, PlatformToKotlinClassMap platformToKotlinClassMap) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        Collection<ClassDescriptor> collection = platformToKotlinClassMap.mapPlatformClass(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull(collection, "platformToKotlinClassMap\u2026PlatformClass(descriptor)");
        return CollectionsKt.plus(collection, descriptor2);
    }

    private final boolean isFinal(KotlinType type2) {
        return !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, type2);
    }

    private final boolean isTrait(KotlinType type2) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor it = classifierDescriptor;
        return it instanceof ClassDescriptor && ((ClassDescriptor)it).getKind() == ClassKind.INTERFACE;
    }

    @JvmStatic
    public static final boolean isCastErased(@NotNull KotlinType supertype, @NotNull KotlinType subtype, @NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkParameterIsNotNull(supertype, "supertype");
        Intrinsics.checkParameterIsNotNull(subtype, "subtype");
        Intrinsics.checkParameterIsNotNull(typeChecker, "typeChecker");
        boolean isNonReifiedTypeParameter = TypeUtils.isNonReifiedTypeParameter(subtype);
        boolean isUpcast = typeChecker.isSubtypeOf(supertype, subtype);
        if (isNonReifiedTypeParameter && !isUpcast) {
            boolean nullableToDefinitelyNotNull;
            boolean bl = nullableToDefinitelyNotNull = !TypeUtils.isNullableType(subtype) && Intrinsics.areEqual(TypeUtilsKt.makeNotNullable(supertype), subtype);
            if (!nullableToDefinitelyNotNull) {
                return true;
            }
        }
        if (supertype.isMarkedNullable() || subtype.isMarkedNullable()) {
            KotlinType kotlinType = TypeUtils.makeNotNullable(supertype);
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.makeNotNullable(supertype)");
            KotlinType kotlinType2 = TypeUtils.makeNotNullable(subtype);
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNotNullable(subtype)");
            return CastDiagnosticsUtil.isCastErased(kotlinType, kotlinType2, typeChecker);
        }
        if (isUpcast) {
            return false;
        }
        if (isNonReifiedTypeParameter) {
            return true;
        }
        if (INSTANCE.allParametersReified(subtype)) {
            return false;
        }
        KotlinType kotlinType = CastDiagnosticsUtil.findStaticallyKnownSubtype(supertype, subtype.getConstructor()).getResultingType();
        if (kotlinType == null) {
            return true;
        }
        KotlinType staticallyKnownSubtype = kotlinType;
        return !typeChecker.isSubtypeOf(staticallyKnownSubtype, subtype);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TypeReconstructionResult findStaticallyKnownSubtype(@NotNull KotlinType supertype, @NotNull TypeConstructor subtypeConstructor) {
        Map map2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<TypeParameterDescriptor> variables;
        ClassifierDescriptor descriptor2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(supertype, "supertype");
        Intrinsics.checkParameterIsNotNull(subtypeConstructor, "subtypeConstructor");
        boolean bl2 = bl = !supertype.isMarkedNullable();
        if (_Assertions.ENABLED && !bl) {
            String string = "This method only makes sense for non-nullable types";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassifierDescriptor classifierDescriptor = subtypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            String $i$a$1$assert = "Can't create default type for " + subtypeConstructor;
            throw (Throwable)new IllegalStateException($i$a$1$assert.toString());
        }
        ClassifierDescriptor classifierDescriptor2 = descriptor2 = classifierDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor2, "descriptor");
        SimpleType subtypeWithVariables = classifierDescriptor2.getDefaultType();
        KotlinType supertypeWithVariables = TypeCheckingProcedure.findCorrespondingSupertype(subtypeWithVariables, supertype);
        List<TypeParameterDescriptor> list2 = variables = subtypeWithVariables.getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "variables");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void descriptor3;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v4 = descriptor3;
            Intrinsics.checkExpressionValueIsNotNull(v4, "descriptor");
            TypeConstructor typeConstructor2 = v4.getTypeConstructor();
            collection.add(typeConstructor2);
        }
        Set variableConstructors = CollectionsKt.toSet((List)destination$iv$iv);
        if (supertypeWithVariables != null) {
            TypeUnifier.UnificationResult solution2;
            destination$iv$iv = new Function1<TypeConstructor, Boolean>(variableConstructors){

                public final boolean invoke(@NotNull TypeConstructor p1) {
                    Intrinsics.checkParameterIsNotNull(p1, "p1");
                    return ((Set)this.receiver).contains(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(Set.class);
                }

                public final String getName() {
                    return "contains";
                }

                public final String getSignature() {
                    return "contains(Ljava/lang/Object;)Z";
                }
            };
            TypeUnifier.UnificationResult unificationResult = solution2 = TypeUnifier.unify(new TypeProjectionImpl(supertype), new TypeProjectionImpl(supertypeWithVariables), new CastDiagnosticsUtil$sam$java_util_function_Predicate$0((Function1)destination$iv$iv));
            Intrinsics.checkExpressionValueIsNotNull(unificationResult, "solution");
            HashMap<TypeConstructor, TypeProjection> hashMap = Maps.newHashMap(unificationResult.getSubstitution());
            Intrinsics.checkExpressionValueIsNotNull(hashMap, "Maps.newHashMap(solution.substitution)");
            map2 = hashMap;
        } else {
            HashMap hashMap = Maps.newHashMapWithExpectedSize(variables.size());
            Intrinsics.checkExpressionValueIsNotNull(hashMap, "Maps.newHashMapWithExpec\u2026ojection>(variables.size)");
            map2 = hashMap;
        }
        Map substitution2 = map2;
        boolean allArgumentsInferred = true;
        Iterator<Object> iterator2 = variables.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor variable2;
            TypeParameterDescriptor typeParameterDescriptor = variable2 = (TypeParameterDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "variable");
            TypeProjection value = (TypeProjection)substitution2.get(typeParameterDescriptor.getTypeConstructor());
            if (value != null) continue;
            TypeConstructor typeConstructor3 = variable2.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "variable.typeConstructor");
            TypeProjection typeProjection = TypeUtils.makeStarProjection(variable2);
            Intrinsics.checkExpressionValueIsNotNull(typeProjection, "TypeUtils.makeStarProjection(variable)");
            substitution2.put(typeConstructor3, typeProjection);
            allArgumentsInferred = false;
        }
        KotlinType substituted = TypeSubstitutor.create(substitution2).substitute(subtypeWithVariables, Variance.INVARIANT);
        return new TypeReconstructionResult(substituted, allArgumentsInferred);
    }

    private final boolean allParametersReified(KotlinType subtype) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list2 = subtype.getConstructor().getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "subtype.constructor.parameters");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it;
                    TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "it");
                    if (typeParameterDescriptor.isReified()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean castIsUseless(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull ExpressionTypingContext context, @NotNull KotlinType targetType, @NotNull KotlinType actualType) {
        Collection<KotlinType> possibleTypes;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(targetType, "targetType");
        Intrinsics.checkParameterIsNotNull(actualType, "actualType");
        KotlinType refinedTargetType = KtPsiUtil.isSafeCast(expression2) ? TypeUtils.makeNullable(targetType) : targetType;
        Collection<KotlinType> collection = possibleTypes = DataFlowAnalyzer.getAllPossibleTypes(expression2.getLeft(), actualType, context);
        Intrinsics.checkExpressionValueIsNotNull(collection, "possibleTypes");
        KotlinType kotlinType = refinedTargetType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "refinedTargetType");
        KotlinType kotlinType2 = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "context.expectedType");
        return this.isRefinementUseless(collection, kotlinType, this.shouldCheckForExactType(expression2, kotlinType2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRefinementUseless(@NotNull Collection<? extends KotlinType> possibleTypes, @NotNull KotlinType targetType, boolean shouldCheckForExactType) {
        boolean bl;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(possibleTypes, "possibleTypes");
        Intrinsics.checkParameterIsNotNull(targetType, "targetType");
        Iterable iterable = $receiver$iv = (Iterable)possibleTypes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            SimpleType simpleType2 = FlexibleTypesKt.upperIfFlexible((KotlinType)it);
            collection.add(simpleType2);
        }
        KotlinType kotlinType = TypeIntersector.intersectTypes((List)destination$iv$iv);
        if (kotlinType == null) {
            return false;
        }
        KotlinType intersectedType = kotlinType;
        if (shouldCheckForExactType) {
            KotlinType kotlinType2 = intersectedType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "intersectedType");
            bl = this.isExactTypeCast(kotlinType2, targetType);
        } else {
            KotlinType kotlinType3 = intersectedType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "intersectedType");
            bl = this.isUpcast(kotlinType3, targetType);
        }
        return bl;
    }

    private final boolean shouldCheckForExactType(KtBinaryExpressionWithTypeRHS expression2, KotlinType expectedType2) {
        if (TypeUtils.noExpectedType(expectedType2)) {
            return this.checkExactTypeForUselessCast(expression2);
        }
        return TypeUtils.isDontCarePlaceholder(expectedType2);
    }

    private final boolean isExactTypeCast(KotlinType candidateType, KotlinType targetType) {
        return Intrinsics.areEqual(candidateType, targetType) && FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
    }

    private final boolean isUpcast(KotlinType candidateType, KotlinType targetType) {
        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(candidateType, targetType)) {
            return false;
        }
        if (FunctionTypesKt.isFunctionType(candidateType) && FunctionTypesKt.isFunctionType(targetType)) {
            return FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
        }
        return true;
    }

    private final boolean checkExactTypeForUselessCast(KtBinaryExpressionWithTypeRHS expression2) {
        boolean bl;
        PsiElement parent2 = expression2.getParent();
        while (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtAnnotatedExpression) {
            parent2 = parent2.getParent();
        }
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtValueArgument) {
            bl = true;
        } else if (psiElement instanceof KtQualifiedExpression) {
            KtExpression receiver = ((KtQualifiedExpression)parent2).getReceiverExpression();
            bl = PsiTreeUtil.isAncestor(receiver, expression2, false);
        } else {
            bl = psiElement instanceof KtBinaryExpression || psiElement instanceof KtUnaryExpression ? true : psiElement instanceof KtProperty || psiElement instanceof KtPropertyAccessor || psiElement instanceof KtNamedFunction || psiElement instanceof KtFunctionLiteral;
        }
        return bl;
    }

    private CastDiagnosticsUtil() {
    }

    static {
        CastDiagnosticsUtil castDiagnosticsUtil;
        INSTANCE = castDiagnosticsUtil = new CastDiagnosticsUtil();
    }
}

