/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.Color;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginAdapter;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;
import org.protege.editor.owl.ui.selector.AbstractHierarchySelectorPanel;
import org.protege.editor.owl.ui.view.AbstractOWLPropertyHierarchyViewComponent;
import org.protege.editor.owl.ui.view.objectproperty.OWLObjectPropertyHierarchyViewComponent;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLObjectPropertySelectorPanel
extends AbstractHierarchySelectorPanel<OWLObjectProperty> {
    private static final long serialVersionUID = 1660438232937749573L;
    private AbstractOWLPropertyHierarchyViewComponent<OWLObjectProperty> vc;

    public OWLObjectPropertySelectorPanel(OWLEditorKit eKit) {
        this(eKit, true);
    }

    public OWLObjectPropertySelectorPanel(OWLEditorKit eKit, boolean editable) {
        this(eKit, editable, eKit.getModelManager().getOWLHierarchyManager().getOWLObjectPropertyHierarchyProvider());
    }

    public OWLObjectPropertySelectorPanel(OWLEditorKit eKit, boolean editable, OWLObjectHierarchyProvider<OWLObjectProperty> hp) {
        super(eKit, editable, hp);
    }

    @Override
    protected ViewComponentPlugin getViewComponentPlugin() {
        return new ViewComponentPluginAdapter(){

            public String getLabel() {
                return "Object properties";
            }

            public Workspace getWorkspace() {
                return OWLObjectPropertySelectorPanel.this.getOWLEditorKit().getWorkspace();
            }

            public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                OWLObjectPropertySelectorPanel.this.vc = new OWLObjectPropertyHierarchyViewComponent(){

                    @Override
                    protected void performExtraInitialisation() throws Exception {
                        if (OWLObjectPropertySelectorPanel.this.isEditable()) {
                            super.performExtraInitialisation();
                        }
                    }

                    @Override
                    protected OWLObjectHierarchyProvider<OWLObjectProperty> getHierarchyProvider() {
                        return OWLObjectPropertySelectorPanel.this.getHierarchyProvider();
                    }
                };
                OWLObjectPropertySelectorPanel.this.vc.setup((ViewComponentPlugin)this);
                return OWLObjectPropertySelectorPanel.this.vc;
            }

            public Color getBackgroundColor() {
                return OWLSystemColors.getOWLObjectPropertyColor();
            }
        };
    }

    @Override
    public void setSelection(OWLObjectProperty property) {
        this.vc.setSelectedEntity(property);
    }

    @Override
    public void setSelection(Set<OWLObjectProperty> properties) {
        this.vc.setSelectedEntities(properties);
    }

    @Override
    public OWLObjectProperty getSelectedObject() {
        return (OWLObjectProperty)this.vc.getSelectedEntity();
    }

    @Override
    public Set<OWLObjectProperty> getSelectedObjects() {
        return this.vc.getSelectedEntities();
    }

    @Override
    public void dispose() {
        this.vc.dispose();
    }

    @Override
    public void addSelectionListener(ChangeListener listener) {
        this.vc.addChangeListener(listener);
    }

    @Override
    public void removeSelectionListener(ChangeListener listener) {
        this.vc.removeChangeListener(listener);
    }
}

