/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.util.Message;

public abstract class AbstractFSManifestIterable {
    private final Object root;

    public AbstractFSManifestIterable(Object object) {
        this.root = object;
    }

    public Iterator iterator() {
        return new FSManifestIterator(this.root);
    }

    protected abstract List listBundleFiles(Object var1) throws IOException;

    protected abstract List listDirs(Object var1) throws IOException;

    protected abstract InputStream getInputStream(Object var1) throws IOException;

    protected abstract URI buildBundleURI(Object var1) throws IOException;

    class FSManifestIterator
    implements Iterator {
        private ManifestAndLocation next = null;
        private Stack dirs = new Stack();
        private Iterator bundleCandidates = null;
        private Object currentDir = null;

        FSManifestIterator(Object object) {
            this.dirs.add(Collections.singleton(object).iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (this.currentDir == null) {
                    if (((Iterator)this.dirs.peek()).hasNext()) {
                        this.currentDir = ((Iterator)this.dirs.peek()).next();
                        try {
                            this.bundleCandidates = AbstractFSManifestIterable.this.listBundleFiles(this.currentDir).iterator();
                        }
                        catch (IOException iOException) {
                            Message.warn("Unlistable dir: " + this.currentDir + " (" + iOException + ")");
                            this.currentDir = null;
                        }
                        continue;
                    }
                    if (this.dirs.size() <= 1) {
                        return false;
                    }
                    this.dirs.pop();
                    continue;
                }
                if (this.bundleCandidates.hasNext()) {
                    Object e = this.bundleCandidates.next();
                    ZipInputStream zipInputStream = null;
                    try {
                        zipInputStream = new JarInputStream(AbstractFSManifestIterable.this.getInputStream(e));
                        Manifest manifest = ((JarInputStream)zipInputStream).getManifest();
                        if (manifest != null) {
                            this.next = new ManifestAndLocation(manifest, AbstractFSManifestIterable.this.buildBundleURI(e));
                            continue;
                        }
                        Message.debug("No manifest in jar: " + e);
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Message.debug("Jar file just removed: " + e + " (" + fileNotFoundException + ")");
                        continue;
                    }
                    catch (IOException iOException) {
                        Message.warn("Unreadable jar: " + e + " (" + iOException + ")");
                        continue;
                    }
                    finally {
                        if (zipInputStream == null) continue;
                        try {
                            zipInputStream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                try {
                    this.dirs.add(AbstractFSManifestIterable.this.listDirs(this.currentDir).iterator());
                }
                catch (IOException iOException) {
                    Message.warn("Unlistable dir: " + this.currentDir + " (" + iOException + ")");
                    this.dirs.add(Collections.EMPTY_LIST.iterator());
                }
                this.currentDir = null;
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifestAndLocation = this.next;
            this.next = null;
            return manifestAndLocation;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

