# Volatility
# Copyright (c) 2008-2013 Volatility Foundation
#
# This file is part of Volatility.
#
# Volatility is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Volatility is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Volatility.  If not, see <http://www.gnu.org/licenses/>.
#

"""
@author:       MHL
@license:      GNU General Public License 2.0
@contact:      michael.ligh@mnin.org

This file provides support for Windows 2003 SP1/2.
"""

syscalls = [
    [
    'NtAcceptConnectPort', # 0x0
    'NtAccessCheck', # 0x1
    'NtAccessCheckAndAuditAlarm', # 0x2
    'NtAccessCheckByType', # 0x3
    'NtAccessCheckByTypeAndAuditAlarm', # 0x4
    'NtAccessCheckByTypeResultList', # 0x5
    'NtAccessCheckByTypeResultListAndAuditAlarm', # 0x6
    'NtAccessCheckByTypeResultListAndAuditAlarmByHandle', # 0x7
    'NtAddAtom', # 0x8
    'NtAddBootEntry', # 0x9
    'NtAddDriverEntry', # 0xa
    'NtAdjustGroupsToken', # 0xb
    'NtAdjustPrivilegesToken', # 0xc
    'NtAlertResumeThread', # 0xd
    'NtAlertThread', # 0xe
    'NtAllocateLocallyUniqueId', # 0xf
    'NtAllocateUserPhysicalPages', # 0x10
    'NtAllocateUuids', # 0x11
    'NtAllocateVirtualMemory', # 0x12
    'NtApphelpCacheControl', # 0x13
    'NtAreMappedFilesTheSame', # 0x14
    'NtAssignProcessToJobObject', # 0x15
    'NtCallbackReturn', # 0x16
    'NtCancelDeviceWakeupRequest', # 0x17
    'NtCancelIoFile', # 0x18
    'NtCancelTimer', # 0x19
    'NtClearEvent', # 0x1a
    'NtClose', # 0x1b
    'NtCloseObjectAuditAlarm', # 0x1c
    'NtCompactKeys', # 0x1d
    'NtCompareTokens', # 0x1e
    'NtCompleteConnectPort', # 0x1f
    'NtCompressKey', # 0x20
    'NtConnectPort', # 0x21
    'NtContinue', # 0x22
    'NtCreateDebugObject', # 0x23
    'NtCreateDirectoryObject', # 0x24
    'NtCreateEvent', # 0x25
    'NtCreateEventPair', # 0x26
    'NtCreateFile', # 0x27
    'NtCreateIoCompletion', # 0x28
    'NtCreateJobObject', # 0x29
    'NtCreateJobSet', # 0x2a
    'NtCreateKey', # 0x2b
    'NtCreateMailslotFile', # 0x2c
    'NtCreateMutant', # 0x2d
    'NtCreateNamedPipeFile', # 0x2e
    'NtCreatePagingFile', # 0x2f
    'NtCreatePort', # 0x30
    'NtCreateProcess', # 0x31
    'NtCreateProcessEx', # 0x32
    'NtCreateProfile', # 0x33
    'NtCreateSection', # 0x34
    'NtCreateSemaphore', # 0x35
    'NtCreateSymbolicLinkObject', # 0x36
    'NtCreateThread', # 0x37
    'NtCreateTimer', # 0x38
    'NtCreateToken', # 0x39
    'NtCreateWaitablePort', # 0x3a
    'NtDebugActiveProcess', # 0x3b
    'NtDebugContinue', # 0x3c
    'NtDelayExecution', # 0x3d
    'NtDeleteAtom', # 0x3e
    'NtDeleteBootEntry', # 0x3f
    'NtDeleteDriverEntry', # 0x40
    'NtDeleteFile', # 0x41
    'NtDeleteKey', # 0x42
    'NtDeleteObjectAuditAlarm', # 0x43
    'NtDeleteValueKey', # 0x44
    'NtDeviceIoControlFile', # 0x45
    'NtDisplayString', # 0x46
    'NtDuplicateObject', # 0x47
    'NtDuplicateToken', # 0x48
    'NtEnumerateBootEntries', # 0x49
    'NtEnumerateDriverEntries', # 0x4a
    'NtEnumerateKey', # 0x4b
    'NtEnumerateSystemEnvironmentValuesEx', # 0x4c
    'NtEnumerateValueKey', # 0x4d
    'NtExtendSection', # 0x4e
    'NtFilterToken', # 0x4f
    'NtFindAtom', # 0x50
    'NtFlushBuffersFile', # 0x51
    'NtFlushInstructionCache', # 0x52
    'NtFlushKey', # 0x53
    'NtFlushVirtualMemory', # 0x54
    'NtFlushWriteBuffer', # 0x55
    'NtFreeUserPhysicalPages', # 0x56
    'NtFreeVirtualMemory', # 0x57
    'NtFsControlFile', # 0x58
    'NtGetContextThread', # 0x59
    'NtGetDevicePowerState', # 0x5a
    'NtGetPlugPlayEvent', # 0x5b
    'NtGetWriteWatch', # 0x5c
    'NtImpersonateAnonymousToken', # 0x5d
    'NtImpersonateClientOfPort', # 0x5e
    'NtImpersonateThread', # 0x5f
    'NtInitializeRegistry', # 0x60
    'NtInitiatePowerAction', # 0x61
    'NtIsProcessInJob', # 0x62
    'NtIsSystemResumeAutomatic', # 0x63
    'NtListenPort', # 0x64
    'NtLoadDriver', # 0x65
    'NtLoadKey', # 0x66
    'NtLoadKey2', # 0x67
    'NtLoadKeyEx', # 0x68
    'NtLockFile', # 0x69
    'NtLockProductActivationKeys', # 0x6a
    'NtLockRegistryKey', # 0x6b
    'NtLockVirtualMemory', # 0x6c
    'NtMakePermanentObject', # 0x6d
    'NtMakeTemporaryObject', # 0x6e
    'NtMapUserPhysicalPages', # 0x6f
    'NtMapUserPhysicalPagesScatter', # 0x70
    'NtMapViewOfSection', # 0x71
    'NtModifyBootEntry', # 0x72
    'NtModifyDriverEntry', # 0x73
    'NtNotifyChangeDirectoryFile', # 0x74
    'NtNotifyChangeKey', # 0x75
    'NtNotifyChangeMultipleKeys', # 0x76
    'NtOpenDirectoryObject', # 0x77
    'NtOpenEvent', # 0x78
    'NtOpenEventPair', # 0x79
    'NtOpenFile', # 0x7a
    'NtOpenIoCompletion', # 0x7b
    'NtOpenJobObject', # 0x7c
    'NtOpenKey', # 0x7d
    'NtOpenMutant', # 0x7e
    'NtOpenObjectAuditAlarm', # 0x7f
    'NtOpenProcess', # 0x80
    'NtOpenProcessToken', # 0x81
    'NtOpenProcessTokenEx', # 0x82
    'NtOpenSection', # 0x83
    'NtOpenSemaphore', # 0x84
    'NtOpenSymbolicLinkObject', # 0x85
    'NtOpenThread', # 0x86
    'NtOpenThreadToken', # 0x87
    'NtOpenThreadTokenEx', # 0x88
    'NtOpenTimer', # 0x89
    'NtPlugPlayControl', # 0x8a
    'NtPowerInformation', # 0x8b
    'NtPrivilegeCheck', # 0x8c
    'NtPrivilegeObjectAuditAlarm', # 0x8d
    'NtPrivilegedServiceAuditAlarm', # 0x8e
    'NtProtectVirtualMemory', # 0x8f
    'NtPulseEvent', # 0x90
    'NtQueryAttributesFile', # 0x91
    'NtQueryBootEntryOrder', # 0x92
    'NtQueryBootOptions', # 0x93
    'NtQueryDebugFilterState', # 0x94
    'NtQueryDefaultLocale', # 0x95
    'NtQueryDefaultUILanguage', # 0x96
    'NtQueryDirectoryFile', # 0x97
    'NtQueryDirectoryObject', # 0x98
    'NtQueryDriverEntryOrder', # 0x99
    'NtQueryEaFile', # 0x9a
    'NtQueryEvent', # 0x9b
    'NtQueryFullAttributesFile', # 0x9c
    'NtQueryInformationAtom', # 0x9d
    'NtQueryInformationFile', # 0x9e
    'NtQueryInformationJobObject', # 0x9f
    'NtQueryInformationPort', # 0xa0
    'NtQueryInformationProcess', # 0xa1
    'NtQueryInformationThread', # 0xa2
    'NtQueryInformationToken', # 0xa3
    'NtQueryInstallUILanguage', # 0xa4
    'NtQueryIntervalProfile', # 0xa5
    'NtQueryIoCompletion', # 0xa6
    'NtQueryKey', # 0xa7
    'NtQueryMultipleValueKey', # 0xa8
    'NtQueryMutant', # 0xa9
    'NtQueryObject', # 0xaa
    'NtQueryOpenSubKeys', # 0xab
    'NtQueryOpenSubKeysEx', # 0xac
    'NtQueryPerformanceCounter', # 0xad
    'NtQueryQuotaInformationFile', # 0xae
    'NtQuerySection', # 0xaf
    'NtQuerySecurityObject', # 0xb0
    'NtQuerySemaphore', # 0xb1
    'NtQuerySymbolicLinkObject', # 0xb2
    'NtQuerySystemEnvironmentValue', # 0xb3
    'NtQuerySystemEnvironmentValueEx', # 0xb4
    'NtQuerySystemInformation', # 0xb5
    'NtQuerySystemTime', # 0xb6
    'NtQueryTimer', # 0xb7
    'NtQueryTimerResolution', # 0xb8
    'NtQueryValueKey', # 0xb9
    'NtQueryVirtualMemory', # 0xba
    'NtQueryVolumeInformationFile', # 0xbb
    'NtQueueApcThread', # 0xbc
    'NtRaiseException', # 0xbd
    'NtRaiseHardError', # 0xbe
    'NtReadFile', # 0xbf
    'NtReadFileScatter', # 0xc0
    'NtReadRequestData', # 0xc1
    'NtReadVirtualMemory', # 0xc2
    'NtRegisterThreadTerminatePort', # 0xc3
    'NtReleaseMutant', # 0xc4
    'NtReleaseSemaphore', # 0xc5
    'NtRemoveIoCompletion', # 0xc6
    'NtRemoveProcessDebug', # 0xc7
    'NtRenameKey', # 0xc8
    'NtReplaceKey', # 0xc9
    'NtReplyPort', # 0xca
    'NtReplyWaitReceivePort', # 0xcb
    'NtReplyWaitReceivePortEx', # 0xcc
    'NtReplyWaitReplyPort', # 0xcd
    'NtRequestDeviceWakeup', # 0xce
    'NtRequestPort', # 0xcf
    'NtRequestWaitReplyPort', # 0xd0
    'NtRequestWakeupLatency', # 0xd1
    'NtResetEvent', # 0xd2
    'NtResetWriteWatch', # 0xd3
    'NtRestoreKey', # 0xd4
    'NtResumeProcess', # 0xd5
    'NtResumeThread', # 0xd6
    'NtSaveKey', # 0xd7
    'NtSaveKeyEx', # 0xd8
    'NtSaveMergedKeys', # 0xd9
    'NtSecureConnectPort', # 0xda
    'NtSetBootEntryOrder', # 0xdb
    'NtSetBootOptions', # 0xdc
    'NtSetContextThread', # 0xdd
    'NtSetDebugFilterState', # 0xde
    'NtSetDefaultHardErrorPort', # 0xdf
    'NtSetDefaultLocale', # 0xe0
    'NtSetDefaultUILanguage', # 0xe1
    'NtSetDriverEntryOrder', # 0xe2
    'NtSetEaFile', # 0xe3
    'NtSetEvent', # 0xe4
    'NtSetEventBoostPriority', # 0xe5
    'NtSetHighEventPair', # 0xe6
    'NtSetHighWaitLowEventPair', # 0xe7
    'NtSetInformationDebugObject', # 0xe8
    'NtSetInformationFile', # 0xe9
    'NtSetInformationJobObject', # 0xea
    'NtSetInformationKey', # 0xeb
    'NtSetInformationObject', # 0xec
    'NtSetInformationProcess', # 0xed
    'NtSetInformationThread', # 0xee
    'NtSetInformationToken', # 0xef
    'NtSetIntervalProfile', # 0xf0
    'NtSetIoCompletion', # 0xf1
    'NtSetLdtEntries', # 0xf2
    'NtSetLowEventPair', # 0xf3
    'NtSetLowWaitHighEventPair', # 0xf4
    'NtSetQuotaInformationFile', # 0xf5
    'NtSetSecurityObject', # 0xf6
    'NtSetSystemEnvironmentValue', # 0xf7
    'NtSetSystemEnvironmentValueEx', # 0xf8
    'NtSetSystemInformation', # 0xf9
    'NtSetSystemPowerState', # 0xfa
    'NtSetSystemTime', # 0xfb
    'NtSetThreadExecutionState', # 0xfc
    'NtSetTimer', # 0xfd
    'NtSetTimerResolution', # 0xfe
    'NtSetUuidSeed', # 0xff
    'NtSetValueKey', # 0x100
    'NtSetVolumeInformationFile', # 0x101
    'NtShutdownSystem', # 0x102
    'NtSignalAndWaitForSingleObject', # 0x103
    'NtStartProfile', # 0x104
    'NtStopProfile', # 0x105
    'NtSuspendProcess', # 0x106
    'NtSuspendThread', # 0x107
    'NtSystemDebugControl', # 0x108
    'NtTerminateJobObject', # 0x109
    'NtTerminateProcess', # 0x10a
    'NtTerminateThread', # 0x10b
    'NtTestAlert', # 0x10c
    'NtTraceEvent', # 0x10d
    'NtTranslateFilePath', # 0x10e
    'NtUnloadDriver', # 0x10f
    'NtUnloadKey', # 0x110
    'NtUnloadKey2', # 0x111
    'NtUnloadKeyEx', # 0x112
    'NtUnlockFile', # 0x113
    'NtUnlockVirtualMemory', # 0x114
    'NtUnmapViewOfSection', # 0x115
    'NtVdmControl', # 0x116
    'NtWaitForDebugEvent', # 0x117
    'NtWaitForMultipleObjects', # 0x118
    'NtWaitForSingleObject', # 0x119
    'NtWaitHighEventPair', # 0x11a
    'NtWaitLowEventPair', # 0x11b
    'NtWriteFile', # 0x11c
    'NtWriteFileGather', # 0x11d
    'NtWriteRequestData', # 0x11e
    'NtWriteVirtualMemory', # 0x11f
    'NtYieldExecution', # 0x120
    'NtCreateKeyedEvent', # 0x121
    'NtOpenKeyedEvent', # 0x122
    'NtReleaseKeyedEvent', # 0x123
    'NtWaitForKeyedEvent', # 0x124
    'NtQueryPortInformationProcess', # 0x125
    'NtGetCurrentProcessorNumber', # 0x126
    'NtWaitForMultipleObjects32', # 0x127
    ],
    [
    'NtGdiAbortDoc', # 0x0
    'NtGdiAbortPath', # 0x1
    'NtGdiAddFontResourceW', # 0x2
    'NtGdiAddRemoteFontToDC', # 0x3
    'NtGdiAddFontMemResourceEx', # 0x4
    'NtGdiRemoveMergeFont', # 0x5
    'NtGdiAddRemoteMMInstanceToDC', # 0x6
    'NtGdiAlphaBlend', # 0x7
    'NtGdiAngleArc', # 0x8
    'NtGdiAnyLinkedFonts', # 0x9
    'NtGdiFontIsLinked', # 0xa
    'NtGdiArcInternal', # 0xb
    'NtGdiBeginPath', # 0xc
    'NtGdiBitBlt', # 0xd
    'NtGdiCancelDC', # 0xe
    'NtGdiCheckBitmapBits', # 0xf
    'NtGdiCloseFigure', # 0x10
    'NtGdiClearBitmapAttributes', # 0x11
    'NtGdiClearBrushAttributes', # 0x12
    'NtGdiColorCorrectPalette', # 0x13
    'NtGdiCombineRgn', # 0x14
    'NtGdiCombineTransform', # 0x15
    'NtGdiComputeXformCoefficients', # 0x16
    'NtGdiConsoleTextOut', # 0x17
    'NtGdiConvertMetafileRect', # 0x18
    'NtGdiCreateBitmap', # 0x19
    'NtGdiCreateClientObj', # 0x1a
    'NtGdiCreateColorSpace', # 0x1b
    'NtGdiCreateColorTransform', # 0x1c
    'NtGdiCreateCompatibleBitmap', # 0x1d
    'NtGdiCreateCompatibleDC', # 0x1e
    'NtGdiCreateDIBBrush', # 0x1f
    'NtGdiCreateDIBitmapInternal', # 0x20
    'NtGdiCreateDIBSection', # 0x21
    'NtGdiCreateEllipticRgn', # 0x22
    'NtGdiCreateHalftonePalette', # 0x23
    'NtGdiCreateHatchBrushInternal', # 0x24
    'NtGdiCreateMetafileDC', # 0x25
    'NtGdiCreatePaletteInternal', # 0x26
    'NtGdiCreatePatternBrushInternal', # 0x27
    'NtGdiCreatePen', # 0x28
    'NtGdiCreateRectRgn', # 0x29
    'NtGdiCreateRoundRectRgn', # 0x2a
    'NtGdiCreateServerMetaFile', # 0x2b
    'NtGdiCreateSolidBrush', # 0x2c
    'NtGdiD3dContextCreate', # 0x2d
    'NtGdiD3dContextDestroy', # 0x2e
    'NtGdiD3dContextDestroyAll', # 0x2f
    'NtGdiD3dValidateTextureStageState', # 0x30
    'NtGdiD3dDrawPrimitives2', # 0x31
    'NtGdiDdGetDriverState', # 0x32
    'NtGdiDdAddAttachedSurface', # 0x33
    'NtGdiDdAlphaBlt', # 0x34
    'NtGdiDdAttachSurface', # 0x35
    'NtGdiDdBeginMoCompFrame', # 0x36
    'NtGdiDdBlt', # 0x37
    'NtGdiDdCanCreateSurface', # 0x38
    'NtGdiDdCanCreateD3DBuffer', # 0x39
    'NtGdiDdColorControl', # 0x3a
    'NtGdiDdCreateDirectDrawObject', # 0x3b
    'NtGdiDdCreateSurface', # 0x3c
    'NtGdiDdCreateD3DBuffer', # 0x3d
    'NtGdiDdCreateMoComp', # 0x3e
    'NtGdiDdCreateSurfaceObject', # 0x3f
    'NtGdiDdDeleteDirectDrawObject', # 0x40
    'NtGdiDdDeleteSurfaceObject', # 0x41
    'NtGdiDdDestroyMoComp', # 0x42
    'NtGdiDdDestroySurface', # 0x43
    'NtGdiDdDestroyD3DBuffer', # 0x44
    'NtGdiDdEndMoCompFrame', # 0x45
    'NtGdiDdFlip', # 0x46
    'NtGdiDdFlipToGDISurface', # 0x47
    'NtGdiDdGetAvailDriverMemory', # 0x48
    'NtGdiDdGetBltStatus', # 0x49
    'NtGdiDdGetDC', # 0x4a
    'NtGdiDdGetDriverInfo', # 0x4b
    'NtGdiDdGetDxHandle', # 0x4c
    'NtGdiDdGetFlipStatus', # 0x4d
    'NtGdiDdGetInternalMoCompInfo', # 0x4e
    'NtGdiDdGetMoCompBuffInfo', # 0x4f
    'NtGdiDdGetMoCompGuids', # 0x50
    'NtGdiDdGetMoCompFormats', # 0x51
    'NtGdiDdGetScanLine', # 0x52
    'NtGdiDdLock', # 0x53
    'NtGdiDdLockD3D', # 0x54
    'NtGdiDdQueryDirectDrawObject', # 0x55
    'NtGdiDdQueryMoCompStatus', # 0x56
    'NtGdiDdReenableDirectDrawObject', # 0x57
    'NtGdiDdReleaseDC', # 0x58
    'NtGdiDdRenderMoComp', # 0x59
    'NtGdiDdResetVisrgn', # 0x5a
    'NtGdiDdSetColorKey', # 0x5b
    'NtGdiDdSetExclusiveMode', # 0x5c
    'NtGdiDdSetGammaRamp', # 0x5d
    'NtGdiDdCreateSurfaceEx', # 0x5e
    'NtGdiDdSetOverlayPosition', # 0x5f
    'NtGdiDdUnattachSurface', # 0x60
    'NtGdiDdUnlock', # 0x61
    'NtGdiDdUnlockD3D', # 0x62
    'NtGdiDdUpdateOverlay', # 0x63
    'NtGdiDdWaitForVerticalBlank', # 0x64
    'NtGdiDvpCanCreateVideoPort', # 0x65
    'NtGdiDvpColorControl', # 0x66
    'NtGdiDvpCreateVideoPort', # 0x67
    'NtGdiDvpDestroyVideoPort', # 0x68
    'NtGdiDvpFlipVideoPort', # 0x69
    'NtGdiDvpGetVideoPortBandwidth', # 0x6a
    'NtGdiDvpGetVideoPortField', # 0x6b
    'NtGdiDvpGetVideoPortFlipStatus', # 0x6c
    'NtGdiDvpGetVideoPortInputFormats', # 0x6d
    'NtGdiDvpGetVideoPortLine', # 0x6e
    'NtGdiDvpGetVideoPortOutputFormats', # 0x6f
    'NtGdiDvpGetVideoPortConnectInfo', # 0x70
    'NtGdiDvpGetVideoSignalStatus', # 0x71
    'NtGdiDvpUpdateVideoPort', # 0x72
    'NtGdiDvpWaitForVideoPortSync', # 0x73
    'NtGdiDvpAcquireNotification', # 0x74
    'NtGdiDvpReleaseNotification', # 0x75
    'NtGdiDxgGenericThunk', # 0x76
    'NtGdiDeleteClientObj', # 0x77
    'NtGdiDeleteColorSpace', # 0x78
    'NtGdiDeleteColorTransform', # 0x79
    'NtGdiDeleteObjectApp', # 0x7a
    'NtGdiDescribePixelFormat', # 0x7b
    'NtGdiGetPerBandInfo', # 0x7c
    'NtGdiDoBanding', # 0x7d
    'NtGdiDoPalette', # 0x7e
    'NtGdiDrawEscape', # 0x7f
    'NtGdiEllipse', # 0x80
    'NtGdiEnableEudc', # 0x81
    'NtGdiEndDoc', # 0x82
    'NtGdiEndPage', # 0x83
    'NtGdiEndPath', # 0x84
    'NtGdiEnumFontChunk', # 0x85
    'NtGdiEnumFontClose', # 0x86
    'NtGdiEnumFontOpen', # 0x87
    'NtGdiEnumObjects', # 0x88
    'NtGdiEqualRgn', # 0x89
    'NtGdiEudcLoadUnloadLink', # 0x8a
    'NtGdiExcludeClipRect', # 0x8b
    'NtGdiExtCreatePen', # 0x8c
    'NtGdiExtCreateRegion', # 0x8d
    'NtGdiExtEscape', # 0x8e
    'NtGdiExtFloodFill', # 0x8f
    'NtGdiExtGetObjectW', # 0x90
    'NtGdiExtSelectClipRgn', # 0x91
    'NtGdiExtTextOutW', # 0x92
    'NtGdiFillPath', # 0x93
    'NtGdiFillRgn', # 0x94
    'NtGdiFlattenPath', # 0x95
    'NtGdiFlush', # 0x96
    'NtGdiForceUFIMapping', # 0x97
    'NtGdiFrameRgn', # 0x98
    'NtGdiFullscreenControl', # 0x99
    'NtGdiGetAndSetDCDword', # 0x9a
    'NtGdiGetAppClipBox', # 0x9b
    'NtGdiGetBitmapBits', # 0x9c
    'NtGdiGetBitmapDimension', # 0x9d
    'NtGdiGetBoundsRect', # 0x9e
    'NtGdiGetCharABCWidthsW', # 0x9f
    'NtGdiGetCharacterPlacementW', # 0xa0
    'NtGdiGetCharSet', # 0xa1
    'NtGdiGetCharWidthW', # 0xa2
    'NtGdiGetCharWidthInfo', # 0xa3
    'NtGdiGetColorAdjustment', # 0xa4
    'NtGdiGetColorSpaceforBitmap', # 0xa5
    'NtGdiGetDCDword', # 0xa6
    'NtGdiGetDCforBitmap', # 0xa7
    'NtGdiGetDCObject', # 0xa8
    'NtGdiGetDCPoint', # 0xa9
    'NtGdiGetDeviceCaps', # 0xaa
    'NtGdiGetDeviceGammaRamp', # 0xab
    'NtGdiGetDeviceCapsAll', # 0xac
    'NtGdiGetDIBitsInternal', # 0xad
    'NtGdiGetETM', # 0xae
    'NtGdiGetEudcTimeStampEx', # 0xaf
    'NtGdiGetFontData', # 0xb0
    'NtGdiGetFontResourceInfoInternalW', # 0xb1
    'NtGdiGetGlyphIndicesW', # 0xb2
    'NtGdiGetGlyphIndicesWInternal', # 0xb3
    'NtGdiGetGlyphOutline', # 0xb4
    'NtGdiGetKerningPairs', # 0xb5
    'NtGdiGetLinkedUFIs', # 0xb6
    'NtGdiGetMiterLimit', # 0xb7
    'NtGdiGetMonitorID', # 0xb8
    'NtGdiGetNearestColor', # 0xb9
    'NtGdiGetNearestPaletteIndex', # 0xba
    'NtGdiGetObjectBitmapHandle', # 0xbb
    'NtGdiGetOutlineTextMetricsInternalW', # 0xbc
    'NtGdiGetPath', # 0xbd
    'NtGdiGetPixel', # 0xbe
    'NtGdiGetRandomRgn', # 0xbf
    'NtGdiGetRasterizerCaps', # 0xc0
    'NtGdiGetRealizationInfo', # 0xc1
    'NtGdiGetRegionData', # 0xc2
    'NtGdiGetRgnBox', # 0xc3
    'NtGdiGetServerMetaFileBits', # 0xc4
    'NtGdiGetSpoolMessage', # 0xc5
    'NtGdiGetStats', # 0xc6
    'NtGdiGetStockObject', # 0xc7
    'NtGdiGetStringBitmapW', # 0xc8
    'NtGdiGetSystemPaletteUse', # 0xc9
    'NtGdiGetTextCharsetInfo', # 0xca
    'NtGdiGetTextExtent', # 0xcb
    'NtGdiGetTextExtentExW', # 0xcc
    'NtGdiGetTextFaceW', # 0xcd
    'NtGdiGetTextMetricsW', # 0xce
    'NtGdiGetTransform', # 0xcf
    'NtGdiGetUFI', # 0xd0
    'NtGdiGetEmbUFI', # 0xd1
    'NtGdiGetUFIPathname', # 0xd2
    'NtGdiGetEmbedFonts', # 0xd3
    'NtGdiChangeGhostFont', # 0xd4
    'NtGdiAddEmbFontToDC', # 0xd5
    'NtGdiGetFontUnicodeRanges', # 0xd6
    'NtGdiGetWidthTable', # 0xd7
    'NtGdiGradientFill', # 0xd8
    'NtGdiHfontCreate', # 0xd9
    'NtGdiIcmBrushInfo', # 0xda
    'NtGdiInit', # 0xdb
    'NtGdiInitSpool', # 0xdc
    'NtGdiIntersectClipRect', # 0xdd
    'NtGdiInvertRgn', # 0xde
    'NtGdiLineTo', # 0xdf
    'NtGdiMakeFontDir', # 0xe0
    'NtGdiMakeInfoDC', # 0xe1
    'NtGdiMaskBlt', # 0xe2
    'NtGdiModifyWorldTransform', # 0xe3
    'NtGdiMonoBitmap', # 0xe4
    'NtGdiMoveTo', # 0xe5
    'NtGdiOffsetClipRgn', # 0xe6
    'NtGdiOffsetRgn', # 0xe7
    'NtGdiOpenDCW', # 0xe8
    'NtGdiPatBlt', # 0xe9
    'NtGdiPolyPatBlt', # 0xea
    'NtGdiPathToRegion', # 0xeb
    'NtGdiPlgBlt', # 0xec
    'NtGdiPolyDraw', # 0xed
    'NtGdiPolyPolyDraw', # 0xee
    'NtGdiPolyTextOutW', # 0xef
    'NtGdiPtInRegion', # 0xf0
    'NtGdiPtVisible', # 0xf1
    'NtGdiQueryFonts', # 0xf2
    'NtGdiQueryFontAssocInfo', # 0xf3
    'NtGdiRectangle', # 0xf4
    'NtGdiRectInRegion', # 0xf5
    'NtGdiRectVisible', # 0xf6
    'NtGdiRemoveFontResourceW', # 0xf7
    'NtGdiRemoveFontMemResourceEx', # 0xf8
    'NtGdiResetDC', # 0xf9
    'NtGdiResizePalette', # 0xfa
    'NtGdiRestoreDC', # 0xfb
    'NtGdiRoundRect', # 0xfc
    'NtGdiSaveDC', # 0xfd
    'NtGdiScaleViewportExtEx', # 0xfe
    'NtGdiScaleWindowExtEx', # 0xff
    'NtGdiSelectBitmap', # 0x100
    'NtGdiSelectBrush', # 0x101
    'NtGdiSelectClipPath', # 0x102
    'NtGdiSelectFont', # 0x103
    'NtGdiSelectPen', # 0x104
    'NtGdiSetBitmapAttributes', # 0x105
    'NtGdiSetBitmapBits', # 0x106
    'NtGdiSetBitmapDimension', # 0x107
    'NtGdiSetBoundsRect', # 0x108
    'NtGdiSetBrushAttributes', # 0x109
    'NtGdiSetBrushOrg', # 0x10a
    'NtGdiSetColorAdjustment', # 0x10b
    'NtGdiSetColorSpace', # 0x10c
    'NtGdiSetDeviceGammaRamp', # 0x10d
    'NtGdiSetDIBitsToDeviceInternal', # 0x10e
    'NtGdiSetFontEnumeration', # 0x10f
    'NtGdiSetFontXform', # 0x110
    'NtGdiSetIcmMode', # 0x111
    'NtGdiSetLinkedUFIs', # 0x112
    'NtGdiSetMagicColors', # 0x113
    'NtGdiSetMetaRgn', # 0x114
    'NtGdiSetMiterLimit', # 0x115
    'NtGdiGetDeviceWidth', # 0x116
    'NtGdiMirrorWindowOrg', # 0x117
    'NtGdiSetLayout', # 0x118
    'NtGdiSetPixel', # 0x119
    'NtGdiSetPixelFormat', # 0x11a
    'NtGdiSetRectRgn', # 0x11b
    'NtGdiSetSystemPaletteUse', # 0x11c
    'NtGdiSetTextJustification', # 0x11d
    'NtGdiSetupPublicCFONT', # 0x11e
    'NtGdiSetVirtualResolution', # 0x11f
    'NtGdiSetSizeDevice', # 0x120
    'NtGdiStartDoc', # 0x121
    'NtGdiStartPage', # 0x122
    'NtGdiStretchBlt', # 0x123
    'NtGdiStretchDIBitsInternal', # 0x124
    'NtGdiStrokeAndFillPath', # 0x125
    'NtGdiStrokePath', # 0x126
    'NtGdiSwapBuffers', # 0x127
    'NtGdiTransformPoints', # 0x128
    'NtGdiTransparentBlt', # 0x129
    'NtGdiUnloadPrinterDriver', # 0x12a
    'NtGdiUnmapMemFont', # 0x12b
    'NtGdiUnrealizeObject', # 0x12c
    'NtGdiUpdateColors', # 0x12d
    'NtGdiWidenPath', # 0x12e
    'NtUserActivateKeyboardLayout', # 0x12f
    'NtUserAlterWindowStyle', # 0x130
    'NtUserAssociateInputContext', # 0x131
    'NtUserAttachThreadInput', # 0x132
    'NtUserBeginPaint', # 0x133
    'NtUserBitBltSysBmp', # 0x134
    'NtUserBlockInput', # 0x135
    'NtUserBuildHimcList', # 0x136
    'NtUserBuildHwndList', # 0x137
    'NtUserBuildNameList', # 0x138
    'NtUserBuildPropList', # 0x139
    'NtUserCallHwnd', # 0x13a
    'NtUserCallHwndLock', # 0x13b
    'NtUserCallHwndOpt', # 0x13c
    'NtUserCallHwndParam', # 0x13d
    'NtUserCallHwndParamLock', # 0x13e
    'NtUserCallMsgFilter', # 0x13f
    'NtUserCallNextHookEx', # 0x140
    'NtUserCallNoParam', # 0x141
    'NtUserCallOneParam', # 0x142
    'NtUserCallTwoParam', # 0x143
    'NtUserChangeClipboardChain', # 0x144
    'NtUserChangeDisplaySettings', # 0x145
    'NtUserCheckImeHotKey', # 0x146
    'NtUserCheckMenuItem', # 0x147
    'NtUserChildWindowFromPointEx', # 0x148
    'NtUserClipCursor', # 0x149
    'NtUserCloseClipboard', # 0x14a
    'NtUserCloseDesktop', # 0x14b
    'NtUserCloseWindowStation', # 0x14c
    'NtUserConsoleControl', # 0x14d
    'NtUserConvertMemHandle', # 0x14e
    'NtUserCopyAcceleratorTable', # 0x14f
    'NtUserCountClipboardFormats', # 0x150
    'NtUserCreateAcceleratorTable', # 0x151
    'NtUserCreateCaret', # 0x152
    'NtUserCreateDesktop', # 0x153
    'NtUserCreateInputContext', # 0x154
    'NtUserCreateLocalMemHandle', # 0x155
    'NtUserCreateWindowEx', # 0x156
    'NtUserCreateWindowStation', # 0x157
    'NtUserDdeGetQualityOfService', # 0x158
    'NtUserDdeInitialize', # 0x159
    'NtUserDdeSetQualityOfService', # 0x15a
    'NtUserDeferWindowPos', # 0x15b
    'NtUserDefSetText', # 0x15c
    'NtUserDeleteMenu', # 0x15d
    'NtUserDestroyAcceleratorTable', # 0x15e
    'NtUserDestroyCursor', # 0x15f
    'NtUserDestroyInputContext', # 0x160
    'NtUserDestroyMenu', # 0x161
    'NtUserDestroyWindow', # 0x162
    'NtUserDisableThreadIme', # 0x163
    'NtUserDispatchMessage', # 0x164
    'NtUserDragDetect', # 0x165
    'NtUserDragObject', # 0x166
    'NtUserDrawAnimatedRects', # 0x167
    'NtUserDrawCaption', # 0x168
    'NtUserDrawCaptionTemp', # 0x169
    'NtUserDrawIconEx', # 0x16a
    'NtUserDrawMenuBarTemp', # 0x16b
    'NtUserEmptyClipboard', # 0x16c
    'NtUserEnableMenuItem', # 0x16d
    'NtUserEnableScrollBar', # 0x16e
    'NtUserEndDeferWindowPosEx', # 0x16f
    'NtUserEndMenu', # 0x170
    'NtUserEndPaint', # 0x171
    'NtUserEnumDisplayDevices', # 0x172
    'NtUserEnumDisplayMonitors', # 0x173
    'NtUserEnumDisplaySettings', # 0x174
    'NtUserEvent', # 0x175
    'NtUserExcludeUpdateRgn', # 0x176
    'NtUserFillWindow', # 0x177
    'NtUserFindExistingCursorIcon', # 0x178
    'NtUserFindWindowEx', # 0x179
    'NtUserFlashWindowEx', # 0x17a
    'NtUserGetAltTabInfo', # 0x17b
    'NtUserGetAncestor', # 0x17c
    'NtUserGetAppImeLevel', # 0x17d
    'NtUserGetAsyncKeyState', # 0x17e
    'NtUserGetAtomName', # 0x17f
    'NtUserGetCaretBlinkTime', # 0x180
    'NtUserGetCaretPos', # 0x181
    'NtUserGetClassInfoEx', # 0x182
    'NtUserGetClassName', # 0x183
    'NtUserGetClipboardData', # 0x184
    'NtUserGetClipboardFormatName', # 0x185
    'NtUserGetClipboardOwner', # 0x186
    'NtUserGetClipboardSequenceNumber', # 0x187
    'NtUserGetClipboardViewer', # 0x188
    'NtUserGetClipCursor', # 0x189
    'NtUserGetComboBoxInfo', # 0x18a
    'NtUserGetControlBrush', # 0x18b
    'NtUserGetControlColor', # 0x18c
    'NtUserGetCPD', # 0x18d
    'NtUserGetCursorFrameInfo', # 0x18e
    'NtUserGetCursorInfo', # 0x18f
    'NtUserGetDC', # 0x190
    'NtUserGetDCEx', # 0x191
    'NtUserGetDoubleClickTime', # 0x192
    'NtUserGetForegroundWindow', # 0x193
    'NtUserGetGuiResources', # 0x194
    'NtUserGetGUIThreadInfo', # 0x195
    'NtUserGetIconInfo', # 0x196
    'NtUserGetIconSize', # 0x197
    'NtUserGetImeHotKey', # 0x198
    'NtUserGetImeInfoEx', # 0x199
    'NtUserGetInternalWindowPos', # 0x19a
    'NtUserGetKeyboardLayoutList', # 0x19b
    'NtUserGetKeyboardLayoutName', # 0x19c
    'NtUserGetKeyboardState', # 0x19d
    'NtUserGetKeyNameText', # 0x19e
    'NtUserGetKeyState', # 0x19f
    'NtUserGetListBoxInfo', # 0x1a0
    'NtUserGetMenuBarInfo', # 0x1a1
    'NtUserGetMenuIndex', # 0x1a2
    'NtUserGetMenuItemRect', # 0x1a3
    'NtUserGetMessage', # 0x1a4
    'NtUserGetMouseMovePointsEx', # 0x1a5
    'NtUserGetObjectInformation', # 0x1a6
    'NtUserGetOpenClipboardWindow', # 0x1a7
    'NtUserGetPriorityClipboardFormat', # 0x1a8
    'NtUserGetProcessWindowStation', # 0x1a9
    'NtUserGetRawInputBuffer', # 0x1aa
    'NtUserGetRawInputData', # 0x1ab
    'NtUserGetRawInputDeviceInfo', # 0x1ac
    'NtUserGetRawInputDeviceList', # 0x1ad
    'NtUserGetRegisteredRawInputDevices', # 0x1ae
    'NtUserGetScrollBarInfo', # 0x1af
    'NtUserGetSystemMenu', # 0x1b0
    'NtUserGetThreadDesktop', # 0x1b1
    'NtUserGetThreadState', # 0x1b2
    'NtUserGetTitleBarInfo', # 0x1b3
    'NtUserGetUpdateRect', # 0x1b4
    'NtUserGetUpdateRgn', # 0x1b5
    'NtUserGetWindowDC', # 0x1b6
    'NtUserGetWindowPlacement', # 0x1b7
    'NtUserGetWOWClass', # 0x1b8
    'NtUserHardErrorControl', # 0x1b9
    'NtUserHideCaret', # 0x1ba
    'NtUserHiliteMenuItem', # 0x1bb
    'NtUserImpersonateDdeClientWindow', # 0x1bc
    'NtUserInitialize', # 0x1bd
    'NtUserInitializeClientPfnArrays', # 0x1be
    'NtUserInitTask', # 0x1bf
    'NtUserInternalGetWindowText', # 0x1c0
    'NtUserInvalidateRect', # 0x1c1
    'NtUserInvalidateRgn', # 0x1c2
    'NtUserIsClipboardFormatAvailable', # 0x1c3
    'NtUserKillTimer', # 0x1c4
    'NtUserLoadKeyboardLayoutEx', # 0x1c5
    'NtUserLockWindowStation', # 0x1c6
    'NtUserLockWindowUpdate', # 0x1c7
    'NtUserLockWorkStation', # 0x1c8
    'NtUserMapVirtualKeyEx', # 0x1c9
    'NtUserMenuItemFromPoint', # 0x1ca
    'NtUserMessageCall', # 0x1cb
    'NtUserMinMaximize', # 0x1cc
    'NtUserMNDragLeave', # 0x1cd
    'NtUserMNDragOver', # 0x1ce
    'NtUserModifyUserStartupInfoFlags', # 0x1cf
    'NtUserMoveWindow', # 0x1d0
    'NtUserNotifyIMEStatus', # 0x1d1
    'NtUserNotifyProcessCreate', # 0x1d2
    'NtUserNotifyWinEvent', # 0x1d3
    'NtUserOpenClipboard', # 0x1d4
    'NtUserOpenDesktop', # 0x1d5
    'NtUserOpenInputDesktop', # 0x1d6
    'NtUserOpenWindowStation', # 0x1d7
    'NtUserPaintDesktop', # 0x1d8
    'NtUserPeekMessage', # 0x1d9
    'NtUserPostMessage', # 0x1da
    'NtUserPostThreadMessage', # 0x1db
    'NtUserPrintWindow', # 0x1dc
    'NtUserProcessConnect', # 0x1dd
    'NtUserQueryInformationThread', # 0x1de
    'NtUserQueryInputContext', # 0x1df
    'NtUserQuerySendMessage', # 0x1e0
    'NtUserQueryWindow', # 0x1e1
    'NtUserRealChildWindowFromPoint', # 0x1e2
    'NtUserRealInternalGetMessage', # 0x1e3
    'NtUserRealWaitMessageEx', # 0x1e4
    'NtUserRedrawWindow', # 0x1e5
    'NtUserRegisterClassExWOW', # 0x1e6
    'NtUserRegisterUserApiHook', # 0x1e7
    'NtUserRegisterHotKey', # 0x1e8
    'NtUserRegisterRawInputDevices', # 0x1e9
    'NtUserRegisterTasklist', # 0x1ea
    'NtUserRegisterWindowMessage', # 0x1eb
    'NtUserRemoveMenu', # 0x1ec
    'NtUserRemoveProp', # 0x1ed
    'NtUserResolveDesktop', # 0x1ee
    'NtUserResolveDesktopForWOW', # 0x1ef
    'NtUserSBGetParms', # 0x1f0
    'NtUserScrollDC', # 0x1f1
    'NtUserScrollWindowEx', # 0x1f2
    'NtUserSelectPalette', # 0x1f3
    'NtUserSendInput', # 0x1f4
    'NtUserSetActiveWindow', # 0x1f5
    'NtUserSetAppImeLevel', # 0x1f6
    'NtUserSetCapture', # 0x1f7
    'NtUserSetClassLong', # 0x1f8
    'NtUserSetClassWord', # 0x1f9
    'NtUserSetClipboardData', # 0x1fa
    'NtUserSetClipboardViewer', # 0x1fb
    'NtUserSetConsoleReserveKeys', # 0x1fc
    'NtUserSetCursor', # 0x1fd
    'NtUserSetCursorContents', # 0x1fe
    'NtUserSetCursorIconData', # 0x1ff
    'NtUserSetFocus', # 0x200
    'NtUserSetImeHotKey', # 0x201
    'NtUserSetImeInfoEx', # 0x202
    'NtUserSetImeOwnerWindow', # 0x203
    'NtUserSetInformationProcess', # 0x204
    'NtUserSetInformationThread', # 0x205
    'NtUserSetInternalWindowPos', # 0x206
    'NtUserSetKeyboardState', # 0x207
    'NtUserSetLogonNotifyWindow', # 0x208
    'NtUserSetMenu', # 0x209
    'NtUserSetMenuContextHelpId', # 0x20a
    'NtUserSetMenuDefaultItem', # 0x20b
    'NtUserSetMenuFlagRtoL', # 0x20c
    'NtUserSetObjectInformation', # 0x20d
    'NtUserSetParent', # 0x20e
    'NtUserSetProcessWindowStation', # 0x20f
    'NtUserSetProp', # 0x210
    'NtUserSetScrollInfo', # 0x211
    'NtUserSetShellWindowEx', # 0x212
    'NtUserSetSysColors', # 0x213
    'NtUserSetSystemCursor', # 0x214
    'NtUserSetSystemMenu', # 0x215
    'NtUserSetSystemTimer', # 0x216
    'NtUserSetThreadDesktop', # 0x217
    'NtUserSetThreadLayoutHandles', # 0x218
    'NtUserSetThreadState', # 0x219
    'NtUserSetTimer', # 0x21a
    'NtUserSetWindowFNID', # 0x21b
    'NtUserSetWindowLong', # 0x21c
    'NtUserSetWindowPlacement', # 0x21d
    'NtUserSetWindowPos', # 0x21e
    'NtUserSetWindowRgn', # 0x21f
    'NtUserSetWindowsHookAW', # 0x220
    'NtUserSetWindowsHookEx', # 0x221
    'NtUserSetWindowStationUser', # 0x222
    'NtUserSetWindowWord', # 0x223
    'NtUserSetWinEventHook', # 0x224
    'NtUserShowCaret', # 0x225
    'NtUserShowScrollBar', # 0x226
    'NtUserShowWindow', # 0x227
    'NtUserShowWindowAsync', # 0x228
    'NtUserSoundSentry', # 0x229
    'NtUserSwitchDesktop', # 0x22a
    'NtUserSystemParametersInfo', # 0x22b
    'NtUserTestForInteractiveUser', # 0x22c
    'NtUserThunkedMenuInfo', # 0x22d
    'NtUserThunkedMenuItemInfo', # 0x22e
    'NtUserToUnicodeEx', # 0x22f
    'NtUserTrackMouseEvent', # 0x230
    'NtUserTrackPopupMenuEx', # 0x231
    'NtUserCalcMenuBar', # 0x232
    'NtUserPaintMenuBar', # 0x233
    'NtUserTranslateAccelerator', # 0x234
    'NtUserTranslateMessage', # 0x235
    'NtUserUnhookWindowsHookEx', # 0x236
    'NtUserUnhookWinEvent', # 0x237
    'NtUserUnloadKeyboardLayout', # 0x238
    'NtUserUnlockWindowStation', # 0x239
    'NtUserUnregisterClass', # 0x23a
    'NtUserUnregisterUserApiHook', # 0x23b
    'NtUserUnregisterHotKey', # 0x23c
    'NtUserUpdateInputContext', # 0x23d
    'NtUserUpdateInstance', # 0x23e
    'NtUserUpdateLayeredWindow', # 0x23f
    'NtUserGetLayeredWindowAttributes', # 0x240
    'NtUserSetLayeredWindowAttributes', # 0x241
    'NtUserUpdatePerUserSystemParameters', # 0x242
    'NtUserUserHandleGrantAccess', # 0x243
    'NtUserValidateHandleSecure', # 0x244
    'NtUserValidateRect', # 0x245
    'NtUserValidateTimerCallback', # 0x246
    'NtUserVkKeyScanEx', # 0x247
    'NtUserWaitForInputIdle', # 0x248
    'NtUserWaitForMsgAndEvent', # 0x249
    'NtUserWaitMessage', # 0x24a
    'NtUserWin32PoolAllocationStats', # 0x24b
    'NtUserWindowFromPoint', # 0x24c
    'NtUserYieldTask', # 0x24d
    'NtUserRemoteConnect', # 0x24e
    'NtUserRemoteRedrawRectangle', # 0x24f
    'NtUserRemoteRedrawScreen', # 0x250
    'NtUserRemoteStopScreenUpdates', # 0x251
    'NtUserCtxDisplayIOCtl', # 0x252
    'NtGdiEngAssociateSurface', # 0x253
    'NtGdiEngCreateBitmap', # 0x254
    'NtGdiEngCreateDeviceSurface', # 0x255
    'NtGdiEngCreateDeviceBitmap', # 0x256
    'NtGdiEngCreatePalette', # 0x257
    'NtGdiEngComputeGlyphSet', # 0x258
    'NtGdiEngCopyBits', # 0x259
    'NtGdiEngDeletePalette', # 0x25a
    'NtGdiEngDeleteSurface', # 0x25b
    'NtGdiEngEraseSurface', # 0x25c
    'NtGdiEngUnlockSurface', # 0x25d
    'NtGdiEngLockSurface', # 0x25e
    'NtGdiEngBitBlt', # 0x25f
    'NtGdiEngStretchBlt', # 0x260
    'NtGdiEngPlgBlt', # 0x261
    'NtGdiEngMarkBandingSurface', # 0x262
    'NtGdiEngStrokePath', # 0x263
    'NtGdiEngFillPath', # 0x264
    'NtGdiEngStrokeAndFillPath', # 0x265
    'NtGdiEngPaint', # 0x266
    'NtGdiEngLineTo', # 0x267
    'NtGdiEngAlphaBlend', # 0x268
    'NtGdiEngGradientFill', # 0x269
    'NtGdiEngTransparentBlt', # 0x26a
    'NtGdiEngTextOut', # 0x26b
    'NtGdiEngStretchBltROP', # 0x26c
    'NtGdiXLATEOBJ_cGetPalette', # 0x26d
    'NtGdiXLATEOBJ_iXlate', # 0x26e
    'NtGdiXLATEOBJ_hGetColorTransform', # 0x26f
    'NtGdiCLIPOBJ_bEnum', # 0x270
    'NtGdiCLIPOBJ_cEnumStart', # 0x271
    'NtGdiCLIPOBJ_ppoGetPath', # 0x272
    'NtGdiEngDeletePath', # 0x273
    'NtGdiEngCreateClip', # 0x274
    'NtGdiEngDeleteClip', # 0x275
    'NtGdiBRUSHOBJ_ulGetBrushColor', # 0x276
    'NtGdiBRUSHOBJ_pvAllocRbrush', # 0x277
    'NtGdiBRUSHOBJ_pvGetRbrush', # 0x278
    'NtGdiBRUSHOBJ_hGetColorTransform', # 0x279
    'NtGdiXFORMOBJ_bApplyXform', # 0x27a
    'NtGdiXFORMOBJ_iGetXform', # 0x27b
    'NtGdiFONTOBJ_vGetInfo', # 0x27c
    'NtGdiFONTOBJ_pxoGetXform', # 0x27d
    'NtGdiFONTOBJ_cGetGlyphs', # 0x27e
    'NtGdiFONTOBJ_pifi', # 0x27f
    'NtGdiFONTOBJ_pfdg', # 0x280
    'NtGdiFONTOBJ_pQueryGlyphAttrs', # 0x281
    'NtGdiFONTOBJ_pvTrueTypeFontFile', # 0x282
    'NtGdiFONTOBJ_cGetAllGlyphHandles', # 0x283
    'NtGdiSTROBJ_bEnum', # 0x284
    'NtGdiSTROBJ_bEnumPositionsOnly', # 0x285
    'NtGdiSTROBJ_bGetAdvanceWidths', # 0x286
    'NtGdiSTROBJ_vEnumStart', # 0x287
    'NtGdiSTROBJ_dwGetCodePage', # 0x288
    'NtGdiPATHOBJ_vGetBounds', # 0x289
    'NtGdiPATHOBJ_bEnum', # 0x28a
    'NtGdiPATHOBJ_vEnumStart', # 0x28b
    'NtGdiPATHOBJ_vEnumStartClipLines', # 0x28c
    'NtGdiPATHOBJ_bEnumClipLines', # 0x28d
    'NtGdiGetDhpdev', # 0x28e
    'NtGdiEngCheckAbort', # 0x28f
    'NtGdiHT_Get8BPPFormatPalette', # 0x290
    'NtGdiHT_Get8BPPMaskPalette', # 0x291
    'NtGdiUpdateTransform', # 0x292
    'NtGdiSetPUMPDOBJ', # 0x293
    'NtGdiBRUSHOBJ_DeleteRbrush', # 0x294
    'NtGdiUMPDEngFreeUserMem', # 0x295
    'NtGdiDrawStream', # 0x296
    'NtGdiMakeObjectXferable', # 0x297
    'DxEngGetRedirectionBitmap', # 0x298
    ],
]
