/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.api.GenericColor;
import javajs.awt.EventManager;
import javajs.awt.Font;
import javajs.util.CU;
import javajs.util.Lst;
import jspecview.api.AnnotationData;
import jspecview.api.JSVPanel;
import jspecview.api.PanelListener;
import jspecview.api.VisibleInterface;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.Coordinate;
import jspecview.common.GraphSet;
import jspecview.common.Integral;
import jspecview.common.JSVFileManager;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.common.MeasurementData;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PlotWidget;
import jspecview.common.PrintLayout;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.dialog.JSVDialog;
import org.jmol.api.GenericGraphics;
import org.jmol.util.Logger;

public class PanelData
implements EventManager {
    public GenericGraphics g2d;
    public GenericGraphics g2d0;
    JSViewer vwr;
    private Lst<PanelListener> listeners = new Lst();
    private GraphSet currentGraphSet;
    public Hashtable<ScriptToken, Object> options = new Hashtable();
    public JSVPanel jsvp;
    public Lst<GraphSet> graphSets;
    public int currentSplitPoint;
    public PlotWidget thisWidget;
    public Coordinate coordClicked;
    public Coordinate[] coordsClicked;
    public static final int defaultPrintHeight = 450;
    public static final int defaultPrintWidth = 280;
    public static final int topMargin = 40;
    public static final int bottomMargin = 50;
    public static final int leftMargin = 60;
    public static final int rightMargin = 50;
    public boolean ctrlPressed;
    public boolean shiftPressed;
    public boolean drawXAxisLeftToRight;
    public boolean isIntegralDrag;
    public boolean xAxisLeftToRight = true;
    public int scalingFactor = 1;
    public int integralShiftMode;
    public int left = 60;
    public int right = 50;
    public String coordStr = "";
    public String startupPinTip = "Click to set.";
    public String title;
    int clickCount;
    private int nSpectra;
    public int thisWidth;
    private int thisHeight;
    private int startIndex;
    private int endIndex;
    private String commonFilePath;
    private String viewTitle;
    private String displayFontName;
    private String titleFontName;
    public boolean isPrinting;
    private boolean doReset = true;
    public String printingFontName;
    public String printGraphPosition = "default";
    public boolean titleDrawn;
    public boolean display1D;
    public boolean isLinked;
    public String printJobTitle;
    public Lst<Spectrum> spectra;
    private boolean taintedAll = true;
    private boolean testingJavaScript;
    private Font currentFont;
    private Mouse mouseState;
    public boolean gridOn;
    public boolean titleOn;
    public boolean peakTabsOn;
    public int mouseX;
    public int mouseY;
    private boolean linking;
    public int xPixelClicked;
    public GenericColor coordinatesColor;
    public GenericColor gridColor;
    public GenericColor integralPlotColor;
    public GenericColor peakTabColor;
    public GenericColor plotAreaColor;
    public GenericColor scaleColor;
    public GenericColor titleColor;
    public GenericColor unitsColor;
    public GenericColor highlightColor;
    public GenericColor zoomBoxColor;
    public GenericColor zoomBoxColor2;
    public GenericColor BLACK;
    public GenericColor bgcolor;
    public Hashtable<ScriptToken, Object> optionsSaved;
    private Object gMain;

    public PanelData(JSVPanel jSVPanel, JSViewer jSViewer) {
        this.vwr = jSViewer;
        this.jsvp = jSVPanel;
        this.g2d = this.g2d0 = jSViewer.g2d;
        this.BLACK = this.g2d.getColor1(0);
        this.highlightColor = this.g2d.getColor4(255, 0, 0, 200);
        this.zoomBoxColor = this.g2d.getColor4(150, 150, 100, 130);
        this.zoomBoxColor2 = this.g2d.getColor4(150, 100, 100, 130);
    }

    public void addListener(PanelListener panelListener) {
        if (!this.listeners.contains(panelListener)) {
            this.listeners.addLast(panelListener);
        }
    }

    public GraphSet getCurrentGraphSet() {
        return this.currentGraphSet;
    }

    public void dispose() {
        this.jsvp = null;
        for (int i = 0; i < this.graphSets.size(); ++i) {
            ((GraphSet)this.graphSets.get(i)).dispose();
        }
        this.graphSets = null;
        this.currentFont = null;
        this.currentGraphSet = null;
        this.coordClicked = null;
        this.coordsClicked = null;
        this.thisWidget = null;
        this.options = null;
        this.listeners = null;
    }

    public void setViewTitle(String string) {
        this.viewTitle = string;
    }

    public String getViewTitle() {
        return this.viewTitle == null ? this.getTitle() : this.viewTitle;
    }

    public Map<String, Object> getInfo(boolean bl, String string) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Lst<Map<String, Object>> lst = null;
        if (bl) {
            return this.currentGraphSet.getInfo(string, this.getCurrentSpectrumIndex());
        }
        Set<Map.Entry<ScriptToken, Object>> set = this.options.entrySet();
        if ("".equals(string)) {
            Object object = "type title nSets ";
            for (Map.Entry<ScriptToken, Object> entry : set) {
                object = (String)object + entry.getKey().name() + " ";
            }
            hashtable.put("KEYS", object);
        } else {
            for (Map.Entry entry : set) {
                Parameters.putInfo(string, hashtable, ((ScriptToken)((Object)entry.getKey())).name(), entry.getValue());
            }
            Parameters.putInfo(string, hashtable, "type", this.getSpectrumAt(0).getDataType());
            Parameters.putInfo(string, hashtable, "title", this.title);
            Parameters.putInfo(string, hashtable, "nSets", this.graphSets.size());
        }
        lst = new Lst<Map<String, Object>>();
        int n = this.graphSets.size();
        while (--n >= 0) {
            lst.addLast(((GraphSet)this.graphSets.get(n)).getInfo(string, -1));
        }
        hashtable.put("sets", lst);
        return hashtable;
    }

    public void setBooleans(Parameters parameters, ScriptToken scriptToken) {
        if (scriptToken == null) {
            Map<ScriptToken, Boolean> map = parameters.getBooleans();
            for (Map.Entry<ScriptToken, Boolean> entry : map.entrySet()) {
                this.setBooleans(parameters, entry.getKey());
            }
            return;
        }
        this.setBoolean(scriptToken, parameters.getBoolean(scriptToken));
    }

    public void setBoolean(ScriptToken scriptToken, boolean bl) {
        this.setTaintedAll();
        if (scriptToken == ScriptToken.REVERSEPLOT) {
            this.currentGraphSet.setReversePlot(bl);
            return;
        }
        this.options.put(scriptToken, bl);
        switch (scriptToken) {
            case DISPLAY1D: 
            case DISPLAY2D: {
                this.doReset = true;
            }
        }
    }

    public boolean getBoolean(ScriptToken scriptToken) {
        if (scriptToken == ScriptToken.REVERSEPLOT) {
            return this.currentGraphSet.reversePlot;
        }
        if (this.options == null) {
            return false;
        }
        Object object = this.options.get((Object)scriptToken);
        return object != null && object instanceof Boolean && (Boolean)object == Boolean.TRUE;
    }

    public void setFontName(ScriptToken scriptToken, String string) {
        switch (scriptToken) {
            case DISPLAYFONTNAME: {
                this.displayFontName = string;
                break;
            }
            case TITLEFONTNAME: {
                this.titleFontName = string;
            }
        }
        if (string != null) {
            this.options.put(scriptToken, string);
        }
    }

    public boolean getDisplay1D() {
        return this.display1D;
    }

    public void setTaintedAll() {
        this.taintedAll = true;
    }

    public void initOne(Spectrum spectrum) {
        this.spectra = new Lst();
        this.spectra.addLast(spectrum);
        this.initMany(this.spectra, 0, 0);
    }

    public void initMany(Lst<Spectrum> lst, int n, int n2) {
        this.startIndex = n;
        this.endIndex = n2;
        this.nSpectra = lst.size();
        this.spectra = lst;
        this.commonFilePath = ((Spectrum)lst.get(0)).getFilePath();
        for (int i = 0; i < this.nSpectra; ++i) {
            if (this.commonFilePath.equalsIgnoreCase(((Spectrum)lst.get(i)).getFilePath())) continue;
            this.commonFilePath = null;
            break;
        }
        this.setGraphSets(LinkMode.NONE);
    }

    private void setGraphSets(LinkMode linkMode) {
        this.graphSets = GraphSet.createGraphSetsAndSetLinkMode(this, this.jsvp, this.spectra, this.startIndex, this.endIndex, linkMode);
        this.currentGraphSet = (GraphSet)this.graphSets.get(0);
        this.title = this.getSpectrum().getTitleLabel();
    }

    public PeakInfo findMatchingPeakInfo(PeakInfo peakInfo) {
        PeakInfo peakInfo2 = null;
        for (int i = 0; i < this.graphSets.size() && (peakInfo2 = ((GraphSet)this.graphSets.get(i)).findMatchingPeakInfo(peakInfo)) == null; ++i) {
        }
        return peakInfo2;
    }

    public void integrateAll(ColorParameters colorParameters) {
        int n = this.graphSets.size();
        while (--n >= 0) {
            ((GraphSet)this.graphSets.get(n)).integrate(-1, colorParameters);
        }
    }

    public int getNumberOfGraphSets() {
        return this.graphSets.size();
    }

    public String getTitle() {
        return this.title;
    }

    public void refresh() {
        this.doReset = true;
    }

    public void addAnnotation(Lst<String> lst) {
        String string = this.currentGraphSet.addAnnotation(lst, this.getTitle());
        if (string != null) {
            this.title = string;
        }
    }

    public void addPeakHighlight(PeakInfo peakInfo) {
        for (int i = 0; i < this.graphSets.size(); ++i) {
            ((GraphSet)this.graphSets.get(i)).addPeakHighlight(peakInfo);
        }
    }

    public PeakInfo selectPeakByFileIndex(String string, String string2, String string3) {
        PeakInfo peakInfo;
        block1: {
            peakInfo = this.currentGraphSet.selectPeakByFileIndex(string, string2, string3);
            if (peakInfo != null) break block1;
            int n = this.graphSets.size();
            while (--n >= 0 && (this.graphSets.get(n) == this.currentGraphSet || (peakInfo = ((GraphSet)this.graphSets.get(n)).selectPeakByFileIndex(string, string2, string3)) == null)) {
            }
        }
        return peakInfo;
    }

    public void setPlotColors(GenericColor[] genericColorArray) {
        int n = this.graphSets.size();
        while (--n >= 0) {
            ((GraphSet)this.graphSets.get(n)).setPlotColors(genericColorArray);
        }
    }

    public void selectSpectrum(String string, String string2, String string3, boolean bl) {
        if (bl) {
            this.currentGraphSet.selectSpectrum(string, string2, string3);
        }
        if ("ID".equals(string2)) {
            this.jumpToSpectrumIndex(this.getCurrentSpectrumIndex(), true);
            return;
        }
        for (int i = 0; i < this.graphSets.size(); ++i) {
            if (this.graphSets.get(i) == this.currentGraphSet) continue;
            ((GraphSet)this.graphSets.get(i)).selectSpectrum(string, string2, string3);
        }
    }

    public boolean hasFileLoaded(String string) {
        int n = this.graphSets.size();
        while (--n >= 0) {
            if (!((GraphSet)this.graphSets.get(n)).hasFileLoaded(string)) continue;
            return true;
        }
        return false;
    }

    public void clearAllView() {
        int n = this.graphSets.size();
        while (--n >= 0) {
            ((GraphSet)this.graphSets.get(n)).resetViewCompletely();
        }
    }

    public synchronized void drawGraph(Object object, Object object2, Object object3, int n, int n2, boolean bl) {
        boolean bl2;
        boolean bl3;
        this.gMain = object;
        this.display1D = !this.isLinked && this.getBoolean(ScriptToken.DISPLAY1D);
        int n3 = 40;
        int n4 = 50;
        boolean bl4 = bl3 = this.isPrinting || this.doReset || this.thisWidth != n || this.thisHeight != n2;
        if (bl3) {
            this.setTaintedAll();
        }
        if (this.taintedAll) {
            this.g2d.fillBackground(object3, this.bgcolor);
        }
        if (object2 != object) {
            this.g2d.fillBackground(object2, null);
            if (object != object3) {
                this.g2d.fillBackground(object, null);
            }
            this.g2d.setStrokeBold(object, false);
        }
        if (this.isPrinting) {
            n3 *= 3;
            n4 *= 3;
            this.scalingFactor = 10;
            bl2 = false;
        } else {
            this.scalingFactor = 1;
            bl2 = this.getBoolean(ScriptToken.COORDINATESON);
            this.titleOn = this.getBoolean(ScriptToken.TITLEON);
            this.gridOn = this.getBoolean(ScriptToken.GRIDON);
            this.peakTabsOn = this.getBoolean(ScriptToken.PEAKTABSON);
        }
        this.doReset = false;
        this.titleDrawn = false;
        this.thisWidth = n;
        this.thisHeight = n2;
        int n5 = this.graphSets.size();
        while (--n5 >= 0) {
            ((GraphSet)this.graphSets.get(n5)).drawGraphSet(object, object2, object3, n, n2, this.left, this.right, n3, n4, bl3, this.taintedAll);
        }
        if (this.titleOn && !this.titleDrawn && this.taintedAll) {
            this.drawTitle(object, n2 * this.scalingFactor, n * this.scalingFactor, this.getDrawTitle(this.isPrinting));
        }
        if (bl2 && this.coordStr != null) {
            this.drawCoordinates(object2, n3, this.thisWidth - this.right, n3 - 20);
        }
        if (bl && this.taintedAll) {
            String string;
            String string2 = this.commonFilePath != null ? this.commonFilePath : (string = this.graphSets.size() == 1 && this.currentGraphSet.getTitle(true) != null ? this.getSpectrum().getFilePath() : null);
            if (string != null) {
                this.printFilePath(object, this.left, n2, string);
            }
        }
        if (this.isPrinting) {
            this.printVersion(object, n2);
        }
        if (!this.testingJavaScript && (this.isPrinting || object == object2)) {
            this.setTaintedAll();
        } else {
            this.taintedAll = false;
        }
    }

    public void drawCoordinates(Object object, int n, int n2, int n3) {
        this.g2d.setGraphicsColor(object, this.coordinatesColor);
        Font font = this.setFont(object, this.jsvp.getWidth(), 1, 14.0f, true);
        this.g2d.drawString(object, this.coordStr, n2 - font.stringWidth(this.coordStr), n3);
    }

    public Font setFont(Object object, int n, int n2, float f, boolean bl) {
        return this.g2d.setFont(object, this.getFont(object, n, n2, f, bl));
    }

    public void printFilePath(Object object, int n, int n2, String string) {
        n *= this.scalingFactor;
        n2 *= this.scalingFactor;
        if (string.indexOf("?") > 0) {
            string = string.substring(string.indexOf("?") + 1);
        }
        string = string.substring(string.lastIndexOf("/") + 1);
        string = string.substring(string.lastIndexOf("\\") + 1);
        this.g2d.setGraphicsColor(object, this.BLACK);
        Font font = this.setFont(object, 1000, 0, 9.0f, true);
        if (n != this.left * this.scalingFactor) {
            n -= font.stringWidth(string);
        }
        this.g2d.drawString(object, string, n, n2 - font.getHeight());
    }

    public void printVersion(Object object, int n) {
        this.g2d.setGraphicsColor(object, this.BLACK);
        Font font = this.setFont(object, 100, 0, 12.0f, true);
        String string = this.jsvp.getApiPlatform().getDateFormat(null) + " JSpecView " + JSVersion.VERSION_SHORT;
        int n2 = font.stringWidth(string);
        this.g2d.drawString(object, string, (this.thisWidth - this.right) * this.scalingFactor - n2, n * this.scalingFactor - font.getHeight() * 3);
    }

    public void drawTitle(Object object, int n, int n2, String string) {
        string = string.replace('\n', ' ');
        Font font = this.getFont(object, n2, this.isPrinting || this.getBoolean(ScriptToken.TITLEBOLDON) ? 1 : 0, 14.0f, true);
        int n3 = font.stringWidth(string);
        if (n3 > n2) {
            int n4 = (int)(14.0 * (double)n2 / (double)n3);
            if (n4 < 10) {
                n4 = 10;
            }
            font = this.getFont(object, n2, this.isPrinting || this.getBoolean(ScriptToken.TITLEBOLDON) ? 1 : 0, n4, true);
        }
        this.g2d.setGraphicsColor(object, this.titleColor);
        this.setCurrentFont(this.g2d.setFont(object, font));
        this.g2d.drawString(object, string, this.isPrinting ? this.left * this.scalingFactor : 5, n - (int)((double)font.getHeight() * (this.isPrinting ? 2.0 : 0.5)));
    }

    private void setCurrentFont(Font font) {
        this.currentFont = font;
    }

    int getFontHeight() {
        return this.currentFont.getAscent();
    }

    int getStringWidth(String string) {
        return this.currentFont.stringWidth(string);
    }

    public void selectFromEntireSet(int n) {
        int n2 = 0;
        for (int i = 0; i < this.graphSets.size(); ++i) {
            if (n == Integer.MIN_VALUE) {
                ((GraphSet)this.graphSets.get(i)).setSelected(-1);
                continue;
            }
            Lst<Spectrum> lst = ((GraphSet)this.graphSets.get((int)i)).spectra;
            int n3 = 0;
            while (n3 < lst.size()) {
                if (n < 0 || n == n2) {
                    ((GraphSet)this.graphSets.get(i)).setSelected(n3);
                }
                ++n3;
                ++n2;
            }
        }
    }

    public void addToList(int n, Lst<Spectrum> lst) {
        for (int i = 0; i < this.spectra.size(); ++i) {
            if (n >= 0 && i != n) continue;
            lst.addLast((Spectrum)this.spectra.get(i));
        }
    }

    public void scaleSelectedBy(double d) {
        int n = this.graphSets.size();
        while (--n >= 0) {
            ((GraphSet)this.graphSets.get(n)).scaleSelectedBy(d);
        }
    }

    private boolean setCurrentGraphSet(GraphSet graphSet, int n) {
        int n2 = graphSet.nSplit > 1 ? graphSet.getSplitPoint(n) : graphSet.getCurrentSpectrumIndex();
        boolean bl = this.currentGraphSet != graphSet;
        boolean bl2 = bl || this.currentSplitPoint != n2;
        this.currentGraphSet = graphSet;
        this.currentSplitPoint = n2;
        if (bl || graphSet.nSplit > 1 && bl2) {
            this.setSpectrum(n2, true);
        }
        if (!bl) {
            bl = graphSet.checkSpectrumClickedEvent(this.mouseX, this.mouseY, this.clickCount);
            if (!bl) {
                return false;
            }
            this.currentSplitPoint = n2 = graphSet.getCurrentSpectrumIndex();
            this.setSpectrum(n2, true);
        }
        this.jumpToSpectrumIndex(n2, bl || graphSet.nSplit > 1 && bl2);
        return bl;
    }

    public void jumpToSpectrum(Spectrum spectrum) {
        int n = this.currentGraphSet.getSpectrumIndex(spectrum);
        this.jumpToSpectrumIndex(n, true);
    }

    public void jumpToSpectrumIndex(int n, boolean bl) {
        if (n < 0 || n >= this.currentGraphSet.nSpectra) {
            return;
        }
        this.currentSplitPoint = n;
        if (bl) {
            this.setSpectrum(this.currentSplitPoint, this.currentGraphSet.nSplit > 1);
        }
        Spectrum spectrum = this.getSpectrum();
        this.notifySubSpectrumChange(spectrum.getSubIndex(), spectrum);
    }

    public void splitStack(boolean bl) {
        this.currentGraphSet.splitStack(bl);
    }

    public int getNumberOfSpectraInCurrentSet() {
        return this.currentGraphSet.nSpectra;
    }

    public String getSourceID() {
        String string = this.getSpectrum().sourceID;
        return string == null ? this.getSpectrumAt((int)0).sourceID : string;
    }

    public int getStartingPointIndex(int n) {
        return this.currentGraphSet.viewData.getStartingPointIndex(n);
    }

    public int getEndingPointIndex(int n) {
        return this.currentGraphSet.viewData.getEndingPointIndex(n);
    }

    public boolean haveSelectedSpectrum() {
        return this.currentGraphSet.haveSelectedSpectrum();
    }

    public boolean getShowAnnotation(Annotation.AType aType) {
        return this.currentGraphSet.getShowAnnotation(aType, -1);
    }

    public void showAnnotation(Annotation.AType aType, Boolean bl) {
        this.currentGraphSet.setShowAnnotation(aType, bl);
    }

    public void setYStackOffsetPercent(int n) {
        this.currentGraphSet.yStackOffsetPercent = n;
    }

    public void setSpectrum(int n, boolean bl) {
        this.currentGraphSet.setSpectrum(n, bl);
    }

    public Spectrum getSpectrum() {
        return this.currentGraphSet.getSpectrum();
    }

    public void setSpecForIRMode(Spectrum spectrum) {
        this.setTaintedAll();
        Spectrum spectrum2 = this.currentGraphSet.getSpectrum();
        this.currentGraphSet.setSpectrumJDX(spectrum);
        for (int i = 0; i < this.spectra.size(); ++i) {
            if (this.spectra.get(i) != spectrum2) continue;
            this.spectra.set(i, spectrum);
        }
    }

    public boolean isShowAllStacked() {
        return this.currentGraphSet.showAllStacked;
    }

    public int getCurrentSpectrumIndex() {
        return this.currentGraphSet.getCurrentSpectrumIndex();
    }

    public Spectrum getSpectrumAt(int n) {
        if (this.currentGraphSet == null) {
            return null;
        }
        return this.currentGraphSet.getSpectrumAt(n);
    }

    public void addHighlight(GraphSet graphSet, double d, double d2, Spectrum spectrum, int n, int n2, int n3, int n4) {
        (graphSet == null ? this.currentGraphSet : graphSet).addHighlight(d, d2, spectrum, this.g2d.getColor4(n, n2, n3, n4));
    }

    public void removeHighlight(double d, double d2) {
        this.currentGraphSet.removeHighlight(d, d2);
    }

    public void removeAllHighlights() {
        this.currentGraphSet.removeAllHighlights();
    }

    public void setZoom(double d, double d2, double d3, double d4) {
        this.currentGraphSet.setZoom(d, d2, d3, d4);
        this.doReset = true;
        this.setTaintedAll();
        this.notifyListeners(new ZoomEvent());
    }

    public void resetView() {
        this.currentGraphSet.resetView();
    }

    public void previousView() {
        this.currentGraphSet.previousView();
    }

    public void nextView() {
        this.currentGraphSet.nextView();
    }

    public Integral getSelectedIntegral() {
        return this.currentGraphSet.getSelectedIntegral();
    }

    public void advanceSubSpectrum(int n) {
        this.currentGraphSet.advanceSubSpectrum(n);
    }

    public void setSelectedIntegral(double d) {
        this.currentGraphSet.setSelectedIntegral(d);
    }

    public void scaleYBy(double d) {
        this.currentGraphSet.scaleYBy(d);
    }

    public void toPeak(int n) {
        this.currentGraphSet.toPeak(n);
    }

    public Coordinate getClickedCoordinate() {
        return this.coordClicked;
    }

    public boolean getPickedCoordinates(Coordinate coordinate, Coordinate coordinate2) {
        return Coordinate.getPickedCoordinates(this.coordsClicked, this.coordClicked, coordinate, coordinate2);
    }

    public boolean shiftSpectrum(int n, double d, double d2) {
        return this.currentGraphSet.shiftSpectrum(n, d, d2);
    }

    public void findX(Spectrum spectrum, double d) {
        this.currentGraphSet.setXPointer(spectrum, d);
    }

    public void setXPointers(Spectrum spectrum, double d, Spectrum spectrum2, double d2) {
        this.currentGraphSet.setXPointer(spectrum, d);
        this.currentGraphSet.setXPointer2(spectrum2, d2);
    }

    public boolean isCurrentGraphSet(GraphSet graphSet) {
        return graphSet == this.currentGraphSet;
    }

    public void repaint() {
        this.jsvp.doRepaint(false);
    }

    public void setToolTipText(String string) {
        this.jsvp.setToolTipText(string);
    }

    public void setHighlightColor(GenericColor genericColor) {
        this.setColor(ScriptToken.HIGHLIGHTCOLOR, genericColor);
    }

    String getInput(String string, String string2, String string3) {
        return this.jsvp.getInput(string, string2, string3);
    }

    private Font getFont(Object object, int n, int n2, float f, boolean bl) {
        f *= (float)this.scalingFactor;
        if (bl) {
            if (n < 400) {
                f = (float)n * f / 400.0f;
            }
        } else if (n < 250) {
            f = (float)n * f / 250.0f;
        }
        int n3 = this.jsvp.getFontFaceID(this.isPrinting ? this.printingFontName : this.displayFontName);
        this.currentFont = Font.createFont3D(n3, n2, f, f, this.jsvp.getApiPlatform(), object);
        return this.currentFont;
    }

    public void notifySubSpectrumChange(int n, Spectrum spectrum) {
        this.notifyListeners(new SubSpecChangeEvent(n, spectrum == null ? null : spectrum.getTitleLabel()));
    }

    public void notifyPeakPickedListeners(PeakPickEvent peakPickEvent) {
        if (peakPickEvent == null) {
            peakPickEvent = new PeakPickEvent(this.jsvp, this.coordClicked, this.getSpectrum().getAssociatedPeakInfo(this.xPixelClicked, this.coordClicked));
        }
        this.notifyListeners(peakPickEvent);
    }

    public void notifyListeners(Object object) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) == null) continue;
            ((PanelListener)this.listeners.get(i)).panelEvent(object);
        }
    }

    public void escapeKeyPressed(boolean bl) {
        this.currentGraphSet.escapeKeyPressed(bl);
    }

    public boolean hasFocus() {
        return this.jsvp.hasFocus();
    }

    public boolean isMouseUp() {
        return this.mouseState == Mouse.UP;
    }

    public void doMouseMoved(int n, int n2) {
        this.mouseX = n;
        this.mouseY = n2;
        this.mouseState = Mouse.UP;
        this.clickCount = 0;
        GraphSet graphSet = GraphSet.findGraphSet(this.graphSets, n, n2);
        if (graphSet == null) {
            return;
        }
        graphSet.mouseMovedEvent(n, n2);
    }

    public void doMousePressed(int n, int n2) {
        this.mouseState = Mouse.DOWN;
        GraphSet graphSet = GraphSet.findGraphSet(this.graphSets, n, n2);
        if (graphSet == null) {
            return;
        }
        this.setCurrentGraphSet(graphSet, n2);
        ++this.clickCount;
        this.clickCount %= 3;
        this.currentGraphSet.mousePressedEvent(n, n2, this.clickCount);
    }

    public void doMouseDragged(int n, int n2) {
        this.isIntegralDrag |= this.ctrlPressed;
        this.mouseState = Mouse.DOWN;
        if (GraphSet.findGraphSet(this.graphSets, n, n2) != this.currentGraphSet) {
            return;
        }
        if (this.currentGraphSet.checkWidgetEvent(n, n2, false)) {
            this.setTaintedAll();
        }
        this.currentGraphSet.mouseMovedEvent(n, n2);
    }

    public void doMouseReleased(int n, int n2, boolean bl) {
        this.mouseState = Mouse.UP;
        if (this.thisWidget == null && this.currentGraphSet.pendingMeasurement == null || !bl) {
            return;
        }
        this.currentGraphSet.mouseReleasedEvent(n, n2);
        this.thisWidget = null;
        this.isIntegralDrag = false;
        this.integralShiftMode = 0;
    }

    public void doMouseClicked(int n, int n2, boolean bl) {
        GraphSet graphSet = GraphSet.findGraphSet(this.graphSets, n, n2);
        if (graphSet == null) {
            return;
        }
        this.setCurrentGraphSet(graphSet, n2);
        graphSet.mouseClickedEvent(n, n2, this.clickCount, bl);
        this.setTaintedAll();
        this.repaint();
    }

    public boolean hasCurrentMeasurements(Annotation.AType aType) {
        return this.currentGraphSet.hasCurrentMeasurement(aType);
    }

    public AnnotationData getDialog(Annotation.AType aType) {
        return this.currentGraphSet.getDialog(aType, -1);
    }

    public void addDialog(int n, Annotation.AType aType, AnnotationData annotationData) {
        this.currentGraphSet.addDialog(n, aType, annotationData);
    }

    public void getPeakListing(Parameters parameters, Boolean bl) {
        if (parameters != null) {
            this.currentGraphSet.getPeakListing(-1, parameters, true);
        }
        this.currentGraphSet.setPeakListing(bl);
    }

    public void checkIntegral(Parameters parameters, String string) {
        this.currentGraphSet.checkIntegralParams(parameters, string);
    }

    public void setIntegrationRatios(String string) {
        this.currentGraphSet.setIntegrationRatios(string);
    }

    public ScaleData getView() {
        return this.currentGraphSet.getCurrentView();
    }

    public void closeAllDialogsExcept(Annotation.AType aType) {
        int n = this.graphSets.size();
        while (--n >= 0) {
            ((GraphSet)this.graphSets.get(n)).closeDialogsExcept(aType);
        }
    }

    public void removeDialog(JSVDialog jSVDialog) {
        this.currentGraphSet.removeDialog(jSVDialog);
    }

    public void normalizeIntegral() {
        Integral integral = this.getSelectedIntegral();
        if (integral == null) {
            return;
        }
        String string = integral.text;
        if (string.length() == 0) {
            string = "" + integral.getValue();
        }
        String string2 = this.getInput("Enter a new value for this integral", "Normalize Integral", string);
        try {
            this.setSelectedIntegral(Double.parseDouble(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDrawTitle(boolean bl) {
        String string = null;
        if (bl) {
            string = this.printJobTitle;
        } else if (this.nSpectra == 1) {
            string = this.getSpectrum().getPeakTitle();
        } else if (this.viewTitle != null) {
            if (this.currentGraphSet.getTitle(false) != null) {
                string = this.getSpectrum().getPeakTitle();
            }
            if (string == null) {
                string = this.viewTitle;
            }
        } else {
            string = this.jsvp.getTitle().trim();
        }
        if (string.indexOf("\n") >= 0) {
            string = string.substring(0, string.indexOf("\n")).trim();
        }
        return string;
    }

    public String getPrintJobTitle(boolean bl) {
        String string = null;
        if (this.nSpectra == 1) {
            string = this.getSpectrum().getTitle();
        } else if (this.viewTitle != null) {
            if (this.graphSets.size() == 1) {
                string = this.currentGraphSet.getTitle(bl);
            }
            if (string == null) {
                string = this.viewTitle;
            }
        } else {
            string = this.jsvp.getTitle().trim();
        }
        if (string.indexOf("\n") >= 0) {
            string = string.substring(0, string.indexOf("\n")).trim();
        } else if (string.startsWith("$")) {
            string = string.substring(1);
        }
        return string;
    }

    public synchronized void linkSpectra(LinkMode linkMode) {
        if (linkMode == LinkMode.ALL) {
            LinkMode linkMode2 = this.nSpectra == 2 ? LinkMode.AB : (linkMode = this.nSpectra == 3 ? LinkMode.ABC : LinkMode.NONE);
        }
        if (linkMode != LinkMode.NONE && linkMode.toString().length() != this.nSpectra) {
            return;
        }
        this.setGraphSets(linkMode);
    }

    public void doZoomLinked(GraphSet graphSet, double d, double d2, boolean bl, boolean bl2, boolean bl3) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        Spectrum spectrum = graphSet.getSpectrumAt(0);
        int n = this.graphSets.size();
        while (--n >= 0) {
            GraphSet graphSet2 = (GraphSet)this.graphSets.get(n);
            if (graphSet2 == graphSet || !Spectrum.areXScalesCompatible(spectrum, ((GraphSet)this.graphSets.get(n)).getSpectrumAt(0), false, true)) continue;
            graphSet2.doZoom(d, 0.0, d2, 0.0, bl3, false, bl2, false, bl);
        }
        this.linking = false;
    }

    public void clearLinkViews(GraphSet graphSet) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        Spectrum spectrum = graphSet.getSpectrum();
        int n = this.graphSets.size();
        while (--n >= 0) {
            GraphSet graphSet2 = (GraphSet)this.graphSets.get(n);
            if (graphSet2 == graphSet || !Spectrum.areXScalesCompatible(spectrum, ((GraphSet)this.graphSets.get(n)).getSpectrum(), false, true)) continue;
            graphSet2.clearViews();
        }
        this.linking = false;
    }

    public void setlinkedXMove(GraphSet graphSet, double d, boolean bl) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        Spectrum spectrum = graphSet.getSpectrum();
        int n = this.graphSets.size();
        while (--n >= 0) {
            GraphSet graphSet2 = (GraphSet)this.graphSets.get(n);
            if (graphSet2 == graphSet || !Spectrum.areXScalesCompatible(spectrum, ((GraphSet)this.graphSets.get(n)).getSpectrum(), false, true) || graphSet2.imageView != null) continue;
            if (bl) {
                graphSet2.setXPixelMovedTo(Double.MAX_VALUE, d, 0, 0);
                continue;
            }
            graphSet2.setXPixelMovedTo(d, Double.MAX_VALUE, 0, 0);
        }
        this.linking = false;
    }

    public void set2DCrossHairsLinked(GraphSet graphSet, double d, double d2, boolean bl) {
        int n = this.graphSets.size();
        while (--n >= 0) {
            GraphSet graphSet2 = (GraphSet)this.graphSets.get(n);
            if (graphSet2 == graphSet) continue;
            graphSet2.set2DXY(d, d2, bl);
        }
    }

    public void dialogsToFront(Spectrum spectrum) {
        this.currentGraphSet.dialogsToFront(spectrum);
    }

    public void setColor(ScriptToken scriptToken, GenericColor genericColor) {
        if (genericColor != null) {
            this.options.put(scriptToken, CU.toRGBHexString(genericColor));
        }
        switch (scriptToken) {
            case COORDINATESCOLOR: {
                this.coordinatesColor = genericColor;
                return;
            }
            case HIGHLIGHTCOLOR: {
                this.highlightColor = genericColor;
                if (this.highlightColor.getOpacity255() == 255) {
                    this.highlightColor.setOpacity255(150);
                }
                return;
            }
            case ZOOMBOXCOLOR: {
                this.zoomBoxColor = genericColor;
                return;
            }
            case ZOOMBOXCOLOR2: {
                this.zoomBoxColor2 = genericColor;
                return;
            }
            case BACKGROUNDCOLOR: {
                this.bgcolor = genericColor;
                this.jsvp.setBackgroundColor(this.bgcolor);
                break;
            }
            case GRIDCOLOR: {
                this.gridColor = genericColor;
                break;
            }
            case INTEGRALPLOTCOLOR: {
                this.integralPlotColor = genericColor;
                break;
            }
            case PEAKTABCOLOR: {
                this.peakTabColor = genericColor;
                break;
            }
            case PLOTCOLOR: {
                int n = this.graphSets.size();
                while (--n >= 0) {
                    ((GraphSet)this.graphSets.get(n)).setPlotColor0(genericColor);
                }
                break;
            }
            case PLOTAREACOLOR: {
                this.plotAreaColor = genericColor;
                break;
            }
            case SCALECOLOR: {
                this.scaleColor = genericColor;
                break;
            }
            case TITLECOLOR: {
                this.titleColor = genericColor;
                break;
            }
            case UNITSCOLOR: {
                this.unitsColor = genericColor;
                break;
            }
            default: {
                Logger.warn("AwtPanel --- unrecognized color: " + (Object)((Object)scriptToken));
                return;
            }
        }
        this.taintedAll = true;
    }

    public GenericColor getColor(ScriptToken scriptToken) {
        switch (scriptToken) {
            default: {
                Logger.error("awtgraphset missing color " + (Object)((Object)scriptToken));
                return this.BLACK;
            }
            case ZOOMBOXCOLOR2: {
                return this.zoomBoxColor2;
            }
            case ZOOMBOXCOLOR: {
                return this.zoomBoxColor;
            }
            case HIGHLIGHTCOLOR: {
                return this.highlightColor;
            }
            case INTEGRALPLOTCOLOR: {
                return this.integralPlotColor;
            }
            case GRIDCOLOR: {
                return this.gridColor;
            }
            case PEAKTABCOLOR: {
                return this.peakTabColor;
            }
            case PLOTAREACOLOR: {
                return this.plotAreaColor;
            }
            case SCALECOLOR: {
                return this.scaleColor;
            }
            case TITLECOLOR: {
                return this.titleColor;
            }
            case UNITSCOLOR: 
        }
        return this.unitsColor;
    }

    public Object[][] getOverlayLegendData() {
        String string;
        int n = this.currentGraphSet.nSpectra;
        Object[][] objectArray = new Object[n][];
        String string2 = this.getSpectrumAt(0).getFilePath();
        boolean bl = !string2.equals(string = this.getSpectrumAt(n - 1).getFilePath());
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2 = new Object[3];
            Spectrum spectrum = this.getSpectrumAt(i);
            this.title = spectrum.getTitle();
            if (bl) {
                this.title = JSVFileManager.getTagName(spectrum.getFilePath()) + " - " + this.title;
            }
            GenericColor genericColor = this.getCurrentPlotColor(i);
            objectArray2[0] = new Integer(i + 1);
            objectArray2[1] = genericColor;
            objectArray2[2] = " " + this.title;
            objectArray[i] = objectArray2;
        }
        return objectArray;
    }

    public void setColorOrFont(ColorParameters colorParameters, ScriptToken scriptToken) {
        if (scriptToken == null) {
            Map<ScriptToken, GenericColor> map = colorParameters.elementColors;
            for (Map.Entry<ScriptToken, GenericColor> entry : map.entrySet()) {
                this.setColorOrFont(colorParameters, entry.getKey());
            }
            this.setColorOrFont(colorParameters, ScriptToken.DISPLAYFONTNAME);
            this.setColorOrFont(colorParameters, ScriptToken.TITLEFONTNAME);
            return;
        }
        switch (scriptToken) {
            case DISPLAYFONTNAME: {
                this.setFontName(scriptToken, colorParameters.displayFontName);
                return;
            }
            case TITLEFONTNAME: {
                this.setFontName(scriptToken, colorParameters.titleFontName);
                return;
            }
        }
        this.setColor(scriptToken, colorParameters.getElementColor(scriptToken));
    }

    public GenericColor getCurrentPlotColor(int n) {
        return this.currentGraphSet.getPlotColor(n);
    }

    public void setPrint(PrintLayout printLayout, String string) {
        if (printLayout == null) {
            this.options.putAll(this.optionsSaved);
            this.optionsSaved = null;
            return;
        }
        this.printJobTitle = printLayout.title;
        this.printingFontName = string;
        this.printGraphPosition = printLayout.position;
        this.optionsSaved = new Hashtable();
        this.optionsSaved.putAll(this.options);
        this.gridOn = printLayout.showGrid;
        this.titleOn = printLayout.showTitle;
        this.setBoolean(ScriptToken.XSCALEON, printLayout.showXScale);
        this.setBoolean(ScriptToken.XUNITSON, printLayout.showXScale);
        this.setBoolean(ScriptToken.YSCALEON, printLayout.showYScale);
        this.setBoolean(ScriptToken.YUNITSON, printLayout.showYScale);
    }

    public void setDefaultPrintOptions(PrintLayout printLayout) {
        printLayout.showGrid = this.gridOn;
        printLayout.showXScale = this.getBoolean(ScriptToken.XSCALEON);
        printLayout.showYScale = this.getBoolean(ScriptToken.YSCALEON);
        printLayout.showTitle = this.titleOn;
    }

    public JSVDialog showDialog(Annotation.AType aType) {
        AnnotationData annotationData = this.getDialog(aType);
        this.closeAllDialogsExcept(aType);
        if (annotationData != null && annotationData instanceof JSVDialog) {
            return ((JSVDialog)annotationData).reEnable();
        }
        int n = this.getCurrentSpectrumIndex();
        if (n < 0) {
            this.jsvp.showMessage("To enable " + (Object)((Object)aType) + " first select a spectrum by clicking on it.", "" + (Object)((Object)aType));
            return null;
        }
        Spectrum spectrum = this.getSpectrum();
        JSVDialog jSVDialog = this.vwr.getDialog(aType, spectrum);
        if (annotationData == null && aType == Annotation.AType.Measurements) {
            annotationData = new MeasurementData(Annotation.AType.Measurements, spectrum);
        }
        if (annotationData != null) {
            jSVDialog.setData(annotationData);
        }
        this.addDialog(n, aType, jSVDialog);
        jSVDialog.reEnable();
        return jSVDialog;
    }

    public void printPdf(GenericGraphics genericGraphics, PrintLayout printLayout) {
        boolean bl = !printLayout.layout.equals("landscape");
        this.print(genericGraphics, bl ? printLayout.imageableHeight : printLayout.imageableWidth, bl ? printLayout.imageableWidth : printLayout.imageableHeight, printLayout.imageableX, printLayout.imageableY, printLayout.paperHeight, printLayout.paperWidth, bl, 0);
    }

    public int print(Object object, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, int n) {
        this.g2d = this.g2d0;
        if (n == 0) {
            this.isPrinting = true;
            boolean bl2 = false;
            if (object instanceof GenericGraphics) {
                this.g2d = (GenericGraphics)object;
                object = this.gMain;
            }
            if (this.printGraphPosition.equals("default")) {
                if (bl) {
                    d = 450.0;
                    d2 = 280.0;
                } else {
                    d = 280.0;
                    d2 = 450.0;
                }
            } else if (this.printGraphPosition.equals("fit to page")) {
                bl2 = true;
            } else if (bl) {
                d = 450.0;
                d2 = 280.0;
                d3 = (int)(d6 - d2) / 2;
                d4 = (int)(d5 - d) / 2;
            } else {
                d = 280.0;
                d2 = 450.0;
                d4 = (int)(d6 - 280.0) / 2;
                d3 = (int)(d5 - 450.0) / 2;
            }
            this.g2d.translateScale(object, d3, d4, 0.1);
            this.setTaintedAll();
            this.drawGraph(object, object, object, (int)d2, (int)d, bl2);
            this.isPrinting = false;
            return 0;
        }
        this.isPrinting = false;
        return 1;
    }

    @Override
    public boolean keyPressed(int n, int n2) {
        if (this.isPrinting) {
            return false;
        }
        this.checkKeyControl(n, true);
        switch (n) {
            case 8: 
            case 27: 
            case 127: {
                this.escapeKeyPressed(n != 27);
                this.isIntegralDrag = false;
                this.setTaintedAll();
                this.repaint();
                return true;
            }
        }
        double d = 0.0;
        boolean bl = false;
        if (n2 == 0) {
            switch (n) {
                case 37: 
                case 39: {
                    this.doMouseMoved(n == 39 ? (this.mouseX = this.mouseX + 1) : (this.mouseX = this.mouseX - 1), this.mouseY);
                    this.repaint();
                    bl = true;
                    break;
                }
                case 33: 
                case 34: {
                    d = n == 33 ? GraphSet.RT2 : 1.0 / GraphSet.RT2;
                    bl = true;
                    break;
                }
                case 38: 
                case 40: {
                    int n3;
                    int n4 = n3 = n == 40 ? -1 : 1;
                    if (this.getSpectrumAt(0).getSubSpectra() == null) {
                        this.notifySubSpectrumChange(n3, null);
                    } else {
                        this.advanceSubSpectrum(n3);
                        this.setTaintedAll();
                        this.repaint();
                    }
                    bl = true;
                }
            }
        } else if (this.checkMod(n, 2)) {
            switch (n) {
                case 38: 
                case 40: 
                case 45: 
                case 61: {
                    d = n == 61 || n == 38 ? GraphSet.RT2 : 1.0 / GraphSet.RT2;
                    bl = true;
                    break;
                }
                case 37: 
                case 39: {
                    this.toPeak(n == 39 ? 1 : -1);
                    bl = true;
                }
            }
        }
        if (d != 0.0) {
            this.scaleYBy(d);
            this.setTaintedAll();
            this.repaint();
        }
        return bl;
    }

    @Override
    public void keyReleased(int n) {
        if (this.isPrinting) {
            return;
        }
        this.checkKeyControl(n, false);
    }

    @Override
    public boolean keyTyped(int n, int n2) {
        if (this.isPrinting) {
            return false;
        }
        switch (n) {
            case 110: {
                if (n2 != 0) break;
                this.normalizeIntegral();
                return true;
            }
            case 26: {
                if (n2 != 2) break;
                this.previousView();
                this.setTaintedAll();
                this.repaint();
                return true;
            }
            case 25: {
                if (n2 != 2) break;
                this.nextView();
                this.setTaintedAll();
                this.repaint();
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseAction(int n, long l, int n2, int n3, int n4, int n5) {
        if (this.isPrinting) {
            return;
        }
        switch (n) {
            case 4: {
                if (!this.checkMod(n5, 16)) {
                    return;
                }
                this.doMousePressed(n2, n3);
                break;
            }
            case 5: {
                this.doMouseReleased(n2, n3, this.checkMod(n5, 16));
                this.setTaintedAll();
                this.repaint();
                break;
            }
            case 1: {
                this.doMouseDragged(n2, n3);
                this.repaint();
                break;
            }
            case 0: {
                this.jsvp.getFocusNow(false);
                if ((n5 & 0x1C) != 0) {
                    this.doMouseDragged(n2, n3);
                    this.repaint();
                    return;
                }
                this.doMouseMoved(n2, n3);
                if (this.coordStr == null) break;
                this.repaint();
                break;
            }
            case 2: {
                if (this.checkMod(n5, 4)) {
                    this.jsvp.showMenu(n2, n3);
                    return;
                }
                this.ctrlPressed = false;
                this.doMouseClicked(n2, n3, this.updateControlPressed(n5));
            }
        }
    }

    public boolean checkMod(int n, int n2) {
        return (n & n2) == n2;
    }

    public void checkKeyControl(int n, boolean bl) {
        switch (n) {
            case 17: 
            case 157: {
                this.ctrlPressed = bl;
                break;
            }
            case 16: {
                this.shiftPressed = bl;
            }
        }
    }

    public boolean updateControlPressed(int n) {
        return this.ctrlPressed |= this.checkMod(n, 2) || this.checkMod(n, 20);
    }

    @Override
    public void mouseEnterExit(long l, int n, int n2, boolean bl) {
        if (bl) {
            this.thisWidget = null;
            this.isIntegralDrag = false;
            this.integralShiftMode = 0;
        } else {
            try {
                this.jsvp.getFocusNow(false);
            }
            catch (Exception exception) {
                System.out.println("pd " + this + " cannot focus");
            }
        }
    }

    public void setSolutionColor(String string) {
        boolean bl;
        boolean bl2 = string.indexOf("none") >= 0;
        boolean bl3 = bl = string.indexOf("false") < 0;
        if (string.indexOf("all") < 0) {
            int n = bl2 ? -1 : this.vwr.getSolutionColor(bl);
            this.getSpectrum().setFillColor(n == -1 ? null : this.vwr.parameters.getColor1(n));
        } else {
            VisibleInterface visibleInterface = (VisibleInterface)JSViewer.getInterface("jspecview.common.Visible");
            int n = this.graphSets.size();
            while (--n >= 0) {
                ((GraphSet)this.graphSets.get(n)).setSolutionColor(visibleInterface, bl2, bl);
            }
        }
    }

    public void setIRMode(Spectrum.IRMode iRMode, String string) {
        int n = this.graphSets.size();
        while (--n >= 0) {
            ((GraphSet)this.graphSets.get(n)).setIRMode(iRMode, string);
        }
    }

    public void closeSpectrum() {
        this.vwr.close("views");
        this.vwr.close(this.getSourceID());
        this.vwr.execView("*", true);
    }

    private static enum Mouse {
        UP,
        DOWN;

    }

    public static enum LinkMode {
        ALL,
        NONE,
        AB,
        ABC;


        public static LinkMode getMode(String string) {
            if (string.equals("*")) {
                return ALL;
            }
            for (LinkMode linkMode : LinkMode.values()) {
                if (!linkMode.name().equalsIgnoreCase(string)) continue;
                return linkMode;
            }
            return NONE;
        }
    }
}

