/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.c.STR;
import org.jmol.dssx.Bridge;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class DSSP {
    private BioPolymer[] bioPolymers;
    private Lst<Bond> vHBonds;
    private BS[] done;
    private boolean doReport;
    private boolean dsspIgnoreHydrogens;
    private boolean setStructure;
    private char[][] labels;
    private BS bsBad;
    private int bioPolymerCount;
    private Map<String, Bridge> htBridges;
    private Map<int[][], Boolean> htLadders;
    private Lst<Bridge> bridgesA;
    private Lst<Bridge> bridgesP;
    private boolean isDSSP2;
    private int[][] sheetOffsets = new int[][]{{0, -1, 1, 0, 1, 0, 0, -1}, {0, 0, 0, 0, 1, -1, 1, -1}};

    public String calculateDssp(Object[] objBioPolymers, int bioPolymerCount, Object objVHBonds, boolean doReport, boolean dsspIgnoreHydrogens, boolean setStructure, int version) {
        this.bioPolymers = (BioPolymer[])objBioPolymers;
        this.bioPolymerCount = bioPolymerCount;
        this.vHBonds = (Lst)objVHBonds;
        this.doReport = doReport;
        this.dsspIgnoreHydrogens = dsspIgnoreHydrogens;
        this.setStructure = setStructure;
        this.isDSSP2 = version > 1;
        BS bsAmino = new BS();
        for (int i = 0; i < bioPolymerCount; ++i) {
            if (!(this.bioPolymers[i] instanceof AminoPolymer)) continue;
            bsAmino.set(i);
        }
        if (bsAmino.isEmpty()) {
            return "";
        }
        Model m = this.bioPolymers[0].model;
        SB sb = new SB();
        sb.append("Jmol ").append(Viewer.getJmolVersion()).append(" DSSP analysis for model ").append(m.ms.getModelNumberDotted(m.modelIndex)).append(" - ").append(m.ms.getModelTitle(m.modelIndex)).append("\n");
        if (m.modelIndex == 0) {
            sb.append("\nW. Kabsch and C. Sander, Biopolymers, vol 22, 1983, pp 2577-2637\n\nWe thank Wolfgang Kabsch and Chris Sander for writing the DSSP software,\nand we thank the CMBI for maintaining it to the extent that it was easy to\nre-engineer in Java for our purposes. \n\nSecond generation DSSP 2.0 is ").append(this.isDSSP2 ? "" : "NOT ").append("used in this analysis. See Int. J. Mol. Sci. 2014, 15, 7841-7864; doi:10.3390/ijms15057841.\n");
        }
        if (setStructure && m.modelIndex == 0) {
            sb.append("\nAll bioshapes have been deleted and must be regenerated.\n");
        }
        if (m.altLocCount > 0) {
            sb.append("\nNote: This model contains alternative locations. Use  'CONFIGURATION 1' to be consistent with CMBI DSSP.\n");
        }
        this.labels = new char[bioPolymerCount][];
        this.done = new BS[bioPolymerCount];
        this.bsBad = new BS();
        boolean haveWarned = false;
        int i = bsAmino.nextSetBit(0);
        while (i >= 0) {
            AminoPolymer ap = (AminoPolymer)this.bioPolymers[i];
            if (!haveWarned && ((AminoMonomer)ap.monomers[0]).getExplicitNH() != null) {
                if (dsspIgnoreHydrogens) {
                    sb.append(GT.o((String)GT._((String)"NOTE: Backbone amide hydrogen positions are present and will be ignored. Their positions will be approximated, as in standard DSSP analysis.\nUse {0} to not use this approximation.\n\n"), (Object)"SET dsspCalculateHydrogenAlways FALSE"));
                } else {
                    sb.append(GT.o((String)GT._((String)"NOTE: Backbone amide hydrogen positions are present and will be used. Results may differ significantly from standard DSSP analysis.\nUse {0} to ignore these hydrogen positions.\n\n"), (Object)"SET dsspCalculateHydrogenAlways TRUE"));
                }
                haveWarned = true;
            }
            ap.recalculateLeadMidpointsAndWingVectors();
            int n = ap.monomerCount;
            this.labels[i] = new char[n];
            this.done[i] = new BS();
            for (int j = 0; j < n; ++j) {
                if (((AminoMonomer)ap.monomers[j]).getCarbonylOxygenAtom() != null) continue;
                this.bsBad.set(ap.monomers[j].leadAtomIndex);
            }
            i = bsAmino.nextSetBit(i + 1);
        }
        int[][][][] min = this.getDualHydrogenBondArray();
        this.bridgesA = new Lst();
        this.bridgesP = new Lst();
        this.htBridges = new Hashtable<String, Bridge>();
        this.htLadders = new Hashtable<int[][], Boolean>();
        this.getBridges(min);
        this.getSheetStructures();
        String[] reports = new String[bioPolymerCount];
        int i2 = bsAmino.nextSetBit(0);
        while (i2 >= 0) {
            if (min[i2] != null) {
                reports[i2] = this.findHelixes(i2, min[i2]);
            }
            i2 = bsAmino.nextSetBit(i2 + 1);
        }
        if (doReport) {
            SB sbSummary = new SB();
            sb.append("\n------------------------------\n");
            int i3 = bsAmino.nextSetBit(0);
            while (i3 >= 0) {
                if (this.labels[i3] != null) {
                    AminoPolymer ap = (AminoPolymer)this.bioPolymers[i3];
                    sbSummary.append(this.dumpSummary(ap, this.labels[i3]));
                    sb.append(reports[i3]).append(this.dumpTags(ap, "$.1: " + String.valueOf(this.labels[i3]), this.bsBad, 2));
                }
                i3 = bsAmino.nextSetBit(i3 + 1);
            }
            if (this.bsBad.nextSetBit(0) >= 0) {
                sb.append("\nNOTE: '!' indicates a residue that is missing a backbone carbonyl oxygen atom.\n");
            }
            sb.append("\n").append("SUMMARY:" + sbSummary);
        }
        return sb.toString();
    }

    private int[][][][] getDualHydrogenBondArray() {
        int i;
        int[][][][] min = AU.newInt4((int)this.bioPolymerCount);
        for (i = 0; i < this.bioPolymerCount; ++i) {
            if (!(this.bioPolymers[i] instanceof AminoPolymer)) continue;
            int n = this.bioPolymers[i].monomerCount;
            min[i] = new int[n][2][3];
            for (int j = 0; j < n; ++j) {
                min[i][j][1][1] = Integer.MIN_VALUE;
                min[i][j][0][1] = Integer.MIN_VALUE;
                min[i][j][1][2] = 0;
                min[i][j][0][2] = 0;
            }
        }
        for (i = 0; i < this.bioPolymerCount; ++i) {
            if (min[i] == null) continue;
            for (int j = 0; j < this.bioPolymerCount; ++j) {
                if (min[j] == null) continue;
                this.bioPolymers[i].calcRasmolHydrogenBonds(this.bioPolymers[j], null, null, null, 2, min[i], false, this.dsspIgnoreHydrogens);
            }
        }
        return min;
    }

    private void getBridges(int[][][][] min) {
        Atom[] atoms = this.bioPolymers[0].model.ms.at;
        Bridge bridge = null;
        Hashtable<String, Boolean> htTemp = new Hashtable<String, Boolean>();
        for (int p1 = 0; p1 < min.length; ++p1) {
            if (!(this.bioPolymers[p1] instanceof AminoPolymer)) continue;
            AminoPolymer ap1 = (AminoPolymer)this.bioPolymers[p1];
            int n = min[p1].length - 1;
            for (int a = 1; a < n; ++a) {
                int ia = ap1.monomers[a].leadAtomIndex;
                if (this.bsBad.get(ia)) continue;
                for (int p2 = p1; p2 < min.length; ++p2) {
                    int b;
                    if (!(this.bioPolymers[p2] instanceof AminoPolymer)) continue;
                    int n2 = b = p1 == p2 ? a + 3 : 1;
                    while (b < min[p2].length - 1) {
                        block8: {
                            int ib;
                            block9: {
                                AminoPolymer ap2 = (AminoPolymer)this.bioPolymers[p2];
                                ib = ap2.monomers[b].leadAtomIndex;
                                if (this.bsBad.get(ib)) break block8;
                                bridge = this.getBridge(min, p1, a, p2, b, this.bridgesP, atoms[ia], atoms[ib], ap1, ap2, htTemp, false);
                                if (bridge != null) break block9;
                                bridge = this.getBridge(min, p1, a, p2, b, this.bridgesA, atoms[ia], atoms[ib], ap1, ap2, htTemp, true);
                                if (bridge == null) break block8;
                                bridge.isAntiparallel = true;
                            }
                            if (Logger.debugging) {
                                Logger.debug((String)("Bridge found " + bridge));
                            }
                            this.done[p1].set(a);
                            this.done[p2].set(b);
                            this.htBridges.put(ia + "-" + ib, bridge);
                        }
                        ++b;
                    }
                }
            }
        }
    }

    private Bridge getBridge(int[][][][] min, int p1, int a, int p2, int b, Lst<Bridge> bridges, Atom atom1, Atom atom2, AminoPolymer ap1, AminoPolymer ap2, Map<String, Boolean> htTemp, boolean isAntiparallel) {
        block5: {
            int[] offsets;
            int ipt;
            int[] b2;
            int[] b1;
            block4: {
                b1 = null;
                b2 = null;
                ipt = 0;
                offsets = isAntiparallel ? this.sheetOffsets[1] : this.sheetOffsets[0];
                b1 = this.isHbonded(a + offsets[0], b + offsets[1], p1, p2, min);
                if (b1 != null && (b2 = this.isHbonded(b + offsets[2], a + offsets[3], p2, p1, min)) != null) break block4;
                ipt = 4;
                b1 = this.isHbonded(a + offsets[4], b + offsets[5], p1, p2, min);
                if (b1 == null || (b2 = this.isHbonded(b + offsets[6], a + offsets[7], p2, p1, min)) == null) break block5;
            }
            Bridge bridge = new Bridge(atom1, atom2, this.htLadders);
            bridges.addLast((Object)bridge);
            if (this.vHBonds != null) {
                int type = isAntiparallel ? 14336 : 6144;
                this.addHbond(ap1.monomers[a + offsets[ipt]], ap2.monomers[b + offsets[++ipt]], b1[2], type, htTemp);
                this.addHbond(ap2.monomers[b + offsets[++ipt]], ap1.monomers[a + offsets[++ipt]], b2[2], type, htTemp);
            }
            return bridge;
        }
        return null;
    }

    private void addHbond(Monomer donor, Monomer acceptor, int iEnergy, int type, Map<String, Boolean> htTemp) {
        Atom nitrogen = ((AminoMonomer)donor).getNitrogenAtom();
        Atom oxygen = ((AminoMonomer)acceptor).getCarbonylOxygenAtom();
        if (htTemp != null) {
            String key = nitrogen.i + " " + oxygen.i;
            if (htTemp.containsKey(key)) {
                return;
            }
            htTemp.put(key, Boolean.TRUE);
        }
        this.vHBonds.addLast((Object)new HBond(nitrogen, oxygen, type, 1, 0, (float)iEnergy / 1000.0f));
    }

    private void getSheetStructures() {
        if (this.bridgesA.size() == 0 && this.bridgesP.size() == 0) {
            return;
        }
        this.createLadders(this.bridgesA, true);
        this.createLadders(this.bridgesP, false);
        BS bsEEE = new BS();
        BS bsB = new BS();
        for (int[][] ladder : this.htLadders.keySet()) {
            if (ladder[0][0] == ladder[0][1] && ladder[1][0] == ladder[1][1]) {
                bsB.set(ladder[0][0]);
                bsB.set(ladder[1][0]);
                continue;
            }
            bsEEE.setBits(ladder[0][0], ladder[0][1] + 1);
            bsEEE.setBits(ladder[1][0], ladder[1][1] + 1);
        }
        BS bsSheet = new BS();
        BS bsBridge = new BS();
        int i = this.bioPolymers.length;
        while (--i >= 0) {
            if (!(this.bioPolymers[i] instanceof AminoPolymer)) continue;
            bsSheet.clearAll();
            bsBridge.clearAll();
            AminoPolymer ap = (AminoPolymer)this.bioPolymers[i];
            int iStart = 0;
            while (iStart < ap.monomerCount) {
                int index = ap.monomers[iStart].leadAtomIndex;
                if (bsEEE.get(index)) {
                    int iEnd;
                    for (iEnd = iStart + 1; iEnd < ap.monomerCount && bsEEE.get(ap.monomers[iEnd].leadAtomIndex); ++iEnd) {
                    }
                    bsSheet.setBits(iStart, iEnd);
                    iStart = iEnd;
                    continue;
                }
                if (bsB.get(index)) {
                    bsBridge.set(iStart);
                }
                ++iStart;
            }
            if (this.doReport) {
                this.setTag(this.labels[i], bsBridge, 'B');
                this.setTag(this.labels[i], bsSheet, 'E');
            }
            if (this.setStructure) {
                ap.setStructureBS(0, 3, STR.SHEET, bsSheet, false);
            }
            this.done[i].or(bsSheet);
            this.done[i].or(bsBridge);
        }
    }

    private void createLadders(Lst<Bridge> bridges, boolean isAntiparallel) {
        int i;
        int dir = isAntiparallel ? -1 : 1;
        int n = bridges.size();
        for (i = 0; i < n; ++i) {
            this.checkBridge((Bridge)bridges.get(i), isAntiparallel, 1, dir);
        }
        for (i = 0; i < n; ++i) {
            this.checkBulge((Bridge)bridges.get(i), isAntiparallel, 1);
        }
    }

    private boolean checkBridge(Bridge bridge, boolean isAntiparallel, int n1, int n2) {
        Bridge b = this.htBridges.get(bridge.a.getOffsetResidueAtom("\u0000", n1) + "-" + bridge.b.getOffsetResidueAtom("\u0000", n2));
        return b != null && bridge.addBridge(b, this.htLadders);
    }

    private void checkBulge(Bridge bridge, boolean isAntiparallel, int dir) {
        int dir1 = isAntiparallel ? -1 : 1;
        for (int i = 0; i < 3; ++i) {
            int j;
            int n = j = i == 0 ? 1 : 0;
            while (j < 6) {
                this.checkBridge(bridge, isAntiparallel, i * dir, j * dir1);
                if (j > i) {
                    this.checkBridge(bridge, isAntiparallel, j * dir, i * dir1);
                }
                ++j;
            }
        }
    }

    private String dumpSummary(AminoPolymer ap, char[] labels) {
        Atom a = ap.monomers[0].getLeadAtom();
        int id = a.getChainID();
        String prefix = id == 0 ? "" : a.getChainIDStr() + ":";
        SB sb = new SB();
        char lastChar = '\u0000';
        char insCode1 = '\u0000';
        char insCode2 = '\u0000';
        int firstResno = -1;
        int lastResno = -1;
        int n = ap.monomerCount;
        Monomer[] m = ap.monomers;
        for (int i = 0; i <= n; ++i) {
            if (i == n || labels[i] != lastChar) {
                if (lastChar != '\u0000') {
                    sb.appendC('\n').appendC(lastChar).append(" : ").append(prefix).appendI(firstResno).append(insCode1 == '\u0000' ? "" : String.valueOf(insCode1)).append("_").append(prefix).appendI(lastResno).append(insCode2 == '\u0000' ? "" : String.valueOf(insCode2));
                }
                if (i == n) break;
                lastChar = labels[i];
                firstResno = m[i].getResno();
                insCode1 = m[i].getInsertionCode();
            }
            lastResno = m[i].getResno();
            insCode2 = m[i].getInsertionCode();
        }
        return sb.toString();
    }

    private String dumpTags(AminoPolymer ap, String lines, BS bsBad, int mode) {
        String prefix = ap.monomers[0].getLeadAtom().getChainID() + "." + (ap.bioPolymerIndexInModel + 1);
        lines = PT.rep((String)lines, (String)"$", (String)prefix);
        int iFirst = ap.monomers[0].getResno();
        String pre = "\n" + prefix;
        SB sb = new SB();
        SB sb0 = new SB().append(pre + ".8: ");
        SB sb1 = new SB().append(pre + ".7: ");
        SB sb2 = new SB().append(pre + ".6: ");
        SB sb3 = new SB().append(pre + ".0: ");
        int i = iFirst;
        int n = ap.monomerCount;
        for (int ii = 0; ii < n; ++ii) {
            i = ap.monomers[ii].getResno();
            sb0.append(i % 100 == 0 ? "" + i / 100 % 100 : " ");
            sb1.append(i % 10 == 0 ? "" + i / 10 % 10 : " ");
            sb2.appendI(i % 10);
            sb3.appendC(bsBad.get(ap.monomers[ii].leadAtomIndex) ? (char)'!' : ap.monomers[ii].getGroup1());
        }
        if ((mode & 1) == 1) {
            sb.appendSB(sb0).appendSB(sb1).appendSB(sb2);
        }
        sb.append("\n");
        sb.append(lines);
        if ((mode & 2) == 2) {
            sb.appendSB(sb3);
            sb.append("\n\n");
        }
        return sb.toString().replace('\u0000', '.');
    }

    private int[] isHbonded(int indexDonor, int indexAcceptor, int pDonor, int pAcceptor, int[][][][] min) {
        if (indexDonor < 0 || indexAcceptor < 0) {
            return null;
        }
        int[][][] min1 = min[pDonor];
        int[][][] min2 = min[pAcceptor];
        if (indexDonor >= min1.length || indexAcceptor >= min2.length) {
            return null;
        }
        return min1[indexDonor][0][0] == pAcceptor && min1[indexDonor][0][1] == indexAcceptor ? min1[indexDonor][0] : (min1[indexDonor][1][0] == pAcceptor && min1[indexDonor][1][1] == indexAcceptor ? min1[indexDonor][1] : null);
    }

    private String findHelixes(int iPolymer, int[][][] min) {
        String line3;
        String line4;
        String line5;
        AminoPolymer ap = (AminoPolymer)this.bioPolymers[iPolymer];
        if (Logger.debugging) {
            for (int j = 0; j < ap.monomerCount; ++j) {
                Logger.debug((String)(iPolymer + "." + ap.monomers[j].getResno() + "\t" + Escape.e((Object)min[j])));
            }
        }
        BS bsTurn = new BS();
        if (this.isDSSP2) {
            line5 = this.findHelixes2(0, iPolymer, 5, min, STR.HELIXPI, 12288, bsTurn, true);
            line4 = this.findHelixes2(2, iPolymer, 4, min, STR.HELIXALPHA, 10240, bsTurn, false);
            line3 = this.findHelixes2(4, iPolymer, 3, min, STR.HELIX310, 8192, bsTurn, false);
        } else {
            line4 = this.findHelixes2(2, iPolymer, 4, min, STR.HELIXALPHA, 10240, bsTurn, true);
            line3 = this.findHelixes2(4, iPolymer, 3, min, STR.HELIX310, 8192, bsTurn, false);
            line5 = this.findHelixes2(0, iPolymer, 5, min, STR.HELIXPI, 12288, bsTurn, false);
        }
        if (this.setStructure) {
            ap.setStructureBS(0, 6, STR.TURN, bsTurn, false);
        }
        if (this.doReport) {
            this.setTag(this.labels[iPolymer], bsTurn, 'T');
            return this.dumpTags(ap, "$.5: " + line5 + "\n" + "$.4: " + line4 + "\n" + "$.3: " + line3, this.bsBad, 1);
        }
        return "";
    }

    private String findHelixes2(int mmtfType, int iPolymer, int pitch, int[][][] min, STR subtype, int type, BS bsTurn, boolean isFirst) {
        char[] taglines;
        AminoPolymer ap = (AminoPolymer)this.bioPolymers[iPolymer];
        BS bsStart = new BS();
        BS bsNNN = new BS();
        BS bsX = new BS();
        BS bsStop = new BS();
        BS bsHelix = new BS();
        BS bsDone = this.done[iPolymer];
        String warning = "";
        int n = ap.monomerCount;
        for (int i = pitch; i < n; ++i) {
            int i0 = i - pitch;
            int bpt = 0;
            if (min[i][0][0] != iPolymer || min[i][0][1] != i0) {
                bpt = 1;
                if (min[i][1][0] != iPolymer || min[i][1][1] != i0) continue;
            }
            int ia = ap.monomers[i0].leadAtomIndex;
            int ipt = this.bsBad.nextSetBit(ia);
            Monomer m = ap.monomers[i];
            if (ipt >= ia && ipt <= m.leadAtomIndex) continue;
            bsStart.set(i0);
            bsNNN.setBits(i0 + 1, i);
            bsStop.set(i);
            ipt = bsDone.nextSetBit(i0);
            boolean isClear = ipt < 0 || ipt >= i;
            boolean addH = false;
            if (i0 > 0 && bsStart.get(i0 - 1) && (isFirst || isClear)) {
                bsHelix.setBits(i0, i);
                if (!isClear) {
                    warning = warning + "  WARNING! Bridge to helix at " + (Object)((Object)ap.monomers[ipt]);
                }
                addH = true;
            } else if (isClear || bsDone.nextClearBit(ipt) < i) {
                addH = true;
            }
            if (bsStop.get(i0)) {
                bsX.set(i0);
            }
            if (!addH || this.vHBonds == null) continue;
            this.addHbond(m, ap.monomers[i0], min[i][bpt][2], type, null);
        }
        if (this.doReport) {
            taglines = new char[n];
            this.setTag(taglines, bsNNN, (char)(48 + pitch));
            this.setTag(taglines, bsStart, '>');
            this.setTag(taglines, bsStop, '<');
            this.setTag(taglines, bsX, 'X');
        } else {
            taglines = null;
        }
        bsDone.or(bsHelix);
        bsNNN.andNot(bsDone);
        bsTurn.or(bsNNN);
        bsTurn.andNot(bsHelix);
        if (this.setStructure) {
            ap.setStructureBS(0, mmtfType, subtype, bsHelix, false);
        }
        if (this.doReport) {
            this.setTag(this.labels[iPolymer], bsHelix, (char)(68 + pitch));
            return String.valueOf(taglines) + warning;
        }
        return "";
    }

    private void setTag(char[] tags, BS bs, char ch) {
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            tags[i] = ch;
            i = bs.nextSetBit(i + 1);
        }
    }
}

